/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin;

import com.idoox.debug.Category;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.systinet.wasp.admin.Package;

class QNameDAG {
    private static final Category log = Category.getCategory("com.systinet.wasp.admin.QNameDAG");
    private HashMap qNames = new HashMap();
    private HashMap objects = new HashMap();
    private ArrayList zeroInDegreeNodes = new ArrayList();
    GraphNode graph;

    QNameDAG() {
    }

    public void insertOrderInfo(Package pckg, QName depName) {
        QName pckgName = new QName(pckg.targetNamespace, pckg.name);
        GraphNode nodeB = this.getNode(pckgName, pckg);
        if (depName != null) {
            GraphNode nodeA = this.getNode(depName);
            nodeA.addLink(nodeB);
        }
    }

    private GraphNode getNode(QName qName, Object object) {
        if (this.qNames.containsKey(qName)) {
            GraphNode node = (GraphNode)this.qNames.get(qName);
            node.object = object;
            this.objects.put(object, node);
            return node;
        }
        GraphNode node = new GraphNode(qName, object);
        this.objects.put(object, node);
        this.qNames.put(qName, node);
        return node;
    }

    private GraphNode getNode(QName qName) {
        if (this.qNames.containsKey(qName)) {
            return (GraphNode)this.qNames.get(qName);
        }
        GraphNode node = new GraphNode(qName, null);
        this.qNames.put(qName, node);
        return node;
    }

    public List getSortedObjects() {
        ArrayList<Object> sorted = new ArrayList<Object>();
        LinkedList<GraphNode> zeroInDegreeNodes = new LinkedList<GraphNode>();
        zeroInDegreeNodes.addAll(this.zeroInDegreeNodes);
        while (!zeroInDegreeNodes.isEmpty()) {
            GraphNode node = (GraphNode)zeroInDegreeNodes.getFirst();
            zeroInDegreeNodes.remove(node);
            if (node.object != null) {
                sorted.add(node.object);
            }
            Iterator i = ((AbstractList)node.next).iterator();
            while (i.hasNext()) {
                GraphNode child = (GraphNode)i.next();
                if (--child.inDegree != 0) continue;
                zeroInDegreeNodes.add(child);
            }
        }
        this.graph = null;
        return sorted;
    }

    public void clear() {
        this.qNames.clear();
        this.objects.clear();
        this.zeroInDegreeNodes.clear();
        if (this.graph != null) {
            this.graph.next.clear();
        }
    }

    class GraphNode {
        public int inDegree = 0;
        public ArrayList next = new ArrayList();
        public QName key;
        public Object object;

        public GraphNode(QName key, Object object) {
            this.key = key;
            this.object = object;
            QNameDAG.this.zeroInDegreeNodes.add(this);
        }

        public void addLink(GraphNode child) {
            if (!this.next.contains(child)) {
                if (child.inDegree == 0) {
                    ((AbstractCollection)QNameDAG.this.zeroInDegreeNodes).remove(child);
                }
                ++child.inDegree;
                this.next.add(child);
            }
        }
    }
}

