/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin;

import com.idoox.debug.Category;
import com.idoox.transport.util.URLDecoder;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.ModuleRepository;
import com.idoox.wasp.PortTypeMappingRegistry;
import com.idoox.wasp.classloader.WaspClassLoader;
import com.idoox.wasp.interceptor.InterceptorRepository;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.wasp.server.Dispatcher;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import com.idoox.xmlrpc.header.HeaderProcessorRepository;
import com.systinet.util.StringHelper;
import com.systinet.wasp.PreferencesConfig;
import com.systinet.wasp.admin.DDLoader;
import com.systinet.wasp.admin.PackageHelper;
import com.systinet.wasp.admin.PackageInfoEx;
import com.systinet.wasp.admin.PackageRepositoryConfig;
import com.systinet.wasp.admin.QNameDAG;
import com.systinet.wasp.dd.BuilderImpl;
import com.systinet.wasp.dd.DeploymentDescriptorImpl;
import com.systinet.wasp.dd.DescriptorConverter;
import com.systinet.wasp.dd.DescriptorHelper;
import com.systinet.wasp.dd.DocumentationImpl;
import com.systinet.wasp.dd.VersionImpl;
import com.systinet.wasp.dd.bc.DescriptorMigrator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.idoox.transport.TransportRepository;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.InstanceNotFoundException;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.admin.Package;
import org.systinet.wasp.admin.PackageException;
import org.systinet.wasp.admin.PackageInfo;
import org.systinet.wasp.admin.PackageListener;
import org.systinet.wasp.admin.PackageRepository;
import org.systinet.wasp.dd.Builder;
import org.systinet.wasp.dd.Dependency;
import org.systinet.wasp.dd.DeploymentDescriptor;
import org.systinet.wasp.dd.DeploymentException;
import org.systinet.wasp.dd.Documentation;
import org.systinet.wasp.dd.DuplicatedNameException;
import org.systinet.wasp.dd.Processing;
import org.systinet.wasp.dd.Version;
import org.systinet.wasp.dd.Writer;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.webservice.IListenerRepository;
import org.systinet.wasp.webservice.PublishException;

public class PackageRepositoryImpl
implements PackageRepository,
Module {
    private static final Category log = Category.getCategory("com.systinet.wasp.admin.PackageRepositoryImpl");
    private Map contexts;
    private Map packages;
    private Map packageIDs;
    private Map classPathPackages;
    private boolean useClasspath;
    private boolean useCache;
    private IConfigurator configurator;
    private File appDir;
    private File workDir;
    private File systemAppDir;
    private File systemWorkDir;
    private String systemContext = "system";
    private QNameDAG qNameDAG;
    private DeploymentDescriptor defaultClientDD = null;
    private boolean initializing = false;
    private final Object packageListenerRepositoryLock = new Object();
    private final List packageListenerRepository = new LinkedList();
    private static final String DEFAULT_CLIENT_PACKAGE_NAME = "DefaultClientPackage";
    private static final String DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE = "http://systinet.com/wasp/app/defaultclientpackage";
    private static final String DEFAULT_CLIENT_PACKAGE_VERSION = "4.7";
    private static final String DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME = "DefaultClientPackageProcessing";
    private boolean serializeDefaultClientDD = false;
    private static final String TEMPORARY_PACKAGE_FILE_NAME = "wasp_install_";
    static /* synthetic */ Class class$com$systinet$wasp$admin$PackageRepositoryConfig;
    static /* synthetic */ Class class$com$systinet$wasp$PreferencesConfig;

    public synchronized void load(Configurable c) throws WaspInternalException {
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.admin.PackageRepository", this);
        this.contexts = new HashMap(13);
        this.packages = new HashMap(13);
        this.packageIDs = new HashMap(13);
        this.qNameDAG = new QNameDAG();
        PackageRepositoryConfig config = (PackageRepositoryConfig)c.narrow(class$com$systinet$wasp$admin$PackageRepositoryConfig == null ? (class$com$systinet$wasp$admin$PackageRepositoryConfig = PackageRepositoryImpl.class$("com.systinet.wasp.admin.PackageRepositoryConfig")) : class$com$systinet$wasp$admin$PackageRepositoryConfig);
        try {
            this.useClasspath = config.isUseClasspath();
        }
        catch (Exception e) {
            this.useClasspath = false;
        }
        try {
            this.useCache = config.isUseCache();
        }
        catch (Exception e) {
            this.useCache = true;
        }
        try {
            this.serializeDefaultClientDD = config.isSerializeDefaultClientDD();
        }
        catch (Exception e) {
            this.serializeDefaultClientDD = false;
        }
    }

    public synchronized void init() throws WaspInternalException {
        this.initializing = true;
        this.contexts.clear();
        this.packages.clear();
        this.packageIDs.clear();
        this.configurator = (IConfigurator)org.idoox.wasp.Context.getInstance("org.idoox.config.IConfigurator");
        this.setupApplicationAndWorkDir();
        if (this.useClasspath) {
            this.searchClassPath();
            this.loadClientPackages();
            this.resolveDefaultClientDD();
        } else {
            this.update();
            this.resolveDependencies();
        }
        this.initializing = false;
    }

    public synchronized void destroy() {
        this.contexts.clear();
        this.packages.clear();
        this.packageIDs.clear();
    }

    public final void addListener(PackageListener packageListener) {
        if (packageListener == null) {
            throw new IllegalArgumentException("Argument can't be null!");
        }
        Object object = this.packageListenerRepositoryLock;
        synchronized (object) {
            int i = 0;
            while (i < this.packageListenerRepository.size()) {
                if (this.packageListenerRepository.get(i) == packageListener) {
                    return;
                }
                ++i;
            }
            this.packageListenerRepository.add(packageListener);
        }
    }

    public final void removeListener(PackageListener packageListener) {
        if (packageListener == null) {
            throw new IllegalArgumentException("Argument can't be null!");
        }
        Object object = this.packageListenerRepositoryLock;
        synchronized (object) {
            this.packageListenerRepository.remove(packageListener);
        }
    }

    private void setupApplicationAndWorkDir() throws WaspInternalException {
        String systemAppLocation;
        String workLocation;
        File app;
        String appLocation;
        Endpoint waspEndpoint;
        try {
            waspEndpoint = new Endpoint(this.configurator.getWaspLocation());
        }
        catch (MalformedURLException e) {
            throw new WaspInternalException(e);
        }
        if (!waspEndpoint.getScheme().equalsIgnoreCase("file")) {
            throw new WaspInternalException("Systinet Server location (wasp.location) is different than file path: " + waspEndpoint.toExternalForm());
        }
        PreferencesConfig preferencesConfig = (PreferencesConfig)this.configurator.getConfigurable("preferences", "main").narrow(class$com$systinet$wasp$PreferencesConfig == null ? (class$com$systinet$wasp$PreferencesConfig = PackageRepositoryImpl.class$("com.systinet.wasp.PreferencesConfig")) : class$com$systinet$wasp$PreferencesConfig);
        String waspLocation = waspEndpoint.getPath();
        if (waspLocation.length() > 0 && waspLocation.charAt(waspLocation.length() - 1) != '/') {
            waspLocation = waspLocation + '/';
        }
        if ((appLocation = preferencesConfig.getApplicationDirectory()) == null) {
            appLocation = "app";
        }
        if ((app = new File(appLocation)).isAbsolute()) {
            this.appDir = app;
        } else {
            appLocation = waspLocation + appLocation;
            appLocation.replace('/', File.separatorChar);
            this.appDir = new File(appLocation);
        }
        if (!this.useClasspath || this.useClasspath && this.useCache) {
            if (!this.appDir.exists()) {
                this.appDir.mkdir();
            }
            if (!this.appDir.exists() || !this.appDir.isDirectory()) {
                throw new WaspInternalException("Systinet Server application directory " + this.appDir + " doesn't exist or it isn't directory");
            }
        }
        if ((workLocation = preferencesConfig.getWorkDirectory()) == null) {
            workLocation = "work";
        }
        workLocation = waspLocation + workLocation;
        workLocation.replace('/', File.separatorChar);
        this.workDir = new File(workLocation);
        if (!this.useClasspath || this.useClasspath && this.useCache) {
            if (!this.workDir.exists()) {
                this.workDir.mkdir();
            }
            if (!this.workDir.exists() || !this.workDir.isDirectory()) {
                throw new WaspInternalException("Systinet Server working directory " + this.workDir + " doesn't exist or it isn't directory");
            }
        }
        if (!this.contexts.containsKey("")) {
            try {
                this.contexts.put("", new Context(new ArrayList(), this.appDir, this.workDir, this.createBuilder("", null)));
            }
            catch (DeploymentException e) {
                throw new WaspInternalException("Can't create builder for appliaction directory " + this.appDir, e);
            }
        }
        if ((systemAppLocation = preferencesConfig.getSystemContext()) == null) {
            systemAppLocation = this.systemContext;
        }
        this.systemContext = systemAppLocation;
        if (!this.useClasspath) {
            systemAppLocation = appLocation + "/" + systemAppLocation;
            systemAppLocation.replace('/', File.separatorChar);
            this.systemAppDir = new File(systemAppLocation);
            if (!this.systemAppDir.exists()) {
                this.systemAppDir.mkdir();
            }
            if (!this.systemAppDir.exists() || !this.systemAppDir.isDirectory()) {
                throw new WaspInternalException("Systinet Server system application directory " + this.systemAppDir + " doesn't exist or it isn't directory");
            }
            String systemWorkLocation = this.systemContext;
            systemWorkLocation = workLocation + "/" + systemWorkLocation;
            systemWorkLocation.replace('/', File.separatorChar);
            this.systemWorkDir = new File(systemWorkLocation);
            if (!this.systemWorkDir.exists()) {
                this.systemWorkDir.mkdir();
            }
            if (!this.systemWorkDir.exists() || !this.systemWorkDir.isDirectory()) {
                throw new WaspInternalException("Systinet Server system working directory " + this.systemWorkDir + " doesn't exist or it isn't directory");
            }
            if (!this.contexts.containsKey(this.systemContext)) {
                this.contexts.put(this.systemContext, new Context(new ArrayList(), this.systemAppDir, this.systemWorkDir, ((Context)this.contexts.get((Object)"")).ddBuilder));
            }
        }
    }

    private void searchClassPath() {
        this.classPathPackages = new HashMap();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Enumeration<URL> en = classLoader.getResources("WASP-INF/package.xml");
            if (en != null) {
                if (en.hasMoreElements()) {
                    this.createDefaultClientDD();
                }
                while (en.hasMoreElements()) {
                    URL url = URLDecoder.decodeUrlWorkaround(en.nextElement());
                    if (url == null) continue;
                    try {
                        this.registerClassPathPackage(url);
                    }
                    catch (DeploymentException e) {
                        log.error("Error when registering package from " + url, e);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Can't get resources WASP-INF/package.xml from current classloader", e);
        }
    }

    private void registerClassPathPackage(URL url) throws DeploymentException {
        URL registeredUrl;
        DeploymentDescriptor dd;
        String context = "";
        Context cxt = (Context)this.contexts.get(context);
        if (cxt == null) {
            throw new DeploymentException("Context [" + context + "] doesn't exist");
        }
        Builder builder = cxt.ddBuilder;
        if (builder == null) {
            throw new DeploymentException("Builder for context [" + context + "] doesn't exist");
        }
        builder.setResolvingMode(0);
        try {
            dd = builder.read(url.toExternalForm(), url.openStream());
        }
        catch (IOException e) {
            throw new DeploymentException("Cannot read from url: " + url.toExternalForm(), e);
        }
        Version version = dd.getVersion();
        if (version == null) {
            version = new VersionImpl("1.0");
        }
        Package newPckg = new Package(context, dd.getTargetNamespace(), dd.getName());
        log.info("Registering package from classpath [" + context + "][" + dd.getTargetNamespace() + "][" + dd.getName() + "]");
        if (this.classPathPackages.containsKey(newPckg) && (registeredUrl = (URL)this.classPathPackages.get(newPckg)) != null) {
            if (!registeredUrl.toExternalForm().equals(url.toExternalForm())) {
                throw new DeploymentException("Duplicated package on classpath " + newPckg + " the first source " + ((URL)this.classPathPackages.get(newPckg)).toExternalForm() + " the second source " + url.toExternalForm());
            }
            return;
        }
        this.classPathPackages.put(newPckg, url);
        this.qNameDAG.insertOrderInfo(newPckg, null);
        Iterator dependencies = dd.getDependencies().iterator();
        while (dependencies.hasNext()) {
            Dependency dependency = (Dependency)dependencies.next();
            this.qNameDAG.insertOrderInfo(newPckg, dependency.getReferredName());
        }
        if (this.defaultClientDD != null) {
            try {
                this.defaultClientDD.addDependency(new QName(dd.getTargetNamespace(), dd.getName()), version.getVersionString());
            }
            catch (DuplicatedNameException e) {
                throw new DeploymentException("Cannot add dependency on package " + dd.getTargetNamespace() + "][" + dd.getName() + "]" + " for default client deployment descriptor", e);
            }
        }
    }

    public synchronized void update() throws WaspInternalException {
        Context context = (Context)this.contexts.get("");
        if (context == null) {
            throw new WaspInternalException("Does't exist context for application directory " + this.appDir);
        }
        this.updateDir(this.systemAppDir, this.systemContext.replace('/', File.separatorChar) + File.separator, context.ddBuilder);
        this.updateDir(this.appDir, "", context.ddBuilder);
        this.cleanDir(this.workDir, "");
    }

    private void updateDir(File dir, String context, Builder parent) {
        String contextWithSlashes = context.replace(File.separatorChar, '/');
        String contextWithoutSlash = contextWithSlashes;
        if (contextWithoutSlash.length() > 0 && contextWithoutSlash.charAt(contextWithoutSlash.length() - 1) == '/') {
            contextWithoutSlash = contextWithoutSlash.substring(0, contextWithoutSlash.length() - 1);
        }
        File[] entries = dir.listFiles();
        int i = 0;
        while (i < entries.length) {
            File ddWorkFile;
            File packageDir;
            String pckg;
            String lowerName = entries[i].getName();
            if (entries[i].isDirectory()) {
                File ddFile = new File(entries[i], PackageHelper.DD_FILE_PATH);
                if (ddFile.exists()) {
                    pckg = contextWithSlashes + lowerName;
                    try {
                        packageDir = new File(this.workDir, contextWithSlashes + lowerName);
                        if (!packageDir.exists()) {
                            PackageHelper.copyDir(entries[i], packageDir, false, null);
                        } else {
                            ddWorkFile = new File(packageDir, PackageHelper.DD_FILE_PATH);
                            if (ddWorkFile.exists()) {
                                if (ddFile.lastModified() > ddWorkFile.lastModified()) {
                                    PackageHelper.deleteDir(packageDir);
                                    PackageHelper.copyDir(entries[i], packageDir, false, null);
                                }
                            } else {
                                PackageHelper.deleteDir(packageDir);
                                PackageHelper.copyDir(entries[i], packageDir, false, null);
                            }
                        }
                        this.registerPackage(contextWithoutSlash, lowerName, packageDir, entries[i], true);
                    }
                    catch (DeploymentException e) {
                        log.error("Error when registering package " + entries[i], e);
                    }
                    catch (IOException e) {
                        log.error("Error when copying package to work directory" + entries[i], e);
                    }
                } else {
                    String newContext = contextWithSlashes + lowerName;
                    if (!this.contexts.containsKey(newContext)) {
                        try {
                            Builder builder = null;
                            builder = newContext.equals(this.systemContext) || newContext.startsWith(this.systemContext + "/") ? ((Context)this.contexts.get((Object)"")).ddBuilder : this.createBuilder(newContext, parent);
                            File cxtWorkDir = new File(this.workDir, newContext);
                            if (!cxtWorkDir.exists() && !cxtWorkDir.mkdirs()) {
                                log.error("Can't create context direcory in work directory " + newContext);
                            }
                            this.contexts.put(newContext, new Context(new ArrayList(), entries[i], cxtWorkDir, builder));
                            this.updateDir(entries[i], context + lowerName + File.separator, builder);
                        }
                        catch (DeploymentException e) {
                            log.error("Can't create builder for context " + newContext, e);
                        }
                    }
                }
            } else if (lowerName.endsWith(".jar")) {
                try {
                    JarFile jar = new JarFile(entries[i]);
                    if (jar.getJarEntry("WASP-INF/package.xml") != null) {
                        jar.close();
                        pckg = entries[i].getName();
                        packageDir = new File(this.workDir, contextWithSlashes + pckg);
                        if (!packageDir.exists()) {
                            pckg = contextWithSlashes + pckg;
                            try {
                                this.reinstallPackageInternal(contextWithoutSlash, false, entries[i], false, false, false, false);
                            }
                            catch (PackageException e) {
                                log.error("Error while installing package " + entries[i], e);
                            }
                        } else if (!packageDir.isDirectory()) {
                            log.error("Can't install " + entries[i] + " to " + packageDir + " directory because the same file already exists");
                        } else {
                            ddWorkFile = new File(packageDir, PackageHelper.DD_FILE_PATH);
                            if (ddWorkFile.exists()) {
                                if (entries[i].lastModified() > ddWorkFile.lastModified()) {
                                    PackageHelper.deleteDir(packageDir);
                                    try {
                                        this.reinstallPackageInternal(contextWithoutSlash, false, entries[i], false, false, false, false);
                                    }
                                    catch (PackageException e) {
                                        log.error("Error while installing package " + entries[i], e);
                                    }
                                } else {
                                    try {
                                        this.registerPackage(contextWithoutSlash, lowerName, packageDir, entries[i], true);
                                    }
                                    catch (DeploymentException e) {
                                        log.error("Error when registering package " + entries[i], e);
                                    }
                                }
                            } else {
                                PackageHelper.deleteDir(packageDir);
                                try {
                                    this.reinstallPackageInternal(contextWithoutSlash, false, entries[i], false, false, false, false);
                                }
                                catch (PackageException e) {
                                    log.error("Error while installing package " + entries[i], e);
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Error when accessing JAR file " + entries[i], e);
                }
            }
            ++i;
        }
    }

    private void cleanDir(File dir, String context) {
        File[] entries;
        String contextWithSlashes = context.replace(File.separatorChar, '/');
        String contextWithoutSlash = contextWithSlashes;
        if (contextWithoutSlash.length() > 0 && contextWithoutSlash.charAt(contextWithoutSlash.length() - 1) == '/') {
            contextWithoutSlash = contextWithoutSlash.substring(0, contextWithoutSlash.length() - 1);
        }
        if ((entries = dir.listFiles()) == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            String name = entries[i].getName();
            if (entries[i].isDirectory()) {
                File ddFile = new File(entries[i], PackageHelper.DD_FILE_PATH);
                if (ddFile.exists()) {
                    String pckg = contextWithSlashes + name;
                    if (!this.packages.containsKey(pckg)) {
                        PackageHelper.deleteDir(entries[i]);
                    }
                } else {
                    this.cleanDir(entries[i], contextWithSlashes + name + File.separator);
                    if (entries[i].listFiles() != null && entries[i].listFiles().length == 0) {
                        entries[i].delete();
                    }
                }
            }
            ++i;
        }
    }

    private Package registerPackage(String context, String name, File pckgDir, File source, boolean canInstall) throws DeploymentException {
        String pckg = context.equals("") ? name : context + "/" + name;
        Package newPckg = null;
        File ddFile = new File(pckgDir, PackageHelper.DD_FILE_PATH);
        try {
            Context cxt = null;
            cxt = (Context)this.contexts.get(context);
            if (cxt == null) {
                throw new Exception("Error when getting context for DD " + ddFile);
            }
            Builder builder = cxt.ddBuilder;
            if (builder == null) {
                throw new Exception("Error when getting builder for DD " + ddFile);
            }
            builder.setResolvingMode(0);
            DeploymentDescriptor dd = builder.read(PackageHelper.toURL(ddFile).toExternalForm());
            if (dd == null) {
                throw new DeploymentException("DD is null");
            }
            Version pckgVersion = dd.getVersion();
            if (pckgVersion == null) {
                pckgVersion = new VersionImpl("0");
            }
            log.info("Registering package [" + context + "][" + dd.getTargetNamespace() + "][" + dd.getName() + "][" + pckgVersion.getVersionString() + "]");
            newPckg = new Package(context, dd.getTargetNamespace(), dd.getName());
            if (canInstall) {
                this.canInstall(context, dd.getTargetNamespace(), dd.getName());
            }
            this.qNameDAG.insertOrderInfo(newPckg, null);
            Iterator dependencies = dd.getDependencies().iterator();
            while (dependencies.hasNext()) {
                Dependency dependency = (Dependency)dependencies.next();
                this.qNameDAG.insertOrderInfo(newPckg, dependency.getReferredName());
            }
            Documentation pckgDoc = dd.getDocumentation();
            if (pckgDoc == null) {
                pckgDoc = new DocumentationImpl();
            }
            String pckgDocURL = null;
            if (pckgDoc.getURL() != null) {
                pckgDocURL = pckgDoc.getURL().toExternalForm();
            }
            String classLoader = DescriptorConverter.resolveClassSpaceName(context, dd);
            PackageInfoEx newInfo = new PackageInfoEx(name, newPckg, classLoader, pckgVersion.getVersionString(), pckgDoc.getDisplayName(), pckgDoc.getDescription(), pckgDocURL, pckgDir, source, ddFile.lastModified(), dd.isLibrary());
            cxt.packages.add(newInfo);
            this.packages.put(pckg, newInfo);
            this.packageIDs.put(newPckg, newInfo);
            return newPckg;
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Package loadPackage(Package newPckg, boolean disabled) throws DeploymentException, IOException, Exception {
        if (newPckg == null) {
            throw new DeploymentException("Internal error: newPckg parameter is null");
        }
        QName packageQname = new QName(newPckg.targetNamespace, newPckg.name);
        String context = newPckg.context;
        PackageInfoEx pckgInfoEx = (PackageInfoEx)this.packageIDs.get(newPckg);
        if (pckgInfoEx == null) {
            throw new DeploymentException("Can't resolve: package IDs doesn't contain package " + newPckg);
        }
        Context cxt = (Context)this.contexts.get(context);
        if (cxt == null) {
            throw new DeploymentException("Context " + context + " doesn't exist");
        }
        Builder builder = cxt.ddBuilder;
        if (builder == null) {
            throw new DeploymentException("Builder for context " + context + " doesn't exist");
        }
        builder.setResolvingMode(0);
        DeploymentDescriptor dd = builder.read(packageQname);
        if (DescriptorMigrator.migrate(dd)) {
            File ddFile = new File(pckgInfoEx.directory, PackageHelper.DD_FILE_PATH);
            FileOutputStream toStream = new FileOutputStream(new File(pckgInfoEx.directory, PackageHelper.DD_FILE_PATH));
            Writer writer = Writer.createWriter();
            writer.write(dd, toStream);
            toStream.close();
            ddFile.setLastModified(pckgInfoEx.timestamp);
            ((BuilderImpl)builder).remove(packageQname);
            builder.read(PackageHelper.toURL(ddFile).toExternalForm());
        }
        builder.setResolvingMode(1);
        dd = builder.read(packageQname);
        if (dd == null) {
            throw new DeploymentException("Internal error: DD is null");
        }
        this.rememberDependencies(dd, pckgInfoEx);
        Version pckgVersion = dd.getVersion();
        if (pckgVersion == null) {
            pckgVersion = new VersionImpl("0");
        }
        log.info("Loading package [" + newPckg.context + "][" + dd.getTargetNamespace() + "][" + dd.getName() + "][" + pckgVersion.getVersionString() + "]");
        File configFile = new File(pckgInfoEx.directory, PackageHelper.WASP_CONFIG_FILE_PATH);
        if (!configFile.exists()) {
            ClassLoader classLoader;
            FileOutputStream output;
            block16: {
                output = new FileOutputStream(configFile);
                classLoader = null;
                try {
                    try {
                        classLoader = this.initializeClassLoader(pckgInfoEx);
                        DescriptorConverter.ddToConfig(dd, output, newPckg.context, this.systemContext, classLoader, disabled);
                    }
                    catch (Exception e) {
                        log.error("Can't convert DD to config " + dd.getLocation());
                        if (output != null) {
                            output.close();
                        }
                        configFile.delete();
                        throw e;
                    }
                    Object var15_13 = null;
                    if (classLoader == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    if (classLoader != null) {
                        ((WaspClassLoader)classLoader).releaseAllResources();
                    }
                    classLoader = null;
                    if (output == null) throw throwable;
                    output.close();
                    throw throwable;
                }
                ((WaspClassLoader)classLoader).releaseAllResources();
            }
            classLoader = null;
            if (output != null) {
                output.close();
            }
        }
        this.configurator.update(configFile);
        String pckgID = DescriptorConverter.encodeName(newPckg.context, newPckg.targetNamespace, newPckg.name);
        Configurable configurable = this.configurator.getConfigurable("config", pckgID);
        if (configurable == null) {
            return newPckg;
        }
        String policyUrl = pckgInfoEx.directory.toURL().toExternalForm() + "/" + "WASP-INF/policy.xml";
        this.notifyRepositories(configurable, policyUrl, this.getPolicyAsInputStream(pckgInfoEx.directory), true, pckgInfoEx);
        return newPckg;
    }

    private void rememberDependencies(DeploymentDescriptor dd, PackageInfoEx pckgInfoEx) {
        String location = dd.getLocation();
        String path = this.getPackageRelativePath(location);
        Iterator dependencies = dd.getDependencies().iterator();
        while (dependencies.hasNext()) {
            DeploymentDescriptor refdd;
            Dependency dependency = (Dependency)dependencies.next();
            if (dependency == null || (refdd = dependency.getReferredDeploymentDescriptor()) == null) continue;
            String refLocation = refdd.getLocation();
            String refPath = this.getPackageRelativePath(refLocation);
            PackageInfoEx refPckgInfoEx = null;
            if (refPath != null) {
                refPckgInfoEx = (PackageInfoEx)this.packages.get(refPath);
            }
            if (refPckgInfoEx == null || pckgInfoEx == null || path == null) continue;
            refPckgInfoEx.dependents.add(path);
            pckgInfoEx.dependencies.add(refPath);
        }
    }

    private String getPackageRelativePath(String ddLocation) {
        String relativePath = null;
        String absoluteWorkDir = this.workDir.getAbsolutePath().replace(File.separatorChar, '/');
        String appPath = (absoluteWorkDir.charAt(0) == '/' ? "file:" : "file:/") + absoluteWorkDir;
        relativePath = ddLocation.substring(appPath.length() + 1, ddLocation.indexOf("WASP-INF/package.xml") - 1);
        return relativePath;
    }

    private void loadClientPackages() {
        Package[] packages = this.qNameDAG.getSortedObjects().toArray(new Package[0]);
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                Package pckg = packages[i];
                try {
                    this.loadClientPackage(pckg);
                }
                catch (Exception e) {
                    log.error("Can't load DD [" + pckg.context + "][" + pckg.targetNamespace + "][" + pckg.name + "]", e);
                }
                ++i;
            }
        }
    }

    public void resolveDependencies() {
        Package[] packages = this.qNameDAG.getSortedObjects().toArray(new Package[0]);
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                PackageInfoEx pckgInfEx;
                Package pckg = packages[i];
                if (pckg != null && (pckgInfEx = (PackageInfoEx)this.packageIDs.get(pckg)) != null) {
                    try {
                        this.loadPackage(pckg, false);
                    }
                    catch (Exception e) {
                        log.error("Can't load package [" + pckg.context + "][" + pckg.targetNamespace + "][" + pckg.name + "]", e);
                        try {
                            this.uninstallPackage(pckg, true, false);
                        }
                        catch (Exception ee) {
                            log.error("Error when unistalling wrong DD [" + pckg.context + "][" + pckg.targetNamespace + "][" + pckg.name + "]", ee);
                        }
                    }
                }
                ++i;
            }
        }
        this.qNameDAG.clear();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Package installPackage(String context, boolean disabled, InputStream fromStream) throws PackageException, IOException {
        int length;
        File jar = File.createTempFile(TEMPORARY_PACKAGE_FILE_NAME, ".jar");
        jar.deleteOnExit();
        FileOutputStream toStream = new FileOutputStream(jar);
        byte[] buffer = new byte[1000];
        while ((length = fromStream.read(buffer)) > 0) {
            void var7_7;
            toStream.write(buffer, 0, (int)var7_7);
        }
        toStream.close();
        Package newPckg = null;
        JarFile pckg = null;
        try {
            pckg = new JarFile(jar);
            if (pckg.getJarEntry("WASP-INF/package.xml") == null) throw new PackageException("Package doesn't contain deployment descriptor file WASP-INF/package.xml");
            pckg.close();
            newPckg = this.reinstallPackageInternal(context, disabled, jar, false, false, true, true);
            Object var11_10 = null;
            if (pckg != null) {
                pckg.close();
            }
            jar.delete();
            return newPckg;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (pckg != null) {
                pckg.close();
            }
            jar.delete();
            throw throwable;
        }
    }

    private void loadClientPackage(Package newPckg) throws DeploymentException, IOException, Exception {
        String context = "";
        if (newPckg == null) {
            throw new DeploymentException("Internal error: newPckg parameter is null");
        }
        URL pckgUrl = (URL)this.classPathPackages.get(newPckg);
        long pckgTimestamp = this.getClientPackageTimestamp(pckgUrl);
        if (pckgTimestamp == -1L) {
            // empty if block
        }
        if (pckgUrl == null) {
            throw new DeploymentException("Internal error: classPathPackages doesn't contain package " + newPckg);
        }
        Context cxt = (Context)this.contexts.get(context);
        if (cxt == null) {
            throw new DeploymentException("Internal error: context " + context + " doesn't exist");
        }
        Builder builder = cxt.ddBuilder;
        if (builder == null) {
            throw new DeploymentException("Internal error: builder for context " + context + " doesn't exist");
        }
        QName packageQname = new QName(newPckg.targetNamespace, newPckg.name);
        builder.setResolvingMode(0);
        DeploymentDescriptor dd = builder.read(packageQname);
        boolean migrated = DescriptorMigrator.migrate(dd);
        if (migrated) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Writer writer = Writer.createWriter();
            writer.write(dd, outputStream);
            outputStream.close();
            ((BuilderImpl)builder).remove(packageQname);
            String pckgDirName = dd.getName() + dd.getVersion().getVersionString() + "_" + pckgTimestamp;
            File pckgDir = new File(this.appDir, pckgDirName);
            File ddFile = new File(pckgDir, PackageHelper.DD_FILE_PATH);
            dd = builder.read(PackageHelper.toURL(ddFile).toExternalForm(), new ByteArrayInputStream(outputStream.toByteArray()));
        }
        builder.setResolvingMode(1);
        dd = builder.read(packageQname);
        if (dd == null) {
            throw new DeploymentException("Internal error: DD is null");
        }
        if (this.useCache) {
            this.loadWithCache(newPckg, dd, pckgUrl, migrated, pckgTimestamp);
        } else {
            this.loadWithoutCache(newPckg, dd, pckgUrl);
        }
    }

    private void loadWithCache(Package newPckg, DeploymentDescriptor dd, URL pckgUrl, boolean migrated, long pckgTimestamp) throws DeploymentException, IOException, Exception {
        String pckgDirName = dd.getName() + dd.getVersion().getVersionString() + "_" + pckgTimestamp;
        File pckgDir = new File(this.appDir, pckgDirName);
        File ddFile = new File(pckgDir, PackageHelper.DD_FILE_PATH);
        File configFile = new File(pckgDir, PackageHelper.WASP_CONFIG_FILE_PATH);
        ((DeploymentDescriptorImpl)dd).setCanSetLocation(true);
        dd.setLocation(PackageHelper.toURL(ddFile).toExternalForm());
        File lock = new File(pckgDir.getAbsolutePath() + "lock");
        if (pckgDir.exists()) {
            PackageHelper.waitingForUnlock(lock);
            this.configurator.update(configFile);
        } else if (PackageHelper.createLock(lock)) {
            try {
                if (!migrated) {
                    this.writeDDfromUrl(pckgUrl, pckgDir);
                } else {
                    this.writeDDfromDD(pckgUrl, dd, pckgDir);
                }
                this.generateConfig(dd, configFile);
                this.writePolicyFromUrl(pckgUrl, pckgDir);
                Object var13_11 = null;
                lock.delete();
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                lock.delete();
                throw throwable;
            }
            this.configurator.update(configFile);
        } else {
            PackageHelper.waitingForUnlock(lock);
            this.configurator.update(configFile);
        }
        String pckgID = DescriptorConverter.encodeName(this.systemContext, newPckg.targetNamespace, newPckg.name);
        Configurable configurable = this.configurator.getConfigurable("config", pckgID);
        if (configurable != null) {
            Documentation pckgDoc;
            String policyUrl = pckgDir.toURL().toExternalForm() + "/" + "WASP-INF/policy.xml";
            Version pckgVersion = dd.getVersion();
            if (pckgVersion == null) {
                pckgVersion = new VersionImpl("0");
            }
            if ((pckgDoc = dd.getDocumentation()) == null) {
                pckgDoc = new DocumentationImpl();
            }
            String pckgDocURL = null;
            if (pckgDoc.getURL() != null) {
                pckgDocURL = pckgDoc.getURL().toExternalForm();
            }
            PackageInfoEx newInfo = new PackageInfoEx("", newPckg, null, pckgVersion.getVersionString(), pckgDoc.getDisplayName(), pckgDoc.getDescription(), pckgDocURL, pckgDir, new File(((URL)this.classPathPackages.get(newPckg)).toExternalForm()), ddFile.lastModified(), dd.isLibrary());
            this.notifyRepositories(configurable, policyUrl, this.getPolicyAsInputStream(pckgDir), true, newInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadWithoutCache(Package newPckg, DeploymentDescriptor dd, URL pckgUrl) throws DeploymentException, IOException, Exception {
        Documentation pckgDoc;
        ByteArrayOutputStream output;
        block11: {
            output = new ByteArrayOutputStream();
            try {
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    DescriptorConverter.ddToConfig(dd, output, this.systemContext, this.systemContext, classLoader, false);
                }
                catch (Exception e) {
                    log.error("Can't convert DD to config " + dd.getLocation());
                    if (output == null) throw e;
                    output.close();
                    throw e;
                }
                Object var7_7 = null;
                if (output == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (output == null) throw throwable;
                output.close();
                throw throwable;
            }
            output.close();
        }
        this.configurator.update(new ByteArrayInputStream(output.toByteArray()), pckgUrl.toExternalForm());
        String pckgID = DescriptorConverter.encodeName(this.systemContext, newPckg.targetNamespace, newPckg.name);
        Configurable configurable = this.configurator.getConfigurable("config", pckgID);
        if (configurable == null) {
            return;
        }
        InputStream inputStream = null;
        URL policyURL = null;
        String pckg = pckgUrl.toExternalForm();
        int index = pckg.indexOf("WASP-INF/package.xml");
        if (index != -1) {
            String base = pckg.substring(0, index);
            pckgUrl = policyURL = new URL(base + "WASP-INF/policy.xml");
            try {
                inputStream = policyURL.openStream();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String policyUrl = policyURL != null ? policyURL.toExternalForm() : null;
        Version pckgVersion = dd.getVersion();
        if (pckgVersion == null) {
            pckgVersion = new VersionImpl("0");
        }
        if ((pckgDoc = dd.getDocumentation()) == null) {
            pckgDoc = new DocumentationImpl();
        }
        String pckgDocURL = null;
        if (pckgDoc.getURL() != null) {
            pckgDocURL = pckgDoc.getURL().toExternalForm();
        }
        PackageInfoEx newInfo = new PackageInfoEx("", newPckg, null, pckgVersion.getVersionString(), pckgDoc.getDisplayName(), pckgDoc.getDescription(), pckgDocURL, new File(((URL)this.classPathPackages.get(newPckg)).toExternalForm()).getParentFile(), new File(((URL)this.classPathPackages.get(newPckg)).toExternalForm()), 0L, dd.isLibrary());
        this.notifyRepositories(configurable, policyUrl, inputStream, true, newInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateConfig(DeploymentDescriptor dd, File configFile) throws Exception {
        FileOutputStream output = new FileOutputStream(configFile);
        try {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                DescriptorConverter.ddToConfig(dd, output, this.systemContext, this.systemContext, classLoader, false);
            }
            catch (Exception e) {
                log.error("Can't convert DD to config " + dd.getLocation());
                if (output != null) {
                    output.close();
                }
                configFile.delete();
                throw e;
            }
            Object var6_6 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (output == null) throw throwable;
            output.close();
            throw throwable;
        }
        output.close();
    }

    /*
     * WARNING - void declaration
     */
    private void writeDDfromUrl(URL packageUrl, File pckgDir) throws DeploymentException {
        try {
            int length;
            if (!pckgDir.exists()) {
                pckgDir.mkdirs();
            }
            if (!pckgDir.isDirectory()) {
                throw new FileNotFoundException(pckgDir + " isn't directory or can't be created");
            }
            File ddFile = PackageHelper.createFileWithDirectories(PackageHelper.DD_FILE_PATH, pckgDir);
            FileOutputStream outputStream = new FileOutputStream(ddFile);
            byte[] buffer = new byte[1024];
            InputStream inputStream = packageUrl.openStream();
            while ((length = inputStream.read(buffer)) > 0) {
                void var6_8;
                outputStream.write(buffer, 0, (int)var6_8);
            }
            outputStream.close();
            pckgDir.setLastModified(ddFile.lastModified());
        }
        catch (Exception e) {
            throw new DeploymentException("Error during unpacking package.xml from " + packageUrl.toExternalForm(), e);
        }
    }

    private void writeDDfromDD(URL packageUrl, DeploymentDescriptor dd, File pckgDir) throws DeploymentException {
        try {
            if (!pckgDir.exists()) {
                pckgDir.mkdirs();
            }
            if (!pckgDir.isDirectory()) {
                throw new FileNotFoundException(pckgDir + " isn't directory or can't be created");
            }
            File ddFile = PackageHelper.createFileWithDirectories(PackageHelper.DD_FILE_PATH, pckgDir);
            FileOutputStream outputStream = new FileOutputStream(ddFile);
            Writer writer = Writer.createWriter();
            writer.write(dd, outputStream);
            outputStream.close();
            pckgDir.setLastModified(ddFile.lastModified());
        }
        catch (Exception e) {
            throw new DeploymentException("Error during unpacking package.xml from " + packageUrl.toExternalForm(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writePolicyFromUrl(URL pckgUrl, File policyDir) throws DeploymentException {
        try {
            int index;
            InputStream inputStream = null;
            String pckg = pckgUrl.toExternalForm();
            if (pckg.startsWith("jndi:")) {
                pckg = StringHelper.replaceFirst(pckg, "jndi:", "jar:file:");
                pckg = StringHelper.replaceLast(pckg, ".jar/", ".jar!/");
                pckg = StringHelper.replaceLast(pckg, ".jar\\", ".jar!\\");
            }
            if ((index = pckg.indexOf("WASP-INF/package.xml")) != -1) {
                URL policyURL;
                String base = pckg.substring(0, index);
                pckgUrl = policyURL = new URL(base + "WASP-INF/policy.xml");
                try {
                    inputStream = policyURL.openStream();
                }
                catch (Exception e) {
                    return;
                }
            }
            if (!policyDir.exists()) {
                policyDir.mkdirs();
            }
            if (!policyDir.isDirectory()) {
                throw new FileNotFoundException(policyDir + " isn't directory or can't be created");
            }
            if (inputStream != null) {
                int length;
                File policyFile = PackageHelper.createFileWithDirectories(PackageHelper.POLICY_FILE_PATH, policyDir);
                FileOutputStream outputStream = new FileOutputStream(policyFile);
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) > 0) {
                    void var10_12;
                    outputStream.write(buffer, 0, (int)var10_12);
                }
                outputStream.close();
                inputStream.close();
                policyDir.setLastModified(policyFile.lastModified());
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Error during unpacking policy.xml from " + pckgUrl.toExternalForm(), e);
        }
    }

    private long getClientPackageTimestamp(URL packageUrl) {
        try {
            if ("file".equals(packageUrl.getProtocol())) {
                File file = new File(packageUrl.getFile());
                if (file.exists()) {
                    return file.lastModified();
                }
            } else {
                URLConnection urlConnection = packageUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                    File jarFile = new File(jarURLConnection.getJarFile().getName());
                    if (jarFile.exists()) {
                        return jarFile.lastModified();
                    }
                } else {
                    URL url = new URL("jar", packageUrl.getHost(), new File(packageUrl.getFile()).toURL().toExternalForm());
                    urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                        File jarFile = new File(jarURLConnection.getJarFile().getName());
                        if (jarFile.exists()) {
                            return jarFile.lastModified();
                        }
                    } else if (packageUrl.openConnection().getLastModified() > 0L) {
                        return packageUrl.openConnection().getLastModified();
                    }
                }
            }
        }
        catch (IOException e) {
            return -1L;
        }
        return -1L;
    }

    private void canInstall(String context, String targetNamespace, String name) throws DeploymentException {
        Package newPckg;
        String tmpContext = context.replace(File.separatorChar, '/') + "/";
        Iterator contexts = this.contexts.keySet().iterator();
        while (contexts.hasNext()) {
            String tmpc;
            String c = (String)contexts.next();
            if (!(tmpContext.equals("/") ? this.packageIDs.containsKey(newPckg = new Package(c, targetNamespace, name)) : (tmpc = c + "/").startsWith(tmpContext) && this.packageIDs.containsKey(newPckg = new Package(c, targetNamespace, name)))) continue;
            throw new DeploymentException("Package [" + targetNamespace + "][" + name + "] is already installed in [" + c + "] context");
        }
        while (tmpContext.length() > 0) {
            int index = tmpContext.lastIndexOf("/");
            newPckg = new Package(tmpContext = index != -1 ? tmpContext.substring(0, index) : "", targetNamespace, name);
            if (!this.packageIDs.containsKey(newPckg)) continue;
            throw new DeploymentException("Package [" + targetNamespace + "][" + name + "] is already installed in [" + tmpContext + "] context");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void unpackPackage(DeploymentDescriptor dd, File workDir, File source) throws IOException {
        FileOutputStream outputStream;
        FileInputStream inputStream;
        block13: {
            JarInputStream fromStream = null;
            inputStream = null;
            outputStream = null;
            try {
                fromStream = new JarInputStream(new FileInputStream(source));
                if (dd.isClientPackage()) {
                    int length;
                    String[] excludeSuffix = new String[]{new String(".class")};
                    PackageHelper.unpack(fromStream, workDir, false, excludeSuffix);
                    File lib = new File(workDir, PackageHelper.WASP_LIB_FILE_PATH);
                    if (!lib.exists()) {
                        lib.mkdirs();
                    }
                    if (!lib.isDirectory()) {
                        throw new FileNotFoundException(lib + " isn't directory or can't be created");
                    }
                    inputStream = new FileInputStream(source);
                    File jar = new File(lib, source.getName());
                    outputStream = new FileOutputStream(jar);
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) > 0) {
                        void var11_11;
                        outputStream.write(buffer, 0, (int)var11_11);
                    }
                    outputStream.close();
                    jar.setLastModified(source.lastModified());
                    lib.setLastModified(source.lastModified());
                } else {
                    PackageHelper.unpack(fromStream, workDir);
                }
                File ddFile = new File(workDir, PackageHelper.DD_FILE_PATH);
                ddFile.setLastModified(source.lastModified());
                workDir.setLastModified(source.lastModified());
                File configFile = new File(workDir, PackageHelper.WASP_CONFIG_FILE_PATH);
                if (configFile.exists()) {
                    configFile.delete();
                }
                Object var13_12 = null;
                if (fromStream == null) break block13;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (fromStream != null) {
                    fromStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (outputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            fromStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (outputStream != null) {
            inputStream.close();
        }
    }

    public synchronized Package installPackage(String context, boolean disabled, File jar) throws PackageException, IOException {
        return this.reinstallPackageInternal(context, disabled, jar, false, false, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyRepositories(Configurable config, String policyUrl, InputStream policy, boolean install, PackageInfo packageInfo) throws DeploymentException {
        Configurable[] entries;
        String referenceLocation;
        block198: {
            IPolicyManager policyManager;
            Dispatcher dispatcher;
            PortTypeMappingRegistry portTypeMappingRegistry;
            SerializationRepositoryImpl serializationRepository;
            block187: {
                int i;
                WaspSerializationHelper.clearProperties();
                referenceLocation = config.getReferenceLocation();
                ModuleRepository moduleRepository = null;
                TransportRepository transportRepository = null;
                InterceptorRepository interceptorRepository = null;
                HeaderProcessorRepository headerProcessorRepository = null;
                EncodingRepository encodingRepository = null;
                serializationRepository = null;
                portTypeMappingRegistry = null;
                dispatcher = null;
                HandlerRepository handlerRepository = null;
                IListenerRepository listenerRepository = null;
                policyManager = null;
                try {
                    moduleRepository = (ModuleRepository)org.idoox.wasp.Context.getInstance("com.idoox.wasp.ModuleRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    transportRepository = (TransportRepository)org.idoox.wasp.Context.getInstance("org.idoox.transport.TransportRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    interceptorRepository = (InterceptorRepository)org.idoox.wasp.Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    listenerRepository = (IListenerRepository)org.idoox.wasp.Context.getInstance("org.systinet.wasp.webservice.ListenerRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    headerProcessorRepository = (HeaderProcessorRepository)org.idoox.wasp.Context.getInstance("com.idoox.xmlrpc.header.HeaderProcessorRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    encodingRepository = (EncodingRepository)org.idoox.wasp.Context.getInstance("com.idoox.xmlrpc.encoding.EncodingRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    serializationRepository = (SerializationRepositoryImpl)org.idoox.wasp.Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    portTypeMappingRegistry = (PortTypeMappingRegistry)org.idoox.wasp.Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    dispatcher = (Dispatcher)org.idoox.wasp.Context.getInstance("com.idoox.wasp.server.Dispatcher");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    handlerRepository = (HandlerRepository)org.idoox.wasp.Context.getInstance("wasp.core.jaxrpc_handler_repository");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                try {
                    policyManager = (IPolicyManager)org.idoox.wasp.Context.getInstance("org.systinet.wasp.policy.PolicyManager");
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                if (install && (entries = this.configurator.getTopEntries("classSpace")) != null) {
                    int i2 = 0;
                    while (i2 < entries.length) {
                        if (entries[i2].getReferenceLocation() != null && entries[i2].getReferenceLocation().equals(referenceLocation)) {
                            try {
                                ClassSpaceHelper.addClassSpace(entries[i2]);
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating ClassSpaces", e);
                            }
                        }
                        ++i2;
                    }
                }
                if ((entries = this.configurator.getTopEntries("module")) != null) {
                    int i3 = 0;
                    while (i3 < entries.length) {
                        if (entries[i3].getReferenceLocation() != null && entries[i3].getReferenceLocation().equals(referenceLocation)) {
                            if (moduleRepository == null) {
                                throw new DeploymentException("ModuleRepository is null.");
                            }
                            try {
                                if (install) {
                                    moduleRepository.addModule(entries[i3]);
                                } else {
                                    moduleRepository.removeModule(entries[i3].getName());
                                }
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating ModuleRepository", e);
                            }
                        }
                        ++i3;
                    }
                }
                if ((entries = this.configurator.getTopEntries("transport")) != null) {
                    int i4 = 0;
                    while (i4 < entries.length) {
                        if (entries[i4].getReferenceLocation() != null && entries[i4].getReferenceLocation().equals(referenceLocation)) {
                            if (transportRepository == null) {
                                throw new DeploymentException("TransportRepository is null.");
                            }
                            try {
                                if (install) {
                                    transportRepository.addTransport(entries[i4], true);
                                } else {
                                    transportRepository.removeTransport(entries[i4].getName());
                                }
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating TransportRepository", e);
                            }
                        }
                        ++i4;
                    }
                }
                if ((entries = this.configurator.getTopEntries("interceptor")) != null) {
                    int i5 = 0;
                    while (i5 < entries.length) {
                        if (entries[i5].getReferenceLocation() != null && entries[i5].getReferenceLocation().equals(referenceLocation)) {
                            if (interceptorRepository == null) {
                                throw new DeploymentException("InterceptorRepository is null.");
                            }
                            try {
                                if (install) {
                                    interceptorRepository.addInterceptor(entries[i5]);
                                } else {
                                    interceptorRepository.removeInterceptor(entries[i5].getName());
                                }
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating InterceptorRepository", e);
                            }
                        }
                        ++i5;
                    }
                }
                if ((entries = this.configurator.getTopEntries("InterceptorChain")) != null) {
                    int i6 = 0;
                    while (i6 < entries.length) {
                        if (entries[i6].getReferenceLocation() != null && entries[i6].getReferenceLocation().equals(referenceLocation)) {
                            if (interceptorRepository == null) {
                                throw new DeploymentException("InterceptorRepository is null.");
                            }
                            try {
                                if (install) {
                                    interceptorRepository.addChain(entries[i6]);
                                } else {
                                    interceptorRepository.removeChain(entries[i6].getName());
                                }
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating InterceptorRepository", e);
                            }
                        }
                        ++i6;
                    }
                }
                if ((entries = this.configurator.getTopEntries("listener")) != null) {
                    int i7 = 0;
                    while (i7 < entries.length) {
                        if (entries[i7].getReferenceLocation() != null && entries[i7].getReferenceLocation().equals(referenceLocation)) {
                            if (listenerRepository == null) {
                                throw new DeploymentException("ListenerRepository is null.");
                            }
                            try {
                                if (install) {
                                    listenerRepository.addListener(entries[i7]);
                                } else {
                                    listenerRepository.removeServiceEndpointListener(entries[i7].getName());
                                    listenerRepository.removeServiceClientListener(entries[i7].getName());
                                }
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating ListenerRepository", e);
                            }
                        }
                        ++i7;
                    }
                }
                if ((entries = this.configurator.getTopEntries("HeaderInstance")) != null) {
                    int i8 = 0;
                    while (i8 < entries.length) {
                        if (entries[i8].getReferenceLocation() != null && entries[i8].getReferenceLocation().equals(referenceLocation)) {
                            if (headerProcessorRepository == null) {
                                throw new DeploymentException("HeaderProcessorRepository is null.");
                            }
                            try {
                                if (install) {
                                    headerProcessorRepository.addHeaderProcessor(entries[i8]);
                                } else {
                                    headerProcessorRepository.removeHeaderProcessor(entries[i8].getName());
                                }
                            }
                            catch (Exception e) {
                                throw new DeploymentException("Error during updating HeaderProcessorRepository", e);
                            }
                        }
                        ++i8;
                    }
                }
                ArrayList<Configurable> allEntries = new ArrayList<Configurable>();
                allEntries.addAll(Arrays.asList(this.configurator.getTopEntries("Headers")));
                allEntries.addAll(Arrays.asList(this.configurator.getTopEntries("Handlers")));
                Iterator it = allEntries.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        entries = this.configurator.getTopEntries("encoding");
                        if (entries != null) {
                            i = 0;
                            break;
                        }
                        break block187;
                    }
                    Configurable entry = (Configurable)it.next();
                    if (entry.getReferenceLocation() == null || !entry.getReferenceLocation().equals(referenceLocation)) continue;
                    if (headerProcessorRepository == null) {
                        throw new DeploymentException("HeaderProcessorRepository is null.");
                    }
                    if (handlerRepository == null) {
                        throw new DeploymentException("HandlerRepository is null.");
                    }
                    try {
                        if (install) {
                            headerProcessorRepository.addHeaderProcessorDeclaration(entry);
                            handlerRepository.registerHandlerChain(entry);
                            continue;
                        }
                        headerProcessorRepository.removeHeaderProcessorDeclaration(entry.getName());
                        handlerRepository.unregisterHandlerChain(entry);
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Error during updating HeaderProcessor(Handler)Repository", e);
                    }
                }
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (encodingRepository == null) {
                            throw new DeploymentException("EncodingRepository is null.");
                        }
                        try {
                            if (install) {
                                encodingRepository.addEncoding(entries[i]);
                            } else {
                                encodingRepository.removeEncoding(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating EncodingRepository", e);
                        }
                    }
                    ++i;
                }
            }
            if ((entries = this.configurator.getTopEntries("serialization")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (serializationRepository == null) {
                            throw new DeploymentException("SerializationRepository is null.");
                        }
                        try {
                            if (install) {
                                serializationRepository.addSerialization(entries[i]);
                            } else {
                                serializationRepository.removeSerialization(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating SerializationRepositoryImpl", e);
                        }
                    }
                    ++i;
                }
            }
            if ((entries = this.configurator.getTopEntries("faultSerialization")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (serializationRepository == null) {
                            throw new DeploymentException("SerializationRepository is null.");
                        }
                        try {
                            if (install) {
                                serializationRepository.addFaultSerialization(entries[i]);
                            } else {
                                serializationRepository.removeFaultSerialization(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating SerializationRepositoryImpl", e);
                        }
                    }
                    ++i;
                }
            }
            if ((entries = this.configurator.getTopEntries("portTypeMappingRegistryConfig")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (portTypeMappingRegistry == null) {
                            throw new DeploymentException("PortTypeMappingRegistry is null.");
                        }
                        try {
                            if (install) {
                                portTypeMappingRegistry.addPortTypeMappingRegistryConfig(entries[i]);
                            } else {
                                portTypeMappingRegistry.removePortTypeMappingRegistryConfig(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating PortTypeMappingRegistry", e);
                        }
                    }
                    ++i;
                }
            }
            if ((entries = this.configurator.getTopEntries("ServiceInstance")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (dispatcher == null) {
                            throw new DeploymentException("ServiceManager is null.");
                        }
                        try {
                            if (install) {
                                dispatcher.addServiceInstance(entries[i]);
                            } else {
                                dispatcher.removeServiceInstance(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating ServiceManager", e);
                        }
                    }
                    ++i;
                }
            }
            if (!this.initializing && (entries = this.configurator.getTopEntries("ServiceBinding")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (dispatcher == null) {
                            throw new DeploymentException("ServiceManager is null.");
                        }
                        try {
                            if (install) {
                                dispatcher.addServiceBinding(entries[i]);
                            } else {
                                dispatcher.removeServiceBinding(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating ServiceManager", e);
                        }
                    }
                    ++i;
                }
            }
            if (!this.initializing && (entries = this.configurator.getTopEntries("GetServiceBinding")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (dispatcher == null) {
                            throw new DeploymentException("ServiceManager is null.");
                        }
                        try {
                            if (install) {
                                dispatcher.addServiceBinding(entries[i]);
                            } else {
                                dispatcher.removeServiceBinding(entries[i].getName());
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating ServiceManager", e);
                        }
                    }
                    ++i;
                }
            }
            if ((entries = this.configurator.getTopEntries("policyAssertion")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (policyManager == null) {
                            throw new DeploymentException("PolicyManager is null.");
                        }
                        try {
                            if (install) {
                                policyManager.addPolicyElement(entries[i]);
                            } else {
                                policyManager.removePolicyElement(entries[i]);
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating PolicyManager", e);
                        }
                    }
                    ++i;
                }
            }
            if ((entries = this.configurator.getTopEntries("domainExpression")) != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                        if (policyManager == null) {
                            throw new DeploymentException("PolicyManager is null.");
                        }
                        try {
                            if (install) {
                                policyManager.addPolicyElement(entries[i]);
                            } else {
                                policyManager.removePolicyElement(entries[i]);
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error during updating PolicyManager", e);
                        }
                    }
                    ++i;
                }
            }
            if (policy != null) {
                if (policyManager == null) {
                    throw new DeploymentException("PolicyManager is null.");
                }
                try {
                    try {
                        if (install) {
                            policyManager.addPolicy(policyUrl, policy);
                        } else {
                            policyManager.removePolicy(policyUrl);
                        }
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Error during updating PolicyManager", e);
                    }
                    Object var24_71 = null;
                    if (policy == null) break block198;
                }
                catch (Throwable throwable) {
                    Object var24_72 = null;
                    if (policy == null) throw throwable;
                    try {
                        policy.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                policy.close();
            }
        }
        if (packageInfo != null) {
            Object e = this.packageListenerRepositoryLock;
            synchronized (e) {
                if (this.packageListenerRepository.size() != 0) {
                    ClassLoader classLoader = null;
                    if (packageInfo != null && packageInfo.classLoader != null) {
                        try {
                            classLoader = ClassSpaceHelper.getClassSpace(packageInfo.classLoader).getClassLoader();
                        }
                        catch (Exception e2) {
                            classLoader = this.getClass().getClassLoader();
                        }
                    }
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    int i = 0;
                    while (i < this.packageListenerRepository.size()) {
                        if (install) {
                            ((PackageListener)this.packageListenerRepository.get(i)).onDeploy(packageInfo, classLoader, config);
                        } else {
                            ((PackageListener)this.packageListenerRepository.get(i)).onUndeploy(packageInfo);
                        }
                        ++i;
                    }
                }
            }
        }
        if (install) return;
        entries = this.configurator.getTopEntries("classSpace");
        if (entries == null) return;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getReferenceLocation() != null && entries[i].getReferenceLocation().equals(referenceLocation)) {
                try {
                    ClassSpaceHelper.removeClassSpace(entries[i].getName());
                }
                catch (Exception e) {
                    throw new DeploymentException("Error during updating ClassSpaces", e);
                }
            }
            ++i;
        }
        return;
    }

    public synchronized void uninstallPackage(Package pckg, boolean force) throws PackageException {
        this.uninstallPackage(pckg, force, true);
    }

    public void uninstallPackage(Package pckg, boolean force, boolean deleteSource) throws PackageException {
        try {
            if (pckg == null) {
                throw new DeploymentException("Please, specify a package to undeploy");
            }
            if (pckg.context == null) {
                throw new DeploymentException("Please, specify a package context");
            }
            if (pckg.targetNamespace == null) {
                throw new DeploymentException("Please, specify a package targetNamespace");
            }
            if (pckg.name == null) {
                throw new DeploymentException("Please, specify a package name");
            }
            log.info("Uninstalling package [" + pckg.context + "][" + pckg.targetNamespace + "][" + pckg.name + "]");
            String lowerContext = pckg.context;
            PackageInfoEx infoEx = (PackageInfoEx)this.packageIDs.get(pckg);
            if (infoEx == null) {
                throw new DeploymentException("Package [" + lowerContext + "][" + pckg.targetNamespace + "][" + pckg.name + "] isn't installed");
            }
            this.updateDependencies(pckg, force);
            String pckgID = DescriptorConverter.encodeName(lowerContext, pckg.targetNamespace, pckg.name);
            Configurable configurable = this.configurator.getConfigurable("config", pckgID);
            if (configurable != null) {
                String policyUrl = null;
                try {
                    policyUrl = infoEx.directory.toURL().toExternalForm() + "/" + "WASP-INF/policy.xml";
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                this.notifyRepositories(configurable, policyUrl, this.getPolicyAsInputStream(infoEx.directory), false, infoEx);
            }
            Context cxt = (Context)this.contexts.get(lowerContext);
            if (cxt == null) {
                throw new DeploymentException("Can't find context: " + lowerContext);
            }
            int i = 0;
            while (i < cxt.packages.size()) {
                if (((PackageInfoEx)cxt.packages.get((int)i)).pckg.equals(pckg)) {
                    cxt.packages.remove(i);
                    break;
                }
                ++i;
            }
            PackageInfoEx pckgInfoEx = (PackageInfoEx)this.packageIDs.get(pckg);
            if (pckgInfoEx != null) {
                try {
                    File ddFile = new File(pckgInfoEx.directory, PackageHelper.DD_FILE_PATH);
                    ((BuilderImpl)cxt.ddBuilder).remove(PackageHelper.toURL(ddFile).toExternalForm());
                }
                catch (MalformedURLException e) {
                    log.error("Internal error: can't remove package from builder " + pckg);
                }
            }
            if (this.packages.remove("".equals(lowerContext) ? infoEx.dirName : lowerContext + '/' + infoEx.dirName) == null) {
                log.error("Internal error: packages doesn't contain package " + lowerContext + '/' + infoEx.dirName);
            }
            if (this.packageIDs.remove(pckg) == null) {
                log.error("Internal error: package IDs doesn't contain package " + pckg);
            }
            PackageHelper.deleteDir(infoEx.directory);
            if (deleteSource) {
                if (infoEx.source.isDirectory()) {
                    PackageHelper.deleteDir(infoEx.source);
                } else {
                    infoEx.source.delete();
                }
            }
            this.configurator.update();
        }
        catch (DeploymentException e) {
            throw new PackageException(e);
        }
        catch (RuntimeWrappedException e) {
            throw new PackageException("Can't update configurator", e);
        }
    }

    public Package reinstallPackageInternal(String context, boolean disabled, File source, boolean reinstall, boolean force, boolean load, boolean deleteSource) throws PackageException, IOException {
        Context cxt = null;
        DeploymentDescriptor dd = null;
        Package pckg = null;
        Package newPckg = null;
        PackageInfoEx infoEx = null;
        File pckgDir = null;
        File newSource = null;
        try {
            this.checkContext(context);
            cxt = this.createContextWithParentContext(context);
            cxt.ddBuilder.setResolvingMode(0);
            if (source.isFile()) {
                dd = cxt.ddBuilder.read("jar:" + PackageHelper.toURL(source) + "!/" + "WASP-INF/package.xml");
                ((BuilderImpl)cxt.ddBuilder).remove("jar:" + PackageHelper.toURL(source) + "!/" + "WASP-INF/package.xml");
            } else {
                File ddFile = new File(source, PackageHelper.DD_FILE_PATH);
                dd = cxt.ddBuilder.read(PackageHelper.toURL(ddFile).toExternalForm());
                ((BuilderImpl)cxt.ddBuilder).remove(PackageHelper.toURL(ddFile).toExternalForm());
            }
            pckg = new Package(context, dd.getTargetNamespace(), dd.getName());
            if (reinstall && (infoEx = (PackageInfoEx)this.packageIDs.get(pckg)) != null) {
                this.uninstallPackage(pckg, force, deleteSource);
            }
            this.canInstall(context, dd.getTargetNamespace(), dd.getName());
        }
        catch (Exception e) {
            throw new PackageException(e);
        }
        try {
            log.info("Installing package " + source);
            String pckgName = source.getName();
            if (source.isFile()) {
                if (pckgName.startsWith(TEMPORARY_PACKAGE_FILE_NAME)) {
                    pckgName = dd.getName();
                    pckgName = PackageHelper.newName(cxt.appDirectory, cxt.workDirectory, pckgName);
                } else {
                    File newJar;
                    String newName;
                    if (pckgName.endsWith(".jar")) {
                        pckgName = pckgName.substring(0, pckgName.length() - 4);
                    }
                    if (!pckgName.equals(newName = PackageHelper.newName(cxt.workDirectory, pckgName)) && (newJar = new File(cxt.appDirectory, newName + ".jar")).exists()) {
                        newName = PackageHelper.newName(cxt.appDirectory, cxt.workDirectory, pckgName);
                    }
                    pckgName = newName;
                }
                newSource = new File(cxt.appDirectory, pckgName + ".jar");
                pckgDir = new File(cxt.workDirectory, pckgName + ".jar");
                PackageHelper.moveTo(source, newSource);
                pckgName = newSource.getName();
                this.unpackPackage(dd, pckgDir, newSource);
            } else {
                pckgDir = new File(cxt.workDirectory, pckgName);
                if (pckgDir.exists()) {
                    if (pckgName.endsWith(".jar")) {
                        pckgName = pckgName.substring(0, pckgName.length() - 4);
                    }
                    pckgName = PackageHelper.newName(cxt.appDirectory, cxt.workDirectory, pckgName);
                    pckgDir = new File(cxt.workDirectory, pckgName);
                }
                PackageHelper.copyDir(source, pckgDir, false, null);
                newSource = new File(cxt.appDirectory, pckgName);
                PackageHelper.moveTo(source, newSource);
                pckgName = newSource.getName();
            }
            try {
                newPckg = this.registerPackage(context, pckgName, pckgDir, newSource, false);
            }
            catch (DeploymentException e) {
                log.error("Can't register package " + newSource);
                throw e;
            }
            if (load) {
                try {
                    try {
                        newPckg = this.loadPackage(newPckg, disabled);
                    }
                    catch (Exception e) {
                        log.error("Can't load package " + newPckg);
                        throw e;
                    }
                    Object var19_23 = null;
                    this.qNameDAG.clear();
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    this.qNameDAG.clear();
                    throw throwable;
                }
            }
            PackageInfoEx newInfoEx = (PackageInfoEx)this.packageIDs.get(pckg);
            if (infoEx != null) {
                newInfoEx.dependents = infoEx.dependents;
            }
            return pckg;
        }
        catch (Exception e) {
            if (newPckg != null) {
                try {
                    this.uninstallPackage(newPckg, true, deleteSource);
                }
                catch (PackageException ee) {
                    throw new PackageException("Can't install package: " + e.getMessage() + " " + "this wrong package can't be uninstalled: " + ee.getMessage(), e);
                }
            } else if (pckgDir != null) {
                PackageHelper.deleteDir(pckgDir);
                if (deleteSource && newSource != null) {
                    if (source.isDirectory()) {
                        PackageHelper.deleteDir(newSource);
                    } else {
                        newSource.delete();
                    }
                }
            }
            throw new PackageException(e);
        }
    }

    public synchronized Package reinstallPackage(String context, boolean disabled, File jar, boolean force) throws PackageException, IOException {
        return this.reinstallPackageInternal(context, disabled, jar, true, force, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Package reinstallPackage(String context, boolean disabled, InputStream fromStream, boolean force) throws PackageException, IOException {
        int length;
        File jar = File.createTempFile(TEMPORARY_PACKAGE_FILE_NAME, ".jar");
        jar.deleteOnExit();
        FileOutputStream toStream = new FileOutputStream(jar);
        byte[] buffer = new byte[1000];
        while ((length = fromStream.read(buffer)) > 0) {
            void var8_8;
            toStream.write(buffer, 0, (int)var8_8);
        }
        toStream.close();
        Package newPckg = null;
        JarFile pckg = null;
        try {
            pckg = new JarFile(jar);
            if (pckg.getJarEntry("WASP-INF/package.xml") == null) {
                throw new PackageException("Package doesn't contain deployment descriptor file WASP-INF/package.xml");
            }
            pckg.close();
            newPckg = this.reinstallPackageInternal(context, disabled, jar, true, force, true, true);
            Object var12_11 = null;
            jar.delete();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            jar.delete();
            throw throwable;
        }
        return newPckg;
    }

    public String[] getContexts() {
        Map map = this.contexts;
        synchronized (map) {
            String[] stringArray = this.contexts.keySet().toArray(new String[0]);
            return stringArray;
        }
    }

    public PackageInfo[] getAllPackages() {
        Map map = this.packages;
        synchronized (map) {
            PackageInfo[] packageInfoArray = this.packages.values().toArray(new PackageInfo[0]);
            return packageInfoArray;
        }
    }

    public PackageInfo[] getPackages(String context) {
        Map map = this.contexts;
        synchronized (map) {
            Context cxt = (Context)this.contexts.get(context);
            if (cxt == null) {
                PackageInfo[] packageInfoArray = null;
                return packageInfoArray;
            }
            PackageInfo[] packageInfoArray = cxt.packages.toArray(new PackageInfo[0]);
            return packageInfoArray;
        }
    }

    public PackageInfo getPackage(Package pckg) {
        Map map = this.packageIDs;
        synchronized (map) {
            PackageInfoEx packageInfoEx = (PackageInfoEx)this.packageIDs.get(pckg);
            return packageInfoEx;
        }
    }

    public PackageInfo findPackage(String targetNamespace, String name, String context) {
        String tmpContext = context.replace(File.separatorChar, '/') + "/";
        while (tmpContext.length() > 0) {
            int index = tmpContext.lastIndexOf("/");
            tmpContext = index != -1 ? tmpContext.substring(0, index) : "";
            Package pckg = new Package(tmpContext, targetNamespace, name);
            Map map = this.packageIDs;
            synchronized (map) {
                PackageInfoEx pckgInfoEx = (PackageInfoEx)this.packageIDs.get(pckg);
                if (pckgInfoEx != null) {
                    PackageInfoEx packageInfoEx = pckgInfoEx;
                    return packageInfoEx;
                }
            }
        }
        return null;
    }

    public InputStream getPackageDDAsStream(Package pckg) throws IOException {
        Map map = this.packageIDs;
        synchronized (map) {
            PackageInfoEx infoEx = (PackageInfoEx)this.packageIDs.get(pckg);
            if (infoEx == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            FileInputStream fileInputStream = new FileInputStream(new File(infoEx.directory, PackageHelper.DD_FILE_PATH));
            return fileInputStream;
        }
    }

    public InputStream getPackageDDAsStream(Package pckg, String ddNamespace) throws IOException {
        InputStream in = this.getPackageDDAsStream(pckg);
        if (in == null) {
            return null;
        }
        if (ddNamespace.equals("http://systinet.com/wasp/package/1.2")) {
            in = this.convert(in, "http://systinet.com/wasp/package/1.2");
        } else if (ddNamespace.equals("http://systinet.com/wasp/package/1.1")) {
            in = this.convert(in, "http://systinet.com/wasp/package/1.1");
        } else if (ddNamespace.equals("http://systinet.com/wasp/package/1.0")) {
            in = this.convert(in, "http://systinet.com/wasp/package/1.0");
        }
        return in;
    }

    protected InputStream convert(InputStream in, String requiredNamespace) {
        ByteArrayInputStream pipe = null;
        try {
            Builder builder = Builder.createBuilder();
            builder.setResolvingMode(0);
            DeploymentDescriptor dd = builder.read("http://wasp", in);
            ((DeploymentDescriptorImpl)dd).setRequiredNamespace(requiredNamespace);
            Writer writer = Writer.createWriter();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            writer.write(dd, out);
            pipe = new ByteArrayInputStream(out.toByteArray());
            in.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return pipe;
    }

    public DeploymentDescriptor getPackageDDAsObject(Package pckg) throws PackageException {
        try {
            if (pckg == null) {
                return null;
            }
            QName packageQname = new QName(pckg.targetNamespace, pckg.name);
            String context = pckg.context;
            Context cxt = null;
            Map map = this.contexts;
            synchronized (map) {
                cxt = (Context)this.contexts.get(context);
            }
            if (cxt == null) {
                throw new PackageException("Context " + context + " doesn't exist");
            }
            Builder builder = cxt.ddBuilder;
            if (builder == null) {
                throw new PackageException("Builder for context " + context + " doesn't exist");
            }
            return builder.read(packageQname);
        }
        catch (IllegalArgumentException e) {
            throw new PackageException("Can't get deployment descriptor", e);
        }
        catch (DeploymentException e) {
            throw new PackageException("Can't get deployment descriptor", e);
        }
    }

    public InputStream getPackageAsStream(Package pckg) throws IOException {
        File jar = this.getPackageAsFile(pckg);
        if (jar == null) {
            return null;
        }
        return new FileInputStream(jar);
    }

    public File getPackageAsFile(Package pckg) throws IOException {
        PackageInfoEx infoEx = null;
        Map map = this.packageIDs;
        synchronized (map) {
            infoEx = (PackageInfoEx)this.packageIDs.get(pckg);
        }
        if (infoEx == null) {
            return null;
        }
        if (infoEx.source.isFile()) {
            return infoEx.source;
        }
        File jar = File.createTempFile(TEMPORARY_PACKAGE_FILE_NAME, ".jar");
        jar.deleteOnExit();
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jar));
        PackageHelper.pack(infoEx.directory, jarStream, new String[]{"WASP-INF/wasp.xml", "debug.txt"});
        jarStream.close();
        return jar;
    }

    public String getSystemContext() {
        return this.systemContext;
    }

    private BuilderImpl createBuilder(String context, Builder parent) throws DeploymentException {
        BuilderImpl ddBuilder = (BuilderImpl)Builder.createBuilder();
        ddBuilder.setParrentBuilder(parent);
        ddBuilder.registerLoader(new DDLoader(this.packageIDs, context));
        return ddBuilder;
    }

    private void updateDependencies(Package pckg, boolean force) throws DeploymentException {
        PackageInfoEx pckgInfoEx = (PackageInfoEx)this.packageIDs.get(pckg);
        if (!force && pckgInfoEx != null) {
            Iterator dependants = pckgInfoEx.dependents.iterator();
            while (dependants.hasNext()) {
                String path = (String)dependants.next();
                PackageInfoEx tmpPckg = (PackageInfoEx)this.packages.get(path);
                if (tmpPckg == null) continue;
                throw new DeploymentException("Package " + tmpPckg.pckg + " depends on unistalled package." + "(Undeploy this package first)");
            }
        }
        String pckgPath = pckg.context.replace(File.separatorChar, '/') + "/" + pckgInfoEx.dirName;
        if (pckgInfoEx != null) {
            Iterator iterator = pckgInfoEx.dependencies.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                PackageInfoEx tmpPckgInfoEx = (PackageInfoEx)this.packages.get(path);
                if (tmpPckgInfoEx != null) {
                    tmpPckgInfoEx.dependents.remove(pckgPath);
                    continue;
                }
                log.warn("Undeployed package " + pckg + " has unconsistent dependencies (" + path + " doesn't exist)");
            }
            pckgInfoEx.dependencies.clear();
        }
    }

    private void checkContext(String context) throws DeploymentException {
        if (context == null) {
            throw new DeploymentException("Please, specify a context where to deploy. Context can't be null.");
        }
        String[] notSupportChar = new String[]{"..", ":", "*", "?", "\"", "<", ">", "|", "~"};
        int i = 0;
        while (i < notSupportChar.length) {
            if (context.indexOf(notSupportChar[i]) != -1) {
                throw new DeploymentException("Context can't contain any of the following characters .. : * ? \" < > | ~");
            }
            ++i;
        }
        if ((context = context.replace(File.separatorChar, '/')).startsWith("/") || context.endsWith("/")) {
            throw new DeploymentException("Context can't start or end with /");
        }
    }

    private Context createContextWithParentContext(String context) throws DeploymentException, IOException {
        Context cxt = (Context)this.contexts.get(context);
        if (cxt == null) {
            if (this.packages.containsKey(context)) {
                Package pckg = ((PackageInfoEx)this.packages.get((Object)context)).pckg;
                throw new DeploymentException("Context path can't begin with some existing package path " + pckg.context + "/" + pckg.name);
            }
            String tmpContext = context;
            int index = context.lastIndexOf("/");
            if (index != -1) {
                tmpContext = tmpContext.substring(0, index);
            } else {
                tmpContext = "";
                if (!this.contexts.containsKey(tmpContext)) {
                    try {
                        this.contexts.put(tmpContext, new Context(new ArrayList(), this.appDir, this.workDir, this.createBuilder(tmpContext, null)));
                    }
                    catch (DeploymentException e) {
                        throw new DeploymentException("Can't create builder for appliaction directory " + this.appDir, e);
                    }
                }
            }
            Context subCxt = this.createContextWithParentContext(tmpContext);
            File cxtAppDir = PackageHelper.createFileWithDirectories(context.replace('/', File.separatorChar) + File.separator, this.appDir);
            File cxtWorkDir = PackageHelper.createFileWithDirectories(context.replace('/', File.separatorChar) + File.separator, this.workDir);
            Builder builder = null;
            builder = context.equals(this.systemContext) || context.startsWith(this.systemContext + "/") ? ((Context)this.contexts.get((Object)"")).ddBuilder : this.createBuilder(context, subCxt.ddBuilder);
            cxt = new Context(new ArrayList(), cxtAppDir, cxtWorkDir, builder);
            this.contexts.put(context, cxt);
            return cxt;
        }
        if (!cxt.appDirectory.exists()) {
            cxt.appDirectory.mkdirs();
        }
        if (!cxt.workDirectory.exists()) {
            cxt.workDirectory.mkdirs();
        }
        return cxt;
    }

    private ClassLoader initializeClassLoader(PackageInfoEx pckg) throws DeploymentException {
        File classes;
        File[] files;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File lib = new File(pckg.directory, PackageHelper.WASP_LIB_FILE_PATH);
        if (lib.exists() && (files = lib.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.exists() && (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip"))) {
                    try {
                        arrayList.add(PackageHelper.toURL(file));
                    }
                    catch (MalformedURLException e) {
                        throw new DeploymentException("Can't get URL from file " + file.getAbsolutePath(), e);
                    }
                }
                ++i;
            }
        }
        if ((classes = new File(pckg.directory, PackageHelper.WASP_CLASSES_FILE_PATH)).exists()) {
            try {
                arrayList.add(PackageHelper.toURL(classes));
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Can't get URL from directory " + classes.getAbsolutePath(), e);
            }
        }
        ArrayList<ClassLoader> parentClassLoaders = new ArrayList<ClassLoader>();
        Iterator iterator = pckg.dependencies.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            PackageInfoEx depenedency = (PackageInfoEx)this.packages.get(key);
            if (!depenedency.isLibrary) continue;
            try {
                String referenceLocation = PackageHelper.toURL(depenedency.directory).toExternalForm();
                if (referenceLocation.endsWith("/")) {
                    referenceLocation = referenceLocation.substring(0, referenceLocation.length() - 1);
                }
                parentClassLoaders.add(ClassSpaceHelper.getClassSpace(null, referenceLocation).getClassLoader());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Can't get parent classSpace for package " + pckg, e);
            }
        }
        if (parentClassLoaders.size() == 0) {
            parentClassLoaders.add(ClassSpaceHelper.getServiceDefaultParentClassSpace().getClassLoader());
        }
        return new WaspClassLoader(arrayList.toArray(new URL[0]), parentClassLoaders.toArray(new ClassLoader[0]));
    }

    private void createDefaultClientDD() {
        try {
            String context = "";
            Context cxt = (Context)this.contexts.get(context);
            if (cxt == null) {
                throw new DeploymentException("Internal error: context " + context + " doesn't exist");
            }
            Builder builder = cxt.ddBuilder;
            if (builder == null) {
                throw new DeploymentException("Internal error: builder for context " + context + " doesn't exist");
            }
            this.defaultClientDD = builder.create(DEFAULT_CLIENT_PACKAGE_NAME, DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE, DEFAULT_CLIENT_PACKAGE_VERSION);
            this.defaultClientDD.addProcessing(DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
            this.defaultClientDD.setClientPackage(true);
            this.defaultClientDD.setLocation(PackageHelper.toURL(this.appDir).toExternalForm() + DEFAULT_CLIENT_PACKAGE_NAME + DEFAULT_CLIENT_PACKAGE_VERSION + "/" + "WASP-INF/package.xml");
        }
        catch (Exception e) {
            log.error("Cannot create default client deployment descriptor", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveDefaultClientDD() {
        String context = "";
        try {
            ByteArrayOutputStream output;
            block11: {
                if (this.defaultClientDD == null) {
                    return;
                }
                Context cxt = (Context)this.contexts.get(context);
                if (cxt == null) {
                    throw new DeploymentException("Internal error: context " + context + " doesn't exist");
                }
                Builder builder = cxt.ddBuilder;
                if (builder == null) {
                    throw new DeploymentException("Internal error: builder for context " + context + " doesn't exist");
                }
                builder.setResolvingMode(1);
                ((BuilderImpl)builder).resolveDependencies(this.defaultClientDD);
                if (this.serializeDefaultClientDD) {
                    this.seralizeDefaulDD();
                }
                output = new ByteArrayOutputStream();
                try {
                    try {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        DescriptorConverter.ddToConfig(this.defaultClientDD, output, this.systemContext, this.systemContext, classLoader, false);
                    }
                    catch (Exception e) {
                        log.error("Can't convert DD to config " + this.defaultClientDD.getLocation());
                        if (output == null) throw e;
                        output.close();
                        throw e;
                    }
                    Object var7_8 = null;
                    if (output == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (output == null) throw throwable;
                    output.close();
                    throw throwable;
                }
                output.close();
            }
            File pckgDir = new File(this.appDir, "DefaultClientPackage4.7/WASP-INF/wasp.xml");
            this.configurator.update(new ByteArrayInputStream(output.toByteArray()), PackageHelper.toURL(pckgDir).toExternalForm());
            String pckgID = DescriptorConverter.encodeName(this.systemContext, DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE, DEFAULT_CLIENT_PACKAGE_NAME);
            Configurable configurable = this.configurator.getConfigurable("config", pckgID);
            if (configurable == null) {
                return;
            }
            this.notifyRepositories(configurable, null, null, true, null);
            return;
        }
        catch (Exception e) {
            log.error("Can't load DD [" + context + "][" + this.defaultClientDD.getTargetNamespace() + "][" + this.defaultClientDD.getName() + "]", e);
        }
    }

    private void seralizeDefaulDD() {
        try {
            File pckgDir = new File(this.appDir, "DefaultClientPackage4.7");
            if (!pckgDir.exists()) {
                pckgDir.mkdirs();
            }
            if (!pckgDir.isDirectory()) {
                throw new FileNotFoundException(pckgDir + " isn't directory or can't be created");
            }
            File ddFile = PackageHelper.createFileWithDirectories(PackageHelper.DD_FILE_PATH, pckgDir);
            File configFile = PackageHelper.createFileWithDirectories(PackageHelper.WASP_CONFIG_FILE_PATH, pckgDir);
            FileOutputStream outputStream = new FileOutputStream(ddFile);
            Writer writer = Writer.createWriter();
            writer.write(this.defaultClientDD, outputStream);
            outputStream.close();
            pckgDir.setLastModified(ddFile.lastModified());
            ClassLoader classLoader = this.getClass().getClassLoader();
            FileOutputStream output = new FileOutputStream(configFile);
            DescriptorConverter.ddToConfig(this.defaultClientDD, output, this.systemContext, this.systemContext, classLoader, false);
            output.close();
        }
        catch (Exception e) {
            log.error("Error during serializing default client package", e);
        }
    }

    public String getDefaultSerializationID() {
        if (this.defaultClientDD != null) {
            Processing processing = (Processing)this.defaultClientDD.getProcessings().get(DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
            try {
                if (processing != null && DescriptorHelper.getProcessedSerializations(processing).hasNext()) {
                    String context = this.systemContext;
                    return DescriptorConverter.encodeName(context, DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE, DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
                }
            }
            catch (PublishException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return null;
    }

    public String getDefaultTransportInterceptorsID() {
        if (this.defaultClientDD != null) {
            Processing processing = (Processing)this.defaultClientDD.getProcessings().get(DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
            try {
                if (processing != null && DescriptorHelper.getProcessedInterceptors(processing).hasNext()) {
                    String context = this.systemContext;
                    return DescriptorConverter.encodeName(context, DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE, DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
                }
            }
            catch (PublishException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return null;
    }

    public String getDefaultHeadersID() {
        return this.getDefaultHandlersID();
    }

    public String getDefaultHandlersID() {
        if (this.defaultClientDD != null) {
            Processing processing = (Processing)this.defaultClientDD.getProcessings().get(DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
            try {
                if (processing != null && DescriptorHelper.getProcessedHandlers(processing).hasNext() || DescriptorHelper.getProcessedHeaderProcessors(processing).hasNext()) {
                    String context = this.systemContext;
                    return DescriptorConverter.encodeName(context, DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE, DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
                }
            }
            catch (PublishException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return null;
    }

    public String getDefaultFaultSerializationID() {
        if (this.defaultClientDD != null) {
            Processing processing = (Processing)this.defaultClientDD.getProcessings().get(DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
            try {
                if (processing != null && DescriptorHelper.getProcessedFaultSerializations(processing).hasNext()) {
                    String context = this.systemContext;
                    return DescriptorConverter.encodeName(context, DEFAULT_CLIENT_PACKAGE_TARGETNAMESPACE, DEFAULT_CLIENT_PACKAGE_PROCESSING_NAME);
                }
            }
            catch (PublishException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return null;
    }

    public Builder getContextBuilder(String contextName) {
        Context context = (Context)this.contexts.get(contextName);
        return context == null ? null : context.ddBuilder;
    }

    public File getApplicationDirectory() {
        return this.appDir;
    }

    public Map getPackagesMap() {
        return this.packages;
    }

    private InputStream getPolicyAsInputStream(File pckgDir) {
        try {
            File policyFile = new File(pckgDir, PackageHelper.POLICY_FILE_PATH);
            if (policyFile.exists()) {
                return new FileInputStream(policyFile);
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Context {
        public ArrayList packages;
        public File appDirectory;
        public File workDirectory;
        public Builder ddBuilder;

        public Context(ArrayList packages, File appDirectory, File workDirectory, Builder ddBuiler) {
            this.packages = packages;
            this.appDirectory = appDirectory;
            this.workDirectory = workDirectory;
            this.ddBuilder = ddBuiler;
        }

        public String toString() {
            return "[app dir: " + this.appDirectory.toString() + "][work dir: " + this.workDirectory.toString();
        }
    }
}

