/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin;

import com.idoox.debug.Category;
import com.systinet.wasp.PreferencesConfig;
import com.systinet.wasp.admin.PackageRepositoryConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.config.IConfigurator;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.dd.Builder;
import org.systinet.wasp.dd.DeploymentDescriptor;
import org.systinet.wasp.dd.DeploymentException;

public class PackageHelper {
    private static final Category log = Category.getCategory("com.systinet.wasp.admin.PackageHelper");
    public static final String DD_FILE_PATH = "WASP-INF" + File.separator + "package.xml";
    public static final String DD_CACHE_FILE_PATH = "WASP-INF" + File.separator + "package.cache";
    public static final String DD_IGNORE_FILE_PATH = "WASP-INF" + File.separator + "package.ignore";
    public static final String DD_URL_PATH = "WASP-INF/package.xml";
    public static final String DD_CACHE_URL_PATH = "WASP-INF/package.cache";
    public static final String DD_FILE_NAME = "package.xml";
    public static final String DD_CACHE_FILE_NAME = "package.cache";
    public static final String WASP_CONFIG_FILE_PATH = "WASP-INF" + File.separator + "wasp.xml";
    public static final String WASP_CACHE_CONFIG_FILE_PATH = "WASP-INF" + File.separator + "wasp.cache";
    public static final String WASP_IGNORE_CONFIG_FILE_PATH = "WASP-INF" + File.separator + "wasp.ignore";
    public static final String WASP_CONFIG_URL_PATH = "WASP-INF/wasp.xml";
    public static final String WASP_CONFIG_FILE_NAME = "wasp.xml";
    public static final String WASP_CACHE_CONFIG_FILE_NAME = "wasp.cache";
    public static final String WASP_CLASSES_FILE_PATH = "WASP-INF" + File.separator + "classes";
    public static final String WASP_CLASSES_URL_PATH = "WASP-INF/classes";
    public static final String WASP_LIB_FILE_PATH = "WASP-INF" + File.separator + "lib";
    public static final String WASP_LIB_URL_PATH = "WASP-INF/lib";
    public static final String WASP_WSDL_FILE_PATH = "WASP-INF" + File.separator + "wsdl";
    public static final String WASP_WSDL_URL_PATH = "WASP-INF/wsdl";
    public static final String WASP_INF_URL_PATH = "WASP-INF/";
    public static final String POLICY_FILE_PATH = "WASP-INF" + File.separator + "policy.xml";
    public static final String POLICY_URL_PATH = "WASP-INF/policy.xml";
    public static final String PACKAGE_REPOSITORY_MODULE_NAME = "PackageRepository";
    public static final String CLIENT_LOCK_FILE_NAME = "lock";
    private static final int MAX_TIME_WAIT = 60000;
    private static final int STEP_TIME_WAIT = 10;
    public static final String CLIENT_CACHE_LOCK = "ClientCacheLock";
    static /* synthetic */ Class class$com$systinet$wasp$admin$PackageRepositoryConfig;
    static /* synthetic */ Class class$com$systinet$wasp$PreferencesConfig;

    public static String newName(String directory, String packageName) throws FileNotFoundException, IOException {
        return PackageHelper.newName(new File(directory), packageName);
    }

    public static String newName(File dir, String packageName) throws FileNotFoundException, IOException {
        if (!dir.exists()) {
            throw new FileNotFoundException("" + dir + " wasn't found");
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("" + dir + " isn't directory");
        }
        String itemName = packageName;
        File dirItem = new File(dir, itemName);
        File jarItem = new File(dir, itemName + ".jar");
        int iterator = 1;
        while (dirItem.exists() || jarItem.exists()) {
            itemName = packageName + Integer.toString(iterator);
            dirItem = new File(dir, itemName);
            jarItem = new File(dir, itemName + ".jar");
            ++iterator;
        }
        return itemName;
    }

    public static String newName(File dir1, File dir2, String packageName) throws FileNotFoundException, IOException {
        if (!dir1.exists() || !dir2.exists()) {
            throw new FileNotFoundException("" + dir1 + " or " + dir2 + " wasn't found");
        }
        if (!dir1.isDirectory() || !dir2.isDirectory()) {
            throw new FileNotFoundException("" + dir1 + " or " + dir2 + " isn't directory");
        }
        String itemName = packageName;
        File dir1Item = new File(dir1, itemName);
        File jar1Item = new File(dir1, itemName + ".jar");
        File dir2Item = new File(dir2, itemName);
        File jar2Item = new File(dir2, itemName + ".jar");
        int iterator = 1;
        while (dir1Item.exists() || jar1Item.exists() || dir2Item.exists() || jar2Item.exists()) {
            itemName = packageName + Integer.toString(iterator);
            dir1Item = new File(dir1, itemName);
            jar1Item = new File(dir1, itemName + ".jar");
            dir2Item = new File(dir2, itemName);
            jar2Item = new File(dir2, itemName + ".jar");
            ++iterator;
        }
        return itemName;
    }

    public static void pack(String fromDirectory, JarOutputStream toStream, String[] excludeEntries) throws FileNotFoundException, IOException {
        PackageHelper.pack(new File(fromDirectory), toStream, excludeEntries);
    }

    public static void pack(File fromDirectory, JarOutputStream toStream, String[] excludeEntries) throws FileNotFoundException, IOException {
        if (!fromDirectory.exists()) {
            throw new FileNotFoundException(fromDirectory + " wasn't found");
        }
        if (!fromDirectory.isDirectory()) {
            throw new FileNotFoundException(fromDirectory + " isn't directory");
        }
        PackageHelper.pack(fromDirectory, toStream, excludeEntries, "", new byte[1000]);
    }

    /*
     * WARNING - void declaration
     */
    private static void pack(File dir, JarOutputStream toStream, String[] excludeEntries, String context, byte[] buffer) throws IOException {
        File[] entries = dir.listFiles();
        int i = 0;
        while (i < entries.length) {
            String newEntry;
            if (entries[i].isDirectory()) {
                newEntry = context + entries[i].getName() + '/';
                if (!PackageHelper.testExclude(excludeEntries, newEntry)) {
                    toStream.putNextEntry(new JarEntry(newEntry));
                    toStream.closeEntry();
                    PackageHelper.pack(entries[i], toStream, excludeEntries, newEntry, buffer);
                }
            } else {
                newEntry = context + entries[i].getName();
                if (!PackageHelper.testExclude(excludeEntries, newEntry)) {
                    int length;
                    toStream.putNextEntry(new JarEntry(newEntry));
                    FileInputStream fromStream = new FileInputStream(entries[i]);
                    while ((length = fromStream.read(buffer)) > 0) {
                        void var9_9;
                        toStream.write(buffer, 0, (int)var9_9);
                    }
                    fromStream.close();
                    toStream.closeEntry();
                }
            }
            ++i;
        }
    }

    private static boolean testExclude(String[] excludeEntries, String entry) {
        if (excludeEntries == null || entry == null) {
            return false;
        }
        int i = 0;
        while (i < excludeEntries.length) {
            if (entry.equalsIgnoreCase(excludeEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void unpack(JarInputStream fromStream, String toDirectory) throws FileNotFoundException, IOException {
        PackageHelper.unpack(fromStream, new File(toDirectory));
    }

    public static void unpack(JarInputStream fromStream, File toDirectory) throws FileNotFoundException, IOException {
        PackageHelper.unpack(fromStream, toDirectory, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void unpack(JarInputStream fromStream, File toDirectory, boolean checkTimeStamps, String[] excludeSuffix) throws FileNotFoundException, IOException {
        JarEntry entry;
        if (!toDirectory.exists()) {
            toDirectory.mkdir();
        }
        if (!toDirectory.isDirectory()) {
            throw new FileNotFoundException(toDirectory + " isn't directory or can't be created");
        }
        HashSet<String> fromStreamFiles = new HashSet<String>();
        HashMap<File, Long> directories = new HashMap<File, Long>();
        byte[] buffer = new byte[1000];
        while ((entry = fromStream.getNextJarEntry()) != null) {
            int length;
            void var6_7;
            if (var6_7.isDirectory()) {
                File dir = new File(toDirectory, var6_7.getName());
                if (var6_7.getTime() == -1L) continue;
                directories.put(dir, new Long(var6_7.getTime()));
                continue;
            }
            if (PackageHelper.testExcludeForUnpack(excludeSuffix, var6_7.getName())) continue;
            if (checkTimeStamps) {
                File oldFile = new File(toDirectory, var6_7.getName().replace('/', File.separatorChar));
                fromStreamFiles.add(oldFile.getAbsolutePath());
                if (oldFile.exists() && oldFile.lastModified() > var6_7.getTime()) continue;
            }
            File newFile = PackageHelper.createFileWithDirectories(var6_7.getName().replace('/', File.separatorChar), toDirectory);
            FileOutputStream toStream = new FileOutputStream(newFile);
            while ((length = fromStream.read(buffer)) > 0) {
                void var10_10;
                toStream.write(buffer, 0, (int)var10_10);
            }
            toStream.close();
            if (var6_7.getTime() == -1L) continue;
            newFile.setLastModified(var6_7.getTime());
        }
        Iterator iterator = directories.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry dir = iterator.next();
            ((File)dir.getKey()).setLastModified((Long)dir.getValue());
        }
        if (checkTimeStamps) {
            File[] entries = toDirectory.listFiles();
            int i = 0;
            while (i < entries.length) {
                PackageHelper.updateDirectory(entries[i], fromStreamFiles);
                ++i;
            }
        }
    }

    private static boolean testExcludeForUnpack(String[] excludeEntries, String entry) {
        if (excludeEntries == null || entry == null) {
            return false;
        }
        int i = 0;
        while (i < excludeEntries.length) {
            if (entry.endsWith(excludeEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void updateDirectory(File directory, Set fromJarFiles) {
        if (directory.isDirectory()) {
            File[] entries = directory.listFiles();
            int i = 0;
            while (i < entries.length) {
                PackageHelper.updateDirectory(entries[i], fromJarFiles);
                ++i;
            }
        }
        if (fromJarFiles.contains(directory.getAbsolutePath())) {
            if (!fromJarFiles.contains(directory.getParentFile().getAbsolutePath())) {
                fromJarFiles.add(directory.getParentFile().getAbsolutePath());
            }
        } else if (!directory.getAbsolutePath().endsWith(WASP_CONFIG_FILE_NAME) && !directory.getAbsolutePath().endsWith(WASP_CACHE_CONFIG_FILE_NAME)) {
            PackageHelper.deleteDir(directory);
        }
    }

    public static File createFileWithDirectories(String filePath, File directory) throws FileNotFoundException, IOException {
        if (directory != null && !directory.exists()) {
            throw new FileNotFoundException("Directory " + directory.getAbsolutePath() + " doesn't exist");
        }
        File file = directory;
        int index = filePath.lastIndexOf(File.separatorChar);
        if (index == -1) {
            if (!(file = new File(file, filePath)).exists() && !file.createNewFile()) {
                throw new IOException("File " + file.getAbsolutePath() + " can't be created");
            }
        } else if (index == filePath.length() - 1) {
            if (!(file = new File(file, filePath)).exists() && !file.mkdirs()) {
                throw new IOException("Directory " + file.getAbsolutePath() + " can't be created");
            }
        } else {
            String token = filePath.substring(0, index);
            if (!(file = new File(file, token)).exists() && !file.mkdirs()) {
                throw new IOException("Directory " + file.getAbsolutePath() + " can't be created");
            }
            token = filePath.substring(index + 1, filePath.length());
            if (!(file = new File(file, token)).exists() && !file.createNewFile()) {
                throw new IOException("File " + file.getAbsolutePath() + " can't be created");
            }
        }
        return file;
    }

    public static void deleteDir(File directory) {
        if (directory.isDirectory()) {
            File[] entries = directory.listFiles();
            int i = 0;
            while (i < entries.length) {
                PackageHelper.deleteDir(entries[i]);
                ++i;
            }
        }
        directory.delete();
    }

    public static void deleteEmptyDir(File directory) {
        if (directory.isDirectory()) {
            File[] entries = directory.listFiles();
            int i = 0;
            while (i < entries.length) {
                PackageHelper.deleteEmptyDir(entries[i]);
                ++i;
            }
            directory.delete();
        }
    }

    public static void copyDir(File fromDir, File toDir, boolean checkTimeStamps, String[] excludeSuffix) throws IOException {
        HashSet fromDirFiles = new HashSet();
        PackageHelper.copyDir(fromDir, toDir, fromDirFiles, checkTimeStamps, excludeSuffix);
        if (checkTimeStamps) {
            File[] entries = toDir.listFiles();
            int i = 0;
            while (i < entries.length) {
                PackageHelper.updateDirectory(entries[i], fromDirFiles);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void copyDir(File fromDir, File toDir, Set fromDirFiles, boolean checkTimeStamps, String[] excludeSuffix) throws IOException {
        File[] entries = fromDir.listFiles();
        byte[] buffer = new byte[1000];
        int i = 0;
        while (i < entries.length) {
            block8: {
                int length;
                File entry;
                block9: {
                    block7: {
                        if (!entries[i].isDirectory()) break block7;
                        PackageHelper.copyDir(entries[i], new File(toDir, entries[i].getName()), fromDirFiles, checkTimeStamps, excludeSuffix);
                        break block8;
                    }
                    entry = entries[i];
                    if (PackageHelper.testExcludeForUnpack(excludeSuffix, entries[i].getName())) break block8;
                    if (!toDir.exists()) {
                        toDir.mkdirs();
                    }
                    if (!toDir.isDirectory()) {
                        throw new FileNotFoundException(toDir + " isn't directory or can't be created");
                    }
                    if (!checkTimeStamps) break block9;
                    File oldFile = new File(toDir, entry.getName());
                    fromDirFiles.add(oldFile.getAbsolutePath());
                    if (oldFile.exists() && oldFile.lastModified() > entry.lastModified()) break block8;
                }
                FileInputStream fromStream = new FileInputStream(entry);
                File newFile = PackageHelper.createFileWithDirectories(entry.getName(), toDir);
                FileOutputStream toStream = new FileOutputStream(newFile);
                while ((length = fromStream.read(buffer)) > 0) {
                    void var12_12;
                    toStream.write(buffer, 0, (int)var12_12);
                }
                toStream.close();
                fromStream.close();
                newFile.setLastModified(entry.lastModified());
            }
            ++i;
        }
        toDir.setLastModified(fromDir.lastModified());
    }

    public static void cacheClientPackages(IConfigurator configurator) throws WaspInternalException {
        File appDir = PackageHelper.getApplicationDirectory(configurator);
        File[] entries = appDir.listFiles();
        int i = 0;
        while (i < entries.length) {
            PackageHelper.renameToCache(entries[i]);
            ++i;
        }
    }

    private static void renameToCache(File directory) {
        if (directory.isDirectory()) {
            File[] entries = directory.listFiles();
            int i = 0;
            while (i < entries.length) {
                PackageHelper.renameToCache(entries[i]);
                ++i;
            }
        }
        if (directory.getName().equalsIgnoreCase(WASP_CONFIG_FILE_NAME)) {
            directory.renameTo(new File(directory.getParentFile(), WASP_CACHE_CONFIG_FILE_NAME));
        }
        if (directory.getName().equalsIgnoreCase(DD_FILE_NAME)) {
            directory.renameTo(new File(directory.getParentFile(), DD_CACHE_FILE_NAME));
        }
    }

    public static DeploymentDescriptor getDeploymentDescriptorFromJar(Builder builder, File jar) throws DeploymentException {
        try {
            return builder.read("jar:" + jar.toURL() + "!/" + DD_URL_PATH);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getContextFromLocation(String uriPackage, String contextPackage, String uriUnknownPackage) {
        try {
            String locationUriUnknownPackage;
            String appWithContext;
            String locationUriPackage;
            int index = uriPackage.indexOf(DD_URL_PATH);
            if (index == -1 || (index = (locationUriPackage = uriPackage.substring(0, index - 1)).lastIndexOf("/")) == -1) return contextPackage;
            String app = appWithContext = locationUriPackage.substring(0, index);
            if (!"".equals(contextPackage)) {
                if (!appWithContext.endsWith(contextPackage)) return contextPackage;
                index = appWithContext.lastIndexOf(contextPackage);
                if (index == -1) return contextPackage;
                app = appWithContext.substring(0, index - 1);
            }
            if ((index = uriUnknownPackage.indexOf(DD_URL_PATH)) == -1 || (index = (locationUriUnknownPackage = uriUnknownPackage.substring(0, index - 1)).lastIndexOf("/")) == -1) return contextPackage;
            String appUnknownWithContext = locationUriUnknownPackage.substring(0, index);
            if (!(appUnknownWithContext = appUnknownWithContext + "/").startsWith(app = app + "/")) return "";
            if (appUnknownWithContext.length() == app.length()) {
                return "";
            }
            if (appUnknownWithContext.length() <= app.length()) return contextPackage;
            return appUnknownWithContext.substring(app.length(), appUnknownWithContext.length() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return contextPackage;
        }
    }

    public static boolean isClient(Configurator configurator) throws WaspInternalException {
        Configurable module = Configurator.getConfigurable("module", PACKAGE_REPOSITORY_MODULE_NAME);
        if (module == null) {
            return false;
        }
        boolean isClient = false;
        PackageRepositoryConfig config = (PackageRepositoryConfig)module.narrow(class$com$systinet$wasp$admin$PackageRepositoryConfig == null ? (class$com$systinet$wasp$admin$PackageRepositoryConfig = PackageHelper.class$("com.systinet.wasp.admin.PackageRepositoryConfig")) : class$com$systinet$wasp$admin$PackageRepositoryConfig);
        if (config != null) {
            try {
                isClient = config.isUseClasspath();
            }
            catch (Exception e) {
                isClient = false;
            }
        }
        return isClient;
    }

    public static File getApplicationDirectory(IConfigurator configurator) throws WaspInternalException {
        URL waspUrl;
        try {
            waspUrl = new URL(configurator.getWaspLocation());
        }
        catch (MalformedURLException e) {
            throw new WaspInternalException(e);
        }
        if (!waspUrl.getProtocol().equalsIgnoreCase("file")) {
            throw new WaspInternalException("Systinet Server location (wasp.location) is different than file path: " + waspUrl.toExternalForm());
        }
        PreferencesConfig preferencesConfig = (PreferencesConfig)configurator.getConfigurable("preferences", "main").narrow(class$com$systinet$wasp$PreferencesConfig == null ? (class$com$systinet$wasp$PreferencesConfig = PackageHelper.class$("com.systinet.wasp.PreferencesConfig")) : class$com$systinet$wasp$PreferencesConfig);
        String waspLocation = waspUrl.getFile();
        String appLocation = preferencesConfig.getApplicationDirectory();
        if (appLocation == null) {
            appLocation = "app_classpath";
        }
        appLocation.replace('/', File.separatorChar);
        File appDir = new File(waspLocation, appLocation);
        if (!appDir.exists() && !appDir.mkdirs()) {
            throw new WaspInternalException("Systinet Server application directory " + appDir + " doesn't exist or can't be created");
        }
        return appDir;
    }

    public static void waitingForUnlock(File lock) throws WaspInternalException {
        long wait = 0L;
        try {
            while (lock.exists() && wait < 60000L) {
                wait += 10L;
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (lock.exists()) {
            throw new WaspInternalException("Read timed out. Another client application locks the cache. Delete lock file " + lock.getAbsolutePath() + " and try to run client again");
        }
    }

    public static boolean createLock(File lock) {
        boolean isLock = false;
        try {
            isLock = lock.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isLock;
    }

    public static File lock(File directory) {
        int i;
        Object[] locks;
        long suffix = PackageHelper.createSuffix(directory);
        File lock = new File(directory, "lock." + suffix);
        while (!PackageHelper.createLock(lock)) {
            suffix = PackageHelper.createSuffix(directory);
            lock = new File(directory, "lock." + suffix);
        }
        LockFilter filter = new LockFilter();
        boolean locked = true;
        long wait = 0L;
        block3: while (locked && wait < 60000L) {
            locks = directory.list(filter);
            i = 0;
            while (i < locks.length) {
                Object name = locks[i];
                long lockSuffix = Long.valueOf(((String)name).substring(((String)name).indexOf(".") + 1, ((String)name).length()));
                if (lockSuffix < suffix) {
                    try {
                        wait += 10L;
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    locked = true;
                    continue block3;
                }
                locked = false;
                ++i;
            }
        }
        if (wait >= 60000L) {
            locks = directory.listFiles(new LockFilter());
            i = 0;
            while (i < locks.length) {
                Object lockFile = locks[i];
                if (!((File)lockFile).getName().endsWith(String.valueOf(suffix))) {
                    ((File)lockFile).delete();
                }
                ++i;
            }
        }
        return lock;
    }

    private static long createSuffix(File directory) {
        long suffix = 0L;
        String[] locks = directory.list(new LockFilter());
        ArrayList<Long> list = new ArrayList<Long>();
        int i = 0;
        while (i < locks.length) {
            String name = locks[i];
            list.add(Long.valueOf(name.substring(name.indexOf(".") + 1, name.length())));
            ++i;
        }
        if (list.size() > 0) {
            Long maxSuffix = (Long)Collections.max(list);
            suffix = maxSuffix;
            ++suffix;
        }
        return suffix;
    }

    public static void unlock(File lock) {
        if (lock != null) {
            lock.delete();
        }
    }

    public static void removeAllLocks(File directory) {
        File[] locks = directory.listFiles(new LockFilter());
        int i = 0;
        while (i < locks.length) {
            File lock = locks[i];
            lock.delete();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void moveTo(File source, File dest) throws IOException {
        block14: {
            if (dest != null && source != null) {
                if (source.getAbsolutePath().equals(dest.getAbsolutePath())) {
                    return;
                }
                if (source.renameTo(dest)) {
                    return;
                }
                if (source.isFile()) {
                    FileOutputStream outputStream;
                    block13: {
                        if (!dest.exists() && !dest.createNewFile()) {
                            throw new IOException("File " + dest.getAbsolutePath() + " can't be created");
                        }
                        FileInputStream inputStream = null;
                        outputStream = null;
                        try {
                            int length;
                            inputStream = new FileInputStream(source);
                            outputStream = new FileOutputStream(dest);
                            byte[] buffer = new byte[1024];
                            while ((length = inputStream.read(buffer)) > 0) {
                                void var5_5;
                                outputStream.write(buffer, 0, (int)var5_5);
                            }
                            Object var7_6 = null;
                            if (inputStream == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            source.delete();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    source.delete();
                    {
                        break block14;
                    }
                }
                if (source.isDirectory()) {
                    PackageHelper.copyDir(source, dest, false, null);
                    PackageHelper.deleteDir(dest);
                } else {
                    throw new IOException("Can't move file to directory or vice versa " + source + " " + dest);
                }
            }
        }
    }

    public static URL toURL(File file) throws MalformedURLException {
        File f = file.getAbsoluteFile();
        String sp = PackageHelper.slashify(f.getPath(), f.isDirectory());
        if (sp.startsWith("//")) {
            sp = "//" + sp;
        }
        return new URL("file", "", sp);
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LockFilter
    implements FilenameFilter {
        LockFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(PackageHelper.CLIENT_LOCK_FILE_NAME);
        }
    }
}

