/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.util;

import com.systinet.util.Condition;
import com.systinet.util.ConditionImpl;
import com.systinet.util.ReentrantLock;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ReentrantLockImpl
implements ReentrantLock {
    private Thread currentOwner = null;
    private int count = 0;
    private final String name;
    static final Map registeredLocks = new WeakHashMap();

    protected ReentrantLockImpl() {
        this.name = "unknown";
    }

    protected ReentrantLockImpl(String name) {
        this.name = name;
    }

    public final synchronized void lock() {
        this.lockAll(1);
    }

    int getCount() {
        return this.count;
    }

    String getName() {
        return this.name;
    }

    Thread getCurrentOwner() {
        return this.currentOwner;
    }

    final synchronized void lockAll(int n) {
        boolean hasBeenInterrupted = false;
        while (this.currentOwner != null && this.currentOwner != this.getJoker()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                hasBeenInterrupted = true;
            }
        }
        this.count += n;
        if (this.currentOwner == null) {
            this.currentOwner = this.getJoker();
        }
        if (hasBeenInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public final synchronized void unlock() throws IllegalMonitorStateException {
        this.unlock(1);
    }

    public final synchronized void unlock(int level) throws IllegalMonitorStateException {
        if (this.currentOwner != this.getJoker()) {
            throw new IllegalMonitorStateException("Cannot unlock " + this.name + "! You haven't locked it!!\n deepness: " + this.count + "\nowner:" + this.currentOwner + "\nyour thread:" + this.getJoker());
        }
        if (this.count < level) {
            throw new IllegalMonitorStateException("Cannot unlock " + this.name + " for " + level + " levels!!\n deepness: " + this.count + "\nowner:" + this.currentOwner);
        }
        this.count -= level;
        if (this.count == 0) {
            this.currentOwner = null;
            this.notify();
        }
    }

    final synchronized int unlockAll() throws IllegalMonitorStateException {
        if (this.currentOwner != this.getJoker()) {
            throw new IllegalMonitorStateException("Cannot unlock " + this.name + "! You haven't locked it!!\n deepness: " + this.count + "\nowner:" + this.currentOwner + "\nyour thread:" + this.getJoker());
        }
        int prevValue = this.count;
        this.count = 0;
        this.currentOwner = null;
        this.notify();
        return prevValue;
    }

    public final Condition newCondition() {
        return new ConditionImpl(this);
    }

    abstract Thread getJoker();
}

