/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.util;

import com.systinet.util.Condition;
import com.systinet.util.ReentrantLockImpl;

public class ConditionImpl
implements Condition {
    private ReentrantLockImpl lock;
    private boolean hasBeenNotified = false;

    public ConditionImpl(ReentrantLockImpl lock) {
        this.lock = lock;
    }

    public synchronized void signal() throws IllegalMonitorStateException {
        this.hasBeenNotified = true;
        this.notify();
    }

    public synchronized void signalAll() throws IllegalMonitorStateException {
        this.hasBeenNotified = true;
        this.notifyAll();
    }

    public void await(long timeout) throws InterruptedException {
        int count = this.lock.unlockAll();
        try {
            ConditionImpl conditionImpl = this;
            synchronized (conditionImpl) {
                if (!this.hasBeenNotified) {
                    this.wait(timeout);
                }
                this.hasBeenNotified = false;
            }
            Object var7_5 = null;
            this.lock.lockAll(count);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.lock.lockAll(count);
            throw throwable;
        }
    }

    public void await() throws InterruptedException {
        this.await(0L);
    }
}

