/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.transport.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ContentTypeParametersTokenizer
implements Iterator {
    private StringBuffer s;
    private String str;
    private int i;
    private int j;
    private int len;
    private int deleted;
    private static final char SP = ' ';
    private static final char HT = '\t';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String TOKEN_DELIM = "()<>@,;:\\\"/[]?={} \t";
    private static final Parameter TMP_PARAM = new Parameter();

    public ContentTypeParametersTokenizer() {
    }

    public ContentTypeParametersTokenizer(String contentTypeString) {
        this.init(contentTypeString);
    }

    public void init(String contentTypeString) {
        if (contentTypeString == null) {
            throw new IllegalArgumentException("Content Type string MUST NOT be null!");
        }
        this.deleted = 0;
        this.s = null;
        this.str = contentTypeString;
        this.len = contentTypeString.length();
        this.i = contentTypeString.indexOf(";");
        this.j = 0;
        this.i = this.i < 0 ? this.len : ++this.i;
    }

    public boolean hasNext() {
        return this.i < this.len;
    }

    public Object next() {
        if (this.s == null) {
            this.s = new StringBuffer(this.str);
        }
        this.skipWhiteSpace();
        String attr = this.getParameter();
        this.i = this.j;
        if (this.i >= this.len) {
            throw new IllegalStateException("'=' expected in Content-type header (" + this.str + ") at position " + (this.i + this.deleted) + " but found end of the header!");
        }
        if (this.s.charAt(this.i) != '=') {
            throw new IllegalStateException("'=' expected in Content-type header (" + this.str + ") at position " + (this.i + this.deleted) + " but found end of the header!");
        }
        ++this.i;
        String value = this.getValue();
        this.i += value.length() + 1;
        ContentTypeParametersTokenizer.TMP_PARAM.attribute = attr;
        ContentTypeParametersTokenizer.TMP_PARAM.value = value;
        return TMP_PARAM;
    }

    /*
     * Unable to fully structure code
     */
    public String getValueFor(String attribute) {
        k = this.str.indexOf(59, this.i);
        if (k > (l = this.str.indexOf(attribute, this.i)) && l >= 0) {
            this.i = l + attribute.length();
            if (this.str.charAt(this.i) != '=') {
                throw new IllegalStateException("'=' expected in Content-type header (" + this.str + ") at position " + (this.i + this.deleted));
            }
            ++this.i;
            return this.getValueFast();
        }
        if (k < 0) {
            k = this.i;
        }
        this.j = this.str.indexOf(34, k);
        if (this.j <= 0 || l <= 0 || l >= this.j) ** GOTO lbl21
        this.i = l + attribute.length();
        if (this.str.charAt(this.i) != '=') {
            throw new IllegalStateException("'=' expected in Content-type header (" + this.str + ") at position " + (this.i + this.deleted));
        }
        ++this.i;
        return this.getValueFast();
lbl-1000:
        // 1 sources

        {
            par = (Parameter)this.next();
            if (!par.attribute.equals(attribute)) continue;
            this.j = this.i + par.value.length();
            return par.value;
lbl21:
            // 2 sources

            ** while (this.i < this.len)
        }
lbl22:
        // 1 sources

        return null;
    }

    protected String getValueFast() {
        if (this.str.charAt(this.i) == '\"') {
            ++this.i;
            this.j = this.str.indexOf(34, this.i);
            if (this.j < 0) {
                throw new IllegalStateException("Quote '\"' at position " + (this.i - 1) + " of the Content-type header (" + this.str + ") is not terminated.");
            }
            int k = this.str.indexOf(92);
            if (k < 0 || k > this.j) {
                return this.str.substring(this.i, this.j);
            }
            --this.i;
        }
        if (this.s == null) {
            this.s = new StringBuffer(this.str);
        }
        return this.getValue();
    }

    protected String getParameter() {
        StringTokenizer tokenizer = new StringTokenizer(this.s.substring(this.i), TOKEN_DELIM, false);
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalStateException("Attribute  expected in Content-type header (" + this.str + ") at position " + (this.i + this.deleted));
        }
        String result = tokenizer.nextToken();
        int resLen = result.length();
        if (resLen == 0) {
            throw new IllegalStateException("Attribute  of the Content-type header (" + this.str + ") at position " + (this.i + this.deleted) + " cannot be empty string");
        }
        this.j = this.i + resLen;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected String getValue() {
        char c;
        if (this.s.charAt(this.i) != '\"') {
            return this.getParameter();
        }
        ++this.i;
        this.j = this.i;
        while ((c = this.s.charAt(this.j)) != '\"' && this.j < this.len) {
            void var1_1;
            if (var1_1 == 92) {
                this.s.deleteCharAt(this.j);
                ++this.deleted;
                --this.len;
            }
            ++this.j;
        }
        if (c != '\"') {
            throw new IllegalStateException("Expecting \" at Content-type header(" + this.str + ") at position " + (this.j + this.deleted));
        }
        return this.s.substring(this.i, this.j++);
    }

    protected void skipWhiteSpace() {
        boolean ok = true;
        char crOrLf = '\r';
        while (ok && this.i < this.len) {
            ok = false;
            char c = this.s.charAt(this.i);
            if (c == ' ' || c == '\t') {
                ok = true;
            } else if (c == crOrLf) {
                c = this.switchCRLF(c);
                ok = true;
            }
            if (!ok) continue;
            ++this.i;
        }
    }

    private char switchCRLF(char crOrLf) {
        switch (crOrLf) {
            case '\r': {
                return '\n';
            }
            case '\n': {
                return '\r';
            }
        }
        throw new RuntimeException("Internal Error while parsing value of the Content-type header (" + this.str + ") at position " + (this.i + this.deleted));
    }

    public void remove() {
        throw new UnsupportedOperationException("Content Type Parameters Tokenizerdoes not allow modifications.");
    }

    public String setValueFor(String parameter, String value) {
        this.getValueFor(parameter);
        if (this.s == null) {
            this.s = new StringBuffer(this.str);
        }
        this.s.replace(this.i, this.j, value);
        this.str = this.s.toString();
        return this.str;
    }

    private static class Parameter
    implements Serializable {
        protected String attribute;
        protected String value;

        protected Parameter() {
        }

        public Parameter(String attribute, String value) {
            if (attribute == null || value == null) {
                throw new IllegalArgumentException("Nor attribute neither value of the Parameter can be null");
            }
            this.attribute = attribute;
            this.value = value;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.attribute + "=\"" + this.value + "\"";
        }

        public int hashCode() {
            return this.attribute.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Parameter) {
                Parameter p = (Parameter)obj;
                return p.attribute.equals(this.attribute) && p.value.equals(this.value);
            }
            return false;
        }
    }
}

