/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.FacetFactory;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.Constants;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SimpleTypeParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.Facet;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SimpleTypeEnumExtension;
import org.idoox.xml.schema.SimpleTypeFacetsExtension;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleTypeRestrictionParser {
    private static final Set IGNORED_TAGS = new HashSet(){
        {
            this.add("annotation");
            this.add("simpleType");
        }
    };
    private static final Set IGNORED_FACETS = new HashSet(){
        {
            this.add("encoding");
        }
    };

    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params) throws SchemaException {
        SimpleTypeFacetsExtension fext;
        Type baseTypeType;
        String namespaceURI = el.getNamespaceURI();
        String baseType = ElementHelper.getAttributeNS(el, null, "base");
        Element simpleType = ElementHelper.getChildElementByTagName(el, namespaceURI, "simpleType");
        if (baseType != null && simpleType != null) {
            throw new SchemaException("Restriction should be defined using attribute <base> or element <simpleType>, not both. Context : " + ElementHelper.getFullPath(el));
        }
        if (baseType != null) {
            QName baseQName = ElementHelper.getQName(el, baseType);
            baseQName = ElementHelper.chameleonQName(baseQName, params.chameleonNamespace);
            baseTypeType = parser.getSchemaType(baseQName, false);
        } else if (simpleType != null) {
            baseTypeType = new Type();
            SimpleTypeParser.parse(baseTypeType, simpleType, parser, params, false);
        } else {
            baseTypeType = parser.getSchemaType(Constants.ANY_SIMPLE_TYPE, false);
        }
        parseInto.setBaseType(baseTypeType);
        parseInto.setKind((short)16);
        parseInto.setInheritedByRestriction(true);
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
        SimpleTypeEnumExtension ext = SimpleTypeRestrictionParser.parseEnumerations(el);
        if (ext != null) {
            parseInto.setKind((short)20);
            parseInto.setExtension("SimpleTypeEnumExtension", ext);
        }
        if ((fext = SimpleTypeRestrictionParser.getRestrictionFacets(parseInto, el, IGNORED_TAGS)) != null) {
            parseInto.setExtension("SimpleTypeFacetsExtension", fext);
        }
    }

    public static SimpleTypeFacetsExtension getRestrictionFacets(Type forType, Element restrictionElem, Set ignoredElems) throws SchemaException {
        String namespaceURI = restrictionElem.getNamespaceURI();
        Element[] childElems = SimpleTypeRestrictionParser.getAllChildElements(restrictionElem, namespaceURI);
        HashSet<Facet> s = childElems.length > 0 ? new HashSet<Facet>() : null;
        int i = 0;
        while (i < childElems.length) {
            block7: {
                String tagName;
                Element elem;
                block5: {
                    block6: {
                        elem = childElems[i];
                        tagName = elem.getLocalName();
                        if (!elem.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !elem.getNamespaceURI().equals("http://www.w3.org/2000/10/XMLSchema") && !elem.getNamespaceURI().equals("http://www.w3.org/1999/XMLSchema")) break block5;
                        if (!FacetFactory.isFacetSupported(tagName)) break block6;
                        s.add(FacetFactory.getFacetFor(forType, elem));
                        break block7;
                    }
                    if (IGNORED_FACETS.contains(tagName) || ignoredElems != null && ignoredElems.contains(tagName)) break block7;
                }
                throw new SchemaException("prohibited element in XML schema found: " + tagName + ", path: " + ElementHelper.getFullPath(elem));
            }
            ++i;
        }
        if (s != null) {
            return new SimpleTypeFacetsExtension(s);
        }
        return null;
    }

    public static SimpleTypeEnumExtension parseEnumerations(Element restrictionElem) {
        SimpleTypeEnumExtension retVal = null;
        String namespaceURI = restrictionElem.getNamespaceURI();
        Element[] enumerations = ElementHelper.getChildrenElementsByTagName(restrictionElem, namespaceURI, "enumeration");
        if (enumerations != null && enumerations.length > 0) {
            retVal = new SimpleTypeEnumExtension();
            int i = 0;
            while (i < enumerations.length) {
                String value = ElementHelper.getAttribute(enumerations[i], "value");
                String javaName = ElementHelper.getAttributeNS(enumerations[i], "http://systinet.com/mapping/", "java-field");
                if (javaName == null) {
                    javaName = value;
                }
                retVal.addValue(value, javaName);
                ++i;
            }
        }
        return retVal;
    }

    public static Element[] getAllChildElements(Element parent, String namespace) {
        Object e;
        ArrayList<Object> els = new ArrayList<Object>();
        Node n = parent.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                e = (Element)n;
                String nsURI = e.getNamespaceURI();
                if (namespace == null) {
                    if (nsURI == null || nsURI.length() == 0) {
                        els.add(e);
                    }
                } else if (namespace.equals(nsURI)) {
                    els.add(e);
                }
            }
            n = n.getNextSibling();
        }
        e = new Element[els.size()];
        return els.toArray((T[])e);
    }
}

