/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.Constants;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SimpleTypeParser;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Facet;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SimpleTypeFacetsExtension;
import org.idoox.xml.schema.SimpleTypeListExtension;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class SimpleTypeListParser {
    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params) throws SchemaException {
        Type itemTypeType;
        String namespaceURI = el.getNamespaceURI();
        parseInto.setKind((short)17);
        String itemType = ElementHelper.getAttributeNS(el, null, "itemType");
        Element simpleType = ElementHelper.getChildElementByTagName(el, namespaceURI, "simpleType");
        if (itemType != null && simpleType != null) {
            throw new SchemaException("Type of list's item should be defined using attribute <itemType> or element <simpleType>, not both. Context : " + ElementHelper.getFullPath(el));
        }
        HashSet<Facet.WhiteSpace> facets = new HashSet<Facet.WhiteSpace>();
        facets.add(new Facet.WhiteSpace("collapse", true));
        SimpleTypeFacetsExtension fe = new SimpleTypeFacetsExtension(facets);
        parseInto.setExtension("SimpleTypeFacetsExtension", fe);
        if (itemType != null) {
            QName itemQName = ElementHelper.getQName(el, itemType);
            itemQName = ElementHelper.chameleonQName(itemQName, params.chameleonNamespace);
            itemTypeType = parser.getSchemaType(itemQName, false);
        } else if (simpleType != null) {
            itemTypeType = new Type();
            SimpleTypeParser.parse(itemTypeType, simpleType, parser, params, false);
        } else {
            itemTypeType = parser.getSchemaType(Constants.ANY_SIMPLE_TYPE, false);
        }
        parseInto.setExtension("SimpleTypeListExtension", new SimpleTypeListExtension(itemTypeType));
        parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
    }

    public static void write(TokenWriter writer, Type type, Set importedNamespaces) throws IOException, SchemaException {
        writer.enter("http://www.w3.org/2001/XMLSchema", "list");
        SimpleTypeListExtension ext = (SimpleTypeListExtension)type.getExtension("SimpleTypeListExtension");
        Type t = ext.getItemType();
        if (t.getName() != null) {
            Helper.writeQNameAttribute(writer, null, "type", t.getName());
        } else {
            SimpleTypeParser.write(writer, t, importedNamespaces);
        }
        writer.leave();
    }
}

