/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.Namespaces;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PredefinedSchemas {
    private static final Integer SIMPLE_TYPE = new Integer(0);
    private static final Integer COMPLEX_TYPE = new Integer(1);
    private static final Integer GROUP = new Integer(2);
    private static final Integer ELEMENT = new Integer(3);
    private static final Integer ATTRIBUTE = new Integer(4);
    private static final Integer ATTRIBUTE_GROUP = new Integer(5);
    private static final Map knownSchemas = new HashMap();

    public static boolean isNamespacePredefined(String namespaceURI) {
        return knownSchemas.containsKey(namespaceURI);
    }

    public static boolean isTypePredefined(String namespaceURI, String localName) {
        return PredefinedSchemas.isComplexTypePredefined(namespaceURI, localName) || PredefinedSchemas.isSimpleTypePredefined(namespaceURI, localName);
    }

    public static boolean isSimpleTypePredefined(String namespaceURI, String localName) {
        Map knownSchema = (Map)knownSchemas.get(namespaceURI);
        if (knownSchema == null) {
            return false;
        }
        Set typeDefinitions = (Set)knownSchema.get(SIMPLE_TYPE);
        if (typeDefinitions == null) {
            return false;
        }
        return typeDefinitions.contains(localName);
    }

    public static boolean isComplexTypePredefined(String namespaceURI, String localName) {
        Map knownSchema = (Map)knownSchemas.get(namespaceURI);
        if (knownSchema == null) {
            return false;
        }
        Set typeDefinitions = (Set)knownSchema.get(COMPLEX_TYPE);
        if (typeDefinitions == null) {
            return false;
        }
        return typeDefinitions.contains(localName);
    }

    public static boolean isGroupPredefined(String namespaceURI, String localName) {
        Map knownSchema = (Map)knownSchemas.get(namespaceURI);
        if (knownSchema == null) {
            return false;
        }
        Set groupDefinitions = (Set)knownSchema.get(GROUP);
        if (groupDefinitions == null) {
            return false;
        }
        return groupDefinitions.contains(localName);
    }

    public static boolean isElementPredefined(String namespaceURI, String localName) {
        Map knownSchema = (Map)knownSchemas.get(namespaceURI);
        if (knownSchema == null) {
            return false;
        }
        Set elementDefinitions = (Set)knownSchema.get(ELEMENT);
        if (elementDefinitions == null) {
            return false;
        }
        return elementDefinitions.contains(localName);
    }

    public static boolean isAttributePredefined(String namespaceURI, String localName) {
        Map knownSchema = (Map)knownSchemas.get(namespaceURI);
        if (knownSchema == null) {
            return false;
        }
        Set attributeDefinitions = (Set)knownSchema.get(ATTRIBUTE);
        if (attributeDefinitions == null) {
            return false;
        }
        return attributeDefinitions.contains(localName);
    }

    public static boolean isAttributeGroupPredefined(String namespaceURI, String localName) {
        Map knownSchema = (Map)knownSchemas.get(namespaceURI);
        if (knownSchema == null) {
            return false;
        }
        Set attributeGroupDefinitions = (Set)knownSchema.get(ATTRIBUTE_GROUP);
        if (attributeGroupDefinitions == null) {
            return false;
        }
        return attributeGroupDefinitions.contains(localName);
    }

    static {
        HashSet<String> complexTypeDefinitions = new HashSet<String>();
        HashSet<String> simpleTypeDefinitions = new HashSet<String>();
        HashSet<String> groupDefinitions = new HashSet<String>();
        HashSet<String> elementDefinitions = new HashSet<String>();
        HashSet<String> attributeGroupDefinitions = new HashSet<String>();
        HashMap knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchema.put(GROUP, groupDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchema.put(ATTRIBUTE_GROUP, attributeGroupDefinitions);
        knownSchemas.put("http://www.w3.org/2001/XMLSchema", knownSchema);
        attributeGroupDefinitions.add("defRef");
        attributeGroupDefinitions.add("occurs");
        complexTypeDefinitions.add("all");
        complexTypeDefinitions.add("annotated");
        complexTypeDefinitions.add("anyType");
        complexTypeDefinitions.add("attribute");
        complexTypeDefinitions.add("attributeGroup");
        complexTypeDefinitions.add("attributeGroupRef");
        complexTypeDefinitions.add("complexRestrictionType");
        complexTypeDefinitions.add("complexType");
        complexTypeDefinitions.add("element");
        complexTypeDefinitions.add("explicitGroup");
        complexTypeDefinitions.add("extensionType");
        complexTypeDefinitions.add("facet");
        complexTypeDefinitions.add("group");
        complexTypeDefinitions.add("groupRef");
        complexTypeDefinitions.add("keybase");
        complexTypeDefinitions.add("localComplexType");
        complexTypeDefinitions.add("localElement");
        complexTypeDefinitions.add("localSimpleType");
        complexTypeDefinitions.add("namedAttributeGroup");
        complexTypeDefinitions.add("namedGroup");
        complexTypeDefinitions.add("noFixedFacet");
        complexTypeDefinitions.add("numFacet");
        complexTypeDefinitions.add("openAttrs");
        complexTypeDefinitions.add("realGroup");
        complexTypeDefinitions.add("restrictionType");
        complexTypeDefinitions.add("simpleExplicitGroup");
        complexTypeDefinitions.add("simpleExtensionType");
        complexTypeDefinitions.add("simpleRestrictionType");
        complexTypeDefinitions.add("simpleType");
        complexTypeDefinitions.add("topLevelAttribute");
        complexTypeDefinitions.add("topLevelComplexType");
        complexTypeDefinitions.add("topLevelElement");
        complexTypeDefinitions.add("topLevelSimpleType");
        complexTypeDefinitions.add("wildcard");
        elementDefinitions.add("all");
        elementDefinitions.add("annotation");
        elementDefinitions.add("any");
        elementDefinitions.add("anyAttribute");
        elementDefinitions.add("appinfo");
        elementDefinitions.add("attribute");
        elementDefinitions.add("attributeGroup");
        elementDefinitions.add("choice");
        elementDefinitions.add("complexContent");
        elementDefinitions.add("complexType");
        elementDefinitions.add("documentation");
        elementDefinitions.add("element");
        elementDefinitions.add("enumeration");
        elementDefinitions.add("field");
        elementDefinitions.add("fractionDigits");
        elementDefinitions.add("group");
        elementDefinitions.add("import");
        elementDefinitions.add("include");
        elementDefinitions.add("key");
        elementDefinitions.add("keyref");
        elementDefinitions.add("length");
        elementDefinitions.add("list");
        elementDefinitions.add("maxExclusive");
        elementDefinitions.add("maxInclusive");
        elementDefinitions.add("maxLength");
        elementDefinitions.add("minExclusive");
        elementDefinitions.add("minInclusive");
        elementDefinitions.add("minLength");
        elementDefinitions.add("notation");
        elementDefinitions.add("pattern");
        elementDefinitions.add("redefine");
        elementDefinitions.add("restriction");
        elementDefinitions.add("schema");
        elementDefinitions.add("selector");
        elementDefinitions.add("sequence");
        elementDefinitions.add("simpleContent");
        elementDefinitions.add("simpleType");
        elementDefinitions.add("totalDigits");
        elementDefinitions.add("union");
        elementDefinitions.add("unique");
        elementDefinitions.add("whiteSpace");
        groupDefinitions.add("allModel");
        groupDefinitions.add("attrDecls");
        groupDefinitions.add("complexTypeModel");
        groupDefinitions.add("facets");
        groupDefinitions.add("identityConstraint");
        groupDefinitions.add("nestedParticle");
        groupDefinitions.add("particle");
        groupDefinitions.add("redefinable");
        groupDefinitions.add("schemaTop");
        groupDefinitions.add("simpleDerivation");
        groupDefinitions.add("simpleRestrictionModel");
        groupDefinitions.add("typeDefParticle");
        simpleTypeDefinitions.add("ENTITIES");
        simpleTypeDefinitions.add("ENTITY");
        simpleTypeDefinitions.add("ID");
        simpleTypeDefinitions.add("IDREF");
        simpleTypeDefinitions.add("IDREFS");
        simpleTypeDefinitions.add("NCName");
        simpleTypeDefinitions.add("NMTOKEN");
        simpleTypeDefinitions.add("NMTOKENS");
        simpleTypeDefinitions.add("NOTATION");
        simpleTypeDefinitions.add("Name");
        simpleTypeDefinitions.add("QName");
        simpleTypeDefinitions.add("allNNI");
        simpleTypeDefinitions.add("anySimpleType");
        simpleTypeDefinitions.add("anyURI");
        simpleTypeDefinitions.add("base64Binary");
        simpleTypeDefinitions.add("blockSet");
        simpleTypeDefinitions.add("boolean");
        simpleTypeDefinitions.add("byte");
        simpleTypeDefinitions.add("date");
        simpleTypeDefinitions.add("dateTime");
        simpleTypeDefinitions.add("decimal");
        simpleTypeDefinitions.add("derivationControl");
        simpleTypeDefinitions.add("derivationSet");
        simpleTypeDefinitions.add("double");
        simpleTypeDefinitions.add("duration");
        simpleTypeDefinitions.add("float");
        simpleTypeDefinitions.add("formChoice");
        simpleTypeDefinitions.add("gDay");
        simpleTypeDefinitions.add("gMonth");
        simpleTypeDefinitions.add("gMonthDay");
        simpleTypeDefinitions.add("gYear");
        simpleTypeDefinitions.add("gYearMonth");
        simpleTypeDefinitions.add("hexBinary");
        simpleTypeDefinitions.add("int");
        simpleTypeDefinitions.add("integer");
        simpleTypeDefinitions.add("language");
        simpleTypeDefinitions.add("long");
        simpleTypeDefinitions.add("namespaceList");
        simpleTypeDefinitions.add("negativeInteger");
        simpleTypeDefinitions.add("nonNegativeInteger");
        simpleTypeDefinitions.add("nonPositiveInteger");
        simpleTypeDefinitions.add("normalizedString");
        simpleTypeDefinitions.add("positiveInteger");
        simpleTypeDefinitions.add("public");
        simpleTypeDefinitions.add("reducedDerivationControl");
        simpleTypeDefinitions.add("short");
        simpleTypeDefinitions.add("simpleDerivationSet");
        simpleTypeDefinitions.add("string");
        simpleTypeDefinitions.add("time");
        simpleTypeDefinitions.add("token");
        simpleTypeDefinitions.add("unsignedByte");
        simpleTypeDefinitions.add("unsignedInt");
        simpleTypeDefinitions.add("unsignedLong");
        simpleTypeDefinitions.add("unsignedShort");
        complexTypeDefinitions = new HashSet();
        simpleTypeDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchemas.put("http://www.w3.org/2000/10/XMLSchema", knownSchema);
        complexTypeDefinitions.add("anyType");
        simpleTypeDefinitions.add("anySimpleType");
        simpleTypeDefinitions.add("string");
        simpleTypeDefinitions.add("boolean");
        simpleTypeDefinitions.add("float");
        simpleTypeDefinitions.add("double");
        simpleTypeDefinitions.add("decimal");
        simpleTypeDefinitions.add("timeDuration");
        simpleTypeDefinitions.add("binary");
        simpleTypeDefinitions.add("uriReference");
        simpleTypeDefinitions.add("ID");
        simpleTypeDefinitions.add("IDREF");
        simpleTypeDefinitions.add("ENTITY");
        simpleTypeDefinitions.add("QName");
        simpleTypeDefinitions.add("CDATA");
        simpleTypeDefinitions.add("token");
        simpleTypeDefinitions.add("language");
        simpleTypeDefinitions.add("IDREFS");
        simpleTypeDefinitions.add("ENTITIES");
        simpleTypeDefinitions.add("NMTOKEN");
        simpleTypeDefinitions.add("NMTOKENS");
        simpleTypeDefinitions.add("Name");
        simpleTypeDefinitions.add("NCName");
        simpleTypeDefinitions.add("NOTATION");
        simpleTypeDefinitions.add("integer");
        simpleTypeDefinitions.add("nonPositiveInteger");
        simpleTypeDefinitions.add("negativeInteger");
        simpleTypeDefinitions.add("long");
        simpleTypeDefinitions.add("int");
        simpleTypeDefinitions.add("short");
        simpleTypeDefinitions.add("byte");
        simpleTypeDefinitions.add("nonNegativeInteger");
        simpleTypeDefinitions.add("unsignedLong");
        simpleTypeDefinitions.add("unsignedInt");
        simpleTypeDefinitions.add("unsignedShort");
        simpleTypeDefinitions.add("unsignedByte");
        simpleTypeDefinitions.add("positiveInteger");
        simpleTypeDefinitions.add("timeInstant");
        simpleTypeDefinitions.add("time");
        simpleTypeDefinitions.add("date");
        simpleTypeDefinitions.add("month");
        simpleTypeDefinitions.add("year");
        complexTypeDefinitions = new HashSet();
        simpleTypeDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchemas.put("http://www.w3.org/1999/XMLSchema", knownSchema);
        complexTypeDefinitions.add("anyType");
        simpleTypeDefinitions.add("simpleType");
        simpleTypeDefinitions.add("anySimpleType");
        simpleTypeDefinitions.add("urType");
        simpleTypeDefinitions.add("string");
        simpleTypeDefinitions.add("boolean");
        simpleTypeDefinitions.add("float");
        simpleTypeDefinitions.add("double");
        simpleTypeDefinitions.add("decimal");
        simpleTypeDefinitions.add("timeInstant");
        simpleTypeDefinitions.add("timeDuration");
        simpleTypeDefinitions.add("binary");
        simpleTypeDefinitions.add("uri");
        simpleTypeDefinitions.add("language");
        simpleTypeDefinitions.add("NMTOKEN");
        simpleTypeDefinitions.add("NMTOKENS");
        simpleTypeDefinitions.add("Name");
        simpleTypeDefinitions.add("QName");
        simpleTypeDefinitions.add("NCName");
        simpleTypeDefinitions.add("ID");
        simpleTypeDefinitions.add("IDREF");
        simpleTypeDefinitions.add("IDREFS");
        simpleTypeDefinitions.add("ENTITY");
        simpleTypeDefinitions.add("ENTITIES");
        simpleTypeDefinitions.add("NOTATION");
        simpleTypeDefinitions.add("int");
        simpleTypeDefinitions.add("integer");
        simpleTypeDefinitions.add("non-negative-integer");
        simpleTypeDefinitions.add("positive-integer");
        simpleTypeDefinitions.add("non-positive-integer");
        simpleTypeDefinitions.add("negative-integer");
        simpleTypeDefinitions.add("date");
        simpleTypeDefinitions.add("time");
        HashSet<String> attributeDefinitions = new HashSet<String>();
        attributeGroupDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(ATTRIBUTE, attributeDefinitions);
        knownSchema.put(ATTRIBUTE_GROUP, attributeGroupDefinitions);
        knownSchemas.put("http://www.w3.org/XML/1998/namespace", knownSchema);
        attributeDefinitions.add("lang");
        attributeDefinitions.add("space");
        attributeGroupDefinitions.add("specialAttrs");
        complexTypeDefinitions = new HashSet();
        groupDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        attributeDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(GROUP, groupDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchema.put(ATTRIBUTE, attributeDefinitions);
        knownSchemas.put("http://schemas.xmlsoap.org/wsdl/", knownSchema);
        attributeDefinitions.add("arrayType");
        attributeDefinitions.add("required");
        complexTypeDefinitions.add("tDocumentation");
        complexTypeDefinitions.add("tDocumented");
        complexTypeDefinitions.add("tExtensibleAttributesDocumented");
        complexTypeDefinitions.add("tExtensibleDocumented");
        complexTypeDefinitions.add("tDefinitions");
        complexTypeDefinitions.add("tImport");
        complexTypeDefinitions.add("tTypes");
        complexTypeDefinitions.add("tMessage");
        complexTypeDefinitions.add("tPart");
        complexTypeDefinitions.add("tPortType");
        complexTypeDefinitions.add("tOperation");
        complexTypeDefinitions.add("tParam");
        complexTypeDefinitions.add("tFault");
        complexTypeDefinitions.add("tBinding");
        complexTypeDefinitions.add("tBindingOperationMessage");
        complexTypeDefinitions.add("tBindingOperationFault");
        complexTypeDefinitions.add("tBindingOperation");
        complexTypeDefinitions.add("tService");
        complexTypeDefinitions.add("tPort");
        complexTypeDefinitions.add("tExtensibilityElement");
        elementDefinitions.add("definitions");
        groupDefinitions.add("anyTopLevelOptionalElement");
        groupDefinitions.add("optional-response-fault");
        groupDefinitions.add("request-response-one-way-operation");
        groupDefinitions.add("optional-solicit-fault");
        groupDefinitions.add("solicit-response-notification-operation");
        complexTypeDefinitions = new HashSet();
        simpleTypeDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        attributeDefinitions = new HashSet();
        attributeGroupDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchema.put(ATTRIBUTE, attributeDefinitions);
        knownSchema.put(ATTRIBUTE_GROUP, attributeGroupDefinitions);
        knownSchemas.put("http://schemas.xmlsoap.org/soap/envelope/", knownSchema);
        attributeDefinitions.add("actor");
        attributeDefinitions.add("encodingStyle");
        attributeDefinitions.add("mustUnderstand");
        attributeGroupDefinitions.add("encodingStyle");
        complexTypeDefinitions.add("Body");
        complexTypeDefinitions.add("Envelope");
        complexTypeDefinitions.add("Fault");
        complexTypeDefinitions.add("Header");
        complexTypeDefinitions.add("detail");
        elementDefinitions.add("Body");
        elementDefinitions.add("Envelope");
        elementDefinitions.add("Fault");
        elementDefinitions.add("Header");
        simpleTypeDefinitions.add("encodingStyle");
        complexTypeDefinitions = new HashSet();
        simpleTypeDefinitions = new HashSet();
        groupDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        attributeDefinitions = new HashSet();
        attributeGroupDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchema.put(GROUP, groupDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchema.put(ATTRIBUTE, attributeDefinitions);
        knownSchema.put(ATTRIBUTE_GROUP, attributeGroupDefinitions);
        knownSchemas.put("http://schemas.xmlsoap.org/soap/encoding/", knownSchema);
        attributeDefinitions.add("arrayType");
        attributeDefinitions.add("offset");
        attributeDefinitions.add("position");
        attributeDefinitions.add("root");
        attributeGroupDefinitions.add("arrayAttributes");
        attributeGroupDefinitions.add("arrayMemberAttributes");
        attributeGroupDefinitions.add("commonAttributes");
        complexTypeDefinitions.add("Array");
        complexTypeDefinitions.add("ENTITIES");
        complexTypeDefinitions.add("ENTITY");
        complexTypeDefinitions.add("ID");
        complexTypeDefinitions.add("IDREF");
        complexTypeDefinitions.add("IDREFS");
        complexTypeDefinitions.add("NCName");
        complexTypeDefinitions.add("NMTOKEN");
        complexTypeDefinitions.add("NMTOKENS");
        complexTypeDefinitions.add("NOTATION");
        complexTypeDefinitions.add("Name");
        complexTypeDefinitions.add("QName");
        complexTypeDefinitions.add("Struct");
        complexTypeDefinitions.add("anyURI");
        complexTypeDefinitions.add("base64Binary");
        complexTypeDefinitions.add("boolean");
        complexTypeDefinitions.add("byte");
        complexTypeDefinitions.add("date");
        complexTypeDefinitions.add("dateTime");
        complexTypeDefinitions.add("decimal");
        complexTypeDefinitions.add("double");
        complexTypeDefinitions.add("duration");
        complexTypeDefinitions.add("float");
        complexTypeDefinitions.add("gDay");
        complexTypeDefinitions.add("gMonth");
        complexTypeDefinitions.add("gMonthDay");
        complexTypeDefinitions.add("gYear");
        complexTypeDefinitions.add("gYearMonth");
        complexTypeDefinitions.add("hexBinary");
        complexTypeDefinitions.add("int");
        complexTypeDefinitions.add("integer");
        complexTypeDefinitions.add("language");
        complexTypeDefinitions.add("long");
        complexTypeDefinitions.add("negativeInteger");
        complexTypeDefinitions.add("nonNegativeInteger");
        complexTypeDefinitions.add("nonPositiveInteger");
        complexTypeDefinitions.add("normalizedString");
        complexTypeDefinitions.add("positiveInteger");
        complexTypeDefinitions.add("short");
        complexTypeDefinitions.add("string");
        complexTypeDefinitions.add("time");
        complexTypeDefinitions.add("token");
        complexTypeDefinitions.add("unsignedByte");
        complexTypeDefinitions.add("unsignedInt");
        complexTypeDefinitions.add("unsignedLong");
        complexTypeDefinitions.add("unsignedShort");
        elementDefinitions.add("Array");
        elementDefinitions.add("ENTITIES");
        elementDefinitions.add("ENTITY");
        elementDefinitions.add("ID");
        elementDefinitions.add("IDREF");
        elementDefinitions.add("IDREFS");
        elementDefinitions.add("NCName");
        elementDefinitions.add("NMTOKEN");
        elementDefinitions.add("NMTOKENS");
        elementDefinitions.add("NOTATION");
        elementDefinitions.add("Name");
        elementDefinitions.add("QName");
        elementDefinitions.add("Struct");
        elementDefinitions.add("anyType");
        elementDefinitions.add("anyURI");
        elementDefinitions.add("base64Binary");
        elementDefinitions.add("boolean");
        elementDefinitions.add("byte");
        elementDefinitions.add("date");
        elementDefinitions.add("dateTime");
        elementDefinitions.add("decimal");
        elementDefinitions.add("double");
        elementDefinitions.add("duration");
        elementDefinitions.add("float");
        elementDefinitions.add("gDay");
        elementDefinitions.add("gMonth");
        elementDefinitions.add("gMonthDay");
        elementDefinitions.add("gYear");
        elementDefinitions.add("gYearMonth");
        elementDefinitions.add("hexBinary");
        elementDefinitions.add("int");
        elementDefinitions.add("integer");
        elementDefinitions.add("language");
        elementDefinitions.add("long");
        elementDefinitions.add("negativeInteger");
        elementDefinitions.add("nonNegativeInteger");
        elementDefinitions.add("nonPositiveInteger");
        elementDefinitions.add("normalizedString");
        elementDefinitions.add("positiveInteger");
        elementDefinitions.add("short");
        elementDefinitions.add("string");
        elementDefinitions.add("time");
        elementDefinitions.add("token");
        elementDefinitions.add("unsignedByte");
        elementDefinitions.add("unsignedInt");
        elementDefinitions.add("unsignedLong");
        elementDefinitions.add("unsignedShort");
        groupDefinitions.add("Array");
        groupDefinitions.add("Struct");
        simpleTypeDefinitions.add("arrayCoordinate");
        simpleTypeDefinitions.add("base64");
        complexTypeDefinitions = new HashSet();
        simpleTypeDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        attributeGroupDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchema.put(ATTRIBUTE_GROUP, attributeGroupDefinitions);
        knownSchemas.put("http://schemas.xmlsoap.org/wsdl/soap/", knownSchema);
        attributeGroupDefinitions.add("tBodyAttributes");
        complexTypeDefinitions.add("tAddress");
        complexTypeDefinitions.add("tBinding");
        complexTypeDefinitions.add("tBody");
        complexTypeDefinitions.add("tHeader");
        complexTypeDefinitions.add("tHeaderFault");
        complexTypeDefinitions.add("tOperation");
        elementDefinitions.add("address");
        elementDefinitions.add("binding");
        elementDefinitions.add("body");
        elementDefinitions.add("fault");
        elementDefinitions.add("header");
        elementDefinitions.add("headerfault");
        elementDefinitions.add("operation");
        simpleTypeDefinitions.add("encodingStyle");
        simpleTypeDefinitions.add("tStyleChoice");
        simpleTypeDefinitions.add("useChoice");
        complexTypeDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchemas.put("http://schemas.xmlsoap.org/wsdl/mime/", knownSchema);
        complexTypeDefinitions.add("contentType");
        complexTypeDefinitions.add("multipartRelatedType");
        complexTypeDefinitions.add("tMimeXml");
        complexTypeDefinitions.add("tPart");
        elementDefinitions.add("content");
        elementDefinitions.add("mimeXml");
        elementDefinitions.add("multipartRelated");
        complexTypeDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchemas.put("http://schemas.xmlsoap.org/wsdl/http/", knownSchema);
        complexTypeDefinitions.add("addressType");
        complexTypeDefinitions.add("bindingType");
        complexTypeDefinitions.add("operationType");
        elementDefinitions.add("address");
        elementDefinitions.add("binding");
        elementDefinitions.add("operation");
        elementDefinitions.add("urlEncoded");
        elementDefinitions.add("urlReplacement");
        complexTypeDefinitions = new HashSet();
        simpleTypeDefinitions = new HashSet();
        groupDefinitions = new HashSet();
        elementDefinitions = new HashSet();
        attributeDefinitions = new HashSet();
        attributeGroupDefinitions = new HashSet();
        knownSchema = new HashMap();
        knownSchema.put(COMPLEX_TYPE, complexTypeDefinitions);
        knownSchema.put(SIMPLE_TYPE, simpleTypeDefinitions);
        knownSchema.put(GROUP, groupDefinitions);
        knownSchema.put(ELEMENT, elementDefinitions);
        knownSchema.put(ATTRIBUTE, attributeDefinitions);
        knownSchema.put(ATTRIBUTE_GROUP, attributeGroupDefinitions);
        knownSchemas.put(Namespaces.SOAP12_ENC_NS, knownSchema);
        attributeDefinitions.add("arraySize");
        attributeDefinitions.add("itemType");
        attributeDefinitions.add("root");
        attributeGroupDefinitions.add("arrayAttributes");
        attributeGroupDefinitions.add("commonAttributes");
        complexTypeDefinitions.add("Array");
        complexTypeDefinitions.add("ENTITIES");
        complexTypeDefinitions.add("ENTITY");
        complexTypeDefinitions.add("ID");
        complexTypeDefinitions.add("IDREF");
        complexTypeDefinitions.add("IDREFS");
        complexTypeDefinitions.add("NCName");
        complexTypeDefinitions.add("NMTOKEN");
        complexTypeDefinitions.add("NMTOKENS");
        complexTypeDefinitions.add("Name");
        complexTypeDefinitions.add("QName");
        complexTypeDefinitions.add("Struct");
        complexTypeDefinitions.add("anyURI");
        complexTypeDefinitions.add("base64Binary");
        complexTypeDefinitions.add("boolean");
        complexTypeDefinitions.add("byte");
        complexTypeDefinitions.add("date");
        complexTypeDefinitions.add("dateTime");
        complexTypeDefinitions.add("decimal");
        complexTypeDefinitions.add("double");
        complexTypeDefinitions.add("duration");
        complexTypeDefinitions.add("float");
        complexTypeDefinitions.add("gDay");
        complexTypeDefinitions.add("gMonth");
        complexTypeDefinitions.add("gMonthDay");
        complexTypeDefinitions.add("gYear");
        complexTypeDefinitions.add("gYearMonth");
        complexTypeDefinitions.add("hexBinary");
        complexTypeDefinitions.add("int");
        complexTypeDefinitions.add("integer");
        complexTypeDefinitions.add("language");
        complexTypeDefinitions.add("long");
        complexTypeDefinitions.add("negativeInteger");
        complexTypeDefinitions.add("nonNegativeInteger");
        complexTypeDefinitions.add("nonPositiveInteger");
        complexTypeDefinitions.add("normalizedString");
        complexTypeDefinitions.add("positiveInteger");
        complexTypeDefinitions.add("short");
        complexTypeDefinitions.add("string");
        complexTypeDefinitions.add("time");
        complexTypeDefinitions.add("token");
        complexTypeDefinitions.add("unsignedByte");
        complexTypeDefinitions.add("unsignedInt");
        complexTypeDefinitions.add("unsignedLong");
        complexTypeDefinitions.add("unsignedShort");
        elementDefinitions.add("Array");
        elementDefinitions.add("ENTITIES");
        elementDefinitions.add("ENTITY");
        elementDefinitions.add("ID");
        elementDefinitions.add("IDREF");
        elementDefinitions.add("IDREFS");
        elementDefinitions.add("NCName");
        elementDefinitions.add("NMTOKEN");
        elementDefinitions.add("NMTOKENS");
        elementDefinitions.add("Name");
        elementDefinitions.add("QName");
        elementDefinitions.add("Struct");
        elementDefinitions.add("anyType");
        elementDefinitions.add("anyURI");
        elementDefinitions.add("base64Binary");
        elementDefinitions.add("boolean");
        elementDefinitions.add("byte");
        elementDefinitions.add("date");
        elementDefinitions.add("dateTime");
        elementDefinitions.add("decimal");
        elementDefinitions.add("double");
        elementDefinitions.add("duration");
        elementDefinitions.add("float");
        elementDefinitions.add("gDay");
        elementDefinitions.add("gMonth");
        elementDefinitions.add("gMonthDay");
        elementDefinitions.add("gYear");
        elementDefinitions.add("gYearMonth");
        elementDefinitions.add("hexBinary");
        elementDefinitions.add("int");
        elementDefinitions.add("integer");
        elementDefinitions.add("language");
        elementDefinitions.add("long");
        elementDefinitions.add("negativeInteger");
        elementDefinitions.add("nonNegativeInteger");
        elementDefinitions.add("nonPositiveInteger");
        elementDefinitions.add("normalizedString");
        elementDefinitions.add("positiveInteger");
        elementDefinitions.add("short");
        elementDefinitions.add("string");
        elementDefinitions.add("time");
        elementDefinitions.add("token");
        elementDefinitions.add("unsignedByte");
        elementDefinitions.add("unsignedInt");
        elementDefinitions.add("unsignedLong");
        elementDefinitions.add("unsignedShort");
        groupDefinitions.add("Array");
        groupDefinitions.add("Struct");
        simpleTypeDefinitions.add("arraySize");
        simpleTypeDefinitions.add("arraySizeBase");
        simpleTypeDefinitions.add("base64");
    }
}

