/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.Writer2Element;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.ElementParser;
import com.idoox.xml.schema.parser.GroupParser;
import com.idoox.xml.schema.parser.TypeParser;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Facet;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.RepeatableSchemaConstruct;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Helper {
    public static void fillFacets(Element element, SchemaConstruct fillTo, boolean fillAllFacets) {
        NamedNodeMap attrs = element.getAttributes();
        int l = attrs.getLength();
        HashMap<QName, String> facets = fillTo.getFacets();
        int i = 0;
        while (i < l) {
            Attr attr = (Attr)attrs.item(i);
            String locName = attr.getLocalName();
            if (locName == null) {
                locName = attr.getName();
            }
            QName n = new QName(attr.getNamespaceURI(), locName);
            if (fillAllFacets || n.equals(XMLSchemaUtil.SOAPENC_ARRAYTYPE) || n.equals(XMLSchemaUtil.WSDL_ARRAYTYPE)) {
                int index;
                if (facets == null) {
                    facets = l < 5 ? new HashMap<QName, String>(11) : new HashMap(23);
                    fillTo.setFacets(facets);
                }
                boolean setPrefix = false;
                if ("http://schemas.xmlsoap.org/wsdl/".equals(attr.getNamespaceURI()) && "arrayType".equals(attr.getLocalName())) {
                    setPrefix = true;
                }
                if (setPrefix && (index = attr.getValue().indexOf(58)) > 0) {
                    String prefix = "xmlns:" + attr.getValue().substring(0, index);
                    Node node = element;
                    while (node != null) {
                        String prefixValue;
                        if (node instanceof Element && (prefixValue = node.getAttribute(prefix)) != null && prefixValue.length() > 0 && !"http://www.w3.org/XML/1998/namespace".equals(prefixValue)) {
                            element.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix, prefixValue);
                            break;
                        }
                        node = node.getParentNode();
                    }
                }
                facets.put(n, attr.getValue());
            }
            ++i;
        }
    }

    public static void setAppInfo(Element el, SchemaConstruct fillTo) {
        Element appinfo;
        String namespace = el.getNamespaceURI();
        Element annot = ElementHelper.getChildElementByTagName(el, namespace, "annotation");
        if (annot != null && (appinfo = ElementHelper.getChildElementByTagName(annot, namespace, "appinfo")) != null) {
            fillTo.setAppInfo(appinfo);
        }
    }

    public static void setMinMaxOccurs(Element el, RepeatableSchemaConstruct fillTo, int minOccursDefault, int maxOccursDefault) {
        String minOccursString = ElementHelper.getAttribute(el, "minOccurs");
        if (minOccursString != null) {
            fillTo.setMinOccurs(Integer.parseInt(minOccursString));
        } else {
            fillTo.setMinOccurs(minOccursDefault);
        }
        String maxOccursString = ElementHelper.getAttribute(el, "maxOccurs");
        if (maxOccursString != null) {
            if ("unbounded".equals(maxOccursString)) {
                fillTo.setMaxOccurs(-1);
            } else {
                fillTo.setMaxOccurs(Integer.parseInt(maxOccursString));
            }
        } else {
            fillTo.setMaxOccurs(maxOccursDefault);
        }
    }

    public static void writeConstruct(TokenWriter writer, SchemaConstruct construct, Set importedNamespaces, boolean topLevel) throws IOException, SchemaException {
        if (construct.getConstructType() == SchemaConstruct.ConstructType.TYPE) {
            Type t = (Type)construct;
            if (t.getKind() == 36) {
                GroupParser.write(writer, t, importedNamespaces);
            } else {
                TypeParser.write(writer, t, importedNamespaces, topLevel);
            }
        } else if (construct.getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
            ElementParser.write(writer, (Member)construct, importedNamespaces);
        }
    }

    public static void writeNamespacesAndFacets(TokenWriter writer, SchemaConstruct construct, Set importedNamespaces) throws IOException {
        Helper.writeNamespacesAndFacets(writer, construct, true);
    }

    private static String getPrefixForNamespaceHelper(TokenWriter writer, String namespace) throws IOException {
        if (writer instanceof Writer2Element) {
            Writer2Element writer2Element = (Writer2Element)writer;
            return writer2Element.getPrefixForNamespaceWithoutSideEffect(namespace);
        }
        return writer.getPrefixForNamespace(namespace);
    }

    public static void writeNamespacesAndFacets(TokenWriter writer, SchemaConstruct construct, boolean facetsAndSpaces) throws IOException {
        if (facetsAndSpaces) {
            Map facets;
            Map prefix2namespace = construct.getPrefixNamespaceMapping();
            if (prefix2namespace != null) {
                Iterator i = prefix2namespace.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String prefix = (String)entry.getKey();
                    String ns = (String)entry.getValue();
                    if (prefix != null) {
                        if (prefix.equals(Helper.getPrefixForNamespaceHelper(writer, ns))) continue;
                        writer.setPrefixForNamespace(prefix, ns);
                        continue;
                    }
                    if (Helper.getPrefixForNamespaceHelper(writer, ns) == null) continue;
                    writer.setPrefixForNamespace(prefix, ns);
                }
            }
            if ((facets = construct.getFacets()) != null) {
                Iterator i = facets.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    QName name = (QName)entry.getKey();
                    Object o_value = entry.getValue();
                    if (!(o_value instanceof String)) continue;
                    String value = (String)o_value;
                    String localPart = name.getLocalPart();
                    if (localPart.equals("base") || localPart.equals("type") || localPart.equals("ref")) continue;
                    writer.writeAttribute(name.getNamespaceURI(), localPart, value);
                }
            }
        }
        if (construct instanceof RepeatableSchemaConstruct) {
            RepeatableSchemaConstruct rsc = (RepeatableSchemaConstruct)construct;
            if (rsc.getMaxOccurs() == -1) {
                writer.writeAttribute(null, "maxOccurs", "unbounded");
            } else if (rsc.getMaxOccurs() != 1) {
                writer.writeAttribute(null, "maxOccurs", String.valueOf(rsc.getMaxOccurs()));
            }
            if (rsc.getMinOccurs() != 1) {
                writer.writeAttribute(null, "minOccurs", String.valueOf(rsc.getMinOccurs()));
            }
        }
    }

    public static void writeQNameAttribute(TokenWriter writer, String namespaceURI, String name, QName value) throws IOException {
        if (value == null) {
            return;
        }
        String prefix = writer.getPrefixForNamespace(value.getNamespaceURI());
        if (prefix == null || prefix.length() == 0) {
            writer.writeAttribute(namespaceURI, name, value.getLocalPart());
        } else {
            writer.writeAttribute(namespaceURI, name, prefix + ":" + value.getLocalPart());
        }
    }

    public static void fillJavaType(Element el, Type parseInto, SchemaParserImpl parser) throws SchemaException {
        String namespaceURI = el.getNamespaceURI();
        Element annotation = ElementHelper.getChildElementByTagName(el, namespaceURI, "annotation");
        if (annotation != null) {
            Element[] appinfos = ElementHelper.getChildrenElementsByTagName(annotation, namespaceURI, "appinfo");
            int i = 0;
            while (i < appinfos.length) {
                Element javaType = ElementHelper.getChildElementByTagName(appinfos[i], "http://systinet.com/mapping/", "java-type");
                if (javaType != null) {
                    String javaName = ElementHelper.getAttribute(javaType, "name");
                    if (javaName == null) {
                        throw new SchemaException("Missing attribute <name> in element <java-type>. Context: " + ElementHelper.getFullPath(javaType));
                    }
                    if (parseInto.getJavaTypeName() == null) {
                        parseInto.setJavaTypeName(javaName);
                        parser.addSchemaTypeToJavaTypeMapping(parseInto, javaName);
                    } else {
                        throw new SchemaException("Duplicated <java-type name=''> declaration. Context: " + ElementHelper.getFullPath(javaType));
                    }
                }
                ++i;
            }
        }
    }

    public static void writeExtension(TokenWriter writer, SchemaConstruct schemaConstruct) throws IOException {
        if (schemaConstruct.getJavaName() != null) {
            writer.writeAttribute("http://systinet.com/mapping/", "java-field", schemaConstruct.getJavaName());
        }
    }

    public static void writeFacets(TokenWriter writer, Facet[] facets) throws IOException {
        int i = 0;
        while (i < facets.length) {
            facets[i].writeAsXML(writer);
            ++i;
        }
    }

    static void writeNSPrefixes(SchemaConstruct type, TokenWriter writer) throws IOException {
        Map pref2ns = type.getPrefixNamespaceMapping();
        if (pref2ns != null) {
            Iterator i = pref2ns.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry ce = i.next();
                String pref = (String)ce.getKey();
                String value = (String)ce.getValue();
                writer.setPrefixForNamespace(pref, value);
            }
        }
    }
}

