/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AttributeGroupParser;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.Constants;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SimpleTypeParser;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class ComplexSimpleExtensionParser {
    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params) throws SchemaException {
        SchemaConstruct attr;
        int i;
        Type baseTypeType;
        String namespaceURI = el.getNamespaceURI();
        String baseType = ElementHelper.getAttributeNS(el, null, "base");
        Element simpleType = ElementHelper.getChildElementByTagName(el, namespaceURI, "simpleType");
        if (baseType != null && simpleType != null) {
            throw new SchemaException("Restriction should be defined using attribute <base> or element <simpleType>, not both. Context : " + ElementHelper.getFullPath(el));
        }
        if (baseType != null) {
            QName baseName = ElementHelper.getQName(el, baseType);
            baseName = ElementHelper.chameleonQName(baseName, params.chameleonNamespace);
            baseTypeType = parser.getSchemaType(baseName, false);
        } else if (simpleType != null) {
            baseTypeType = new Type();
            SimpleTypeParser.parse(baseTypeType, simpleType, parser, params, false);
        } else {
            baseTypeType = parser.getSchemaType(Constants.ANY_SIMPLE_TYPE, false);
        }
        parseInto.setBaseType(baseTypeType);
        parseInto.setKind((short)19);
        parseInto.setInheritedByExtension(true);
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
        Element[] attributes = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attribute");
        Element[] attributeGroups = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attributeGroup");
        if (attributes != null) {
            i = 0;
            while (i < attributes.length) {
                attr = AttributeParser.parse(attributes[i], parser, params, false);
                parseInto.addAttribute((Attribute)attr);
                ++i;
            }
        }
        if (attributeGroups != null) {
            i = 0;
            while (i < attributeGroups.length) {
                attr = AttributeGroupParser.parse(attributeGroups[i], parser, params, false);
                parseInto.addAttributeGroup((AttributeGroup)attr);
                ++i;
            }
        }
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
    }
}

