/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AllParser;
import com.idoox.xml.schema.parser.AttributeGroupParser;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.ChoiceParser;
import com.idoox.xml.schema.parser.Constants;
import com.idoox.xml.schema.parser.GroupParser;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SequenceParser;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class ComplexRestrictionParser {
    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params) throws SchemaException {
        Type baseTypeType;
        String baseType;
        SchemaConstruct attr;
        int i;
        String localName = el.getLocalName();
        String namespaceURI = el.getNamespaceURI();
        Element group = ElementHelper.getChildElementByTagName(el, namespaceURI, "group");
        Element all = ElementHelper.getChildElementByTagName(el, namespaceURI, "all");
        Element choice = ElementHelper.getChildElementByTagName(el, namespaceURI, "choice");
        Element sequence = ElementHelper.getChildElementByTagName(el, namespaceURI, "sequence");
        Element[] attributes = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attribute");
        Element[] attributeGroups = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attributeGroup");
        int c = group != null ? 1 : 0;
        c += all != null ? 1 : 0;
        c += choice != null ? 1 : 0;
        if ((c += sequence != null ? 1 : 0) > 1) {
            throw new SchemaException("Only one of <group>, <all>, <choice>, <sequence> allowed in " + ElementHelper.getFullPath(el));
        }
        if (group != null) {
            GroupParser.parse(parseInto, group, parser, params);
        } else if (all != null) {
            AllParser.parse(parseInto, all, parser, params);
        } else if (choice != null) {
            ChoiceParser.parse(parseInto, choice, parser, params);
        } else if (sequence != null) {
            SequenceParser.parse(parseInto, sequence, parser, params);
        }
        if (parseInto.getBaseType() != null && new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array").equals(parseInto.getBaseType().getName()) && (parseInto.getSubconstructs() == null || parseInto.getSubconstructs().length == 0)) {
            parseInto.setKind((short)35);
            parseInto.setSubconstructs(parseInto.getBaseType().getSubconstructs());
        }
        if (attributes != null) {
            i = 0;
            while (i < attributes.length) {
                attr = AttributeParser.parse(attributes[i], parser, params, false);
                parseInto.addAttribute((Attribute)attr);
                ++i;
            }
        }
        if (attributeGroups != null) {
            i = 0;
            while (i < attributeGroups.length) {
                attr = AttributeGroupParser.parse(attributeGroups[i], parser, params, false);
                parseInto.addAttributeGroup((AttributeGroup)attr);
                ++i;
            }
        }
        if ((baseType = ElementHelper.getAttributeNS(el, null, "base")) != null) {
            QName baseName = ElementHelper.getQName(el, baseType);
            baseName = ElementHelper.chameleonQName(baseName, params.chameleonNamespace);
            baseTypeType = parser.getSchemaType(baseName, false);
            if (Constants.ANY_TYPE.equals(baseName) || Constants.ANY_TYPE2000.equals(baseName) || Constants.ANY_TYPE1999.equals(baseName)) {
                baseTypeType = null;
                parseInto.setInheritedByExtension(false);
                parseInto.setInheritedByRestriction(false);
            }
        } else {
            baseTypeType = null;
        }
        parseInto.setBaseType(baseTypeType);
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
    }
}

