/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.debug.Category;
import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.Constants;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SimpleTypeParser;
import com.idoox.xml.schema.parser.TypeParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class AttributeParser {
    private static final Category cat = Category.getCategory("com.idoox.cml.schema.parser.TopLevelAttributeParser");
    private static final QName ANYSIMPLETYPE_QNAME2001 = new QName("http://www.w3.org/2001/XMLSchema", "string");
    private static final QName ANYSIMPLETYPE_QNAME2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "string");
    private static final QName ANYSIMPLETYPE_QNAME1999 = new QName("http://www.w3.org/1999/XMLSchema", "string");

    public static Attribute parse(Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        String namespaceURI = el.getNamespaceURI();
        String java_field = ElementHelper.getAttributeNS(el, "http://systinet.com/mapping/", "java-field");
        Attribute ret = null;
        String localName = ElementHelper.getAttributeNS(el, null, "name");
        String ref = ElementHelper.getAttributeNS(el, null, "ref");
        if (localName != null) {
            if (ref != null) {
                throw new SchemaException("Expecting one of <name> or <ref> attributes, not both. Context : " + ElementHelper.getFullPath(el));
            }
            String tn = null;
            String form = ElementHelper.getAttribute(el, "form");
            if (form == null) {
                if (params.attributeFormDefault || topLevel) {
                    tn = params.targetNamespace;
                }
            } else if ("qualified".equals(form)) {
                tn = params.targetNamespace;
            }
            QName name = new QName(tn, localName);
            if (topLevel && parser.isDefinedAttribute(name)) {
                Attribute attribute = parser.getAttribute(name, false);
                cat.error("Duplicated definition of attribute " + attribute);
                return attribute;
            }
            ret = AttributeParser.parseDefinition(name, el, parser, params, topLevel);
        } else if (ref != null) {
            ret = new Attribute();
            QName refName = ElementHelper.getQName(el, ref);
            refName = ElementHelper.chameleonQName(refName, params.chameleonNamespace);
            ret.setReferencedConstruct(parser.getAttribute(refName, false));
        } else {
            throw new SchemaException("Attribute <name> or <ref> must be present on " + ElementHelper.getFullPath(el));
        }
        Helper.fillFacets(el, ret, parser.isParsingFacets());
        if (topLevel) {
            ret.setPrefixNamespaceMapping(ElementHelper.getAllNamespaces(el, ret.getPrefixNamespaceMapping()));
        } else {
            ret.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, ret.getPrefixNamespaceMapping()));
        }
        if (ret.getType() == null && ret.getReferencedConstruct() == null) {
            QName anySimpleTypeQName = ANYSIMPLETYPE_QNAME2001;
            if (ANYSIMPLETYPE_QNAME2000.getNamespaceURI().equals(namespaceURI)) {
                anySimpleTypeQName = ANYSIMPLETYPE_QNAME2000;
            } else if (ANYSIMPLETYPE_QNAME1999.getNamespaceURI().equals(namespaceURI)) {
                anySimpleTypeQName = ANYSIMPLETYPE_QNAME1999;
            }
            ret.setType(parser.getSchemaType(anySimpleTypeQName, false));
        }
        if (java_field != null) {
            ret.setJavaName(java_field);
        }
        Helper.setAppInfo(el, ret);
        return ret;
    }

    private static Attribute parseDefinition(QName name, Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        Type typeType;
        String namespaceURI = el.getNamespaceURI();
        Attribute returnedAttr = topLevel ? parser.getAttribute(name, true) : new Attribute(name);
        String type = ElementHelper.getAttributeNS(el, null, "type");
        String java_field = ElementHelper.getAttributeNS(el, "http://systinet.com/mapping/", "java-field");
        Element simpleType = ElementHelper.getChildElementByTagName(el, namespaceURI, "simpleType");
        if (type != null && simpleType != null) {
            throw new SchemaException("Attribute's type should be defined using attribute <type> or element <simpleType>, not both. Context : " + ElementHelper.getFullPath(el));
        }
        if (type != null) {
            QName typeName = ElementHelper.getQName(el, type);
            typeName = ElementHelper.chameleonQName(typeName, params.chameleonNamespace);
            typeType = parser.getSchemaType(typeName, false);
        } else if (simpleType != null) {
            typeType = new Type();
            SimpleTypeParser.parse(typeType, simpleType, parser, params, false);
            typeType.setParent(returnedAttr);
        } else {
            typeType = parser.getSchemaType(Constants.ANY_SIMPLE_TYPE, false);
        }
        returnedAttr.setType(typeType);
        if (java_field != null) {
            returnedAttr.setJavaName(java_field);
        }
        return returnedAttr;
    }

    public static void write(TokenWriter writer, Attribute[] attributes, Set importedNamespaces) throws IOException, SchemaException {
        if (attributes == null) {
            return;
        }
        int i = 0;
        while (i < attributes.length) {
            AttributeParser.write(writer, attributes[i], importedNamespaces);
            ++i;
        }
    }

    public static void write(TokenWriter writer, Attribute attr, Set importedNamespaces) throws IOException, SchemaException {
        writer.enter("http://www.w3.org/2001/XMLSchema", "attribute");
        Attribute ref = (Attribute)attr.getReferencedConstruct();
        QName name = attr.getName();
        if (ref == null) {
            HashMap<QName, String> facets = attr.getFacets();
            if (facets == null) {
                facets = new HashMap<QName, String>(7);
                attr.setFacets(facets);
            }
            if (name != null && name.getNamespaceURI().equals("")) {
                facets.put(new QName(null, "form"), "unqualified");
            } else {
                facets.put(new QName(null, "form"), "qualified");
            }
        }
        Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)attr, importedNamespaces);
        Helper.writeExtension(writer, attr);
        if (ref != null) {
            Helper.writeQNameAttribute(writer, null, "ref", ref.getName());
            importedNamespaces.add(ref.getName().getNamespaceURI());
        } else {
            writer.writeAttribute(null, "name", attr.getName().getLocalPart());
            Type type = attr.getType();
            if (type != null) {
                if (type.getName() != null) {
                    Helper.writeQNameAttribute(writer, null, "type", type.getName());
                } else {
                    TypeParser.write(writer, type, importedNamespaces, false);
                }
            }
        }
        writer.leave();
    }
}

