/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema;

import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.SchemaElementParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SchemaParser;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaImpl
implements Schema {
    static final long serialVersionUID = 7335331521018033553L;
    private HashMap typesMap = new HashMap();
    private HashMap groupsMap = new HashMap();
    private HashMap elementsMap = new HashMap();
    private HashMap attributesMap = new HashMap();
    private HashMap attributeGroupsMap = new HashMap();
    private HashMap javaTypeToSchemaType = new HashMap();
    private HashMap allTypes = new HashMap();
    private HashSet namespaces = new HashSet(101);
    SchemaParserImpl parser;

    public SchemaImpl(SchemaParserImpl parser) {
        this.parser = parser;
    }

    public synchronized Type getSchemaType(QName typeName) {
        return (Type)this.allTypes.get(typeName);
    }

    public synchronized Type getSchemaType(String namespace, String name) {
        HashMap theNamespace = (HashMap)this.typesMap.get(namespace);
        if (theNamespace == null) {
            return null;
        }
        return (Type)theNamespace.get(name);
    }

    public synchronized void addSchemaType(Type type) {
        QName typeName = type.getName();
        this.allTypes.put(typeName, type);
        String namespaceURI = typeName.getNamespaceURI();
        String localPart = typeName.getLocalPart();
        this.namespaces.add(namespaceURI);
        HashMap<String, Type> theNamespace = (HashMap<String, Type>)this.typesMap.get(namespaceURI);
        if (theNamespace == null) {
            theNamespace = new HashMap<String, Type>(101);
            this.typesMap.put(namespaceURI, theNamespace);
        }
        theNamespace.put(localPart, type);
        String javaTypeName = type.getJavaTypeName();
        if (javaTypeName != null && this.javaTypeToSchemaType != null) {
            this.javaTypeToSchemaType.put(javaTypeName, type);
        }
    }

    public Type getSchemaGroup(QName groupName) {
        return this.getSchemaGroup(groupName.getNamespaceURI(), groupName.getLocalPart());
    }

    public synchronized Type getSchemaGroup(String namespace, String name) {
        HashMap theNamespace = (HashMap)this.groupsMap.get(namespace);
        if (theNamespace == null) {
            return null;
        }
        return (Type)theNamespace.get(name);
    }

    public synchronized void addSchemaGroup(Type group) {
        String namespaceURI = group.getName().getNamespaceURI();
        String localPart = group.getName().getLocalPart();
        this.namespaces.add(namespaceURI);
        HashMap<String, Type> theNamespace = (HashMap<String, Type>)this.groupsMap.get(namespaceURI);
        if (theNamespace == null) {
            theNamespace = new HashMap<String, Type>(101);
            this.groupsMap.put(namespaceURI, theNamespace);
        }
        theNamespace.put(localPart, group);
    }

    public Member getSchemaElement(QName memberName) {
        return this.getSchemaElement(memberName.getNamespaceURI(), memberName.getLocalPart());
    }

    public synchronized Member getSchemaElement(String namespace, String name) {
        HashMap theNamespace = (HashMap)this.elementsMap.get(namespace);
        if (theNamespace == null) {
            return null;
        }
        return (Member)theNamespace.get(name);
    }

    public synchronized void addSchemaElement(Member element) {
        String namespaceURI = element.getName().getNamespaceURI();
        String localPart = element.getName().getLocalPart();
        this.namespaces.add(namespaceURI);
        HashMap<String, Member> theNamespace = (HashMap<String, Member>)this.elementsMap.get(namespaceURI);
        if (theNamespace == null) {
            theNamespace = new HashMap<String, Member>(101);
            this.elementsMap.put(namespaceURI, theNamespace);
        }
        theNamespace.put(localPart, element);
    }

    public Attribute getAttribute(QName memberName) {
        return this.getAttribute(memberName.getNamespaceURI(), memberName.getLocalPart());
    }

    public synchronized Attribute getAttribute(String namespace, String name) {
        HashMap theNamespace = (HashMap)this.attributesMap.get(namespace);
        if (theNamespace == null) {
            return null;
        }
        return (Attribute)theNamespace.get(name);
    }

    public synchronized void addAttribute(Attribute attribute) {
        String namespaceURI = attribute.getName().getNamespaceURI();
        String localPart = attribute.getName().getLocalPart();
        this.namespaces.add(namespaceURI);
        HashMap<String, Attribute> theNamespace = (HashMap<String, Attribute>)this.attributesMap.get(namespaceURI);
        if (theNamespace == null) {
            theNamespace = new HashMap<String, Attribute>(101);
            this.attributesMap.put(namespaceURI, theNamespace);
        }
        theNamespace.put(localPart, attribute);
    }

    public AttributeGroup getAttributeGroup(QName memberName) {
        return this.getAttributeGroup(memberName.getNamespaceURI(), memberName.getLocalPart());
    }

    public synchronized AttributeGroup getAttributeGroup(String namespace, String name) {
        HashMap theNamespace = (HashMap)this.attributeGroupsMap.get(namespace);
        if (theNamespace == null) {
            return null;
        }
        return (AttributeGroup)theNamespace.get(name);
    }

    public synchronized void addAttributeGroup(AttributeGroup attributeGroup) {
        String namespaceURI = attributeGroup.getName().getNamespaceURI();
        String localPart = attributeGroup.getName().getLocalPart();
        this.namespaces.add(namespaceURI);
        HashMap<String, AttributeGroup> theNamespace = (HashMap<String, AttributeGroup>)this.attributeGroupsMap.get(namespaceURI);
        if (theNamespace == null) {
            theNamespace = new HashMap<String, AttributeGroup>(101);
            this.attributeGroupsMap.put(namespaceURI, theNamespace);
        }
        theNamespace.put(localPart, attributeGroup);
    }

    public SchemaParser getParser() {
        return this.parser;
    }

    public Set getNamespaces() {
        return this.namespaces;
    }

    public synchronized Iterator getTypes(String namespaceURI) {
        HashMap theNamespace = (HashMap)this.typesMap.get(namespaceURI);
        if (theNamespace == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableCollection(theNamespace.values()).iterator();
    }

    public synchronized Iterator getElements(String namespaceURI) {
        HashMap theNamespace = (HashMap)this.elementsMap.get(namespaceURI);
        if (theNamespace == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableCollection(theNamespace.values()).iterator();
    }

    public synchronized Iterator getGroups(String namespaceURI) {
        HashMap theNamespace = (HashMap)this.groupsMap.get(namespaceURI);
        if (theNamespace == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableCollection(theNamespace.values()).iterator();
    }

    public synchronized Iterator getAttributes(String namespaceURI) {
        HashMap theNamespace = (HashMap)this.attributesMap.get(namespaceURI);
        if (theNamespace == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableCollection(theNamespace.values()).iterator();
    }

    public synchronized Iterator getAttributeGroups(String namespaceURI) {
        HashMap theNamespace = (HashMap)this.attributeGroupsMap.get(namespaceURI);
        if (theNamespace == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableCollection(theNamespace.values()).iterator();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("namespaceMap [");
        HashSet alreadyPrinted = new HashSet();
        Iterator ns = this.namespaces.iterator();
        while (ns.hasNext()) {
            String namespace = (String)ns.next();
            ret.append("\n    ");
            ret.append("\n    ");
            ret.append("\n    ");
            ret.append(namespace);
            ret.append("\n        Types :\n");
            Iterator typeIterator = this.getTypes(namespace);
            while (typeIterator.hasNext()) {
                Type tp = (Type)typeIterator.next();
                ret.append(tp.toIndentedString(12, alreadyPrinted));
                ret.append("\n");
            }
            ret.append("\n");
            ret.append("\n        Elements :\n");
            Iterator memberIterator = this.getElements(namespace);
            while (memberIterator.hasNext()) {
                Member m = (Member)memberIterator.next();
                ret.append(m.toIndentedString(12, alreadyPrinted));
                ret.append("\n");
            }
            ret.append("\n");
            ret.append("\n        Groups :\n");
            Iterator groupIterator = this.getGroups(namespace);
            while (groupIterator.hasNext()) {
                Type tp = (Type)groupIterator.next();
                ret.append(tp.toIndentedString(12, alreadyPrinted));
                ret.append("\n");
            }
            ret.append("\n");
            ret.append("\n        Attributes :\n");
            Iterator attributeIterator = this.getAttributes(namespace);
            while (attributeIterator.hasNext()) {
                Attribute tp = (Attribute)attributeIterator.next();
                ret.append(tp.toIndentedString(12, alreadyPrinted));
                ret.append("\n");
            }
            ret.append("\n");
            ret.append("\n        AttributeGroups :\n");
            Iterator attributeGroupIterator = this.getAttributeGroups(namespace);
            while (attributeGroupIterator.hasNext()) {
                AttributeGroup tp = (AttributeGroup)attributeGroupIterator.next();
                ret.append(tp.toIndentedString(12, alreadyPrinted));
                ret.append("\n");
            }
            ret.append("\n");
        }
        ret.append("\n");
        ret.append("]");
        return ret.toString();
    }

    public boolean containsNamespace(String namespaceURI) {
        return this.namespaces.contains(namespaceURI);
    }

    public Element getSchemaAsElement(String namespaceURI) throws SchemaException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            return this.getSchemaAsElement(namespaceURI, doc);
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    private Element getSchemaAsElement(String namespaceURI, Document doc) throws SchemaException {
        HashSet importedNamespaces = new HashSet();
        return SchemaElementParser.write(namespaceURI, doc, importedNamespaces, this);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Map getAllSchemasAsElements() throws SchemaException {
        try {
            void e;
            HashMap<String, Element> ret = new HashMap<String, Element>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Iterator i = this.namespaces.iterator();
            while (i.hasNext()) {
                String nsURI = (String)i.next();
                Element schemaAsElement = this.getSchemaAsElement(nsURI, doc);
                if (schemaAsElement == null) continue;
                ret.put(nsURI, schemaAsElement);
            }
            return e;
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    public synchronized Type getSchemaType(String javaType) throws SchemaException {
        return (Type)this.javaTypeToSchemaType.get(javaType);
    }

    public synchronized void addJavaSchemaTypeMapping(String javaType, Type schemaType) {
        this.javaTypeToSchemaType.put(javaType, schemaType);
    }
}

