/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import com.idoox.util.ObjectPool;
import com.idoox.util.Pool;
import com.idoox.xml.XmlWriter;

public final class XmlWriterPool {
    private static Pool pool = new ObjectPool();

    private XmlWriterPool() {
    }

    public static XmlWriter getXmlWriter() {
        return (XmlWriter)pool.get();
    }

    public static void releaseXmlWriter(XmlWriter tokenizer) {
        tokenizer.clearInternals();
        pool.release(tokenizer);
    }

    static {
        pool.init(new XmlWriterFactory(), 10);
    }

    static class XmlWriterFactory
    implements Pool.Factory {
        XmlWriterFactory() {
        }

        public Object getNewInstance() {
            return new XmlWriter();
        }
    }
}

