/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Writer2Element
implements TokenWriter {
    private ArrayList rootElements = new ArrayList();
    private static final int STATE_NOT_FILLED = 0;
    private static final int STATE_WRITTEN_HEADER = 1;
    private ArrayList states = new ArrayList(19);
    private Document document;
    private int nextPrefix = 0;

    public Writer2Element(Document doc) {
        this.document = doc;
    }

    public Writer2Element(Element top, Document doc) {
        this.document = doc;
        State ret = new State(top.getNamespaceURI(), top.getLocalName());
        ret.el = top;
        ret.state = 1;
        this.states.add(ret);
    }

    private State getState(int offset) {
        int s = this.states.size();
        if ((s = s - offset - 1) >= 0) {
            return (State)this.states.get(s);
        }
        return null;
    }

    private State enterState(String namespaceURI, String localPart) throws IOException {
        this.flush();
        State ret = new State(namespaceURI, localPart);
        this.states.add(ret);
        return ret;
    }

    private State leaveState() throws IOException {
        this.flush();
        State ret = this.getState(0);
        this.states.remove(this.states.size() - 1);
        if (this.states.size() == 0) {
            this.rootElements.add(ret.el);
        }
        return ret;
    }

    private int lastState() {
        return this.states.size();
    }

    public final void flush() throws IOException {
        State s = this.getState(0);
        if (s != null && s.state == 0) {
            Map.Entry e;
            Iterator i;
            String prefix;
            State s1 = this.getState(1);
            if (s.namespace != null && !s.namespace.equals("")) {
                prefix = this.getPrefixForNamespace(s.namespace);
                s.el = "".equals(prefix) ? this.document.createElementNS(s.namespace, s.name) : this.document.createElementNS(s.namespace, prefix + ":" + s.name);
            } else {
                if (!"".equals(this.getDefaultNS())) {
                    this.getPrefixForNamespace(null);
                }
                s.el = this.document.createElementNS(null, s.name);
            }
            if (s1 != null) {
                s1.el.appendChild(s.el);
            } else {
                this.rootElements.add(s.el);
            }
            if (s.attributes != null) {
                i = s.attributes.entrySet().iterator();
                while (i.hasNext()) {
                    e = i.next();
                    QName name = (QName)e.getKey();
                    String value = (String)e.getValue();
                    if ("http://www.w3.org/2000/xmlns/".equals(name.getNamespaceURI())) {
                        this.setPrefixForNamespace(name.getLocalPart(), value);
                        continue;
                    }
                    if (name.getNamespaceURI() != null && !name.getNamespaceURI().equals("")) {
                        prefix = this.getPrefixForNamespace(name.getNamespaceURI());
                        if ("".equals(prefix)) {
                            prefix = this.searchPrefixNotDefault(name.getNamespaceURI());
                        }
                        if ("".equals(prefix)) {
                            s.el.setAttributeNS(name.getNamespaceURI(), name.getLocalPart(), value);
                            continue;
                        }
                        s.el.setAttributeNS(name.getNamespaceURI(), prefix + ":" + name.getLocalPart(), value);
                        continue;
                    }
                    s.el.setAttributeNS(name.getNamespaceURI(), name.getLocalPart(), value);
                }
            }
            if (s.prefixToNamespaceMap != null) {
                i = s.prefixToNamespaceMap.entrySet().iterator();
                while (i.hasNext()) {
                    e = i.next();
                    String curPrefix = (String)e.getKey();
                    String curNamespaceURI = (String)e.getValue();
                    if ("".equals(curPrefix)) {
                        s.el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", curNamespaceURI);
                        continue;
                    }
                    s.el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + curPrefix, curNamespaceURI);
                }
            }
            s.state = 1;
        }
    }

    public void enter(String namespace, String name) throws IOException, IllegalStateException {
        this.enterState(namespace, name);
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        State s = this.getState(0);
        if (s.attributes == null) {
            s.attributes = new HashMap(19);
        }
        s.attributes.put(new QName(namespace, name), value);
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void writeContent(String content) throws IOException, IllegalStateException {
        this.flush();
        State s = this.getState(0);
        s.el.appendChild(this.document.createTextNode(content));
    }

    public void leave() throws IOException, IllegalStateException {
        this.leaveState();
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        if (namespace == null || namespace.length() == 0) {
            if (!"".equals(this.getDefaultNS())) {
                this.setPrefixForNamespace("", "");
            }
            return "";
        }
        String prefix = this.getPrefixForNamespaceWithoutSideEffect(namespace);
        if (prefix == null) {
            State s = this.getState(0);
            Writer2Element.initPrefixMaps(s);
            prefix = this.generateUnusedPrefix(s.prefixToNamespaceMap.keySet());
            this.setPrefixForNamespace(prefix, namespace);
        }
        return prefix;
    }

    private String searchPrefixNotDefault(String namespace) {
        int i = 0;
        int limit = this.lastState();
        while (i < limit) {
            State s = this.getState(i);
            if (s.prefixToNamespaceMap != null) {
                Iterator it = s.prefixToNamespaceMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry ce = it.next();
                    String pref = (String)ce.getKey();
                    String ns = (String)ce.getValue();
                    if (!ns.equals(namespace) || pref.length() <= 0) continue;
                    return pref;
                }
            }
            ++i;
        }
        return "";
    }

    public String getPrefixForNamespaceWithoutSideEffect(String namespace) throws IOException {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        int i = 0;
        int limit = this.lastState();
        while (i < limit) {
            Object prefix;
            State s = this.getState(i);
            if (s.namespaceToPrefixMap != null && (prefix = s.namespaceToPrefixMap.get(namespace)) != null) {
                return (String)prefix;
            }
            ++i;
        }
        return null;
    }

    private String generateUnusedPrefix(Set usedPrefixes) {
        String prefix;
        do {
            prefix = "ns" + this.nextPrefix;
            ++this.nextPrefix;
        } while (usedPrefixes.contains(prefix));
        return prefix;
    }

    private String getDefaultNS() {
        int i = this.lastState() - 1;
        while (i >= 0) {
            State s = this.getState(i);
            if (s.defaultNS != null) {
                return s.defaultNS;
            }
            --i;
        }
        return "";
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        State s = this.getState(0);
        if (prefix == null) {
            prefix = "";
        }
        Writer2Element.initPrefixMaps(s);
        s.namespaceToPrefixMap.put(namespace, prefix);
        if (!this.isPrefix2NSDeclared(prefix, namespace)) {
            s.prefixToNamespaceMap.put(prefix, namespace);
        }
        if ("".equals(prefix)) {
            s.defaultNS = namespace;
        }
    }

    private boolean isPrefix2NSDeclared(String prefix, String namespace) {
        int i = this.lastState() - 1;
        while (i >= 0) {
            String valueForPrefix;
            State s = this.getState(i);
            Map pref2NS = s.prefixToNamespaceMap;
            if (pref2NS != null && (valueForPrefix = (String)pref2NS.get(prefix)) != null) {
                return valueForPrefix.equals(namespace);
            }
            --i;
        }
        return false;
    }

    private static void initPrefixMaps(State s) {
        if (s.namespaceToPrefixMap == null) {
            s.namespaceToPrefixMap = new HashMap(19);
            s.prefixToNamespaceMap = new HashMap(19);
        }
    }

    public List getRootElements() {
        return this.rootElements;
    }

    private static class State {
        int state;
        String namespace;
        String name;
        Map namespaceToPrefixMap;
        Map prefixToNamespaceMap;
        Map attributes;
        Element el;
        String defaultNS;

        State(String namespaceURI, String localPart) {
            this.namespace = namespaceURI;
            this.name = localPart;
            this.state = 0;
        }
    }
}

