/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import java.io.IOException;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;

public class Tokenizer2Writer {
    public static void copy(Tokenizer source, TokenWriter dest) throws TokenizerException, IOException {
        Token token = new Token();
        byte state = source.currentState();
        if (state != 2 && state != 4) {
            throw new TokenizerException("Source must be in START_TOKEN or CONTENT state");
        }
        DeclaredPrefixesStack pStack = new DeclaredPrefixesStack();
        while (state != 1) {
            switch (state) {
                case 2: {
                    source.readToken(token);
                    dest.enter(token.uri, token.localName);
                    pStack.used = 0;
                    source.pushNewlyDeclaredPrefixes(pStack);
                    int i = 0;
                    while (i < pStack.used) {
                        if (pStack.prefixValues[i] != null) {
                            dest.setPrefixForNamespace(pStack.prefixes[i], pStack.prefixValues[i]);
                        }
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < token.getAttributeCount()) {
                        Attribute attr = token.attArr[i2];
                        if ("xmlns".equals(attr.prefix)) {
                            if (attr.value != null) {
                                dest.setPrefixForNamespace(attr.localName, attr.value);
                            }
                        } else if ("xmlns".equals(attr.qName)) {
                            if (attr.value != null) {
                                dest.setPrefixForNamespace("", attr.value);
                            }
                        } else {
                            dest.writeAttribute(attr.uri, attr.localName, attr.value);
                        }
                        ++i2;
                    }
                    break;
                }
                case 3: {
                    dest.leave();
                    break;
                }
                case 4: {
                    dest.writeContent(source.readContent());
                    break;
                }
            }
            state = source.next();
        }
    }
}

