/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import com.idoox.util.StreamReaderWriterPool;
import com.idoox.xml.XmlTokenizer;
import com.idoox.xml.XmlTokenizerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ReaderTokenizer
implements Tokenizer {
    public static final byte UNKNOWN = 0;
    public static final byte END_DOCUMENT = 1;
    public static final byte START_TOKEN = 2;
    public static final byte END_TOKEN = 3;
    public static final byte CONTENT = 4;
    private static final boolean CHECK_ATTRIB_UNIQ = true;
    private boolean emptyElement;
    private boolean seenRootElement;
    private String elContent;
    private XmlTokenizer tokenizer = new XmlTokenizer();
    private byte eventType;
    private byte token;
    private boolean supportNs = true;
    private HashMap prefix2Ns = new HashMap(29, 0.75f);
    private boolean onEnd = false;
    private int attrPosEnd;
    private int attrPosSize;
    private Attribute[] attrPos;
    int elStackDepth;
    private int elStackSize;
    private ElementContent[] elStack;
    private boolean restoreDeclaredNamespaces;
    static final int TABLE_SIZE = 256;
    static final int TABLE_MASK = 255;
    final char[][] charTable = new char[256][];
    final String[] translatedString = new String[256];

    public ReaderTokenizer() {
    }

    public ReaderTokenizer(Reader input) {
        this.setInput(input);
    }

    public ReaderTokenizer(InputStream input) {
        this.setInput(input);
    }

    public final void insertFakeTag(String uri, String prefix, String localName, String qName, String defaultNamespace, String[] prefixes, String[] prefixValues, int prefixesEnd) {
        this.ensureCapacity(0);
        ElementContent elementContent = this.elStack[this.elStackDepth++];
        elementContent.ensureCapacity(0);
        elementContent.defaultNs = defaultNamespace;
        elementContent.localName = localName;
        elementContent.prefix = prefix;
        elementContent.qName = qName;
        elementContent.uri = uri;
        elementContent.prefixesEnd = prefixesEnd;
        System.arraycopy(prefixes, 0, elementContent.prefixes, 0, prefixesEnd);
        System.arraycopy(prefixValues, 0, elementContent.prefixValues, 0, prefixesEnd);
        Arrays.fill(elementContent.prefixPrevNs, 0, prefixesEnd, null);
        this.restoreDeclaredNamespaces = false;
        int i = 0;
        while (i < prefixesEnd) {
            this.prefix2Ns.put(prefixes[i], prefixValues[i]);
            ++i;
        }
        this.eventType = (byte)2;
    }

    public final String getLocalName() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.localName;
    }

    public final String getQName() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.qName;
    }

    private final ElementContent getElementContent() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        return this.elStack[this.elStackDepth - offset];
    }

    private final ElementContent getElementContent(int backtrack) throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        if (offset + backtrack > this.elStackDepth) {
            return null;
        }
        return this.elStack[this.elStackDepth - offset - backtrack];
    }

    public final String getNamespace() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.uri;
    }

    public final String getPrefix() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.prefix;
    }

    public final int getPrefixesEnd() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.prefixesEnd;
    }

    public final String[] getPrefixes() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.prefixes;
    }

    public final String[] getPrefixValues() throws TokenizerException {
        int offset;
        if (this.eventType == 2) {
            offset = 1;
        } else if (this.eventType == 3) {
            offset = 0;
        } else {
            throw new TokenizerException("Not available - not in token");
        }
        ElementContent el = this.elStack[this.elStackDepth - offset];
        return el.prefixValues;
    }

    public final String getNamespaceForPrefix(String prefix) {
        int offset = this.eventType == 3 ? 0 : 1;
        if (prefix == null) {
            return this.elStack[this.elStackDepth - offset].defaultNs;
        }
        String ret = (String)this.prefix2Ns.get(prefix);
        if (ret == null && "xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return ret;
    }

    public final QName parseQName(String qName) {
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int p = qName.indexOf(58);
        String prefix = null;
        String localName = qName.substring(p + 1);
        if (p > 0) {
            prefix = qName.substring(0, p);
        }
        return new QName(this.getNamespaceForPrefix(prefix), localName);
    }

    public final Map getCurrentPrefixMap() {
        Map ret = (Map)this.prefix2Ns.clone();
        if (this.elStack[this.elStackDepth - 1].defaultNs != null) {
            ret.put("", this.elStack[this.elStackDepth - 1].defaultNs);
        }
        return ret;
    }

    public final byte next() throws TokenizerException, IOException {
        Attribute ap = null;
        ElementContent el = null;
        if (this.restoreDeclaredNamespaces) {
            this.restoreDeclaredNamespaces = false;
            el = this.elStack[this.elStackDepth];
            if (this.supportNs && el.prefixes != null) {
                int i = el.prefixesEnd - 1;
                while (i >= 0) {
                    if (el.prefixPrevNs[i] != null) {
                        this.prefix2Ns.put(el.prefixes[i], el.prefixPrevNs[i]);
                    } else {
                        this.prefix2Ns.remove(el.prefixes[i]);
                    }
                    --i;
                }
                el.prefixesEnd = 0;
            }
        }
        if (this.emptyElement) {
            --this.elStackDepth;
            if (this.elStackDepth == 0) {
                this.seenRootElement = true;
            }
            this.emptyElement = false;
            this.restoreDeclaredNamespaces = true;
            this.eventType = 3;
            return 3;
        }
        try {
            block13: do {
                if (this.onEnd) {
                    this.token = (byte)2;
                    this.onEnd = false;
                } else {
                    this.token = this.tokenizer.next();
                }
                switch (this.token) {
                    case 2: {
                        if (this.emptyElement && this.elStackDepth == 1) {
                            this.stagEnd(el);
                            this.onEnd = true;
                            this.eventType = 2;
                            return 2;
                        }
                        if (this.elStackDepth > 0) {
                            throw new TokenizerException("expected element end tag '" + this.elStack[this.elStackDepth - 1].qName + "' not end of document" + this.tokenizer.getPosDesc());
                        }
                        this.eventType = 1;
                        return 1;
                    }
                    case 10: {
                        if (this.elStackDepth > 0) {
                            boolean empty = false;
                            if (this.tokenizer.parsedContent) {
                                if (this.tokenizer.pcEnd - this.tokenizer.pcStart == 0) {
                                    empty = true;
                                }
                            } else if (this.tokenizer.posEnd - this.tokenizer.posStart == 0) {
                                empty = true;
                            }
                            if (empty) continue block13;
                            this.elContent = null;
                            this.eventType = 4;
                            return 4;
                        }
                        if (!this.tokenizer.seenContent) continue block13;
                        this.eventType = (byte)4;
                        throw new TokenizerException("only whitespace content allowed outside root element, found >>" + this.readContent() + "<< on pos " + this.tokenizer.getPosDesc());
                    }
                    case 110: {
                        if (this.seenRootElement) {
                            throw new TokenizerException("no markup allowed outside root element" + this.tokenizer.getPosDesc());
                        }
                        String s = this.getString(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        --this.elStackDepth;
                        if (this.elStackDepth == 0) {
                            this.seenRootElement = true;
                        }
                        if (this.elStackDepth < 0) {
                            throw new TokenizerException("end tag without start stag" + this.tokenizer.getPosDesc());
                        }
                        if (!s.equals(this.elStack[this.elStackDepth].qName)) {
                            throw new TokenizerException("end tag name should be " + this.elStack[this.elStackDepth].qName + " not " + s + this.tokenizer.getPosDesc());
                        }
                        this.restoreDeclaredNamespaces = true;
                        this.eventType = 3;
                        return 3;
                    }
                    case 120: {
                        if (this.seenRootElement) {
                            throw new TokenizerException("no markup allowed outside root element" + this.tokenizer.getPosDesc());
                        }
                        this.emptyElement = false;
                        if (this.elStackDepth >= this.elStackSize) {
                            this.ensureCapacity(this.elStackDepth);
                        }
                        el = this.elStack[this.elStackDepth];
                        el.prefixesEnd = 0;
                        this.attrPosEnd = 0;
                        el.defaultNs = null;
                        el.qName = this.getString(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                            if (this.tokenizer.nsColonCount > 1) {
                                throw new TokenizerException("only one colon allowed in prefixed element name" + this.tokenizer.getPosDesc());
                            }
                            el.prefix = el.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                            el.localName = el.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                        } else {
                            el.prefix = null;
                            el.localName = el.qName;
                        }
                        el.uri = null;
                        ++this.elStackDepth;
                        break;
                    }
                    case 122: {
                        if (this.attrPosEnd >= this.attrPosSize) {
                            this.ensureAttribs(this.attrPosEnd + 1);
                        }
                        ap = this.attrPos[this.attrPosEnd];
                        ap.qName = this.getString(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        ap.uri = null;
                        if (!this.supportNs) continue block13;
                        if (this.tokenizer.posNsColon >= 0) {
                            if (this.tokenizer.nsColonCount > 1) {
                                throw new TokenizerException("only one colon allowed in prefixed attribute name" + this.tokenizer.getPosDesc());
                            }
                            ap.prefix = ap.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                            ap.localName = ap.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                            break;
                        }
                        ap.prefix = null;
                        ap.localName = ap.qName;
                        break;
                    }
                    case 127: {
                        int i;
                        ap.value = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : this.getString(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        if (this.supportNs) {
                            if ("xmlns".equals(ap.prefix)) {
                                if (el.prefixesEnd >= el.prefixesSize) {
                                    el.ensureCapacity(el.prefixesEnd);
                                }
                                el.prefixes[el.prefixesEnd] = ap.localName;
                                el.prefixValues[el.prefixesEnd] = ap.value;
                                el.prefixPrevNs[el.prefixesEnd] = (String)this.prefix2Ns.get(ap.localName);
                                if (el.prefixPrevNs[el.prefixesEnd] == null && "xml".equals(ap.localName)) {
                                    el.prefixPrevNs[el.prefixesEnd] = "http://www.w3.org/XML/1998/namespace";
                                }
                                i = 0;
                                while (i < el.prefixesEnd) {
                                    if (ap.localName.equals(el.prefixes[i])) {
                                        throw new TokenizerException("duplicate xmlns declaration name '" + ap.localName + "'" + this.tokenizer.getPosDesc());
                                    }
                                    ++i;
                                }
                                ++el.prefixesEnd;
                                this.prefix2Ns.put(ap.localName, ap.value);
                                break;
                            }
                            if ("xmlns".equals(ap.qName)) {
                                if (el.defaultNs != null) {
                                    throw new TokenizerException("default namespace was alredy declared by xmlns attribute" + this.tokenizer.getPosDesc());
                                }
                                el.defaultNs = ap.value;
                                break;
                            }
                            ++this.attrPosEnd;
                            break;
                        }
                        i = 0;
                        while (i < this.attrPosEnd) {
                            if (ap.qName.equals(this.attrPos[i].qName)) {
                                throw new TokenizerException("duplicate attribute name '" + ap.qName + "'" + this.tokenizer.getPosDesc());
                            }
                            ++i;
                        }
                        ++this.attrPosEnd;
                        break;
                    }
                    case 111: {
                        this.emptyElement = true;
                        break;
                    }
                    case 112: {
                        this.stagEnd(el);
                        this.eventType = 2;
                        return 2;
                    }
                    default: {
                        throw new TokenizerException("unknown token " + this.token);
                    }
                }
            } while (this.token != 112);
        }
        catch (XmlTokenizerException ex) {
            throw new TokenizerException("tokenizer exception", ex);
        }
        throw new TokenizerException("invalid state of tokenizer token=" + this.token);
    }

    private final void stagEnd(ElementContent el) throws TokenizerException {
        if (this.supportNs) {
            Attribute ap;
            if (el.defaultNs == null) {
                el.defaultNs = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : null;
            }
            if (el.uri == null) {
                el.uri = el.defaultNs;
            }
            if (el.prefix != null) {
                el.uri = (String)this.prefix2Ns.get(el.prefix);
                if (el.uri == null && "xml".equals(el.prefix)) {
                    el.uri = "http://www.w3.org/XML/1998/namespace";
                }
                if (el.uri == null) {
                    throw new TokenizerException("no namespace for prefix '" + el.prefix + "'" + this.tokenizer.getPosDesc());
                }
            } else {
                el.uri = el.defaultNs;
                el.localName = el.qName;
            }
            int j = 0;
            while (j < this.attrPosEnd) {
                ap = this.attrPos[j];
                if (ap.uri == null && ap.prefix != null) {
                    ap.uri = (String)this.prefix2Ns.get(ap.prefix);
                    if (ap.uri == null && "xml".equals(ap.prefix)) {
                        ap.uri = "http://www.w3.org/XML/1998/namespace";
                    }
                    if (ap.uri == null) {
                        throw new TokenizerException("no namespace for prefix " + ap.prefix + this.tokenizer.getPosDesc());
                    }
                }
                ++j;
            }
            int j2 = 1;
            while (j2 < this.attrPosEnd) {
                ap = this.attrPos[j2];
                int i = 0;
                while (i < j2) {
                    if (ap.localName.equals(this.attrPos[i].localName) && (ap.uri != null && ap.uri.equals(this.attrPos[i].uri) || ap.uri == null && this.attrPos[i].uri == null)) {
                        throw new TokenizerException("duplicate attribute name '" + ap.qName + "'" + (ap.uri != null ? " (with namespace '" + ap.uri + "')" : "") + " and " + (ap.uri != null ? " (with namespace '" + ap.uri + "')" : "") + this.tokenizer.getPosDesc());
                    }
                    ++i;
                }
                ++j2;
            }
        } else {
            el.prefix = null;
            el.localName = el.qName;
            el.uri = null;
        }
    }

    public final String readContent() throws TokenizerException {
        if (this.eventType != 4) {
            throw new TokenizerException("no content available to read");
        }
        if (this.elContent == null) {
            this.elContent = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
        }
        return this.elContent;
    }

    public final void readToken(Token token) throws TokenizerException, IOException {
        token.attEnd = 0;
        if (this.eventType == 2) {
            ElementContent el = this.elStack[this.elStackDepth - 1];
            token.type = (byte)2;
            token.uri = el.uri;
            token.localName = el.localName;
            token.prefix = el.prefix;
            token.ensureCapacity(this.attrPosEnd);
            token.attEnd = this.attrPosEnd;
            int i = 0;
            while (i < this.attrPosEnd) {
                Attribute ap = this.attrPos[i];
                Attribute att = token.attArr[i];
                att.prefix = ap.prefix;
                att.qName = ap.qName;
                att.localName = ap.localName;
                att.value = ap.value;
                att.uri = ap.uri;
                ++i;
            }
        } else if (this.eventType == 3) {
            token.uri = this.elStack[this.elStackDepth].uri;
            token.localName = this.elStack[this.elStackDepth].localName;
            token.type = (byte)3;
        } else {
            throw new TokenizerException("no token to be read");
        }
    }

    public void setInput(Reader reader) {
        this.tokenizer.reset();
        this.eventType = (byte)-1;
        this.token = (byte)-1;
        this.elStackDepth = 0;
        this.prefix2Ns.clear();
        this.emptyElement = false;
        this.seenRootElement = false;
        this.onEnd = false;
        this.tokenizer.setMixedContent(true);
        this.tokenizer.setInput(reader);
    }

    public void setInput(InputStream input) {
        try {
            if (this.tokenizer != null) {
                StreamReaderWriterPool.releaseInputStreamUTFReader(this.tokenizer.getReader());
            }
            this.setInput(StreamReaderWriterPool.getInputStreamUTFReader(input));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM internal error: UTF-8 not supported");
        }
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        if (this.eventType != 2) {
            throw new IllegalStateException("Method pushNewlyDeclaredPrefixes can be call only when Tokenizer is in START_TOKEN state.");
        }
        ElementContent el = this.elStack[this.elStackDepth - 1];
        if (el.prefixes == null || el.prefixesEnd == 0) {
            if (el.defaultNs != null) {
                boolean takeIt = false;
                if (this.elStackDepth > 1) {
                    ElementContent el1 = this.elStack[this.elStackDepth - 2];
                    if (el.defaultNs != el1.defaultNs) {
                        takeIt = true;
                    }
                } else {
                    takeIt = true;
                }
                if (takeIt) {
                    prefixes.enlarge(1);
                    prefixes.prefixes[prefixes.used] = null;
                    prefixes.prefixValues[prefixes.used] = el.defaultNs;
                    prefixes.previousPrefixValues[prefixes.used] = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : null;
                    ++prefixes.used;
                    return 1;
                }
            }
            return 0;
        }
        int off = 0;
        if (el.defaultNs != null) {
            if (this.elStackDepth > 1) {
                ElementContent el1 = this.elStack[this.elStackDepth - 2];
                if (el.defaultNs != el1.defaultNs) {
                    off = 1;
                }
            } else {
                off = 1;
            }
        }
        prefixes.enlarge(el.prefixesEnd + off);
        System.arraycopy(el.prefixes, 0, prefixes.prefixes, prefixes.used, el.prefixesEnd);
        System.arraycopy(el.prefixValues, 0, prefixes.prefixValues, prefixes.used, el.prefixesEnd);
        System.arraycopy(el.prefixPrevNs, 0, prefixes.previousPrefixValues, prefixes.used, el.prefixesEnd);
        prefixes.used += el.prefixesEnd;
        if (off > 0) {
            prefixes.prefixes[prefixes.used] = null;
            prefixes.prefixValues[prefixes.used] = el.defaultNs;
            prefixes.previousPrefixValues[prefixes.used] = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : null;
            ++prefixes.used;
        }
        return el.prefixesEnd + off;
    }

    public boolean whitespaceContent() throws TokenizerException {
        if (this.eventType != 4) {
            throw new TokenizerException("no content available to read");
        }
        return !this.tokenizer.seenContent;
    }

    public byte currentState() {
        return this.eventType;
    }

    /*
     * Unable to fully structure code
     */
    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        try {
            ret = null;
            depth = 0;
            nodeStack = new Stack<Node>();
            tok = this.currentState();
            block7: while (true) {
                switch (tok) {
                    case 2: {
                        elContent = this.getElementContent();
                        el = doc.createElementNS(elContent.uri, elContent.qName);
                        if (depth == 0) {
                            ret = el;
                            if (elContent.defaultNs != null) {
                                el.setAttribute("xmlns", elContent.defaultNs);
                            }
                            i = this.prefix2Ns.entrySet().iterator();
                            while (i.hasNext()) {
                                e = i.next();
                                if (e.getValue() == null) continue;
                                prefix = (String)e.getKey();
                                ns = (String)e.getValue();
                                if ("xml".equals(prefix)) continue;
                                el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
                            }
                        } else if (!(elContent.defaultNs == null || (parentElement = this.getElementContent(1)) != null && elContent.defaultNs.equals(parentElement.defaultNs))) {
                            el.setAttribute("xmlns", elContent.defaultNs);
                        }
                        i = 0;
                        while (i < elContent.prefixesEnd) {
                            prefix = elContent.prefixes[i];
                            if (!"xml".equals(prefix)) {
                                if (prefix != null && prefix.length() > 0) {
                                    el.setAttribute("xmlns:" + prefix, elContent.prefixValues[i]);
                                } else {
                                    el.setAttribute("xmlns", elContent.prefixValues[i]);
                                }
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.attrPosEnd) {
                            ap = this.attrPos[i];
                            el.setAttributeNS(ap.uri, ap.qName, ap.value);
                            ++i;
                        }
                        nodeStack.push(el);
                        ++depth;
                        ** GOTO lbl61
                    }
                    case 3: {
                        el = (Element)nodeStack.pop();
                        if (--depth <= 0) break block7;
                        ((Element)nodeStack.peek()).appendChild(el);
                        ** GOTO lbl61
                    }
                    case 4: {
                        text = doc.createTextNode(this.readContent());
                        if (nodeStack.empty()) {
                            nodeStack.push(text);
                        } else {
                            ((Element)nodeStack.peek()).appendChild(text);
                        }
                    }
lbl61:
                    // 5 sources

                    default: {
                        tok = this.next();
                        if (depth > 0) continue block7;
                    }
                }
                break;
            }
            return e;
        }
        catch (IOException e) {
            throw new TokenizerException(e);
        }
    }

    private void ensureCapacity(int size) {
        int newSize = 2 * size;
        if (newSize == 0) {
            newSize = 25;
        }
        if (this.elStackSize < newSize) {
            ElementContent[] newStack = new ElementContent[newSize];
            if (this.elStack != null) {
                System.arraycopy(this.elStack, 0, newStack, 0, this.elStackSize);
            }
            int i = this.elStackSize;
            while (i < newSize) {
                newStack[i] = new ElementContent();
                ++i;
            }
            this.elStack = newStack;
            this.elStackSize = newSize;
        }
    }

    private void ensureAttribs(int size) {
        int newSize = 2 * size;
        if (newSize == 0) {
            newSize = 25;
        }
        if (this.attrPosEnd < newSize) {
            Attribute[] newAttrPos = new Attribute[newSize];
            if (this.attrPos != null) {
                System.arraycopy(this.attrPos, 0, newAttrPos, 0, this.attrPosSize);
            }
            int i = this.attrPosSize;
            while (i < newSize) {
                newAttrPos[i] = new Attribute();
                ++i;
            }
            this.attrPos = newAttrPos;
            this.attrPosSize = newSize;
        }
    }

    static final int shash(char[] chr, int off, int l) {
        int hv = chr[off] << 1;
        if (l > 1) {
            hv ^= chr[off + l - 1];
            if (l > 3) {
                hv ^= chr[off + (l >> 1)] << 2;
                hv ^= chr[off + l - 2];
            }
        }
        return hv ^= l;
    }

    private final String getString(char[] chr, int off, int l) {
        int hv = ReaderTokenizer.shash(chr, off, l);
        char[] p = this.charTable[hv &= 0xFF];
        if (p == null) {
            p = new char[l];
            this.charTable[hv] = p;
            System.arraycopy(chr, off, p, 0, l);
            this.translatedString[hv] = new String(chr, off, l);
            return this.translatedString[hv];
        }
        if (l != p.length) {
            p = new char[l];
            this.charTable[hv] = p;
            System.arraycopy(chr, off, p, 0, l);
            this.translatedString[hv] = new String(chr, off, l);
            return this.translatedString[hv];
        }
        int chrp = off + l - 1;
        int i = l - 1;
        while (i >= 0) {
            if (p[i] != chr[chrp]) {
                p = new char[l];
                this.charTable[hv] = p;
                System.arraycopy(chr, off, p, 0, l);
                this.translatedString[hv] = new String(chr, off, l);
                return this.translatedString[hv];
            }
            --i;
            --chrp;
        }
        return this.translatedString[hv];
    }

    private class ElementContent {
        String qName;
        String uri;
        String localName;
        String prefix;
        String defaultNs;
        int prefixesEnd;
        int prefixesSize;
        String[] prefixes;
        String[] prefixValues;
        String[] prefixPrevNs;

        private ElementContent() {
        }

        private void ensureCapacity(int size) {
            int newSize = 2 * size;
            if (newSize == 0) {
                newSize = 25;
            }
            if (this.prefixesSize < newSize) {
                String[] newPrefixes = new String[newSize];
                String[] newPrefixValues = new String[newSize];
                String[] newPrefixPrevNs = new String[newSize];
                if (this.prefixes != null) {
                    System.arraycopy(this.prefixes, 0, newPrefixes, 0, this.prefixesEnd);
                    System.arraycopy(this.prefixValues, 0, newPrefixValues, 0, this.prefixesEnd);
                    System.arraycopy(this.prefixPrevNs, 0, newPrefixPrevNs, 0, this.prefixesEnd);
                }
                this.prefixes = newPrefixes;
                this.prefixValues = newPrefixValues;
                this.prefixPrevNs = newPrefixPrevNs;
                this.prefixesSize = newSize;
            }
        }
    }
}

