/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import com.idoox.debug.Category;
import com.idoox.xml.DocumentBuilderFactory;
import com.idoox.xml.ErrorHandlerImpl;
import com.idoox.xml.LocationAwareXMLFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LocationAwareDocumentBuilder
extends DocumentBuilder {
    private static final Category log = Category.getCategory("com.idoox.xml.LocationAwareDocumentBuilder");
    private boolean isNamespaceAware = false;
    private boolean isValidating = false;
    private boolean locationAware = false;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private DocumentBuilder builder;
    private XMLReader xmlReader;
    private Transformer transformer;
    private Map locations;
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public LocationAwareDocumentBuilder(DocumentBuilderFactory factory, HashMap attributes) throws SAXException, ParserConfigurationException, TransformerConfigurationException {
        this.isValidating = factory.isValidating();
        this.isNamespaceAware = factory.isNamespaceAware();
        this.locationAware = factory.isLocationAware();
        if (this.locationAware) {
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setNamespaceAware(factory.isNamespaceAware());
                saxFactory.setFeature(NAMESPACE_PREFIXES, true);
                saxFactory.setValidating(factory.isValidating());
                SAXParser saxParser = saxFactory.newSAXParser();
                if (attributes != null) {
                    Iterator iterator = attributes.keySet().iterator();
                    while (iterator.hasNext()) {
                        String property = (String)iterator.next();
                        saxParser.setProperty(property, attributes.get(property));
                    }
                }
                if (this.isValidating) {
                    saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    this.setErrorHandler(new ErrorHandlerImpl());
                }
                this.xmlReader = saxParser.getXMLReader();
                this.transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (Throwable e) {
                this.locationAware = false;
            }
        }
        javax.xml.parsers.DocumentBuilderFactory builderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(factory.isNamespaceAware());
        if (attributes != null) {
            Iterator iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String property = (String)iterator.next();
                builderFactory.setAttribute(property, attributes.get(property));
            }
        }
        if (this.isValidating) {
            builderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            builderFactory.setValidating(factory.isValidating());
            this.setErrorHandler(new ErrorHandlerImpl());
        }
        this.builder = builderFactory.newDocumentBuilder();
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        return this.parse(is, null);
    }

    public Document parse(InputSource is, Map locations) throws SAXException, IOException {
        if (this.locationAware) {
            if (is == null) {
                throw new IllegalArgumentException("InputSource cannot be null");
            }
            LocationAwareXMLFilter xmlFilter = new LocationAwareXMLFilter(this.xmlReader, locations);
            if (this.entityResolver != null) {
                xmlFilter.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                xmlFilter.setErrorHandler(this.errorHandler);
            }
            SAXSource source = new SAXSource(xmlFilter, is);
            Document document = this.builder.newDocument();
            DOMResult result = new DOMResult(document);
            try {
                this.transformer.transform(source, result);
            }
            catch (TransformerException e) {
                Throwable th = e.getException();
                if (th != null && th instanceof SAXParseException) {
                    throw (SAXParseException)th;
                }
                throw new SAXParseException(e.getMessage(), null);
            }
            return document;
        }
        if (this.entityResolver != null) {
            this.builder.setEntityResolver(this.entityResolver);
        }
        if (this.errorHandler != null) {
            this.builder.setErrorHandler(this.errorHandler);
        }
        return this.builder.parse(is);
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public boolean isLocationAware() {
        return this.locationAware;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler == null ? new DefaultHandler() : errorHandler;
    }

    public Document newDocument() {
        return this.builder.newDocument();
    }

    public DOMImplementation getDOMImplementation() {
        return this.builder.getDOMImplementation();
    }
}

