/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import java.io.IOException;
import org.idoox.xml.TokenWriter;

public class EscapingUTF8TokenWriter
implements TokenWriter {
    private TokenWriter writer;

    public EscapingUTF8TokenWriter(TokenWriter writer) {
        if (writer == null) {
            throw new RuntimeException("No TokenWriter is available.");
        }
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void enter(String namespace, String name) throws IOException, IllegalStateException {
        this.writer.enter(namespace, name);
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        this.writer.writeAttribute(namespace, name, this.escape(value));
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        this.writer.writeXmlAttribute(name, value);
    }

    public void writeContent(String content) throws IOException, IllegalStateException {
        this.writer.writeContent(this.escape(content));
    }

    public void leave() throws IOException, IllegalStateException {
        this.writer.leave();
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        return this.writer.getPrefixForNamespace(namespace);
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        this.writer.setPrefixForNamespace(prefix, namespace);
    }

    private String escape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replace('\u0000', ' ');
        StringBuffer sb = new StringBuffer(s.length());
        int position = 0;
        int index = s.indexOf("&#0;", position);
        while (index >= 0) {
            sb.append(s.substring(position, index));
            position = index + 4;
            index = s.indexOf("&#0;", position);
        }
        sb.append(s.substring(position));
        return sb.toString();
    }
}

