/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Element2Tokenizer
implements Tokenizer {
    private static final int NSR_INITIAL_SIZE = 8;
    private static final int NSR_INCREMENT = 8;
    private static final int STACK_INITIAL_SIZE = 8;
    private static final int STACK_INCREMENT = 4;
    private Element currentElement;
    private String localName;
    private String prefix;
    private String uri;
    private int currentNode = -1;
    private int[] nodeStack;
    private int[] nsPosStackLocal;
    private int[] nsPosStackOverridden;
    private int depth;
    private byte state;
    private Map prefixMap = new HashMap(11, 0.75f);
    private String[] localNamespacesPrefix;
    private String[] localNamespacesURI;
    private int localNamespacesPos;
    private String[] overwrittenNamespacesPrefix;
    private String[] overwrittenNamespacesURI;
    private int overwrittenNamespacesPos;
    private boolean reportedEndOfDocument;

    public Element2Tokenizer(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.currentElement = element;
        this.currentElement.normalize();
        this.state = (byte)2;
        this.localNamespacesPrefix = new String[8];
        this.localNamespacesURI = new String[8];
        this.overwrittenNamespacesPrefix = new String[8];
        this.overwrittenNamespacesURI = new String[8];
        this.nodeStack = new int[8];
        this.nsPosStackLocal = new int[8];
        this.nsPosStackOverridden = new int[8];
        Node e = this.currentElement;
        while (e != null && e.getNodeType() != 9) {
            NamedNodeMap attrs = e.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node att = attrs.item(i);
                String name = att.getNodeName();
                if (name.startsWith("xmlns:")) {
                    String prefix = name.substring(name.indexOf(":") + 1);
                    String uri = att.getNodeValue();
                    if (!this.prefixMap.containsKey(prefix)) {
                        this.prefixMap.put(prefix, uri);
                        this.checkLocalNamespacesArraySize();
                        this.localNamespacesPrefix[this.localNamespacesPos] = prefix;
                        this.localNamespacesURI[this.localNamespacesPos] = uri;
                        ++this.localNamespacesPos;
                    }
                } else if ("xmlns".equals(name) && !this.prefixMap.containsKey("")) {
                    String uri = att.getNodeValue();
                    this.prefixMap.put("", uri);
                    this.checkLocalNamespacesArraySize();
                    this.localNamespacesPrefix[this.localNamespacesPos] = "";
                    this.localNamespacesURI[this.localNamespacesPos] = uri;
                    ++this.localNamespacesPos;
                }
                ++i;
            }
            e = e.getParentNode();
        }
        this.setElementName(this.currentElement.getNodeName());
    }

    private void checkLocalNamespacesArraySize() {
        if (this.localNamespacesPos >= this.localNamespacesPrefix.length) {
            this.localNamespacesPrefix = this.resizeStringArray(this.localNamespacesPrefix, this.localNamespacesPrefix.length + 8);
            this.localNamespacesURI = this.resizeStringArray(this.localNamespacesURI, this.localNamespacesURI.length + 8);
        }
    }

    private void checkOverwrittenNamespacesArraySize() {
        if (this.overwrittenNamespacesPos >= this.overwrittenNamespacesPrefix.length) {
            this.overwrittenNamespacesPrefix = this.resizeStringArray(this.overwrittenNamespacesPrefix, this.overwrittenNamespacesPrefix.length + 8);
            this.overwrittenNamespacesURI = this.resizeStringArray(this.overwrittenNamespacesURI, this.overwrittenNamespacesURI.length + 8);
        }
    }

    public String getLocalName() throws TokenizerException {
        if (this.state != 2 && this.state != 3) {
            throw new TokenizerException("No current element");
        }
        return this.localName;
    }

    public String getNamespace() throws TokenizerException {
        if (this.state != 2 && this.state != 3) {
            throw new TokenizerException("No current element");
        }
        return this.uri;
    }

    public String getNamespaceForPrefix(String prefix) {
        String ret;
        if (prefix == null) {
            prefix = "";
        }
        if ((ret = (String)this.prefixMap.get(prefix)) == null && "xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return ret;
    }

    public QName parseQName(String qName) {
        QName retval;
        if (qName == null || "".equals(qName)) {
            return null;
        }
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int pos = qName.indexOf(":");
        if (pos != -1) {
            String prefix = qName.substring(0, pos);
            String localName = qName.substring(pos + 1, qName.length());
            String uri = (String)this.prefixMap.get(prefix);
            if (uri == null) {
                throw new RuntimeException("Unknown prefix " + prefix);
            }
            retval = new QName(uri, localName);
        } else {
            String uri = (String)this.prefixMap.get("");
            retval = new QName(uri, qName);
        }
        return retval;
    }

    public byte next() throws TokenizerException, IOException {
        if (this.reportedEndOfDocument) {
            throw new TokenizerException("Already at the end of document");
        }
        if (this.depth == -1) {
            this.state = 1;
            this.reportedEndOfDocument = true;
            return this.state;
        }
        ++this.currentNode;
        if (this.currentNode == this.currentElement.getChildNodes().getLength()) {
            this.state = (byte)3;
            this.setElementName(this.currentElement.getNodeName());
            --this.depth;
            if (this.depth == -1) {
                return this.state;
            }
            this.currentElement = (Element)this.currentElement.getParentNode();
            this.currentNode = this.nodeStack[this.depth];
            int i = this.nsPosStackLocal[this.depth];
            while (i < this.localNamespacesPos) {
                this.prefixMap.remove(this.localNamespacesPrefix[i]);
                ++i;
            }
            this.localNamespacesPos = this.nsPosStackLocal[this.depth];
            int i2 = this.nsPosStackOverridden[this.depth];
            while (i2 < this.overwrittenNamespacesPos) {
                this.prefixMap.put(this.overwrittenNamespacesPrefix[i2], this.overwrittenNamespacesURI[i2]);
                ++i2;
            }
            this.overwrittenNamespacesPos = this.nsPosStackOverridden[this.depth];
        } else {
            Node n = this.currentElement.getChildNodes().item(this.currentNode);
            switch (n.getNodeType()) {
                case 1: {
                    this.state = (byte)2;
                    Element e = (Element)n;
                    int newSize = this.depth + 4;
                    if (this.depth >= this.nodeStack.length) {
                        this.nodeStack = this.resizeIntArray(this.nodeStack, newSize);
                    }
                    if (this.depth >= this.nsPosStackLocal.length) {
                        this.nsPosStackLocal = this.resizeIntArray(this.nsPosStackLocal, newSize);
                        this.nsPosStackOverridden = this.resizeIntArray(this.nsPosStackOverridden, newSize);
                    }
                    this.nodeStack[this.depth] = this.currentNode;
                    this.nsPosStackLocal[this.depth] = this.localNamespacesPos;
                    this.nsPosStackOverridden[this.depth] = this.overwrittenNamespacesPos;
                    this.currentNode = -1;
                    this.currentElement = e;
                    NamedNodeMap attrs = e.getAttributes();
                    int i = 0;
                    while (i < attrs.getLength()) {
                        Node att = attrs.item(i);
                        String name = att.getNodeName();
                        if (name.startsWith("xmlns:")) {
                            String prefix = name.substring(name.indexOf(":") + 1);
                            String uri = att.getNodeValue();
                            if (this.prefixMap.containsKey(prefix)) {
                                this.checkOverwrittenNamespacesArraySize();
                                this.overwrittenNamespacesPrefix[this.overwrittenNamespacesPos] = prefix;
                                this.overwrittenNamespacesURI[this.overwrittenNamespacesPos] = (String)this.prefixMap.get(prefix);
                                ++this.overwrittenNamespacesPos;
                            }
                            this.prefixMap.put(prefix, uri);
                            this.checkLocalNamespacesArraySize();
                            this.localNamespacesPrefix[this.localNamespacesPos] = prefix;
                            this.localNamespacesURI[this.localNamespacesPos] = uri;
                            ++this.localNamespacesPos;
                        } else if ("xmlns".equals(name)) {
                            if (this.prefixMap.containsKey("")) {
                                this.checkOverwrittenNamespacesArraySize();
                                this.overwrittenNamespacesPrefix[this.overwrittenNamespacesPos] = "";
                                this.overwrittenNamespacesURI[this.overwrittenNamespacesPos] = (String)this.prefixMap.get("");
                                ++this.overwrittenNamespacesPos;
                            }
                            String uri = att.getNodeValue();
                            this.prefixMap.put("", uri);
                            this.checkLocalNamespacesArraySize();
                            this.localNamespacesPrefix[this.localNamespacesPos] = "";
                            this.localNamespacesURI[this.localNamespacesPos] = uri;
                            ++this.localNamespacesPos;
                        }
                        ++i;
                    }
                    this.setElementName(e.getNodeName());
                    ++this.depth;
                    break;
                }
                case 3: 
                case 4: {
                    this.state = (byte)4;
                    break;
                }
                default: {
                    this.next();
                }
            }
        }
        return this.state;
    }

    public byte currentState() {
        return this.state;
    }

    public String readContent() throws TokenizerException {
        if (this.state != 4) {
            throw new TokenizerException("No content available");
        }
        return this.currentElement.getChildNodes().item(this.currentNode).getNodeValue();
    }

    public void readToken(Token stoken) throws TokenizerException, IOException {
        if (this.state == 2) {
            stoken.localName = this.localName;
            stoken.uri = this.uri;
            stoken.prefix = this.prefix;
            stoken.type = (byte)2;
            NamedNodeMap attrs = this.currentElement.getAttributes();
            int count = attrs.getLength();
            stoken.ensureCapacity(count);
            int size = 0;
            int i = 0;
            while (i < count) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getName();
                if (!name.startsWith("xmlns:") && !"xmlns".equals(name)) {
                    String value = attr.getValue();
                    this.fillAttr(stoken.attArr[size], name, value);
                    ++size;
                }
                ++i;
            }
            stoken.attEnd = size;
        } else if (this.state == 3) {
            stoken.localName = this.localName;
            stoken.uri = this.uri;
            stoken.type = (byte)3;
        } else {
            throw new TokenizerException("No token available");
        }
    }

    private void fillAttr(Attribute dst, String name, String value) {
        dst.qName = name;
        dst.value = value;
        int collonPos = name.indexOf(":");
        if (collonPos != -1) {
            dst.localName = name.substring(collonPos + 1);
            String prefix = name.substring(0, collonPos);
            dst.uri = this.getNamespaceForPrefix(prefix);
            dst.prefix = prefix;
        } else {
            dst.uri = null;
            dst.localName = name;
            dst.prefix = null;
        }
    }

    public boolean whitespaceContent() throws TokenizerException {
        if (this.state != 4) {
            throw new TokenizerException("No content available");
        }
        char[] content = this.currentElement.getChildNodes().item(this.currentNode).getNodeValue().toCharArray();
        int i = 0;
        while (i < content.length) {
            if (!this.isS(content[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Map getCurrentPrefixMap() {
        return Collections.unmodifiableMap(this.prefixMap);
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        int localNamespacesStart = 0;
        int overwrittenStart = 0;
        int previousLocalNamespacesStart = 0;
        int index = 0;
        if (this.depth > 0) {
            localNamespacesStart = this.nsPosStackLocal[this.depth - 1];
            overwrittenStart = this.nsPosStackOverridden[this.depth - 1];
        }
        int localNamespacesSize = this.localNamespacesPos - localNamespacesStart;
        int overwrittenSize = this.overwrittenNamespacesPos - overwrittenStart;
        int previousLocalNamespacesSize = -1;
        if (this.depth > 1) {
            previousLocalNamespacesStart = this.nsPosStackLocal[this.depth - 2];
            previousLocalNamespacesSize = localNamespacesStart - previousLocalNamespacesStart;
        }
        if (this.depth == 1) {
            previousLocalNamespacesStart = 0;
            previousLocalNamespacesSize = localNamespacesStart - 0;
        }
        int used = prefixes.used;
        prefixes.enlarge(localNamespacesSize);
        int i = 0;
        while (i < localNamespacesSize) {
            boolean add = true;
            int k = 0;
            while (k < previousLocalNamespacesSize) {
                if (this.localNamespacesPrefix[localNamespacesStart + i].equals(this.localNamespacesPrefix[previousLocalNamespacesStart + k]) && this.localNamespacesURI[localNamespacesStart + i].equals(this.localNamespacesURI[previousLocalNamespacesStart + k])) {
                    add = false;
                    break;
                }
                ++k;
            }
            if (add) {
                prefixes.prefixes[index + used] = this.localNamespacesPrefix[localNamespacesStart + i];
                prefixes.prefixValues[index + used] = this.localNamespacesURI[localNamespacesStart + i];
                prefixes.previousPrefixValues[index + used] = null;
                int j = 0;
                while (j < overwrittenSize) {
                    if (this.overwrittenNamespacesPrefix[overwrittenStart + j].equals(prefixes.prefixes[index + used]) && !this.overwrittenNamespacesURI[overwrittenStart + j].equals(prefixes.prefixValues[index + used])) {
                        prefixes.previousPrefixValues[index + used] = this.overwrittenNamespacesURI[overwrittenStart + j];
                        break;
                    }
                    ++j;
                }
                ++index;
            }
            ++i;
        }
        prefixes.used += index;
        return index;
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        return TokenizerWrapper.getDOMRepresentation(this, doc);
    }

    private boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }

    private String[] resizeStringArray(String[] array, int newSize) {
        String[] newArr = new String[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private int[] resizeIntArray(int[] array, int newSize) {
        int[] newArr = new int[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private void setElementName(String name) {
        if (name == null || "".equals(name)) {
            return;
        }
        int collonPos = name.indexOf(":");
        if (collonPos != -1) {
            this.localName = name.substring(collonPos + 1);
            this.prefix = name.substring(0, collonPos);
            this.uri = (String)this.prefixMap.get(this.prefix);
        } else {
            this.localName = name;
            this.prefix = null;
            this.uri = (String)this.prefixMap.get("");
        }
    }
}

