/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wsdl.util;

import com.idoox.debug.Category;
import com.idoox.wsdl.util.XmlUtil;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class WSDLUtil {
    private static WSDLFactory wsdlFactory;
    private static final Category cat;
    private static final SOAPMethodInfo.PartInfo[] EMPTY_PARTINFOS;

    public static String writeWSDL(Definition definition) throws WSDLException {
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        StringWriter str = new StringWriter();
        wsdlWriter.writeWSDL(definition, str);
        return str.toString();
    }

    public static void writeWSDL(Definition definition, Writer wr) throws WSDLException {
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        wsdlWriter.writeWSDL(definition, wr);
    }

    public static Definition readWSDL(String context, String wsdlURL) throws WSDLException {
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        return wsdlReader.readWSDL(context, wsdlURL);
    }

    public static Definition readWSDL(Element element, String wsdlURL) throws WSDLException {
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        return wsdlReader.readWSDL(wsdlURL, element);
    }

    public static Definition newDefinition() {
        return wsdlFactory.newDefinition();
    }

    public static Map flatGetDefinitions(Definition def) {
        HashMap<String, Definition> flatMap = new HashMap<String, Definition>(7);
        Stack<Definition> defStack = new Stack<Definition>();
        defStack.push(def);
        while (!defStack.empty()) {
            Definition localDef = (Definition)defStack.pop();
            flatMap.put(localDef.getDocumentBaseURI(), localDef);
            Iterator importIter = localDef.getImports().values().iterator();
            while (importIter.hasNext()) {
                Iterator listIter = ((List)importIter.next()).iterator();
                while (listIter.hasNext()) {
                    Import localImport = (Import)listIter.next();
                    if (localImport.getDefinition() == null || flatMap.containsKey(localImport.getDefinition().getDocumentBaseURI())) continue;
                    defStack.push(localImport.getDefinition());
                }
            }
        }
        return flatMap;
    }

    public static Map flatGetBindings(Definition def) {
        HashMap flatMap = new HashMap(30);
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            flatMap.putAll(localDef.getBindings());
        }
        return flatMap;
    }

    public static Map flatGetImports(Definition def) {
        HashMap<String, Map> flatMap = new HashMap<String, Map>(30);
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            flatMap.put(localDef.getDocumentBaseURI(), localDef.getImports());
        }
        return flatMap;
    }

    public static Map flatGetMessages(Definition def) {
        HashMap flatMap = new HashMap(30);
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            flatMap.putAll(localDef.getMessages());
        }
        return flatMap;
    }

    public static Map flatGetPortTypes(Definition def) {
        HashMap flatMap = new HashMap(30);
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            flatMap.putAll(localDef.getPortTypes());
        }
        return flatMap;
    }

    public static Map flatGetServices(Definition def) {
        HashMap flatMap = new HashMap(30);
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            flatMap.putAll(localDef.getServices());
        }
        return flatMap;
    }

    public static Map flatGetTypes(Definition def) {
        HashMap<String, Types> flatMap = new HashMap<String, Types>(30);
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            flatMap.put(localDef.getDocumentBaseURI(), localDef.getTypes());
        }
        return flatMap;
    }

    public static List flatGetSchemas(Definition def) throws MalformedURLException {
        ArrayList<Object> schemaDefinitions = new ArrayList<Object>();
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Map imports;
            Definition localDef = (Definition)defIter.next();
            Types types = localDef.getTypes();
            if (types != null) {
                List ee = types.getExtensibilityElements();
                Iterator eeIter = ee.iterator();
                while (eeIter.hasNext()) {
                    Element possibleSchema;
                    ExtensibilityElement ext = (ExtensibilityElement)eeIter.next();
                    if (!(ext instanceof UnknownExtensibilityElement) || !(possibleSchema = ((UnknownExtensibilityElement)ext).getElement()).getLocalName().equals("schema")) continue;
                    schemaDefinitions.add(localDef.getDocumentBaseURI());
                    schemaDefinitions.add(possibleSchema);
                }
            }
            if ((imports = localDef.getImports()) == null) continue;
            Iterator importIter = imports.values().iterator();
            while (importIter.hasNext()) {
                List importList = (List)importIter.next();
                Iterator oneImportIter = importList.iterator();
                while (oneImportIter.hasNext()) {
                    Import oneImport = (Import)oneImportIter.next();
                    if (oneImport.getDefinition() != null || oneImport.getLocationURI() == null) continue;
                    Endpoint endp = XmlUtil.createEndpoint(localDef.getDocumentBaseURI(), oneImport.getLocationURI());
                    schemaDefinitions.add(endp.toExternalForm());
                    schemaDefinitions.add(null);
                }
            }
        }
        return schemaDefinitions;
    }

    public static List flatGetRequiredUnknownExtElems(Definition def) {
        ArrayList unknownList = new ArrayList();
        Iterator defIter = WSDLUtil.flatGetDefinitions(def).values().iterator();
        while (defIter.hasNext()) {
            Definition localDef = (Definition)defIter.next();
            WSDLUtil.localGetRequiredUnknownExtElems(unknownList, localDef.getExtensibilityElements());
            if (localDef.getTypes() != null) {
                WSDLUtil.localGetRequiredUnknownExtElems(unknownList, localDef.getTypes().getExtensibilityElements());
            }
            Object[] bindings = localDef.getBindings().values().toArray();
            int i = 0;
            while (i < bindings.length) {
                Binding binding = (Binding)bindings[i];
                WSDLUtil.localGetRequiredUnknownExtElems(unknownList, binding.getExtensibilityElements());
                Object[] operations = binding.getBindingOperations().toArray();
                int j = 0;
                while (j < operations.length) {
                    BindingOperation operation = (BindingOperation)operations[j];
                    WSDLUtil.localGetRequiredUnknownExtElems(unknownList, operation.getExtensibilityElements());
                    if (operation.getBindingInput() != null) {
                        WSDLUtil.localGetRequiredUnknownExtElems(unknownList, operation.getBindingInput().getExtensibilityElements());
                    }
                    if (operation.getBindingOutput() != null) {
                        WSDLUtil.localGetRequiredUnknownExtElems(unknownList, operation.getBindingOutput().getExtensibilityElements());
                    }
                    Object[] faults = operation.getBindingFaults().values().toArray();
                    int k = 0;
                    while (k < faults.length) {
                        BindingFault fault = (BindingFault)faults[k];
                        WSDLUtil.localGetRequiredUnknownExtElems(unknownList, fault.getExtensibilityElements());
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            Object[] services = localDef.getServices().values().toArray();
            int i2 = 0;
            while (i2 < services.length) {
                Service service = (Service)services[i2];
                WSDLUtil.localGetRequiredUnknownExtElems(unknownList, service.getExtensibilityElements());
                Object[] ports = service.getPorts().values().toArray();
                int j = 0;
                while (j < ports.length) {
                    WSDLUtil.localGetRequiredUnknownExtElems(unknownList, ((Port)ports[j]).getExtensibilityElements());
                    ++j;
                }
                ++i2;
            }
        }
        return unknownList;
    }

    private static final void localGetRequiredUnknownExtElems(List unknownList, List extElems) {
        Iterator extIter = extElems.iterator();
        while (extIter.hasNext()) {
            ExtensibilityElement extEl = (ExtensibilityElement)extIter.next();
            if (!(extEl instanceof UnknownExtensibilityElement) || extEl.getRequired() == null || !extEl.getRequired().booleanValue()) continue;
            unknownList.add(extEl);
        }
    }

    public static void checkWSDLSyntax(Map globalMap) throws WSDLException {
        Map definitions = (Map)globalMap.get("definitions");
        Map messages = (Map)globalMap.get("message");
        Map portTypes = (Map)globalMap.get("portType");
        Map bindings = (Map)globalMap.get("binding");
        if (!messages.isEmpty()) {
            Message message = (Message)messages.values().iterator().next();
            throw new WSDLException("INVALID_WSDL", "Referenced message not found: '" + message.getQName() + "'");
        }
        if (!portTypes.isEmpty()) {
            PortType portType = (PortType)portTypes.values().iterator().next();
            throw new WSDLException("INVALID_WSDL", "Referenced portType not found: '" + portType.getQName() + "'");
        }
        if (!bindings.isEmpty()) {
            Binding binding = (Binding)bindings.values().iterator().next();
            throw new WSDLException("INVALID_WSDL", "Referenced binding not found: '" + binding.getQName() + "'");
        }
        Iterator defIter = definitions.values().iterator();
        while (defIter.hasNext()) {
            Definition def = (Definition)defIter.next();
            Iterator pTypeIter = def.getPortTypes().values().iterator();
            while (pTypeIter.hasNext()) {
                PortType portType = (PortType)pTypeIter.next();
                HashMap<String, Input> inputMap = new HashMap<String, Input>();
                HashMap<String, Output> outputMap = new HashMap<String, Output>();
                Iterator opIter = portType.getOperations().iterator();
                while (opIter.hasNext()) {
                    Operation operation = (Operation)opIter.next();
                    if (operation.isUndefined()) {
                        throw new WSDLException("INVALID_WSDL", "Referenced operation not found: '" + operation.getName() + "' in PortType: '" + portType.getQName() + "'");
                    }
                    OperationType operationType = operation.getStyle();
                    Input input = operation.getInput();
                    Output output = operation.getOutput();
                    if (input != null) {
                        String inputName = input.getName();
                        if (inputName == null || inputName.length() == 0) {
                            inputName = operationType.equals(OperationType.REQUEST_RESPONSE) ? operation.getName() + "Request" : (operationType.equals(OperationType.SOLICIT_RESPONSE) ? operation.getName() + "Response" : operation.getName());
                        }
                        if (inputMap.put(inputName, input) != null) {
                            throw new WSDLException("INVALID_WSDL", "Duplicated input: '" + inputName + "' in operation: '" + operation.getName() + "' in portType: '" + portType.getQName() + "'");
                        }
                    }
                    if (output == null) continue;
                    String outputName = output.getName();
                    if (outputName == null || outputName.length() == 0) {
                        outputName = operationType.equals(OperationType.REQUEST_RESPONSE) ? operation.getName() + "Response" : (operationType.equals(OperationType.SOLICIT_RESPONSE) ? operation.getName() + "Solicit" : operation.getName());
                    }
                    if (outputMap.put(outputName, output) == null) continue;
                    throw new WSDLException("INVALID_WSDL", "Duplicated output: '" + outputName + "' in operation: '" + operation.getName() + "' in portType: '" + portType.getQName() + "'");
                }
            }
        }
    }

    public static String getAddressLocationURI(Port port) {
        String ret = null;
        Iterator extEL = port.getExtensibilityElements().iterator();
        while (extEL.hasNext()) {
            ExtensibilityElement extE = (ExtensibilityElement)extEL.next();
            if (extE instanceof SOAPAddress) {
                SOAPAddress soapAddr = (SOAPAddress)extE;
                ret = soapAddr.getLocationURI();
                break;
            }
            if (!(extE instanceof HTTPAddress)) continue;
            HTTPAddress httpAddr = (HTTPAddress)extE;
            ret = httpAddr.getLocationURI();
            break;
        }
        return ret;
    }

    public static void getOrdering(Message inputMessage, Message outputMessage, List ordering) {
        ArrayList inputParts = inputMessage != null ? inputMessage.getOrderedParts(null) : new ArrayList();
        ArrayList outputParts = outputMessage != null ? outputMessage.getOrderedParts(null) : new ArrayList();
        HashSet processedNames = new HashSet();
        int i = 0;
        while (i < ordering.size()) {
            processedNames.add(ordering.get(i));
            ++i;
        }
        Iterator i2 = inputParts.iterator();
        while (i2.hasNext()) {
            Part p = (Part)i2.next();
            String name = p.getName();
            if (processedNames.contains(name)) continue;
            ordering.add(name);
            processedNames.add(name);
        }
        Iterator i3 = outputParts.iterator();
        if (i3.hasNext()) {
            i3.next();
        }
        while (i3.hasNext()) {
            Part p = (Part)i3.next();
            String name = p.getName();
            if (processedNames.contains(name)) continue;
            ordering.add(name);
            processedNames.add(name);
        }
    }

    public static boolean isPartInOut(QName inElementName, QName inputTypeName, QName outElementName, QName outputTypeName, Schema schema) throws SchemaException {
        Member outSchemaElement;
        Type outSchemaType;
        boolean inout = false;
        if (inputTypeName != null && inputTypeName.equals(outputTypeName)) {
            inout = true;
        } else if (inElementName != null) {
            if (inElementName.equals(outElementName)) {
                inout = true;
            } else if (outElementName != null) {
                Member inSchemaElement = XMLSchemaUtil.getSchemaElement(schema, inElementName);
                Member outSchemaElement2 = XMLSchemaUtil.getSchemaElement(schema, outElementName);
                Type inSchemaType = inSchemaElement.getType();
                Type outSchemaType2 = outSchemaElement2.getType();
                if (inSchemaType != null && outSchemaType2 != null && inSchemaType.getName() != null && inSchemaType.getName().equals(outSchemaType2.getName())) {
                    inout = true;
                }
            }
        } else if (inputTypeName != null && outElementName != null && (outSchemaType = (outSchemaElement = XMLSchemaUtil.getSchemaElement(schema, outElementName)).getType()) != null && inputTypeName.equals(outSchemaType.getName())) {
            inout = true;
        }
        return inout;
    }

    public static Part getInputWrappedPart(Operation oper, Schema schema) throws SchemaException {
        if (oper.getInput() != null) {
            return WSDLUtil.getWrappedPart(oper, oper.getInput().getMessage(), schema, true);
        }
        return null;
    }

    public static Part getOutputWrappedPart(Operation oper, Schema schema) throws SchemaException {
        if (oper.getOutput() != null) {
            return WSDLUtil.getWrappedPart(oper, oper.getOutput().getMessage(), schema, false);
        }
        return null;
    }

    private static Part getWrappedPart(Operation oper, Message message, Schema schema, boolean isInput) throws SchemaException {
        if (oper.getParameterOrdering() != null) {
            return null;
        }
        if (message == null) {
            return null;
        }
        Part parametersPart = message.getPart("parameters");
        if (parametersPart == null) {
            parametersPart = message.getPart("body");
        }
        if (parametersPart == null && message.getParts().size() == 1) {
            parametersPart = (Part)message.getParts().values().iterator().next();
        }
        if (parametersPart == null) {
            return null;
        }
        QName elementName = parametersPart.getElementName();
        if (elementName != null) {
            if (isInput && !elementName.getLocalPart().startsWith(oper.getName())) {
                return null;
            }
            Member schemaElement = XMLSchemaUtil.getSchemaElement(schema, elementName);
            Type schemaType = schemaElement.getType();
            if (schemaType != null && WSDLUtil.canBeWrapper(schemaType)) {
                return parametersPart;
            }
        }
        return null;
    }

    public static List fetchWrapperMembers(Type t) {
        SchemaConstruct[] members;
        ArrayList<Member> ret = new ArrayList<Member>();
        if (WSDLUtil.canBeWrapper(t) && (members = t.getSubconstructs()) != null) {
            int i = 0;
            while (i < members.length) {
                if (members[i].getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                    Member m = XMLSchemaUtil.dereferenceMember((Member)members[i]);
                    ret.add(m);
                }
                ++i;
            }
        }
        return ret;
    }

    private static boolean canBeWrapper(Type t) {
        return !(t.getKind() != 35 && t.getKind() != 37 || t.getAttributes() != null && t.getAttributes().length != 0);
    }

    public static SOAPMethodInfo.PartInfo[] mergePartInfos(List inWrapperMembers, List outWrapperMembers, Schema schema, List ordering, Map mimeAttachmentsPart) throws SchemaException {
        HashSet<String> processedNames = new HashSet<String>();
        ArrayList<SOAPMethodInfo.PartInfo> newPartInfos = new ArrayList<SOAPMethodInfo.PartInfo>();
        Iterator it = inWrapperMembers.iterator();
        while (it.hasNext()) {
            Member m = (Member)it.next();
            String memberName = m.getName().getLocalPart();
            if (processedNames.contains(memberName)) continue;
            SOAPMethodInfo.PartInfo newPartInfo = new SOAPMethodInfo.PartInfo();
            newPartInfo.partName = memberName;
            newPartInfo.partType = 1;
            newPartInfo.inSchemaElement = m;
            newPartInfo.inSchemaType = m.getType();
            if (mimeAttachmentsPart.containsKey(memberName)) {
                newPartInfo.isAttachment = true;
                newPartInfo.mimeType = (String)mimeAttachmentsPart.get(memberName);
            }
            newPartInfos.add(newPartInfo);
            processedNames.add(memberName);
        }
        it = outWrapperMembers.iterator();
        int order = 0;
        while (it.hasNext()) {
            ++order;
            Member m = (Member)it.next();
            String memberName = m.getName().getLocalPart();
            if (!processedNames.contains(memberName)) {
                if (order == 1) {
                    processedNames.add(memberName);
                    continue;
                }
                SOAPMethodInfo.PartInfo newPartInfo = new SOAPMethodInfo.PartInfo();
                newPartInfo.partName = memberName;
                newPartInfo.outSchemaElement = m;
                newPartInfo.outSchemaType = m.getType();
                newPartInfo.partType = 2;
                if (mimeAttachmentsPart.containsKey(memberName)) {
                    newPartInfo.isAttachment = true;
                    newPartInfo.mimeType = (String)mimeAttachmentsPart.get(memberName);
                }
                newPartInfos.add(newPartInfo);
            } else {
                SOAPMethodInfo.PartInfo desired = null;
                Iterator newPartInfosIt = newPartInfos.iterator();
                while (newPartInfosIt.hasNext()) {
                    SOAPMethodInfo.PartInfo current = (SOAPMethodInfo.PartInfo)newPartInfosIt.next();
                    if (!memberName.equals(current.partName)) continue;
                    desired = current;
                }
                if (desired != null) {
                    desired.outSchemaElement = m;
                    desired.outSchemaType = m.getType();
                    boolean inout = WSDLUtil.isPartInOut(desired.inSchemaElement.getName(), null, desired.outSchemaElement.getName(), null, schema);
                    if (inout) {
                        desired.partType = 3;
                    } else {
                        SOAPMethodInfo.PartInfo newPartInfo = new SOAPMethodInfo.PartInfo();
                        newPartInfo.partName = memberName + "_out";
                        newPartInfo.outSchemaElement = m;
                        newPartInfo.outSchemaType = m.getType();
                        newPartInfo.partType = 2;
                        if (mimeAttachmentsPart.containsKey(memberName)) {
                            newPartInfo.isAttachment = true;
                            newPartInfo.mimeType = (String)mimeAttachmentsPart.get(memberName);
                        }
                        newPartInfos.add(newPartInfo);
                    }
                }
            }
            processedNames.add(memberName);
        }
        Iterator processedNamesIt = processedNames.iterator();
        while (processedNamesIt.hasNext()) {
            String name = (String)processedNamesIt.next();
            if (!mimeAttachmentsPart.containsKey(name) || !ordering.contains(name)) continue;
            ordering.remove(name);
        }
        return newPartInfos.toArray(EMPTY_PARTINFOS);
    }

    static {
        cat = Category.getCategory("com.idoox.wsdl.util.WSDLUtil");
        try {
            wsdlFactory = WSDLFactory.newInstance("com.idoox.wsdl.factory.WSDLFactoryImpl");
        }
        catch (WSDLException e) {
            throw new RuntimeException("Cannot instantiate WSDLFactory:" + e.getMessage());
        }
        EMPTY_PARTINFOS = new SOAPMethodInfo.PartInfo[0];
    }
}

