/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.wsdl;

import com.idoox.debug.Category;
import com.idoox.wasp.InitialReferencesRegistrar;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.idoox.config.Configurable;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.wsdl.WSDLRepository;
import org.xml.sax.SAXException;

public class WSDLRepositoryImpl
implements WSDLRepository,
Module {
    private static final Category log = Category.getCategory("com.idoox.wasp.wsdl.WSDLRepositoryImpl");
    private static WSDLFactory factory;
    private DocumentBuilderFactory docBF;
    private String[] configWSDLUrls;
    private Map urlCache = new HashMap();
    private Map portTypeMap = new HashMap();
    private Map portMap = new HashMap();
    private Map serviceMap = new HashMap();
    static /* synthetic */ Class class$org$idoox$wasp$wsdl$WSDLRepository$Config;

    public void load(Configurable config) {
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.wsdl.WSDLRepository", this);
        Context.getInstance("org.idoox.config.Configurator");
        WSDLRepository.Config wrConfig = (WSDLRepository.Config)config.narrow(class$org$idoox$wasp$wsdl$WSDLRepository$Config == null ? (class$org$idoox$wasp$wsdl$WSDLRepository$Config = WSDLRepositoryImpl.class$("org.idoox.wasp.wsdl.WSDLRepository$Config")) : class$org$idoox$wasp$wsdl$WSDLRepository$Config);
        this.configWSDLUrls = wrConfig.getWSDLUrls();
        try {
            this.docBF = DocumentBuilderFactory.newInstance();
            this.docBF.setNamespaceAware(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize DOM parser: " + e.getMessage());
        }
    }

    public void init() {
        try {
            int i = 0;
            while (i < this.configWSDLUrls.length) {
                this.getDefinition(this.configWSDLUrls[i], true);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error during preloading definitions into WSDLRepository: " + e.getMessage());
        }
    }

    public void destroy() {
        this.portTypeMap.clear();
        this.portMap.clear();
        this.serviceMap.clear();
    }

    public Definition getDefinition(String wsdlURL, boolean register) throws MalformedURLException, IOException, SAXException, WSDLException {
        return this.getDefinition(wsdlURL, register, null);
    }

    public Definition getDefinition(String wsdlURL, boolean register, Map transportProps) throws MalformedURLException, IOException, SAXException, WSDLException {
        Definition defI = null;
        if (this.urlCache.containsKey(wsdlURL)) {
            defI = (Definition)this.urlCache.get(wsdlURL);
        } else {
            if (factory == null) {
                factory = WSDLFactory.newInstance("com.idoox.wsdl.factory.WSDLFactoryImpl");
            }
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            defI = reader.readWSDL(wsdlURL);
        }
        if (register) {
            if (defI.getDocumentBaseURI() != null) {
                this.registerDefinition(defI);
            } else {
                log.info("Cannot register definition: Document base URL is not set!");
            }
        }
        return defI;
    }

    public Definition getDefinition(String wsdlURL) throws MalformedURLException, IOException, SAXException, WSDLException {
        return this.getDefinition(wsdlURL, false, null);
    }

    public Definition getDefinition(String wsdlURL, Map transportProps) throws MalformedURLException, IOException, SAXException, WSDLException {
        return this.getDefinition(wsdlURL, false, transportProps);
    }

    public WSDLRepository.PortInfo[] findPortByPortType(QName portTypeQName) {
        List ret = (List)this.portTypeMap.get(portTypeQName);
        if (ret != null) {
            return ret.toArray(new WSDLRepository.PortInfo[0]);
        }
        return null;
    }

    public String findWSDLUrlByPort(String portName, QName serviceQName) {
        return (String)this.portMap.get(new WSDLRepository.PortInfo(portName, serviceQName, null));
    }

    public WSDLRepository.ServiceInfo findService(QName serviceQName) {
        return (WSDLRepository.ServiceInfo)this.serviceMap.get(serviceQName);
    }

    private void registerDefinition(Definition def) {
        this.registerServices(def);
        Iterator importLI = def.getImports().values().iterator();
        while (importLI.hasNext()) {
            Iterator importI = ((List)importLI.next()).iterator();
            while (importI.hasNext()) {
                Definition df = ((Import)importI.next()).getDefinition();
                this.registerServices(df);
            }
        }
    }

    private void registerServices(Definition def) {
        Iterator servicesI = def.getServices().values().iterator();
        while (servicesI.hasNext()) {
            Service service = (Service)servicesI.next();
            this.serviceMap.put(service.getQName(), new WSDLRepository.ServiceInfo(def, service));
            Iterator portsI = service.getPorts().values().iterator();
            while (portsI.hasNext()) {
                Port port = (Port)portsI.next();
                this.registerPort(def, port, service);
            }
        }
    }

    private void registerPort(Definition def, Port port, Service service) {
        String defURL = def.getDocumentBaseURI();
        WSDLRepository.PortInfo portInfo = new WSDLRepository.PortInfo(port.getName(), service.getQName(), defURL);
        QName portTypeQName = port.getBinding().getPortType().getQName();
        ArrayList<WSDLRepository.PortInfo> portInfoL = (ArrayList<WSDLRepository.PortInfo>)this.portTypeMap.get(portTypeQName);
        if (portInfoL == null) {
            portInfoL = new ArrayList<WSDLRepository.PortInfo>();
            this.portTypeMap.put(portTypeQName, portInfoL);
        }
        portInfoL.add(portInfo);
        this.portMap.put(portInfo, portInfo.getWSDLUrl());
    }

    public void _registerService(String defURL, QName serviceName) {
        this.serviceMap.put(serviceName, new WSDLRepository.ServiceInfo(defURL, serviceName));
    }

    public void _registerPort(String defURL, QName serviceName, String portName, QName portTypeName) {
        WSDLRepository.PortInfo portInfo = new WSDLRepository.PortInfo(portName, serviceName, defURL);
        ArrayList<WSDLRepository.PortInfo> portInfoL = (ArrayList<WSDLRepository.PortInfo>)this.portTypeMap.get(portTypeName);
        if (portInfoL == null) {
            portInfoL = new ArrayList<WSDLRepository.PortInfo>();
            this.portTypeMap.put(portTypeName, portInfoL);
        }
        portInfoL.add(portInfo);
        this.portMap.put(portInfo, portInfo.getWSDLUrl());
    }

    public void _registerParsedDefinitions(String defURL, Definition def) {
        if (defURL == null || def == null) {
            return;
        }
        Map map = this.urlCache;
        synchronized (map) {
            this.urlCache.put(defURL, def);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

