/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.tools.java2schema;

import com.idoox.Namespaces;
import com.idoox.debug.Category;
import com.idoox.util.SignatureHelper;
import com.idoox.wasp.Constants;
import com.idoox.wasp.serialization.ChoiceHelper;
import com.idoox.wasp.serialization.EnumHelper;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.wasp.tools.common.DDTypeMappingContext;
import com.idoox.wasp.tools.common.DefaultValuesHelper;
import com.idoox.wasp.tools.common.Java2TypeConfig;
import com.idoox.wasp.tools.common.util.ClassHelper;
import com.idoox.wasp.tools.common.util.ClassTypeTokenizer;
import com.idoox.wasp.tools.common.util.FieldComparator;
import com.idoox.wasp.tools.common.util.MethodInfo;
import com.idoox.wasp.tools.common.util.UtilFactory;
import com.idoox.wsdl.util.WSDLUtil;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import com.systinet.wasp.admin.PackageRepositoryImpl;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.serialization.TypeMappingContext;
import org.idoox.wasp.tools.java2schema.Java2Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SchemaFactory;
import org.idoox.xml.schema.SchemaParser;
import org.idoox.xmlrpc.header.Schema;
import org.systinet.wasp.dd.Processing;
import org.systinet.wasp.webservice.PublishException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class Java2SchemaImpl
implements Java2Schema {
    private static final Category log = Category.getCategory("com.idoox.wasp.tools.java2schema.Java2SchemaImpl");
    public static final String SCHEMA_TARGETNAMESPACE = "http://systinet.com/wsdl/SchemaTypes/";
    private static DocumentBuilderFactory documentBuilderFactory;
    private static SerializationRepository serializationRepository;
    private static PackageRepositoryImpl packageRepositoryImpl;
    private static SchemaFactory schemaFactory;
    private static Set excludedClassesDefault;
    private static Set includedClassesDefault;
    private static Map encodedSchemasToInclude;
    private static Map literalSchemasToInclude;
    private boolean useNillable = true;
    private DocumentBuilder documentBuilder;
    private Document document;
    private Set definedTypes;
    private Set definedElements;
    private int elementUnique;
    private Map namespaceToSchemaMap;
    private Map namespaceToPrefixMap;
    private Map namespaceToImportsMap;
    private Map namespaceToDefinitionSchema;
    private Map namespaceToSchemaLocation;
    private Map inheritanceMapping;
    private Map packageNamespaceMap;
    private Set excludedClasses;
    private Set includedClasses;
    private boolean javaMappingExtension;
    private boolean enableStructures;
    private boolean sortingFields;
    private int soapEncoding;
    private boolean multidimArrays;
    private static final QName XSD_ANY_TYPE;
    private TypeMappingContext typeMappingContext;
    private String serializationID;
    private String encodingURI;
    private Set referencedSchemas;
    private Set insertedSchemas;
    private SchemaParser schemaParser;
    private Processing processing;
    private String attachmentType;
    private int verbose;
    private boolean reinitialize = true;
    static /* synthetic */ Class class$org$idoox$config$Configurator;
    static /* synthetic */ Class class$com$idoox$wasp$tools$common$Java2TypeConfig;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;

    public Java2SchemaImpl() {
        serializationRepository = (SerializationRepository)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        packageRepositoryImpl = (PackageRepositoryImpl)Context.getInstance("org.systinet.wasp.admin.PackageRepository");
        schemaFactory = (SchemaFactory)Context.getInstance("org.idoox.xml.schema.SchemaFactory");
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeWrappedException("Cannot instantiate DocumentBuilder: ", e);
        }
        this.document = this.documentBuilder.newDocument();
        this.definedTypes = UtilFactory.getSet();
        this.definedElements = UtilFactory.getSet();
        this.elementUnique = 0;
        this.namespaceToSchemaMap = UtilFactory.getMap();
        this.namespaceToPrefixMap = UtilFactory.getMap();
        this.namespaceToImportsMap = UtilFactory.getMap();
        this.namespaceToDefinitionSchema = UtilFactory.getMap();
        this.namespaceToSchemaLocation = UtilFactory.getMap();
        this.inheritanceMapping = UtilFactory.getMap();
        this.packageNamespaceMap = UtilFactory.getMap();
        this.javaMappingExtension = true;
        this.excludedClasses = UtilFactory.getSet(excludedClassesDefault);
        this.includedClasses = UtilFactory.getSet(includedClassesDefault);
        this.referencedSchemas = UtilFactory.getSet();
        this.insertedSchemas = UtilFactory.getSet();
        this.schemaParser = null;
        this.enableStructures = true;
        this.sortingFields = true;
        this.soapEncoding = DefaultValuesHelper.getInstance().getDefaultEncodingStyle();
        this.multidimArrays = true;
        this.attachmentType = DefaultValuesHelper.getInstance().getDefaultAttachmentType();
        this.useNillable = DefaultValuesHelper.getInstance().isDefaultUseNillable();
        this.serializationID = packageRepositoryImpl.getDefaultSerializationID();
        this.encodingURI = null;
        this.typeMappingContext = this.typeMappingContext = serializationRepository.createTypeMappingContext(this.serializationID, this.encodingURI, "java");
        this.setTypeMappingContextSchema();
        this.processing = null;
        this.verbose = 0;
    }

    public void resetCompiler() {
        this.reinitialize = true;
        this.definedTypes = UtilFactory.getSet();
        this.definedElements = UtilFactory.getSet();
        this.elementUnique = 0;
        this.namespaceToSchemaMap = UtilFactory.getMap();
        this.namespaceToPrefixMap = UtilFactory.getMap();
        this.namespaceToImportsMap = UtilFactory.getMap();
    }

    public QName mapJavaType(Class typeClass) {
        return this.mapJavaType(typeClass, true, null);
    }

    public QName mapJavaType(Class typeClass, Set schemaSet) {
        return this.mapJavaType(typeClass, true, schemaSet);
    }

    public QName mapSchemaType(Class typeClass, QName schemaElement, QName schemaType) {
        return this.mapSchemaType(typeClass, schemaElement, schemaType, null, true);
    }

    public QName mapSchemaType(Class typeClass, QName schemaElement, QName schemaType, Set schemaSet) {
        return this.mapSchemaType(typeClass, schemaElement, schemaType, schemaSet, true);
    }

    public void setSchemaBuilder(Document schemaDocument) {
        this.document = schemaDocument;
    }

    public Document getSchemaBuilder() {
        return this.document;
    }

    public Map getAllSchemas() {
        return this.namespaceToSchemaMap;
    }

    public Set getImportReferences(String targetNamespace) {
        Map crossRef = (Map)this.namespaceToImportsMap.get(targetNamespace);
        if (crossRef == null) {
            return UtilFactory.getSet();
        }
        return UtilFactory.getSet(crossRef.values());
    }

    public Map getPackageMapping() {
        return this.packageNamespaceMap;
    }

    public void setPackageMapping(Map packageNamespaceMap) {
        this.packageNamespaceMap = packageNamespaceMap;
    }

    public int getInterfaceMappingMode() {
        return this.enableStructures ? 16 : 17;
    }

    public void setInterfaceMappingMode(int mode) {
        if (mode == 16) {
            this.enableStructures = true;
        } else if (mode == 17) {
            this.enableStructures = false;
        } else {
            throw new RuntimeException("Unsupported InterfaceMappingMode: " + mode);
        }
    }

    public TypeMappingContext getTypeMappingContext() {
        return this.typeMappingContext;
    }

    public void setTypeMappingContext(TypeMappingContext typeMappingContext) {
        this.reinitialize = true;
        this.typeMappingContext = typeMappingContext;
    }

    public Map getInheritanceMapping() {
        return this.inheritanceMapping;
    }

    public boolean isJavaMappingExtension() {
        return this.javaMappingExtension;
    }

    public void setJavaMappingExtension(boolean javaMappingExtension) {
        this.javaMappingExtension = javaMappingExtension;
    }

    public void setInheritanceMapping(Map inheritanceMapping) {
        this.inheritanceMapping = inheritanceMapping;
    }

    public Set getExcludedClasses() {
        return this.excludedClasses;
    }

    public Set getIncludedClasses() {
        return this.includedClasses;
    }

    public void setMappingSchemas(Set referencedSchemas, Set insertedSchemas) {
        this.reinitialize = true;
        this.referencedSchemas = UtilFactory.getSet(referencedSchemas);
        this.insertedSchemas = UtilFactory.getSet(insertedSchemas);
    }

    public boolean testClassInclusion(String className) {
        if (this.includedClasses.contains(className)) {
            return true;
        }
        String classPackage = ClassHelper.getPackage(className) + ".*";
        return !this.excludedClasses.contains(className) && !this.excludedClasses.contains(classPackage);
    }

    public boolean isSortingFields() {
        return this.sortingFields;
    }

    public void setSortingFields(boolean sortingFields) {
        this.sortingFields = sortingFields;
    }

    public int getSOAPEncoding() {
        return this.soapEncoding;
    }

    public void setSOAPEncoding(int soapEncoding) {
        this.reinitialize = true;
        this.soapEncoding = soapEncoding;
        this.encodingURI = soapEncoding == 0 ? "http://schemas.xmlsoap.org/soap/encoding/" : null;
    }

    public boolean isMultidimArrays() {
        return this.multidimArrays;
    }

    public void setMultidimArrays(boolean multidimArrays) {
        this.multidimArrays = multidimArrays;
    }

    public void setDDProcessing(Processing processing) {
        this.reinitialize = true;
        this.processing = processing;
    }

    public Processing getDDProcessing() {
        return this.processing;
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.setVerbose(0);
        } else {
            this.verbose = 0;
        }
    }

    public void setVerbose(int length) {
        this.verbose = length < 0 ? 0 : (length == 0 ? 142 : length);
    }

    public boolean isVerbose() {
        return this.verbose > 0;
    }

    public String getSerializationID() {
        return this.serializationID;
    }

    public void setSerializationID(String serializationID) {
        this.reinitialize = true;
        this.serializationID = serializationID;
    }

    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }

    public String getAttachmentType() {
        return this.attachmentType;
    }

    public boolean defineSchema(String targetNamespace) {
        if (this.namespaceToSchemaMap.get(targetNamespace) != null) {
            return true;
        }
        return this.defineXSD(targetNamespace);
    }

    public void addNamespaceToSchemaLocation(String targetNamespace, Schema schema) {
        if (targetNamespace != null && schema != null && !this.namespaceToSchemaLocation.containsKey(targetNamespace)) {
            this.namespaceToSchemaLocation.put(targetNamespace, schema);
        }
    }

    public Map getNamespaceToDefinitionSchema() {
        return this.namespaceToDefinitionSchema;
    }

    public void setNamespaceToDefinitionSchema(Map namespaceToDefinitionSchema) {
        this.namespaceToDefinitionSchema = namespaceToDefinitionSchema;
    }

    public void setNamespaceToSchemaLocation(Map namespaceToSchemaLocation) {
        this.namespaceToSchemaLocation = namespaceToSchemaLocation;
    }

    private SchemaParser createSchemaParser() {
        SchemaParser schemaParser = schemaFactory.newSchemaParser();
        schemaParser.setNamespaceLocationMap(serializationRepository.getNamespaceLocationMap(this.serializationID, this.encodingURI));
        return schemaParser;
    }

    private void setTypeMappingContextSchema() {
        try {
            if (this.schemaParser != null) {
                this.schemaParser.resolve();
                this.typeMappingContext.setSchema(this.schemaParser.getSchema(), true);
            }
        }
        catch (SchemaException e) {
            throw new RuntimeWrappedException("Exception occured while parsing schemas", e);
        }
    }

    private void parseMappingSchema(String schemaFile) {
        Exception schemaException = null;
        Exception wsdlException = null;
        if (schemaFile.indexOf(58) < 0) {
            schemaFile = "file:" + schemaFile;
        }
        try {
            XMLSchemaUtil.parseTypes(WSDLUtil.readWSDL((String)null, schemaFile), this.schemaParser);
        }
        catch (Exception e) {
            wsdlException = e;
        }
        try {
            if (wsdlException != null) {
                this.schemaParser.parse(new Endpoint(schemaFile));
            }
        }
        catch (Exception e) {
            schemaException = e;
        }
        if (wsdlException != null && schemaException != null) {
            throw new RuntimeException("Referenced file is not XML Schema nor WSDL: \nException (1) Parsing XML Schema: " + schemaException + "\nException (2) Parsing WSDL: " + wsdlException);
        }
    }

    private String getTargetNamespace(Class typeClass) {
        return this.getTargetNamespace(typeClass.getName());
    }

    private String getTargetNamespace(String className) {
        String namespace;
        String packageName = ClassHelper.getPackage(className);
        if (packageName == null || packageName.length() == 0) {
            packageName = "default";
        }
        if ((namespace = (String)this.packageNamespaceMap.get(packageName)) == null) {
            namespace = ClassHelper.getDefaultTargetNamespace(packageName);
            this.packageNamespaceMap.put(packageName, namespace);
        }
        return namespace;
    }

    private Element getSchemaElement(Class typeClass) {
        return this.getSchemaElement(typeClass.getName());
    }

    private Element getSchemaElement(String className) {
        String targetNamespace = this.getTargetNamespace(className);
        return this.getSchemaElementTNS(targetNamespace);
    }

    private Element getSchemaElementTNS(String targetNamespace) {
        Element schemaElement = (Element)this.namespaceToSchemaMap.get(targetNamespace);
        if (schemaElement == null) {
            schemaElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
            schemaElement.setAttribute("targetNamespace", targetNamespace);
            if (this.soapEncoding == 0) {
                schemaElement.setAttribute("elementFormDefault", "unqualified");
            } else {
                schemaElement.setAttribute("elementFormDefault", "qualified");
            }
            schemaElement.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            schemaElement.setAttribute("xmlns:tns", targetNamespace);
            this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
            this.namespaceToSchemaMap.put(targetNamespace, schemaElement);
        }
        return schemaElement;
    }

    private String getSchemaNamespace(Element schemaElement) {
        String targetNamespace = schemaElement.getAttribute("targetNamespace");
        if (targetNamespace == null) {
            return "";
        }
        return targetNamespace;
    }

    private String getNamespacePrefix(Element schemaElement, String namespaceURI) {
        String prefix;
        String targetNamespace = this.getSchemaNamespace(schemaElement);
        if (this.namespaceToPrefixMap.get(targetNamespace + " &&") == null) {
            NamedNodeMap nodeMap = schemaElement.getAttributes();
            int i = 0;
            while (i < nodeMap.getLength()) {
                Attr attr = (Attr)nodeMap.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (name.equals("xmlns") || name.startsWith("xmlns:")) {
                    int index = name.indexOf(58);
                    if (index >= 0) {
                        name = name.substring(index + 1);
                    }
                    this.namespaceToPrefixMap.put(targetNamespace + " & " + value, name);
                }
                ++i;
            }
            this.namespaceToPrefixMap.put(targetNamespace + " &&", schemaElement);
        }
        if ((prefix = (String)this.namespaceToPrefixMap.get(targetNamespace + " & " + namespaceURI)) != null) {
            return prefix + (prefix.length() > 0 ? ":" : "");
        }
        prefix = (String)Namespaces.wellKnownNS.get(namespaceURI);
        if (prefix != null && !schemaElement.hasAttribute("xmlns:" + prefix)) {
            schemaElement.setAttribute("xmlns:" + prefix, namespaceURI);
        } else {
            prefix = null;
        }
        if (prefix == null) {
            int nsIndex = schemaElement.getAttributes().getLength();
            while (schemaElement.hasAttribute("xmlns:xns" + nsIndex)) {
                ++nsIndex;
            }
            prefix = "xns" + nsIndex;
            schemaElement.setAttribute("xmlns:" + prefix, namespaceURI);
        }
        this.namespaceToPrefixMap.put(targetNamespace + " & " + namespaceURI, prefix);
        return prefix + (prefix.length() > 0 ? ":" : "");
    }

    private void defineImports(Element schemaElement, String targetNamespace) {
        if (targetNamespace == null) {
            return;
        }
        String schemaTNS = this.getSchemaNamespace(schemaElement);
        if (targetNamespace.equals(schemaTNS)) {
            return;
        }
        this.defineXSD(targetNamespace);
        if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace)) {
            return;
        }
        Map imported = (Map)this.namespaceToImportsMap.get(schemaTNS);
        if (imported == null) {
            imported = UtilFactory.getMap();
            this.namespaceToImportsMap.put(schemaTNS, imported);
        }
        if (imported.get(targetNamespace) != null) {
            return;
        }
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element importEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "import");
        importEl.setAttribute("namespace", targetNamespace);
        schemaElement.insertBefore(importEl, schemaElement.getFirstChild());
        imported.put(targetNamespace, importEl);
    }

    private boolean defineXSD(String targetNamespace) {
        if (targetNamespace == null || this.namespaceToSchemaMap.get(targetNamespace) != null) {
            return false;
        }
        List resourceList = null;
        if (this.namespaceToDefinitionSchema.containsKey(targetNamespace)) {
            this.namespaceToSchemaMap.put(targetNamespace, this.namespaceToDefinitionSchema.get(targetNamespace));
        }
        if (this.namespaceToSchemaLocation.containsKey(targetNamespace)) {
            try {
                URL schemaUrl = new URL(((Schema)this.namespaceToSchemaLocation.get(targetNamespace)).getLocation());
                InputStream inputStream = schemaUrl.openStream();
                Document xsd = this.documentBuilder.parse(inputStream);
                try {
                    inputStream.close();
                }
                catch (Exception obsoleteException) {
                    // empty catch block
                }
                Element docElement = xsd.getDocumentElement();
                this.namespaceToSchemaMap.put(this.getSchemaNamespace(docElement), docElement);
                this.debugging("NOTE: XSD file '" + schemaUrl.toExternalForm() + "' was imported due to target namespace '" + targetNamespace + "' definition.");
                return true;
            }
            catch (Exception e) {
                log.error("Can't load schema file:", e);
            }
        }
        if (this.soapEncoding == 0) {
            resourceList = (List)encodedSchemasToInclude.get(targetNamespace);
        } else if (this.soapEncoding == 1) {
            resourceList = (List)literalSchemasToInclude.get(targetNamespace);
        }
        if (resourceList == null) {
            return false;
        }
        Iterator resourceIter = resourceList.iterator();
        while (resourceIter.hasNext()) {
            String resource = (String)resourceIter.next();
            try {
                URL resourceURL = this.getClass().getClassLoader().getResource(resource);
                InputStream inputStream = resourceURL.openStream();
                Document xsd = this.documentBuilder.parse(inputStream);
                try {
                    inputStream.close();
                }
                catch (Exception obsoleteException) {
                    // empty catch block
                }
                Element docElement = xsd.getDocumentElement();
                this.namespaceToSchemaMap.put(this.getSchemaNamespace(docElement), docElement);
                this.debugging("NOTE: XSD file '" + resourceURL.toExternalForm() + "' was imported due to target namespace '" + targetNamespace + "' definition.");
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse internal XSD '" + resource + "': " + e.getMessage());
            }
        }
        return true;
    }

    public void initCompiler() {
        if (!this.reinitialize) {
            return;
        }
        encodedSchemasToInclude = Collections.unmodifiableMap(encodedSchemasToInclude);
        literalSchemasToInclude = Collections.unmodifiableMap(literalSchemasToInclude);
        this.reinitialize = false;
        this.schemaParser = this.createSchemaParser();
        if (this.processing != null) {
            try {
                this.typeMappingContext = new DDTypeMappingContext(this.processing, null, this.encodingURI);
            }
            catch (PublishException e) {
                throw new RuntimeWrappedException(e);
            }
        } else {
            this.typeMappingContext = serializationRepository.createTypeMappingContext(this.serializationID, this.encodingURI, "java");
        }
        try {
            Iterator schemaIterator = this.referencedSchemas.iterator();
            while (schemaIterator.hasNext()) {
                this.parseMappingSchema((String)schemaIterator.next());
            }
            schemaIterator = this.insertedSchemas.iterator();
            while (schemaIterator.hasNext()) {
                this.parseMappingSchema((String)schemaIterator.next());
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Exception occured while parsing schemas", e);
        }
        this.setTypeMappingContextSchema();
    }

    private QName mapJavaType(Class typeClass, boolean toplevel, Set schemaSet) {
        ClassTypeTokenizer classTypeTokenizer;
        if (toplevel) {
            this.initCompiler();
        }
        this.debugging(">>> Mapping Java type '" + typeClass + "'");
        QName typeQName = this.getJavaType(typeClass);
        if (typeQName != null) {
            return typeQName;
        }
        try {
            classTypeTokenizer = new ClassTypeTokenizer(typeClass, this.typeMappingContext);
        }
        catch (SchemaException e) {
            throw new RuntimeWrappedException(e);
        }
        typeQName = classTypeTokenizer.getQName();
        if (typeQName != null) {
            this.defineXSD(typeQName.getNamespaceURI());
        }
        if (typeQName == null) {
            typeQName = this.mapJavaTypeAny(classTypeTokenizer.getTypeClass(), schemaSet);
        }
        if (typeQName == null) {
            typeQName = this.mapJavaTypeAttachment(classTypeTokenizer.getTypeClass(), schemaSet);
        }
        if (typeQName == null) {
            typeQName = this.mapJavaTypeEnumeration(classTypeTokenizer.getTypeClass(), schemaSet);
        }
        if (typeQName == null) {
            typeQName = this.mapJavaTypeChoice(classTypeTokenizer, schemaSet);
        }
        if (typeQName == null) {
            typeQName = this.mapJavaTypeInterref(classTypeTokenizer);
        } else if (Constants.IREF_TYPE_QNAME.getNamespaceURI().equals(typeQName.getNamespaceURI())) {
            typeQName = this.mapJavaTypeInterref(null);
        }
        if (typeQName == null) {
            typeQName = this.createJavaTypeException(classTypeTokenizer, schemaSet);
        }
        if (typeQName == null) {
            typeQName = this.createJavaType(classTypeTokenizer, schemaSet);
        }
        typeQName = this.soapEncoding == 1 ? this.createLiteralJavaTypeArray(typeQName, classTypeTokenizer, schemaSet) : (this.multidimArrays ? this.createEncodedJavaTypeMultiArray(typeQName, classTypeTokenizer, schemaSet) : this.createEncodedJavaTypeSingleArray(typeQName, classTypeTokenizer, schemaSet));
        return typeQName;
    }

    private QName mapSchemaType(Class typeClass, QName schemaElement, QName schemaType, Set schemaSet, boolean topLevel) {
        String nillable;
        if (topLevel) {
            this.initCompiler();
        }
        String targetNamespace = "http://systinet.com/xsd/SchemaTypes/";
        schemaElement = new QName(targetNamespace, schemaElement.getLocalPart());
        Element schemaEl = this.getSchemaElementTNS(targetNamespace);
        if (schemaSet != null) {
            schemaSet.add(schemaEl);
        }
        boolean isNillable = typeClass == null || !typeClass.isPrimitive();
        String string = nillable = isNillable ? " # [nillable]" : "";
        if (this.definedElements.contains(schemaElement)) {
            if (this.definedElements.contains(schemaElement + " & " + schemaType + nillable)) {
                return schemaElement;
            }
            while (this.definedElements.contains(schemaElement = new QName(targetNamespace, schemaElement.getLocalPart() + "_" + ++this.elementUnique))) {
            }
        }
        this.definedElements.add(schemaElement);
        this.definedElements.add(schemaElement + " & " + schemaType + nillable);
        this.defineImports(schemaEl, schemaType.getNamespaceURI());
        Document schemaDoc = schemaEl.getOwnerDocument();
        String xsdPrefix = this.getNamespacePrefix(schemaEl, "http://www.w3.org/2001/XMLSchema");
        Element elemDef = schemaDoc.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        elemDef.setAttribute("name", schemaElement.getLocalPart());
        String xmlns = this.getNamespacePrefix(schemaEl, schemaType.getNamespaceURI());
        elemDef.setAttribute("type", xmlns + schemaType.getLocalPart());
        if (isNillable) {
            if (this.useNillable || topLevel) {
                elemDef.setAttribute("nillable", "true");
            } else {
                elemDef.setAttribute("minOccurs", "0");
                elemDef.setAttribute("maxOccurs", "1");
            }
        }
        schemaEl.appendChild(elemDef);
        this.debugging(">>> Mapping Schema type: '" + schemaType + "' -> element '" + schemaElement + "'");
        return schemaElement;
    }

    public QName mapSchemaTypeRight(Class typeClass, QName schemaElement, QName schemaType) {
        return this.mapSchemaTypeRight(typeClass, schemaElement, schemaType, null, true);
    }

    private QName mapSchemaTypeRight(Class typeClass, QName schemaElement, QName schemaType, Set schemaSet, boolean topLevel) {
        String nillable;
        if (topLevel) {
            this.initCompiler();
        }
        String targetNamespace = schemaElement.getNamespaceURI();
        schemaElement = new QName(targetNamespace, schemaElement.getLocalPart());
        Element schemaEl = this.getSchemaElementTNS(targetNamespace);
        if (schemaSet != null) {
            schemaSet.add(schemaEl);
        }
        boolean isNillable = typeClass == null || !typeClass.isPrimitive();
        String string = nillable = isNillable ? " # [nillable]" : "";
        if (this.definedElements.contains(schemaElement)) {
            if (this.definedElements.contains(schemaElement + " & " + schemaType + nillable)) {
                return schemaElement;
            }
            while (this.definedElements.contains(schemaElement = new QName(targetNamespace, schemaElement.getLocalPart() + "_" + ++this.elementUnique))) {
            }
        }
        this.definedElements.add(schemaElement);
        this.definedElements.add(schemaElement + " & " + schemaType + nillable);
        this.defineImports(schemaEl, schemaType.getNamespaceURI());
        Document schemaDoc = schemaEl.getOwnerDocument();
        String xsdPrefix = this.getNamespacePrefix(schemaEl, "http://www.w3.org/2001/XMLSchema");
        Element elemDef = schemaDoc.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        elemDef.setAttribute("name", schemaElement.getLocalPart());
        if (this.soapEncoding != 1 || !"http://www.w3.org/2001/XMLSchema".equals(schemaType.getNamespaceURI()) || !"anyType".equals(schemaType.getLocalPart())) {
            String xmlns = this.getNamespacePrefix(schemaEl, schemaType.getNamespaceURI());
            elemDef.setAttribute("type", xmlns + schemaType.getLocalPart());
        }
        if (isNillable) {
            if (this.useNillable) {
                elemDef.setAttribute("nillable", "true");
            } else {
                elemDef.setAttribute("minOccurs", "0");
                elemDef.setAttribute("maxOccurs", "1");
            }
        }
        schemaEl.appendChild(elemDef);
        this.debugging(">>> Mapping Schema type: '" + schemaType + "' -> element '" + schemaElement + "'");
        return schemaElement;
    }

    private QName mapJavaTypeAny(Class typeClass, Set schemaSet) {
        QName typeQName;
        if (!(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = Java2SchemaImpl.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(typeClass)) {
            return null;
        }
        boolean isElement = (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = Java2SchemaImpl.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(typeClass);
        String typeTNS = this.getTargetNamespace(typeClass);
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        if (this.definedTypes.contains(typeQName = new QName(typeTNS, ClassHelper.getFlatName(typeClass).replace('$', '_')))) {
            return typeQName;
        }
        this.definedTypes.add(typeQName);
        this.debugging("    Creating W3C DOM type '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        newType.setAttribute("name", typeQName.getLocalPart());
        if (!isElement) {
            newType.setAttribute("mixed", "true");
        }
        schemaElement.appendChild(newType);
        if (this.javaMappingExtension) {
            Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
            this.createJavaTypeAppInfo(schemaElement, annotation, xsdPrefix, typeClass.getName());
            newType.appendChild(annotation);
        }
        Element elemSeq = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        newType.appendChild(elemSeq);
        Element elemAny = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "any");
        elemSeq.appendChild(elemAny);
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        return typeQName;
    }

    private QName mapJavaTypeAttachment(Class typeClass, Set schemaSet) {
        if (this.typeMappingContext.getAttachmentMimeType(typeClass.getName()) != null) {
            this.debugging("    Mapping MessageAttachment class");
            if ("application/dime".equals(this.attachmentType)) {
                QName typeQName;
                this.defineXSD("http://schemas.xmlsoap.org/ws/2002/04/reference/");
                String typeNS = "http://systinet.com/attachments";
                Element schemaElement = this.getSchemaElementTNS(typeNS);
                if (schemaSet != null) {
                    schemaSet.add(schemaElement);
                }
                if (this.definedTypes.contains(typeQName = new QName(typeNS, "ReferencedBinary"))) {
                    return typeQName;
                }
                this.definedTypes.add(typeQName);
                this.debugging("    Creating W3C DOM type '" + typeQName + "'");
                String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
                String refPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/ws/2002/04/reference/");
                String contentPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/ws/2002/04/content-type/");
                Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
                newType.setAttribute("name", typeQName.getLocalPart());
                schemaElement.appendChild(newType);
                Element simpleContent = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "simpleContent");
                newType.appendChild(simpleContent);
                if (this.soapEncoding == 0) {
                    String soapEncPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/soap/encoding/");
                    Element extension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "extension");
                    extension.setAttribute("base", soapEncPrefix + "base64Binary");
                    simpleContent.appendChild(extension);
                    Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
                    extension.appendChild(annotation);
                    Element appinfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "appinfo");
                    annotation.appendChild(appinfo);
                    Element content = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", contentPrefix + "mediaType");
                    content.setAttribute("value", "application/octetstream");
                    appinfo.appendChild(content);
                    Element attributeGroup = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "attributeGroup");
                    attributeGroup.setAttribute("ref", soapEncPrefix + "commonAttributes");
                    extension.appendChild(attributeGroup);
                } else {
                    Element extension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "extension");
                    extension.setAttribute("base", xsdPrefix + "base64Binary");
                    simpleContent.appendChild(extension);
                    Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
                    extension.appendChild(annotation);
                    Element appinfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "appinfo");
                    annotation.appendChild(appinfo);
                    Element content = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", contentPrefix + "mediaType");
                    content.setAttribute("value", "application/octetstream");
                    appinfo.appendChild(content);
                    Element attribute = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "attribute");
                    attribute.setAttribute("ref", refPrefix + "location");
                    attribute.setAttribute("use", "optional");
                    extension.appendChild(attribute);
                }
                return typeQName;
            }
            return this.mapJavaType(array$B == null ? (array$B = Java2SchemaImpl.class$("[B")) : array$B, false, schemaSet);
        }
        return null;
    }

    private QName mapJavaTypeEnumeration(Class typeClass, Set schemaSet) {
        QName typeQName;
        if (typeClass.isArray() || typeClass.isInterface() || typeClass.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructors = typeClass.getDeclaredConstructors();
        int i = 0;
        while (i < constructors.length) {
            int modifiers = constructors[i].getModifiers();
            if (!Modifier.isPrivate(modifiers)) {
                return null;
            }
            ++i;
        }
        Field[] typeFields = typeClass.getDeclaredFields();
        boolean hasEnums = false;
        int i2 = 0;
        while (i2 < typeFields.length) {
            int modifiers = typeFields[i2].getModifiers();
            if (!Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers)) {
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                    if (typeFields[i2].getType().equals(typeClass)) {
                        hasEnums = true;
                    }
                } else {
                    return null;
                }
            }
            ++i2;
        }
        if (!hasEnums) {
            return null;
        }
        String typeTNS = this.getTargetNamespace(typeClass);
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        if (this.definedTypes.contains(typeQName = new QName(typeTNS, ClassHelper.getFlatName(typeClass)))) {
            return typeQName;
        }
        this.definedTypes.add(typeQName);
        this.debugging("    Creating enumeration type '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        String javaPrefix = this.getNamespacePrefix(schemaElement, "http://systinet.com/mapping/");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "simpleType");
        newType.setAttribute("name", typeQName.getLocalPart());
        schemaElement.appendChild(newType);
        if (this.javaMappingExtension) {
            Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
            this.createJavaTypeAppInfo(schemaElement, annotation, xsdPrefix, typeClass.getName());
            newType.appendChild(annotation);
        }
        Element elemRestr = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "restriction");
        elemRestr.setAttribute("base", xsdPrefix + "string");
        newType.appendChild(elemRestr);
        int i3 = 0;
        while (i3 < typeFields.length) {
            block18: {
                int modifiers = typeFields[i3].getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && typeFields[i3].getType().equals(typeClass)) {
                    String enumValue;
                    String enumName;
                    block17: {
                        enumName = null;
                        enumValue = null;
                        try {
                            Object enumObject = typeFields[i3].get(null);
                            enumName = typeFields[i3].getName();
                            enumValue = EnumHelper.getEnumValue(enumObject);
                            if (enumValue != null) break block17;
                            enumValue = enumName;
                        }
                        catch (Exception e) {
                            this.debugging("    Failed to introspect field " + typeClass.getName() + "." + typeFields[i3].getName() + ", ignoring...");
                            break block18;
                        }
                    }
                    Element typeEnum = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "enumeration");
                    typeEnum.setAttribute("value", enumValue);
                    if (!enumName.equals(enumValue)) {
                        typeEnum.setAttributeNS("http://systinet.com/mapping/", javaPrefix + "java-field", enumName);
                    }
                    elemRestr.appendChild(typeEnum);
                }
            }
            ++i3;
        }
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        return typeQName;
    }

    private QName mapJavaTypeChoice(ClassTypeTokenizer tokenizer, Set schemaSet) {
        QName typeQName;
        ArrayList choiceParents;
        ArrayList choiceGetters;
        ArrayList choiceFields;
        ArrayList choiceValues;
        Class typeClass = tokenizer.getTypeClass();
        if (!ChoiceHelper.decomposeChoice(typeClass, choiceValues = new ArrayList(), choiceFields = new ArrayList(), choiceGetters = new ArrayList(), choiceParents = new ArrayList())) {
            return null;
        }
        boolean choiceCanBeEmpty = false;
        try {
            choiceCanBeEmpty = ChoiceHelper.canBeEmpty(typeClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        String typeTNS = this.getTargetNamespace(typeClass);
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        if (this.definedTypes.contains(typeQName = new QName(typeTNS, ClassHelper.getFlatName(typeClass).replace('$', '_')))) {
            return typeQName;
        }
        this.definedTypes.add(typeQName);
        this.debugging("    Creating choice type '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        newType.setAttribute("name", typeQName.getLocalPart());
        this.handleAbstractType(typeClass, newType);
        schemaElement.appendChild(newType);
        if (this.javaMappingExtension) {
            Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
            this.createJavaTypeAppInfo(schemaElement, annotation, xsdPrefix, typeClass.getName());
            newType.appendChild(annotation);
        }
        Element toAppend = newType;
        Class inheritClass = ClassHelper.getSuperClass(typeClass, this.inheritanceMapping);
        if (inheritClass != null) {
            this.debugging("    Inheritance used: " + tokenizer.getClassName() + " -> " + inheritClass.getName());
            if (this.testClassInclusion(inheritClass.getName())) {
                Element complexContentEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexContent");
                newType.appendChild(complexContentEl);
                this.debugging("    { Mapping super class {");
                QName btQName = this.mapJavaType(inheritClass, false, schemaSet);
                this.debugging("    }}");
                String prefix = this.getNamespacePrefix(schemaElement, btQName.getNamespaceURI());
                this.defineImports(schemaElement, btQName.getNamespaceURI());
                Element extensionEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "extension");
                extensionEl.setAttribute("base", prefix + btQName.getLocalPart());
                complexContentEl.appendChild(extensionEl);
                toAppend = extensionEl;
            } else {
                this.debugging("    Super class '" + inheritClass.getName() + "' is forbidden");
            }
        }
        Element elemChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "choice");
        if (choiceCanBeEmpty) {
            elemChoice.setAttribute("minOccurs", "0");
        }
        toAppend.appendChild(elemChoice);
        int i = 0;
        while (i < choiceValues.size()) {
            Method method = (Method)choiceGetters.get(i);
            String name = (String)choiceValues.get(i);
            String field = (String)choiceFields.get(i);
            Class<?> choiceClass = method.getReturnType();
            QName choiceSchemaType = this.mapJavaType(choiceClass);
            String xmlns = this.getNamespacePrefix(schemaElement, choiceSchemaType.getNamespaceURI());
            String javans = this.getNamespacePrefix(schemaElement, "http://systinet.com/mapping/");
            Element element = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
            element.setAttribute("name", name);
            element.setAttribute("type", xmlns + choiceSchemaType.getLocalPart());
            if (!name.equals(field)) {
                element.setAttributeNS("http://systinet.com/mapping/", javans + "java-field", field);
            }
            elemChoice.appendChild(element);
            ++i;
        }
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        return typeQName;
    }

    /*
     * WARNING - void declaration
     */
    private QName getJavaType(Class typeClass) {
        try {
            void e;
            QName typeQName = this.typeMappingContext.getSchemaType(SignatureHelper.convertName(typeClass));
            if (typeQName != null && Constants.IREF_TYPE_QNAME.getNamespaceURI().equals(typeQName.getNamespaceURI())) {
                return this.mapJavaTypeInterref(null);
            }
            if (typeQName != null) {
                this.defineXSD(typeQName.getNamespaceURI());
            }
            return e;
        }
        catch (SchemaException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private QName mapJavaTypeInterref(ClassTypeTokenizer classTypeTokenizer) {
        boolean isIref;
        if (classTypeTokenizer != null) {
            Class typeClass = classTypeTokenizer.getTypeClass();
            isIref = !this.enableStructures ? typeClass.isInterface() : (class$java$rmi$Remote == null ? (class$java$rmi$Remote = Java2SchemaImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(typeClass);
        } else {
            isIref = true;
        }
        if (isIref) {
            if (classTypeTokenizer != null) {
                this.debugging("    Class '" + classTypeTokenizer.getTypeClass() + "' is interref");
            }
            if (this.soapEncoding == 0) {
                this.defineXSD(Constants.IREF_TYPE_QNAME.getNamespaceURI());
            } else {
                this.defineXSD(Constants.IREF_LITERAL_TYPE_QNAME.getNamespaceURI());
            }
            return Constants.IREF_TYPE_QNAME;
        }
        return null;
    }

    private QName createJavaType(ClassTypeTokenizer classTypeTokenizer, Set schemaSet) {
        QName typeQName;
        if (classTypeTokenizer == null) {
            return null;
        }
        Class typeClass = classTypeTokenizer.getTypeClass();
        String typeTNS = this.getTargetNamespace(typeClass);
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        if (this.definedTypes.contains(typeQName = new QName(typeTNS, ClassHelper.getFlatName(typeClass).replace('$', '_')))) {
            return typeQName;
        }
        this.definedTypes.add(typeQName);
        this.debugging("    Creating structure type '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        newType.setAttribute("name", typeQName.getLocalPart());
        this.handleAbstractType(typeClass, newType);
        schemaElement.appendChild(newType);
        if (this.javaMappingExtension) {
            Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
            this.createJavaTypeAppInfo(schemaElement, annotation, xsdPrefix, typeClass.getName());
            newType.appendChild(annotation);
        }
        Element toAppend = newType;
        Class inheritClass = ClassHelper.getSuperClass(typeClass, this.inheritanceMapping);
        if (inheritClass != null) {
            this.debugging("    Inheritance used: " + classTypeTokenizer.getClassName() + " -> " + inheritClass.getName());
            if (this.testClassInclusion(inheritClass.getName())) {
                Element complexContentEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexContent");
                newType.appendChild(complexContentEl);
                this.debugging("    { Mapping super class {");
                QName btQName = this.mapJavaType(inheritClass, false, schemaSet);
                this.debugging("    }}");
                String prefix = this.getNamespacePrefix(schemaElement, btQName.getNamespaceURI());
                this.defineImports(schemaElement, btQName.getNamespaceURI());
                Element extensionEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "extension");
                extensionEl.setAttribute("base", prefix + btQName.getLocalPart());
                complexContentEl.appendChild(extensionEl);
                toAppend = extensionEl;
            } else {
                this.debugging("    Super class '" + inheritClass.getName() + "' is forbidden");
            }
        }
        Element newTypeSQ = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        toAppend.appendChild(newTypeSQ);
        Map mappedProps = Collections.EMPTY_MAP;
        Map inheritProps = Collections.EMPTY_MAP;
        try {
            mappedProps = typeClass.isInterface() ? WaspSerializationHelper.getProperties(typeClass, true) : WaspSerializationHelper.getProperties(typeClass, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (inheritClass != null) {
                inheritProps = WaspSerializationHelper.getProperties(inheritClass);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator<Object> iterator = null;
        if (this.sortingFields) {
            TreeSet sortedSet = new TreeSet(FieldComparator.newInstance());
            sortedSet.addAll(mappedProps.keySet());
            iterator = sortedSet.iterator();
        } else {
            iterator = mappedProps.keySet().iterator();
        }
        while (iterator.hasNext()) {
            String propName = (String)iterator.next();
            if (inheritProps.containsKey(propName)) continue;
            Object obj = mappedProps.get(propName);
            Class<?> propType = null;
            if (obj == null) continue;
            if (obj instanceof Field) {
                propType = ((Field)obj).getType();
            } else if (obj instanceof PropertyDescriptor) {
                PropertyDescriptor pd = (PropertyDescriptor)obj;
                if (pd.getReadMethod() == null || pd.getWriteMethod() == null) {
                    log.warn("Property '" + pd.getName() + "' in the class '" + typeClass.getName() + "' has no corresponding" + (pd.getReadMethod() == null ? " read ('getter')" : " write ('setter')") + " method! Class should follow the JavaBeans pattern to prevent the problems during (de)serialization.");
                }
                propType = pd.getPropertyType();
            }
            if (propType == null) continue;
            this.debugging("    { Mapping property {");
            QName propQName = this.mapJavaType(propType, false, schemaSet);
            this.debugging("    }}");
            this.defineImports(schemaElement, propQName.getNamespaceURI());
            Element propEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
            propEl.setAttribute("name", propName);
            if (this.soapEncoding != 1 || !"http://www.w3.org/2001/XMLSchema".equals(propQName.getNamespaceURI()) || !"anyType".equals(propQName.getLocalPart())) {
                String prefix = this.getNamespacePrefix(schemaElement, propQName.getNamespaceURI());
                propEl.setAttribute("type", prefix + propQName.getLocalPart());
            }
            if (propType == null || !propType.isPrimitive()) {
                if (this.useNillable) {
                    propEl.setAttribute("nillable", "true");
                } else {
                    propEl.setAttribute("minOccurs", "0");
                    propEl.setAttribute("maxOccurs", "1");
                }
            }
            newTypeSQ.appendChild(propEl);
        }
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        return typeQName;
    }

    private QName createJavaTypeException(ClassTypeTokenizer classTypeTokenizer, Set schemaSet) {
        Class typeClass;
        if (classTypeTokenizer == null) {
            return null;
        }
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = Java2SchemaImpl.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(typeClass = classTypeTokenizer.getTypeClass())) {
            return null;
        }
        String typeName = typeClass.getName();
        if (typeName.startsWith("java.") || typeName.startsWith("javax.") || typeName.startsWith("com.sun.")) {
            this.debugging("     Mapping to " + XSD_ANY_TYPE + " (standard Java exception)");
            return XSD_ANY_TYPE;
        }
        Class inheritClass = ClassHelper.getSuperClass(typeClass, this.inheritanceMapping);
        Map mappedProps = Collections.EMPTY_MAP;
        try {
            mappedProps = WaspSerializationHelper.getProperties(typeClass, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        Map inheritProps = Collections.EMPTY_MAP;
        try {
            if (inheritClass != null) {
                inheritProps = WaspSerializationHelper.getProperties(inheritClass);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator mappedPropsIt = mappedProps.keySet().iterator();
        while (mappedPropsIt.hasNext()) {
            Class<?> propType;
            PropertyDescriptor pDesc;
            Object obj;
            String propertyName = (String)mappedPropsIt.next();
            if (inheritProps.containsKey(propertyName) || (obj = mappedProps.get(propertyName)) == null || !(obj instanceof PropertyDescriptor) || (pDesc = (PropertyDescriptor)obj).getReadMethod() == null || (propType = pDesc.getPropertyType()) == null || !(class$java$lang$Throwable == null ? Java2SchemaImpl.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(propType)) continue;
            this.debugging("     Mapping to " + XSD_ANY_TYPE + " (contains nested throwable accessible by getter " + pDesc.getReadMethod().getName() + ")");
            return XSD_ANY_TYPE;
        }
        String typeTNS = this.getTargetNamespace(typeClass);
        QName typeQName = new QName(typeTNS, ClassHelper.getFlatName(typeClass).replace('$', '_'));
        if (this.definedTypes.contains(typeQName)) {
            return typeQName;
        }
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        this.definedTypes.add(typeQName);
        this.debugging("    Creating structure type '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        newType.setAttribute("name", typeQName.getLocalPart());
        this.handleAbstractType(typeClass, newType);
        schemaElement.appendChild(newType);
        if (this.javaMappingExtension) {
            Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
            this.createJavaTypeAppInfo(schemaElement, annotation, xsdPrefix, typeClass.getName());
            newType.appendChild(annotation);
        }
        Element toAppend = newType;
        if (inheritClass != null) {
            this.debugging("    Inheritance used: " + classTypeTokenizer.getClassName() + " -> " + inheritClass.getName());
            if (this.testClassInclusion(inheritClass.getName())) {
                Element complexContentEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexContent");
                newType.appendChild(complexContentEl);
                this.debugging("    { Mapping super class {");
                QName btQName = this.mapJavaType(inheritClass, false, schemaSet);
                this.debugging("    }}");
                String prefix = this.getNamespacePrefix(schemaElement, btQName.getNamespaceURI());
                this.defineImports(schemaElement, btQName.getNamespaceURI());
                Element extensionEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "extension");
                extensionEl.setAttribute("base", prefix + btQName.getLocalPart());
                complexContentEl.appendChild(extensionEl);
                toAppend = extensionEl;
            } else {
                this.debugging("    Super class '" + inheritClass.getName() + "' is forbidden");
            }
        }
        Element newTypeSQ = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        toAppend.appendChild(newTypeSQ);
        Iterator<Object> iterator = null;
        if (this.sortingFields) {
            TreeSet sortedSet = new TreeSet(FieldComparator.newInstance());
            sortedSet.addAll(mappedProps.keySet());
            iterator = sortedSet.iterator();
        } else {
            iterator = mappedProps.keySet().iterator();
        }
        if ((class$java$lang$Exception == null ? (class$java$lang$Exception = Java2SchemaImpl.class$("java.lang.Exception")) : class$java$lang$Exception).equals(inheritClass)) {
            Element propEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
            propEl.setAttribute("name", "message");
            propEl.setAttribute("type", "xsd:string");
            if (this.useNillable) {
                propEl.setAttribute("nillable", "true");
            } else {
                propEl.setAttribute("minOccurs", "0");
                propEl.setAttribute("maxOccurs", "1");
            }
            newTypeSQ.appendChild(propEl);
        }
        while (iterator.hasNext()) {
            String propName = (String)iterator.next();
            if (inheritProps.containsKey(propName)) continue;
            Object obj = mappedProps.get(propName);
            Class<?> propType = null;
            if (obj == null || obj instanceof Field) continue;
            if (obj instanceof PropertyDescriptor) {
                propType = ((PropertyDescriptor)obj).getPropertyType();
            }
            if (propType == null) continue;
            this.debugging("    { Mapping property {");
            QName propQName = this.mapJavaType(propType, false, schemaSet);
            this.debugging("    }}");
            this.defineImports(schemaElement, propQName.getNamespaceURI());
            Element propEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
            propEl.setAttribute("name", propName);
            if (this.soapEncoding != 1 || !"http://www.w3.org/2001/XMLSchema".equals(propQName.getNamespaceURI()) || !"anyType".equals(propQName.getLocalPart())) {
                String prefix = this.getNamespacePrefix(schemaElement, propQName.getNamespaceURI());
                propEl.setAttribute("type", prefix + propQName.getLocalPart());
            }
            if (propType == null || !propType.isPrimitive()) {
                if (this.useNillable) {
                    propEl.setAttribute("nillable", "true");
                } else {
                    propEl.setAttribute("minOccurs", "0");
                    propEl.setAttribute("maxOccurs", "1");
                }
            }
            newTypeSQ.appendChild(propEl);
        }
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        return typeQName;
    }

    private void createJavaTypeAppInfo(Element schema, Element annotation, String xsdPrefix, String className) {
        Element appInfo = annotation.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "appinfo");
        String javaPrefix = this.getNamespacePrefix(schema, "http://systinet.com/mapping/");
        Element javaType = annotation.getOwnerDocument().createElementNS("http://systinet.com/mapping/", javaPrefix + "java-type");
        javaType.setAttribute("name", className);
        appInfo.appendChild(javaType);
        annotation.appendChild(appInfo);
    }

    private QName createLiteralJavaTypeArray(QName typeQName, ClassTypeTokenizer classTypeTokenizer, Set schemaSet) {
        if (classTypeTokenizer.getArrayDimensionsCount() <= 0) {
            return typeQName;
        }
        Class typeClass = classTypeTokenizer.getTypeClass();
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        QName arrayQName = typeQName;
        String targetNamespace = this.getSchemaNamespace(schemaElement);
        int dims = 1;
        while (dims <= classTypeTokenizer.getArrayDimensionsCount()) {
            QName newArrayQName = new QName(targetNamespace, "ArrayOf" + arrayQName.getLocalPart());
            if (this.definedTypes.contains(newArrayQName)) {
                arrayQName = newArrayQName;
            } else {
                this.definedTypes.add(newArrayQName);
                this.debugging("    Creating array type: '" + newArrayQName + "'");
                this.createLiteralSchemaArrayType(typeClass, arrayQName, schemaElement, newArrayQName, dims);
                arrayQName = newArrayQName;
            }
            ++dims;
        }
        return arrayQName;
    }

    private void createLiteralSchemaArrayType(Class typeClass, QName typeName, Element schemaElem, QName newTypeName, int dimensions) {
        String xsdPrefix = this.getNamespacePrefix(schemaElem, "http://www.w3.org/2001/XMLSchema");
        Element complexType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        complexType.setAttribute("name", newTypeName.getLocalPart());
        schemaElem.appendChild(complexType);
        if (this.javaMappingExtension) {
            StringBuffer annotatedType = new StringBuffer();
            int i = 1;
            while (i < dimensions) {
                annotatedType.append('[');
                ++i;
            }
            annotatedType.append(Array.newInstance(typeClass, 0).getClass().getName());
            Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "annotation");
            this.createJavaTypeAppInfo(schemaElem, annotation, xsdPrefix, annotatedType.toString());
            complexType.appendChild(annotation);
        }
        Element sequence = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        complexType.appendChild(sequence);
        Element element = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        element.setAttribute("minOccurs", "0");
        element.setAttribute("maxOccurs", "unbounded");
        element.setAttribute("name", typeName.getLocalPart());
        if (this.soapEncoding != 1 || !"http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI()) || !"anyType".equals(typeName.getLocalPart())) {
            String prefix = this.getNamespacePrefix(schemaElem, typeName.getNamespaceURI());
            element.setAttribute("type", prefix + typeName.getLocalPart());
        }
        if (typeClass == null || !typeClass.isPrimitive()) {
            if (this.useNillable) {
                element.setAttribute("nillable", "true");
            } else {
                element.setAttribute("minOccurs", "0");
                element.setAttribute("maxOccurs", "unbounded");
            }
        }
        sequence.appendChild(element);
        this.debugging("newType: '" + complexType.toString() + "' name='" + complexType.getAttribute("name") + "'");
    }

    private QName createEncodedJavaTypeMultiArray(QName typeQName, ClassTypeTokenizer classTypeTokenizer, Set schemaSet) {
        if (classTypeTokenizer.getArrayDimensionsCount() <= 0) {
            return typeQName;
        }
        Class typeClass = classTypeTokenizer.getTypeClass();
        Element schemaElement = this.getSchemaElement(typeClass);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        int arrayDimensionsCount = classTypeTokenizer.getArrayDimensionsCount();
        String arrayOfPrefix = classTypeTokenizer.getArrayOfPrefix();
        String arrayTNS = this.getSchemaNamespace(schemaElement);
        QName arrayQName = new QName(arrayTNS, arrayOfPrefix + typeQName.getLocalPart());
        if (this.definedTypes.contains(arrayQName)) {
            return arrayQName;
        }
        this.definedTypes.add(arrayQName);
        this.debugging("    Creating multi-array type: '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        String wsdlPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/wsdl/");
        String soapEncPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/soap/encoding/");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        newType.setAttribute("name", arrayQName.getLocalPart());
        schemaElement.appendChild(newType);
        Element newTypeCC = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexContent");
        newType.appendChild(newTypeCC);
        Element newTypeRE = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "restriction");
        newTypeRE.setAttribute("base", soapEncPrefix + "Array");
        newTypeCC.appendChild(newTypeRE);
        Element newTypeSQ = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        newTypeRE.appendChild(newTypeSQ);
        String prefix = this.getNamespacePrefix(schemaElement, typeQName.getNamespaceURI());
        Element elEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        elEl.setAttribute("name", "item");
        elEl.setAttribute("type", prefix + typeQName.getLocalPart());
        if (typeClass == null || !typeClass.isPrimitive()) {
            elEl.setAttribute("nillable", "true");
        }
        elEl.setAttribute("minOccurs", "0");
        elEl.setAttribute("maxOccurs", "unbounded");
        newTypeSQ.appendChild(elEl);
        Element attrEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "attribute");
        attrEl.setAttribute("ref", soapEncPrefix + "arrayType");
        StringBuffer arrayType = new StringBuffer();
        arrayType.append(prefix + typeQName.getLocalPart() + "[");
        int aa = 0;
        while (aa < arrayDimensionsCount - 1) {
            arrayType.append(",");
            ++aa;
        }
        arrayType.append("]");
        attrEl.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", wsdlPrefix + "arrayType", arrayType.toString());
        newTypeRE.appendChild(attrEl);
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        return arrayQName;
    }

    private QName createEncodedJavaTypeSingleArray(QName typeQName, ClassTypeTokenizer classTypeTokenizer, Set schemaSet) {
        if (classTypeTokenizer.getArrayDimensionsCount() <= 0) {
            return typeQName;
        }
        Class typeClass = classTypeTokenizer.getTypeClass();
        Element schemaElement = this.getSchemaElement(typeClass);
        String arrayTNS = this.getSchemaNamespace(schemaElement);
        if (schemaSet != null) {
            schemaSet.add(schemaElement);
        }
        return this.createEncodedJavaTypeSingleArray0(typeQName, typeClass, schemaElement, arrayTNS, 1, classTypeTokenizer.getArrayDimensionsCount());
    }

    private QName createEncodedJavaTypeSingleArray0(QName typeQName, Class typeClass, Element schemaElement, String arrayTNS, int dimension, int arrayDimension) {
        QName arrayQName = new QName(arrayTNS, "ArrayOf" + typeQName.getLocalPart());
        if (this.definedTypes.contains(arrayQName)) {
            if (dimension < arrayDimension) {
                return this.createEncodedJavaTypeSingleArray0(arrayQName, null, schemaElement, arrayTNS, dimension + 1, arrayDimension);
            }
            return arrayQName;
        }
        this.definedTypes.add(arrayQName);
        this.debugging("    Creating single-array type: '" + typeQName + "'");
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        String wsdlPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/wsdl/");
        String soapEncPrefix = this.getNamespacePrefix(schemaElement, "http://schemas.xmlsoap.org/soap/encoding/");
        Element newType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        newType.setAttribute("name", arrayQName.getLocalPart());
        schemaElement.appendChild(newType);
        Element newTypeCC = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexContent");
        newType.appendChild(newTypeCC);
        Element newTypeRE = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "restriction");
        newTypeRE.setAttribute("base", soapEncPrefix + "Array");
        newTypeCC.appendChild(newTypeRE);
        Element newTypeSQ = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        newTypeRE.appendChild(newTypeSQ);
        String prefix = this.getNamespacePrefix(schemaElement, typeQName.getNamespaceURI());
        Element elEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        elEl.setAttribute("name", "item");
        elEl.setAttribute("type", prefix + typeQName.getLocalPart());
        if (typeClass == null || !typeClass.isPrimitive()) {
            elEl.setAttribute("nillable", "true");
        }
        elEl.setAttribute("minOccurs", "0");
        elEl.setAttribute("maxOccurs", "unbounded");
        newTypeSQ.appendChild(elEl);
        Element attrEl = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "attribute");
        attrEl.setAttribute("ref", soapEncPrefix + "arrayType");
        attrEl.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", wsdlPrefix + "arrayType", prefix + typeQName.getLocalPart() + "[]");
        newTypeRE.appendChild(attrEl);
        this.debugging("    newType: '" + newType.toString() + "' name='" + newType.getAttribute("name") + "'");
        if (dimension < arrayDimension) {
            return this.createEncodedJavaTypeSingleArray0(arrayQName, null, schemaElement, arrayTNS, dimension + 1, arrayDimension);
        }
        return arrayQName;
    }

    public QName createRequestWrapper(QName name, MethodInfo methodInfo) {
        Element schemaElement = this.getSchemaElementTNS(name.getNamespaceURI());
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element wrapper = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        wrapper.setAttribute("name", name.getLocalPart());
        Element complexType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        Element sequence = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        int i = 0;
        while (i < methodInfo.getParameterTypes().length) {
            if (methodInfo.getParameterDirection(i) != 2) {
                boolean isNillable;
                QName typeName = this.mapJavaType(methodInfo.getParameterTypes()[i]);
                Element el = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
                String ns = this.getNamespacePrefix(schemaElement, typeName.getNamespaceURI());
                el.setAttribute("name", methodInfo.getParameterNames()[i]);
                el.setAttribute("type", ns + typeName.getLocalPart());
                boolean bl = isNillable = methodInfo.getParameterTypes()[i] == null || !methodInfo.getParameterTypes()[i].isPrimitive();
                if (isNillable) {
                    if (this.useNillable) {
                        el.setAttribute("nillable", "true");
                    } else {
                        el.setAttribute("minOccurs", "0");
                        el.setAttribute("maxOccurs", "1");
                    }
                }
                sequence.appendChild(el);
            }
            ++i;
        }
        wrapper.appendChild(complexType);
        complexType.appendChild(sequence);
        schemaElement.appendChild(wrapper);
        return new QName(name.getNamespaceURI(), wrapper.getAttribute("name"));
    }

    public QName createResponseWrapper(QName name, MethodInfo methodInfo) {
        Element schemaElement = this.getSchemaElementTNS(name.getNamespaceURI());
        String xsdPrefix = this.getNamespacePrefix(schemaElement, "http://www.w3.org/2001/XMLSchema");
        Element wrapper = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
        wrapper.setAttribute("name", name.getLocalPart());
        Element complexType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "complexType");
        Element sequence = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "sequence");
        if (methodInfo.getReturnValueType() != Void.TYPE) {
            boolean isNillable;
            QName typeName = this.mapJavaType(methodInfo.getReturnValueType());
            Element el = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
            String ns = this.getNamespacePrefix(schemaElement, typeName.getNamespaceURI());
            el.setAttribute("name", "response");
            el.setAttribute("type", ns + typeName.getLocalPart());
            boolean bl = isNillable = methodInfo.getReturnValueType() == null || !methodInfo.getReturnValueType().isPrimitive();
            if (isNillable) {
                if (this.useNillable) {
                    el.setAttribute("nillable", "true");
                } else {
                    el.setAttribute("minOccurs", "0");
                    el.setAttribute("maxOccurs", "1");
                }
            }
            sequence.appendChild(el);
        }
        int i = 0;
        while (i < methodInfo.getParameterTypes().length) {
            if (methodInfo.getParameterDirection(i) != 1) {
                boolean isNillable;
                QName typeName = this.mapJavaType(methodInfo.getParameterTypes()[i]);
                Element el = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + "element");
                String ns = this.getNamespacePrefix(schemaElement, typeName.getNamespaceURI());
                el.setAttribute("name", methodInfo.getParameterNames()[i]);
                el.setAttribute("type", ns + typeName.getLocalPart());
                boolean bl = isNillable = methodInfo.getParameterTypes()[i] == null || !methodInfo.getParameterTypes()[i].isPrimitive();
                if (isNillable) {
                    el.setAttribute("nillable", "true");
                }
                sequence.appendChild(el);
            }
            ++i;
        }
        wrapper.appendChild(complexType);
        complexType.appendChild(sequence);
        schemaElement.appendChild(wrapper);
        return new QName(name.getNamespaceURI(), wrapper.getAttribute("name"));
    }

    private final void debugging(String message) {
        if (this.verbose > 0) {
            if (message.length() >= this.verbose) {
                message = message.substring(0, this.verbose) + "...";
            }
            System.err.println(message);
        }
    }

    public void setUseNillable(boolean b) {
        this.useNillable = b;
    }

    public boolean isUseNillable() {
        return this.useNillable;
    }

    private void handleAbstractType(Class type, Element complexTypeElement) {
        if (Modifier.isAbstract(type.getModifiers())) {
            complexTypeElement.setAttribute("abstract", "true");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Cannot instantiate DocumentBuilderFactory: ", e);
        }
        excludedClassesDefault = UtilFactory.getSet(23);
        includedClassesDefault = UtilFactory.getSet(23);
        encodedSchemasToInclude = UtilFactory.getMap(17);
        literalSchemasToInclude = UtilFactory.getMap(17);
        Configurator configurator = (Configurator)Context.getInstance(class$org$idoox$config$Configurator == null ? (class$org$idoox$config$Configurator = Java2SchemaImpl.class$("org.idoox.config.Configurator")) : class$org$idoox$config$Configurator);
        Configurable[] configurables = Configurator.getTopEntries("java2Type");
        int i = 0;
        while (i < configurables.length) {
            Java2TypeConfig.XmlSchemaFile[] xmlSchema;
            int j;
            Configurable configurable = configurables[i];
            Java2TypeConfig j2tCfg = (Java2TypeConfig)configurable.narrow(class$com$idoox$wasp$tools$common$Java2TypeConfig == null ? Java2SchemaImpl.class$("com.idoox.wasp.tools.common.Java2TypeConfig") : class$com$idoox$wasp$tools$common$Java2TypeConfig);
            String[] classes = j2tCfg.getExcludedClasses();
            if (classes != null) {
                j = 0;
                while (j < classes.length) {
                    excludedClassesDefault.add(classes[j]);
                    ++j;
                }
            }
            if ((classes = j2tCfg.getIncludedClasses()) != null) {
                j = 0;
                while (j < classes.length) {
                    includedClassesDefault.add(classes[j]);
                    ++j;
                }
            }
            if ((xmlSchema = j2tCfg.getInternalSchemas()) != null) {
                int j2 = 0;
                while (j2 < xmlSchema.length) {
                    List schemaFiles;
                    String use = xmlSchema[j2].getUse();
                    String targetNamespace = xmlSchema[j2].getTargetNamespace();
                    String fileName = xmlSchema[j2].getFileName();
                    if (use == null || "encoded".equals(use) || "*".equals(use)) {
                        schemaFiles = (List)encodedSchemasToInclude.get(targetNamespace);
                        if (schemaFiles == null) {
                            schemaFiles = UtilFactory.getList(5);
                            encodedSchemasToInclude.put(targetNamespace, schemaFiles);
                        }
                        schemaFiles.add(fileName);
                    }
                    if (use == null || "literal".equals(use) || "*".equals(use)) {
                        schemaFiles = (List)literalSchemasToInclude.get(targetNamespace);
                        if (schemaFiles == null) {
                            schemaFiles = UtilFactory.getList(5);
                            literalSchemasToInclude.put(targetNamespace, schemaFiles);
                        }
                        schemaFiles.add(fileName);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        excludedClassesDefault = Collections.unmodifiableSet(excludedClassesDefault);
        includedClassesDefault = Collections.unmodifiableSet(includedClassesDefault);
        XSD_ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    }
}

