/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.tools.common.util;

import com.idoox.debug.Category;
import com.idoox.util.ClassInfo;
import com.idoox.util.JavaTool;
import com.idoox.util.SignatureHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ClassHelper {
    private static final Category log = Category.getCategory("com.idoox.wasp.tools.common.util.ClassHelper");
    static /* synthetic */ Class class$java$lang$Object;

    public static String getPackage(Class cls) {
        return ClassHelper.getPackage(cls.getName());
    }

    public static String getPackage(String className) {
        int id = className.lastIndexOf(".");
        return id > 0 ? className.substring(0, id) : "";
    }

    public static String getFlatName(Class cls) {
        return ClassHelper.getFlatName(cls.getName());
    }

    public static String getFlatName(String className) {
        int id = className.lastIndexOf(".");
        return id > 0 ? className.substring(id + 1) : className;
    }

    public static String getMethodName(String signature) {
        int dot = signature.lastIndexOf(".");
        int bracket = signature.indexOf("(");
        return dot > 0 ? signature.substring(dot + 1, bracket) : signature.substring(0, bracket);
    }

    public static String getArgumentsAsString(String signature) {
        int bracket1 = signature.lastIndexOf("(");
        int bracket2 = signature.indexOf(")");
        return signature.substring(bracket1 + 1, bracket2);
    }

    public static List getPackagesForTargetNamespaceURI(Map packageNamespaceMap, String targetNamespaceURI) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator keyI = packageNamespaceMap.keySet().iterator();
        while (keyI.hasNext()) {
            String packageName = (String)keyI.next();
            if (!targetNamespaceURI.equals((String)packageNamespaceMap.get(packageName))) continue;
            ret.add(packageName);
        }
        return ret;
    }

    public static String getClassUID(Class clazz) {
        return clazz.getName() + Integer.toHexString(clazz.hashCode()).toUpperCase();
    }

    public static String getClassNameFromMethodSignature(String methodSignature) {
        methodSignature = methodSignature.substring(0, methodSignature.indexOf(40));
        methodSignature = methodSignature.substring(0, methodSignature.lastIndexOf(46));
        return methodSignature;
    }

    public static String getDefaultTargetNamespace(Class clazz) {
        return ClassHelper.getDefaultTargetNamespace(ClassHelper.getPackage(clazz));
    }

    public static String getDefaultTargetNamespace(String packageName) {
        if (packageName == null || "".equals(packageName)) {
            return "http://systinet.com/wsdl/";
        }
        return "http://systinet.com/wsdl/" + packageName.replace('.', '/') + "/";
    }

    public static Class getClassForName(String className) {
        return ClassHelper.getClassForName(null, className);
    }

    public static Class getClassForName(ClassLoader userClassLoader, String className) {
        try {
            if (userClassLoader == null) {
                return Class.forName(className);
            }
            return Class.forName(className, true, userClassLoader);
        }
        catch (Exception e) {
            log.error("Exception thrown during class lookup: " + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
    }

    public static ClassInfo sourceIntrospection(Class toProcess, ClassLoader classLoader) {
        try {
            return JavaTool.getClassInfo(toProcess, classLoader);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static Class getSuperClass(Class clazz, Map inheritanceMapping) {
        String inherit = (String)inheritanceMapping.get(clazz.getName());
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> inheritClass = null;
        if (inherit != null) {
            inheritClass = ClassHelper.getClassForName(classLoader, inherit);
            if (inheritClass == null) {
                throw new RuntimeException("Inherit class " + inherit + " cannot be found!");
            }
            if (!inheritClass.isAssignableFrom(clazz)) {
                throw new RuntimeException("The specified inherit class " + inherit + " is not assignable from " + clazz.getName());
            }
        } else {
            inheritClass = clazz.getSuperclass();
            Class<?>[] ifaces = clazz.getInterfaces();
            if (inheritClass == (class$java$lang$Object == null ? (class$java$lang$Object = ClassHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                inheritClass = null;
            }
            if (inheritClass == null && ifaces != null && ifaces.length == 1) {
                inheritClass = ifaces[0];
            }
        }
        return inheritClass;
    }

    public static String[] getSuperMethods(Class clazz, Method method) {
        ArrayList<String> signatures = new ArrayList<String>();
        Stack superiors = new Stack();
        superiors.push(clazz);
        while (!superiors.isEmpty()) {
            clazz = (Class)superiors.pop();
            if (clazz == null) continue;
            superiors.push(clazz.getSuperclass());
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                superiors.push(interfaces[i]);
                ++i;
            }
            try {
                Method superMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                String superSignature = clazz.getName() + "." + superMethod.getName() + SignatureHelper.getSignature(superMethod);
                signatures.add(superSignature);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return signatures.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

