/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.debug.Category;
import com.idoox.soap.ProcedureNotPresentException;
import com.idoox.util.SignatureHelper;
import com.idoox.wasp.PortTypeMappingRegistry;
import com.idoox.wasp.SOAPServiceInfoCache;
import com.idoox.wasp.WSDLSchemas;
import com.idoox.wasp.WSDLServiceInfo;
import com.idoox.wasp.server.ServiceRegistry;
import com.idoox.wasp.server.adaptor.InstanceSelector;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.idoox.wasp.server.config.WSDLConfig;
import com.idoox.wasp.tools.wsdl2java.java.OperationMapping;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.idoox.transport.URI;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.wasp.wsdl.WSDLRepository;
import org.idoox.xml.schema.SchemaException;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wsdl.extensions.java.JavaOperation;

public final class RPCInstanceSelector
implements InstanceSelector {
    private static final Category cat = Category.getCategory("com.idoox.wasp.server.adaptor.RPCInstanceSelector");
    SOAPServiceInfo serviceInfo;
    SOAPMethodInfo methodInfo;
    SOAPPortInfo portInfo;
    Method method;
    Object service;
    String instanceID;
    String serializationId;
    WSRegistry registry;
    Map serviceData;
    ServiceBindingConfig cfg;
    QName methodQName;
    CallContext callContext;
    OperationMapping[] mappings;
    boolean unwrapped = true;
    ServiceEndpointImpl serviceEndpoint;
    String soapAction;
    private PortTypeMappingRegistry irepo = (PortTypeMappingRegistry)Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
    private WSDLRepository wsdlRepo = (WSDLRepository)Context.getInstance("org.idoox.wasp.wsdl.WSDLRepository");
    private static final String PORT_INFO_MAP = "wasp.RPCInstanceSelector.portInfoMap";
    private static final String WRAPPED = "wrapped.invocation";
    private static final String WRAPPED_SERVICE = "wrapped.invocation.service";
    private static Map signatures = new HashMap();
    static /* synthetic */ Class class$org$idoox$wasp$types$AsyncReturn;
    static /* synthetic */ Class class$java$lang$Void;

    public void init(WSRegistry registry, String instanceID, URI serviceURI, ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = (ServiceEndpointImpl)serviceEndpoint;
        this.instanceID = instanceID;
        this.registry = registry;
        this.serviceData = this.serviceEndpoint.getContext().getContextData();
        this.cfg = this.serviceEndpoint.getServiceBindingConfig();
        this.callContext = Current.getCallContext();
        this.methodInfo = null;
        this.serializationId = this.serviceEndpoint.getSerializationID();
        try {
            this.initializeService(serviceEndpoint);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public boolean selectMethodBySOAPAction(String soapAction, String xmlProtocol) throws SchemaException {
        this.soapAction = soapAction;
        if (soapAction == null) {
            return false;
        }
        if (this.instanceID == null) {
            // empty if block
        }
        if (!this.processSOAPAction(soapAction, xmlProtocol)) {
            this.soapAction = null;
            return false;
        }
        return true;
    }

    public Object createService() throws Exception {
        if (this.portInfo != null) {
            ServiceInstanceImpl si = ((ServiceRegistry)this.registry).getServiceInstance();
            return si.createInstanceForPortType(this.portInfo.getPortTypeQName(), this.registry);
        }
        return null;
    }

    public boolean selectMethodByFirstElement(String firstElemNamespaceURI, String firstElemLocalPart, String xmlProtocol) throws Exception {
        if (this.instanceID == null) {
            // empty if block
        }
        this.processPort(firstElemNamespaceURI, firstElemLocalPart, xmlProtocol);
        return true;
    }

    public SOAPMethodInfo getMethodInfo() throws Exception {
        if (this.methodInfo == null) {
            this.prepareMethod();
        }
        return this.methodInfo;
    }

    public Method getMethod() throws Exception {
        if (this.method == null) {
            this.prepareMethod();
        }
        return this.method;
    }

    private void prepareMethodInfo() throws Exception {
        if (this.methodInfo == null) {
            if (this.soapAction != null) {
                this.methodInfo = this.portInfo.getMethodInfo(this.serializationId, this.soapAction, this.unwrapped);
                if (this.methodInfo != null) {
                    this.portInfo.prepareSchema(this.serializationId, this.methodInfo.requestMessageEncodingURI);
                    return;
                }
            }
            this.methodInfo = this.portInfo.getMethodInfo(this.serializationId, this.methodQName, this.unwrapped);
            if (this.methodInfo == null) {
                throw new ProcedureNotPresentException("No method info for input message " + this.methodQName);
            }
        }
    }

    protected static String getSignature(Method method) {
        Map map = signatures;
        synchronized (map) {
            String signature = (String)signatures.get(method);
            if (signature == null) {
                signature = SignatureHelper.getSignature(method);
                signatures.put(method, signature);
            }
            String string = signature;
            return string;
        }
    }

    private OperationMapping getOperationMapping(SOAPMethodInfo methodInfo, OperationMapping[] mappings) {
        if (mappings != null) {
            int i = 0;
            while (i < mappings.length) {
                String opName = mappings[i].wsdlOperationName;
                String inName = mappings[i].wsdlInputName;
                String outName = mappings[i].wsdlOutputName;
                if (opName.equals(methodInfo.operationName) && (inName == null || inName.equals(methodInfo.inputName)) && (outName == null || outName.equals(methodInfo.outputName))) {
                    if (mappings[i].faults != null) {
                        int j = 0;
                        while (j < mappings[i].faults.length) {
                            methodInfo.addFault(mappings[i].faults[j].name, mappings[i].faults[j].javaType);
                            ++j;
                        }
                    }
                    return mappings[i];
                }
                ++i;
            }
        }
        if (methodInfo.signature != null) {
            return new OperationMapping(methodInfo.operationName, methodInfo.inputName, methodInfo.outputName, methodInfo.javaMethodName, methodInfo.signature, null);
        }
        int methodNamePos = -1;
        String encodedSignature = null;
        if (this.soapAction != null) {
            methodNamePos = this.soapAction.indexOf(35);
            encodedSignature = this.soapAction;
        }
        if (methodNamePos == -1) {
            String requestNamespaceURI = methodInfo.requestName.getNamespaceURI();
            methodNamePos = requestNamespaceURI.indexOf(35);
            encodedSignature = requestNamespaceURI;
        }
        if (methodNamePos >= 0) {
            int signaturePos = encodedSignature.indexOf(63, methodNamePos + 1);
            if (signaturePos == -1) {
                signaturePos = encodedSignature.indexOf(35, methodNamePos + 1);
            }
            if (signaturePos >= 0) {
                String methodName = encodedSignature.substring(methodNamePos + 1, signaturePos);
                String signature = encodedSignature.substring(signaturePos + 1);
                try {
                    signature = new String(Base64.decode(signature.getBytes("US-ASCII")), "US-ASCII");
                    return new OperationMapping(methodInfo.operationName, methodInfo.inputName, methodInfo.outputName, methodName, signature, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void prepareMethod() throws Exception {
        this.prepareMethodInfo();
        Map serviceMethods = this.serviceEndpoint.getServiceMethods();
        Method[] methods = (Method[])serviceMethods.get(this.service.getClass());
        if (methods == null) {
            methods = this.service.getClass().getMethods();
            serviceMethods.put(this.service.getClass(), methods);
        }
        boolean noSoapAction = true;
        String signature = null;
        String methodName = null;
        if (this.methodInfo != null) {
            OperationMapping mapping = this.getOperationMapping(this.methodInfo, this.mappings);
            if (mapping != null) {
                signature = mapping.javaMethodSignature;
                methodName = mapping.javaMethodName;
            } else {
                signature = this.methodInfo.signature;
                methodName = this.methodInfo.javaMethodName;
            }
        }
        if (signature != null && signature.length() > 0) {
            int methodIndex = -1;
            int i = 0;
            while (i < methods.length) {
                String sig = RPCInstanceSelector.getSignature(methods[i]);
                if (sig.equals(signature) && methods[i].getName().equals(methodName)) {
                    methodIndex = i;
                    break;
                }
                ++i;
            }
            if (methodIndex >= 0) {
                this.method = methods[methodIndex];
                noSoapAction = false;
            }
        }
        if (noSoapAction) {
            int methodIndex = -1;
            int miParamCount = 0;
            if (this.methodInfo.parts != null) {
                miParamCount = this.methodInfo.parts.length;
            }
            int i = 0;
            while (i < methods.length) {
                Class<?>[] paramTypes = methods[i].getParameterTypes();
                int paramCount = 0;
                if (paramTypes != null) {
                    paramCount = paramTypes.length > 0 && (class$org$idoox$wasp$types$AsyncReturn == null ? RPCInstanceSelector.class$("org.idoox.wasp.types.AsyncReturn") : class$org$idoox$wasp$types$AsyncReturn).isAssignableFrom(paramTypes[0]) ? paramTypes.length - 1 : paramTypes.length;
                }
                if (methods[i].getName().equals(this.methodInfo.operationName) && (paramCount == miParamCount || paramCount == miParamCount - 1 && this.methodInfo.returnValuePart == null && !methods[i].getReturnType().equals(class$java$lang$Void == null ? RPCInstanceSelector.class$("java.lang.Void") : class$java$lang$Void))) {
                    methodIndex = i;
                    break;
                }
                ++i;
            }
            if (methodIndex < 0) {
                throw new ProcedureNotPresentException("Method not found: method info " + this.methodInfo + " in service " + this.service.getClass().getName() + ", instanceID : " + this.instanceID);
            }
            this.method = methods[methodIndex];
        }
    }

    public Object getService() throws Exception {
        return this.service;
    }

    public void setService(Object service) {
        this.service = service;
    }

    public SOAPServiceInfo getServiceInfo() throws Exception {
        return this.serviceInfo;
    }

    public SOAPPortInfo getPortInfo() throws Exception {
        return this.portInfo;
    }

    public boolean isDocumentStyle() throws Exception {
        if (this.method == null) {
            this.prepareMethod();
        }
        return !this.methodInfo.rpcOperation;
    }

    private boolean processSOAPAction(String soapAction, String xmlProtocol) {
        QName serviceQName = this.serviceInfo.getServiceQName();
        Map portInfoMap = (Map)this.serviceData.get(PORT_INFO_MAP);
        this.portInfo = (SOAPPortInfo)portInfoMap.get(new PortInfoMapKey(serviceQName, xmlProtocol, soapAction));
        if (this.portInfo == null) {
            return false;
        }
        if (this.service == null) {
            ServiceInstanceImpl si = ((ServiceRegistry)this.registry).getServiceInstance();
            this.service = si.getInstanceForPortType(this.portInfo.getPortTypeQName(), this.registry);
        }
        return true;
    }

    private void processPort(String firstElemNamespaceURI, String firstElemLocalPart, String xmlProtocol) throws ProcedureNotPresentException, SchemaException, WSDLException {
        QName serviceQName = this.serviceInfo.getServiceQName();
        if (firstElemLocalPart != null) {
            this.methodQName = new QName(firstElemNamespaceURI, firstElemLocalPart);
            Map portInfoMap = (Map)this.serviceData.get(PORT_INFO_MAP);
            this.portInfo = (SOAPPortInfo)portInfoMap.get(new PortInfoMapKey(serviceQName, xmlProtocol, null, this.methodQName));
            if (this.portInfo == null) {
                this.portInfo = (SOAPPortInfo)portInfoMap.get(new PortInfoMapKey(serviceQName, xmlProtocol, this.methodQName, null));
            }
        } else {
            this.portInfo = null;
            this.methodQName = null;
        }
        if (this.portInfo == null) {
            this.findOperationByFirstParam(this.serviceInfo, this.methodQName);
            if (this.portInfo == null) {
                throw new ProcedureNotPresentException("No WSDL:Port has been found for the SOAP operation {" + firstElemNamespaceURI + "} " + firstElemLocalPart + ", service " + serviceQName);
            }
        }
        if (this.portInfo != null && this.methodInfo != null) {
            this.portInfo.prepareSchema(this.serializationId, this.methodInfo.requestMessageEncodingURI);
        }
        if (this.service == null) {
            ServiceInstanceImpl si = ((ServiceRegistry)this.registry).getServiceInstance();
            this.service = si.getInstanceForPortType(this.portInfo.getPortTypeQName(), this.registry);
        }
    }

    private void findOperationByFirstParam(SOAPServiceInfo serviceInfo, QName paramQName) throws WSDLException, SchemaException {
        SOAPPortInfo[] pinfos = serviceInfo.getPortInfos();
        int i = 0;
        while (i < pinfos.length) {
            SOAPMethodInfo[] methodInfos = pinfos[i].getMethodInfos(this.serializationId, this.unwrapped);
            int j = 0;
            while (j < methodInfos.length) {
                if (!methodInfos[j].rpcOperation && this.containsParameter(methodInfos[j], paramQName)) {
                    this.portInfo = pinfos[i];
                    this.methodInfo = methodInfos[j];
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean containsParameter(SOAPMethodInfo methodInfo, QName paramName) {
        if (paramName == null) {
            int argPos = 0;
            while (argPos < methodInfo.parts.length) {
                if (methodInfo.parts[argPos].partType != 2) {
                    return false;
                }
                ++argPos;
            }
            return true;
        }
        int argPos = 0;
        while (argPos < methodInfo.parts.length) {
            if (methodInfo.parts[argPos].inSchemaElement != null ? paramName.equals(methodInfo.parts[argPos].inSchemaElement.getName()) : paramName.getLocalPart().equals(methodInfo.parts[argPos].partName)) {
                return true;
            }
            ++argPos;
        }
        return false;
    }

    private void initializeService(ServiceEndpoint serviceEndpoint) throws SchemaException, WSDLException {
        HashMap<QName, SOAPServiceInfo> serviceInfoMap = null;
        String irepoConfigName = null;
        ServiceBindingConfig serviceBindingConfig = this.cfg;
        synchronized (serviceBindingConfig) {
            Map map = this.serviceData;
            synchronized (map) {
                serviceInfoMap = (HashMap<QName, SOAPServiceInfo>)this.serviceData.get("wasp.service.info.map");
                if (serviceInfoMap == null) {
                    serviceInfoMap = new HashMap<QName, SOAPServiceInfo>();
                    this.serviceData.put("wasp.service.info.map", serviceInfoMap);
                    this.serviceData.put(PORT_INFO_MAP, new HashMap());
                    this.serviceInfo = this.getBaseServiceInfo(serviceEndpoint);
                    serviceInfoMap.put(null, this.serviceInfo);
                    this.processServiceInfo(this.serviceInfo);
                }
                irepoConfigName = (String)this.serviceData.get("wasp.JavaAdaptor.PortTypeMappingRegistryConfig");
            }
            if (this.instanceID != null) {
                this.service = this.registry.getService(this.instanceID);
                if (this.service == null && this.serviceEndpoint.isAutomaticallyInstantiated()) {
                    this.callContext.getContextData().put(org.idoox.webservice.CallContext.INVALID_INSTANCE_ID_KEY, this.instanceID);
                    throw new RuntimeException("unknown/expired instance ID called: " + this.instanceID);
                }
                QName serviceQName = null;
                if (this.service != null) {
                    Class<?> serviceClass = this.service.getClass();
                    serviceQName = this.irepo.getServiceForClass(irepoConfigName, serviceClass);
                }
                if (serviceQName != null) {
                    this.serviceInfo = (SOAPServiceInfo)serviceInfoMap.get(serviceQName);
                    if (this.serviceInfo == null) {
                        WSDLRepository.ServiceInfo repoService = this.wsdlRepo.findService(serviceQName);
                        if (repoService != null) {
                            this.serviceInfo = new WSDLServiceInfo(repoService.getDefinition(), repoService.getService(), new WSDLSchemas(repoService.getDefinition()));
                            Map map2 = this.serviceData;
                            synchronized (map2) {
                                serviceInfoMap.put(serviceQName, this.serviceInfo);
                                this.processServiceInfo(this.serviceInfo);
                            }
                        }
                        Map map3 = this.serviceData;
                        synchronized (map3) {
                            this.serviceInfo = (SOAPServiceInfo)serviceInfoMap.get(null);
                            serviceInfoMap.put(serviceQName, this.serviceInfo);
                        }
                    }
                }
            }
            if (this.serviceInfo == null) {
                this.serviceInfo = (SOAPServiceInfo)serviceInfoMap.get(null);
            }
        }
    }

    private SOAPServiceInfo getBaseServiceInfo(ServiceEndpoint serviceEndpoint) {
        try {
            WSDLConfig wsdlConfig = this.cfg.getWsdl();
            Definition def = serviceEndpoint.getWSDL();
            SOAPServiceInfo[] services = SOAPServiceInfoCache.getServiceInfos(def);
            QName serviceName = wsdlConfig.getService();
            if (serviceName == null) {
                throw new RuntimeException("Config does not contain wsdl service name for : " + this.cfg.getName());
            }
            int i = 0;
            while (i < services.length) {
                if (serviceName.equals(services[i].getServiceQName())) {
                    return services[i];
                }
                ++i;
            }
            throw new RuntimeException("Undefined wsdl service : " + serviceName + " for service : " + this.cfg.getName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Error during parsing wsdl of " + this.cfg.getName(), e);
        }
    }

    private void processServiceInfo(SOAPServiceInfo serviceInfo) throws SchemaException, WSDLException {
        QName serviceQName = serviceInfo.getServiceQName();
        Map portInfoMap = (Map)this.serviceData.get(PORT_INFO_MAP);
        SOAPPortInfo[] ports = serviceInfo.getPortInfos();
        int it = 0;
        while (it < ports.length) {
            SOAPPortInfo portInfo = ports[it];
            String portName = portInfo.getPortName();
            String protocol = portInfo.getProtocol();
            ArrayList<PortInfoMapKey> removeFromPortInfoMap = new ArrayList<PortInfoMapKey>();
            SOAPMethodInfo[] methods = portInfo.getMethodInfos(this.serializationId, this.unwrapped);
            int methodIt = 0;
            while (methodIt < methods.length) {
                SOAPMethodInfo methodInfo = methods[methodIt];
                portInfo.prepareSchema(this.serializationId, methodInfo.requestMessageEncodingURI);
                QName requestQName = methodInfo.requestName;
                String soapAction = methodInfo.soapAction;
                QName wrapperQName = methodInfo.inWrapperQName;
                PortInfoMapKey key = new PortInfoMapKey(serviceQName, protocol, requestQName, null);
                SOAPPortInfo previous = portInfoMap.put(key, portInfo);
                if (previous != null) {
                    removeFromPortInfoMap.add(key);
                }
                if ((previous = portInfoMap.put(key = new PortInfoMapKey(serviceQName, protocol, null, wrapperQName), portInfo)) != null) {
                    removeFromPortInfoMap.add(key);
                }
                if (soapAction != null && !soapAction.equals("") && !soapAction.equals("\"\"") && (previous = portInfoMap.put(key = new PortInfoMapKey(serviceQName, protocol, soapAction), portInfo)) != null) {
                    removeFromPortInfoMap.add(key);
                }
                ++methodIt;
            }
            Iterator it1 = removeFromPortInfoMap.iterator();
            while (it1.hasNext()) {
                portInfoMap.remove(it1.next());
            }
            ++it;
        }
    }

    public void setOperationMapping(OperationMapping[] mappings, boolean unwrapped) {
        this.mappings = mappings;
        this.unwrapped = unwrapped;
    }

    public boolean isUnwrapped(ServiceEndpoint endpoint, String instanceId, WSRegistry registry, CallContext callContext) {
        Definition wsdl = null;
        Boolean wr = (Boolean)endpoint.getContext().getContextData().get(WRAPPED);
        this.service = endpoint.getContext().getContextData().get(WRAPPED_SERVICE);
        if (wr != null) {
            return wr;
        }
        wsdl = endpoint.getWSDL();
        this.service = registry.getService(null);
        endpoint.getContext().getContextData().put(WRAPPED_SERVICE, this.service);
        wr = new Boolean(RPCInstanceSelector.shouldUnwrap(wsdl));
        endpoint.getContext().getContextData().put(WRAPPED, wr);
        return wr;
    }

    private static boolean shouldUnwrap(Definition def) {
        Map bindings = def.getBindings();
        Iterator bindingsIt = bindings.values().iterator();
        while (bindingsIt.hasNext()) {
            Binding binding = (Binding)bindingsIt.next();
            boolean soap = false;
            Iterator bindingExtElIt = binding.getExtensibilityElements().iterator();
            while (bindingExtElIt.hasNext()) {
                ExtensibilityElement bindingExtEl = (ExtensibilityElement)bindingExtElIt.next();
                if (!(bindingExtEl instanceof SOAPBinding)) continue;
                soap = true;
            }
            if (!soap) continue;
            Iterator bindingOpIt = binding.getBindingOperations().iterator();
            while (bindingOpIt.hasNext()) {
                BindingOperation bindingOp = (BindingOperation)bindingOpIt.next();
                Iterator bindingOpExElIt = bindingOp.getExtensibilityElements().iterator();
                while (bindingOpExElIt.hasNext()) {
                    JavaOperation javaOp;
                    ExtensibilityElement extEl = (ExtensibilityElement)bindingOpExElIt.next();
                    if (!(extEl instanceof JavaOperation) || !Boolean.TRUE.equals((javaOp = (JavaOperation)extEl).isUnwrapped())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PortInfoMapKey {
        QName serviceQName;
        String xmlProtocol;
        String soapAction;
        QName requestQName;
        QName wrappingQName;

        public PortInfoMapKey(QName serviceQName, String xmlProtocol, String soapAction) {
            this.serviceQName = serviceQName;
            this.xmlProtocol = xmlProtocol;
            this.soapAction = soapAction;
        }

        public PortInfoMapKey(QName serviceQName, String xmlProtocol, QName requestQName, QName wrappingQName) {
            this.serviceQName = serviceQName;
            this.xmlProtocol = xmlProtocol;
            this.requestQName = requestQName;
            this.wrappingQName = wrappingQName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PortInfoMapKey) {
                PortInfoMapKey key2 = (PortInfoMapKey)obj;
                return PortInfoMapKey.compare(this.serviceQName, key2.serviceQName) && PortInfoMapKey.compare(this.xmlProtocol, key2.xmlProtocol) && PortInfoMapKey.compare(this.soapAction, key2.soapAction) && PortInfoMapKey.compare(this.requestQName, key2.requestQName) && PortInfoMapKey.compare(this.wrappingQName, key2.wrappingQName);
            }
            return false;
        }

        private static final boolean compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }

        public int hashCode() {
            return (this.serviceQName == null ? 0 : this.serviceQName.hashCode()) ^ (this.xmlProtocol == null ? 0 : this.xmlProtocol.hashCode()) ^ (this.soapAction == null ? 0 : this.soapAction.hashCode()) ^ (this.requestQName == null ? 0 : this.requestQName.hashCode()) ^ (this.wrappingQName == null ? 0 : this.wrappingQName.hashCode());
        }
    }
}

