/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.wasp.server.adaptor.InstanceNumberLimitor;
import org.idoox.wasp.server.adaptor.InstanceCountLimitor;
import org.idoox.webservice.server.LifeCycleController;
import org.idoox.webservice.server.LifeCycleService;

public class InstanceNumberLimitorImpl
implements InstanceNumberLimitor,
InstanceCountLimitor,
LifeCycleController {
    private LifeCycleController oldLCC = null;
    private int maxInstances = 0;
    private int currentInstances = 0;
    private final Object LOCK = new Object();

    public void init(int maxInstances) {
        this.setMaxInstances(maxInstances);
    }

    public void setMaxInstances(int max) {
        Object object = this.LOCK;
        synchronized (object) {
            this.maxInstances = max > 0 ? max : 0;
        }
    }

    public int getMaxInstances() {
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.maxInstances == 0 ? -1 : this.maxInstances;
            return n;
        }
    }

    public int getCurrentInstances() {
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.currentInstances;
            return n;
        }
    }

    public void registerAsLifecycleController(LifeCycleService lcs) {
        this.oldLCC = lcs.registerLifeCycleController(this);
        if (this.oldLCC != null && this.oldLCC.equals(this)) {
            this.oldLCC = null;
        }
    }

    public final Object getObjectAccessLock() {
        return this.LOCK;
    }

    public boolean canCreateInstance() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = this.maxInstances == 0 || this.currentInstances < this.maxInstances;
            return bl;
        }
    }

    public void serviceRegistered(Object service) {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.currentInstances;
        }
        if (this.oldLCC != null) {
            this.oldLCC.serviceRegistered(service);
        }
    }

    public long serviceToBeDeregistered(Object service) {
        long retval = 0L;
        if (this.oldLCC != null) {
            retval = this.oldLCC.serviceToBeDeregistered(service);
        }
        if (retval <= 0L) {
            Object object = this.LOCK;
            synchronized (object) {
                --this.currentInstances;
            }
        }
        return retval;
    }
}

