/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.wasp.ProcessingConfigurationImpl;
import com.idoox.wasp.ProtocolRepositoryImpl;
import com.idoox.wasp.server.WSContextImpl;
import com.idoox.xmlrpc.header.HeaderProcessorChain;
import java.util.List;
import java.util.Map;
import org.idoox.wasp.Context;
import org.idoox.wasp.ProtocolHandler;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.server.ServiceMediator;
import org.idoox.wasp.server.config.ServiceEndpointConfiguration;

public class WSServiceConfigurationImpl
extends ProcessingConfigurationImpl
implements ServiceEndpointConfiguration {
    private static final Category log = Category.getCategory("com.idoox.wasp.server.WSServiceConfigurationImpl");
    private ProtocolRepositoryImpl pRepo;
    private WSContextImpl context;
    private Map contextMap;
    public static final String PROTOCOL_HANDLER_INSTANCE_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.protocolHandlerInstance";
    public static final String SERVICE_HEADERS_NAME_WSCONTEXT_KEY = "core.handler.processing.id";
    public static final String SERVICE_TRANSPORT_INTERCEPTORS_NAME_WSCONTEXT_KEY = "core.processing.interceptors_id";
    public static final String SERVICE_SERIALIZATION_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.serializationID";
    public static final String SERVICE_ENCODING_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.encoding";
    public static final String SERVICE_ENCODINGID_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.encodingID";
    public static final String SERVICE_FAULTSERIALIZATION_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.faultSerializationID";
    public static final String SERVICE_DO_MULTIREFS_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.doMultirefs";
    public static final String SERVICE_NO_INSTANCE_IDS_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.noInstanceIDs";
    public static final String SERVICE_DO_POLYMORPHISM_WSCONTEXT_KEY = "com.idoox.wasp.server.WSServiceConfigurationImpl.doPolymorphism";
    private static final ServiceMediator[] EMPTY_SM_ARRAY = new ServiceMediator[0];

    public WSServiceConfigurationImpl(WSContextImpl wsctxt) {
        this.context = wsctxt;
        this.contextMap = this.context.getContextData();
        try {
            this.pRepo = (ProtocolRepositoryImpl)Context.getInstance("org.idoox.wasp.ProtocolRepository");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported repository implementation! (" + e.getMessage() + ")");
        }
    }

    public String getSerializationID(boolean create) {
        String retval = (String)this.contextMap.get(SERVICE_SERIALIZATION_WSCONTEXT_KEY);
        if (retval == null && create) {
            retval = this.sRepo.createSerialization();
            this.contextMap.put(SERVICE_SERIALIZATION_WSCONTEXT_KEY, retval);
        }
        return retval;
    }

    public String getFaultID(boolean create) {
        String retval = (String)this.contextMap.get(SERVICE_FAULTSERIALIZATION_WSCONTEXT_KEY);
        if (retval == null && create) {
            retval = this.sRepo.createFaultSerialization();
            this.contextMap.put(SERVICE_FAULTSERIALIZATION_WSCONTEXT_KEY, retval);
        }
        return retval;
    }

    public String getHeadersID(boolean create) {
        String retval = (String)this.contextMap.get(SERVICE_HEADERS_NAME_WSCONTEXT_KEY);
        if (create) {
            HeaderProcessorChain hpChain = this.hpRepo.getIncomingHeaderProcessors(retval);
            if (retval == null || hpChain == null) {
                retval = this.hpRepo.createHeaders();
                this.contextMap.put(SERVICE_HEADERS_NAME_WSCONTEXT_KEY, retval);
            }
        }
        return retval;
    }

    public String getInterceptorsID(boolean create) {
        String retval = (String)this.contextMap.get(SERVICE_TRANSPORT_INTERCEPTORS_NAME_WSCONTEXT_KEY);
        InterceptorChain iChain = this.iRepo.getChain(retval);
        if (iChain == null) {
            retval = this.iRepo.createTransportInterceptorChain();
            this.contextMap.put(SERVICE_TRANSPORT_INTERCEPTORS_NAME_WSCONTEXT_KEY, retval);
        }
        return retval;
    }

    public boolean isInitConfigUsed() {
        return true;
    }

    public void setDefaultProtocol(String protocolName) {
        if (this.isInitConfigUsed()) {
            throw new IllegalStateException("cannot set protocol, this configuration has already been used and should be changed no more");
        }
        ProtocolHandler pHandler = this.pRepo.getProtocolHandler(protocolName);
        if (pHandler == null) {
            throw new IllegalArgumentException("No such protocol: " + protocolName);
        }
        this.contextMap.put(PROTOCOL_HANDLER_INSTANCE_WSCONTEXT_KEY, pHandler);
    }

    public String getDefaultProtocol() {
        ProtocolHandler pHandler = (ProtocolHandler)this.contextMap.get(PROTOCOL_HANDLER_INSTANCE_WSCONTEXT_KEY);
        try {
            return this.pRepo.getProtocolHandlerName(pHandler);
        }
        catch (Exception e) {
            log.error("Error getting the name of default protocol handler", e);
            return null;
        }
    }

    public boolean isMultirefsEnabled() {
        Boolean val = (Boolean)this.contextMap.get(SERVICE_DO_MULTIREFS_WSCONTEXT_KEY);
        if (val == null) {
            return true;
        }
        return val;
    }

    public void setMultirefsEnabled(boolean value) {
        if (value) {
            this.contextMap.put(SERVICE_DO_MULTIREFS_WSCONTEXT_KEY, Boolean.TRUE);
        } else {
            this.contextMap.put(SERVICE_DO_MULTIREFS_WSCONTEXT_KEY, Boolean.FALSE);
        }
    }

    public boolean isPolymorphismEnabled() {
        Boolean val = (Boolean)this.contextMap.get(SERVICE_DO_POLYMORPHISM_WSCONTEXT_KEY);
        if (val == null) {
            return true;
        }
        return val;
    }

    public void setPolymorphismEnabled(boolean value) {
        if (value) {
            this.contextMap.put(SERVICE_DO_POLYMORPHISM_WSCONTEXT_KEY, Boolean.TRUE);
        } else {
            this.contextMap.put(SERVICE_DO_POLYMORPHISM_WSCONTEXT_KEY, Boolean.FALSE);
        }
    }

    public boolean isInstanceIDEnabled() {
        return this.contextMap.containsKey(SERVICE_NO_INSTANCE_IDS_WSCONTEXT_KEY);
    }

    public void setInstanceIDEnabled(boolean value) {
        if (value) {
            this.contextMap.put(SERVICE_NO_INSTANCE_IDS_WSCONTEXT_KEY, Boolean.TRUE);
        } else {
            this.contextMap.remove(SERVICE_NO_INSTANCE_IDS_WSCONTEXT_KEY);
        }
    }

    public boolean isPortTypeMappingPassingEnabled() {
        Boolean val = (Boolean)this.contextMap.get("wasp.service.NoPTMappingPassing");
        if (val == null) {
            return true;
        }
        return val == false;
    }

    public void setPortTypeMappingPassingEnabled(boolean value) {
        if (value) {
            this.contextMap.put("wasp.service.NoPTMappingPassing", Boolean.TRUE);
        } else {
            this.contextMap.remove(SERVICE_NO_INSTANCE_IDS_WSCONTEXT_KEY);
        }
    }

    public ServiceMediator[] getMediators() {
        List meds = this.context.getMediators();
        if (meds == null) {
            return EMPTY_SM_ARRAY;
        }
        return meds.toArray(EMPTY_SM_ARRAY);
    }

    public void addMediator(ServiceMediator mediator) {
        this.context.addMediator(mediator);
    }

    public void removeMediator(ServiceMediator mediator) {
        this.context.removeMediator(mediator);
    }
}

