/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.wasp.server.config.ConnectorConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.idoox.config.Configurable;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Module;
import org.systinet.wasp.Wasp;

public class Connector
implements Module,
PropertyChangeListener {
    private static final Category log = Category.getCategory("com.idoox.wasp.server.Connector");
    private static int CLIENT_SOCKET_TIMEOUT = 60000;
    private static int SERVER_SOCKET_TIMEOUT = 500;
    private static byte SIGNAL_SHUTDOWN = (byte)107;
    private static byte SIGNAL_KILL = (byte)108;
    private int port = -1;
    private Configurable config;
    private ServerSocket server;
    private Thread serverThread;
    private boolean listening = true;
    private static final String PROPERTY_CONNECTOR_DISABLE_SHUTDOWN = "wasp.connector.disable.shutdown";
    private boolean disableShutdownSocket = false;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ConnectorConfig;

    public void load(Configurable c) {
        try {
            String s = System.getProperty(PROPERTY_CONNECTOR_DISABLE_SHUTDOWN, "false");
            if ("true".equalsIgnoreCase(s)) {
                this.disableShutdownSocket = true;
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        ConnectorConfig config = (ConnectorConfig)c.narrow(class$com$idoox$wasp$server$config$ConnectorConfig == null ? (class$com$idoox$wasp$server$config$ConnectorConfig = Connector.class$("com.idoox.wasp.server.config.ConnectorConfig")) : class$com$idoox$wasp$server$config$ConnectorConfig);
        try {
            this.port = config.getPort();
        }
        catch (Exception e) {
            log.warn("Config does not contain server port for connector " + c.getName());
            this.port = -1;
        }
        c.addPropertyChangeListener(this);
        this.config = c;
    }

    public void init() {
        this.start();
    }

    public void destroy() {
        this.stop();
        this.port = -1;
        if (this.config != null) {
            this.config.removePropertyChangeListener(this);
            this.config = null;
        }
    }

    private void start() {
        if (this.disableShutdownSocket) {
            return;
        }
        if (this.port <= 0) {
            return;
        }
        if (this.server != null) {
            this.stop();
        }
        try {
            log.info("Starting connector server on port " + this.port);
            this.server = new ServerSocket(this.port);
            this.server.setSoTimeout(SERVER_SOCKET_TIMEOUT);
            this.serverThread = new ServerThread();
            this.serverThread.setDaemon(true);
            this.serverThread.start();
        }
        catch (BindException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Error occurred while attempting to bind a socket to a local address and port ");
            sb.append(this.port);
            sb.append(".\nProbably, the port ");
            sb.append(this.port);
            sb.append(" is in use, or the requested local address could not be assigned. ");
            sb.append("\nPlease check if another instance of Systinet Server or another program is using this port.");
            sb.append("\nTo change the port numbers used by Systinet Server please edit Systinet Server configuration file.");
            throw new RuntimeWrappedException(sb.toString(), e);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private void stop() {
        if (this.disableShutdownSocket) {
            return;
        }
        try {
            log.info("Stopping connector server");
            this.listening = false;
            if (this.serverThread != null) {
                this.serverThread.interrupt();
            }
            if (this.serverThread != null) {
                try {
                    this.serverThread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.serverThread = null;
            }
            this.server = null;
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private void shutdown() {
        Thread destroyThread = new Thread(){

            public void run() {
                Wasp.destroy();
            }
        };
        destroyThread.setDaemon(false);
        destroyThread.start();
    }

    private void kill() {
        log.info("Hard kill server NOW.");
        Runtime.getRuntime().halt(-1);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("port")) {
            int port = -1;
            if (event.getNewValue() == null) {
                log.warn("Config does not contain server port for " + this.config.getName());
                port = -1;
            } else {
                port = (Integer)event.getNewValue();
            }
            if (this.port > 0 && this.port != port) {
                this.stop();
            }
            if (port > 0 && this.port != port) {
                this.start();
            }
            this.port = port;
        }
    }

    static /* synthetic */ ServerSocket access$000(Connector x0) {
        return x0.server;
    }

    static /* synthetic */ boolean access$100(Connector x0) {
        return x0.listening;
    }

    static /* synthetic */ int access$200() {
        return CLIENT_SOCKET_TIMEOUT;
    }

    static /* synthetic */ byte access$300() {
        return SIGNAL_SHUTDOWN;
    }

    static /* synthetic */ ServerSocket access$002(Connector x0, ServerSocket x1) {
        x0.server = x1;
        return x0.server;
    }

    static /* synthetic */ void access$400(Connector x0) {
        x0.shutdown();
    }

    static /* synthetic */ boolean access$102(Connector x0, boolean x1) {
        x0.listening = x1;
        return x0.listening;
    }

    static /* synthetic */ byte access$500() {
        return SIGNAL_KILL;
    }

    static /* synthetic */ void access$600(Connector x0) {
        x0.kill();
    }

    static /* synthetic */ Category access$700() {
        return log;
    }

    static /* synthetic */ Thread access$802(Connector x0, Thread x1) {
        x0.serverThread = x1;
        return x0.serverThread;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ServerThread
    extends Thread {
        private ServerSocket serverSocket;

        public ServerThread() {
            super("WaspConnector");
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            this.serverSocket = Connector.access$000(Connector.this);
            if (this.serverSocket != null) ** GOTO lbl35
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    socket = this.serverSocket.accept();
                    if (socket == null) continue;
                    if (!socket.getInetAddress().equals(InetAddress.getLocalHost())) {
                        socket.close();
                        continue;
                    }
                    socket.setSoTimeout(Connector.access$200());
                    try {
                        signal = socket.getInputStream().read();
                        if (signal == Connector.access$300()) {
                            Connector.access$002(Connector.this, null);
                            Connector.access$400(Connector.this);
                            Connector.access$102(Connector.this, false);
                        } else if (signal == Connector.access$500()) {
                            Connector.access$002(Connector.this, null);
                            Connector.access$600(Connector.this);
                            Connector.access$102(Connector.this, false);
                        }
                    }
                    catch (InterruptedIOException e) {
                        // empty catch block
                    }
                    socket.close();
                    continue;
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                catch (IOException e) {
                    Connector.access$700().error("Error during accepting new socket", e);
                }
lbl35:
                // 6 sources

                ** while (Connector.access$100((Connector)Connector.this))
            }
lbl36:
            // 1 sources

            try {
                this.serverSocket.close();
                Connector.access$002(Connector.this, null);
                Connector.access$802(Connector.this, null);
            }
            catch (IOException e) {
                Connector.access$700().error("Error during closing server socket", e);
            }
        }
    }
}

