/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.xmlrpc.encoding.EncodingRepository;
import java.io.IOException;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;

public class XMLEncSerializerWrapper
implements XMLSerializer {
    EncodingTokenWriter encWriter = null;
    Serializer serializer;
    EncodingRepository repo;
    String encodingID;
    String encodingURI;

    public XMLEncSerializerWrapper(EncodingRepository repo, Serializer serializer, String encodingID, String encodingURI) {
        this.serializer = serializer;
        this.repo = repo;
        this.encodingID = encodingID;
        this.encodingURI = encodingURI;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            this.encWriter = this.repo.getEncodingTokenWriter(this.encodingID, this.encodingURI);
            this.encWriter.setTokenWriter(dataWriter);
            this.serializer.serialize(this.encWriter, data, null, context, next);
            this.encWriter.flush();
            this.repo.releaseEncodingTokenWriter(this.encodingID, this.encodingURI, this.encWriter);
            this.encWriter = null;
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
        catch (NoSuchEncodingException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        this.serializer.grabReferences(data, context, next);
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

