/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.wsdl;

import com.idoox.wasp.serialization.MultirefHandler;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.serialization.TypeSerializationHelper;
import com.idoox.wasp.serialization.wsdl.SchemaHandler;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.PostSerializationHandler;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.wasp.types.MessageAttachment;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;

public final class WSDLSerializationContext
extends MultirefHandler
implements SerializationContext {
    private TypeSerializationHelper typeHelper;
    private String serializationID;
    private String encodingURI;
    private SerializationRepositoryImpl serializationRepository;
    private List attachments;
    private SchemaHandler schemaHandler = new SchemaHandler();
    private int repositoryVersion = -1;
    ArrayList handlers;

    public void init(SerializationRepositoryImpl repository, String serializationID, String encodingURI) {
        this.schemaHandler.init();
        if (this.handlers != null) {
            this.handlers.clear();
        }
        this.attachments = null;
        this.clearMultirefs();
        if (serializationID == this.serializationID && encodingURI == this.encodingURI && this.repositoryVersion == repository.getVersion()) {
            return;
        }
        this.repositoryVersion = repository.getVersion();
        this.serializationRepository = repository;
        this.serializationID = serializationID;
        this.encodingURI = encodingURI;
        this.typeHelper = new TypeSerializationHelper();
        this.typeHelper.init(serializationID, "java", this.serializationRepository, encodingURI);
    }

    public void clear() {
        this.schemaHandler.init();
        if (this.handlers != null) {
            this.handlers.clear();
        }
        this.attachments = null;
        this.clearMultirefs();
    }

    public String getAttachmentMimeType(String className) {
        return this.serializationRepository.getAttachmentMimeType(className, this.serializationID, this.encodingURI);
    }

    public String getAttachmentClassName(String mimeType) {
        return this.serializationRepository.getAttachmentClassName(mimeType, this.serializationID, this.encodingURI);
    }

    public Type getSchemaType(QName typeName) throws SchemaException {
        return XMLSchemaUtil.getSchemaType(this.schemaHandler.getSchema(), typeName);
    }

    public QName getSchemaType(String progLangType) throws SchemaException {
        return this.typeHelper.getSchemaType(progLangType);
    }

    public SerializationChain getSerializationChain(Class serializedClass) {
        SerializationChain ret = this.serializationRepository.getSerializationChain(this.serializationID, this.encodingURI, serializedClass, this.getCurrentConstructSchemaType());
        if (SerializationHelper.dcat.isDebugEnabled()) {
            SerializationHelper.dcat.debug("serializer for type " + this.getCurrentConstructSchemaType() + ",\n              serializedClass " + serializedClass + ",\n              id " + this.serializationID + " : " + ret.toString() + "\n               in " + this.toString());
        }
        return ret;
    }

    public void releaseSerializationChain(SerializationChain chain) {
        this.serializationRepository.releaseSerializationChain(chain);
    }

    public XMLSerializer getXMLSerializer(Class serializedClass) {
        SerializationChain serChain = this.getSerializationChain(serializedClass);
        XMLSerializer ret = null;
        if (serChain.hasMoreSerializers()) {
            ret = (XMLSerializer)serChain.getNextSerializerAs("systinet:xmlser/1.0");
        }
        this.releaseSerializationChain(serChain);
        return ret;
    }

    public String getSerializationID() {
        return this.serializationID;
    }

    public String getType(QName name, QName type) throws SchemaException {
        return this.typeHelper.getType(this.getSchemaType(type));
    }

    public String getType(Type type) {
        return this.typeHelper.getType(type);
    }

    public QName getSchemaType(QName name, String progLangType) throws SchemaException {
        return this.typeHelper.getSchemaType(progLangType);
    }

    public void registerAttachment(MessageAttachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        if (this.attachments.contains(attachment)) {
            return;
        }
        this.attachments.add(attachment);
    }

    public Iterator getAttachments() {
        if (this.attachments == null || this.attachments.size() == 0) {
            return null;
        }
        return Collections.unmodifiableList(this.attachments).iterator();
    }

    public Schema getSchema() {
        return this.schemaHandler.getSchema();
    }

    public void setSchema(Schema schema, boolean useSchemaTypeMapping) {
        this.schemaHandler.setSchema(schema);
        this.typeHelper.setSchema(schema, useSchemaTypeMapping);
    }

    public SchemaContext.State putMember(Member member) {
        return this.schemaHandler.putMember(member);
    }

    public SchemaContext.State putSchemaConstruct(SchemaConstruct construct) {
        return this.schemaHandler.putSchemaConstruct(construct);
    }

    public SchemaContext.State enterCurrentMember() {
        return this.schemaHandler.enterCurrentMember();
    }

    public void leave(SchemaContext.State state) {
        this.schemaHandler.leave(state);
    }

    public Member getCurrentMember() {
        return this.schemaHandler.getCurrentMember();
    }

    public SchemaConstruct getCurrentSchemaConstruct() {
        return this.schemaHandler.getCurrentSchemaConstruct();
    }

    public Type getCurrentConstructSchemaType() {
        return this.schemaHandler.getCurrentConstructSchemaType();
    }

    public QName getCurrentConstructName() {
        return this.schemaHandler.getCurrentConstructName();
    }

    public SchemaConstruct.ConstructType getCurrentConstructType() {
        return this.schemaHandler.getCurrentConstructType();
    }

    public Member nextMember() {
        return this.schemaHandler.nextMember();
    }

    public SchemaConstruct nextSchemaConstruct() {
        return this.schemaHandler.nextSchemaConstruct();
    }

    public SchemaConstruct nextSchemaConstruct(String namespaceURI, String localPart) {
        return this.schemaHandler.nextSchemaConstruct(namespaceURI, localPart);
    }

    public void replaceTopMember(QName name, Type type) {
        this.schemaHandler.replaceTopMember(name, type);
    }

    public Type replaceTopMemberType(Type newType) {
        return this.schemaHandler.replaceTopMemberType(newType);
    }

    public boolean typeOfCurrentConstructReplaced() {
        return this.schemaHandler.typeOfCurrentConstructReplaced();
    }

    public Type getOriginalType() {
        return this.schemaHandler.getOriginalType();
    }

    public boolean isCurrentConstructArray() {
        return this.schemaHandler.isCurrentConstructArray();
    }

    public void registerPostSerializationHandler(PostSerializationHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public void unregisterPostSerializationHandler(PostSerializationHandler handler) {
        if (this.handlers == null) {
            return;
        }
        ((AbstractCollection)this.handlers).remove(handler);
    }

    public Iterator getPostSerializationHandlers() {
        if (this.handlers == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return ((AbstractList)this.handlers).iterator();
    }

    public void replaceTopSchemaConstruct(SchemaConstruct referencedConstruct) {
        this.schemaHandler.replaceTopSchemaConstruct(referencedConstruct);
    }

    public void enter(QName name, QName type) {
    }

    public void leave() {
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("WSDLSerializationContext[\n");
        ret.append(this.schemaHandler.toString());
        ret.append("]");
        return ret.toString();
    }
}

