/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.wsdl;

import com.idoox.xml.schema.util.XMLSchemaUtil;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.RepeatableSchemaConstruct;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;

public final class SchemaHandler
implements SchemaContext {
    private int constructStackSize = 5;
    private SchemaConstruct[] constructStack = new SchemaConstruct[this.constructStackSize];
    private Type[] typeStack = new Type[this.constructStackSize];
    private Type[] originalTypeStack = new Type[this.constructStackSize];
    private int[] iteratorStack = new int[this.constructStackSize];
    private int[] originalIteratorStack = new int[this.constructStackSize];
    private int constructStackTop = -1;
    private int constructStackBase = -1;
    private int enterLevel = 0;
    private Schema types;
    private String encodingUri;
    private boolean typeOfCurrentConstructReplaced = false;

    public final void init() {
        this.constructStackTop = -1;
        this.enterLevel = -1;
        this.types = null;
    }

    public final void setSchema(Schema types) {
        this.constructStackTop = -1;
        this.types = types;
    }

    public final void setEncodingUri(String value) {
        this.encodingUri = value;
    }

    public final Schema getSchema() {
        return this.types;
    }

    public SchemaContext.State putMember(Member member) {
        return this.putSchemaConstruct(member);
    }

    public SchemaContext.State putSchemaConstruct(SchemaConstruct schemaConstruct) {
        this.typeOfCurrentConstructReplaced = false;
        SchemaContextState ret = new SchemaContextState(this.constructStackTop, this.enterLevel++, this.constructStackBase);
        this.assureConstructStackSize();
        this.constructStack[++this.constructStackTop] = SchemaHandler.flatReference(schemaConstruct);
        this.originalTypeStack[this.constructStackTop] = null;
        this.typeStack[this.constructStackTop] = null;
        this.iteratorStack[this.constructStackTop] = 0;
        if (this.constructStackBase >= 0 && this.originalIteratorStack[this.constructStackBase] < 0) {
            this.originalIteratorStack[this.constructStackBase] = this.iteratorStack[this.constructStackBase];
            this.iteratorStack[this.constructStackBase] = 0;
        }
        return ret;
    }

    public final SchemaContext.State enterCurrentMember() {
        this.typeOfCurrentConstructReplaced = false;
        if (this.constructStackBase >= 0 && this.originalIteratorStack[this.constructStackBase] < 0) {
            this.originalIteratorStack[this.constructStackBase] = this.iteratorStack[this.constructStackBase];
        }
        SchemaContextState ret = new SchemaContextState(this.constructStackTop, this.enterLevel++, this.constructStackBase);
        this.constructStackBase = this.constructStackTop;
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        Type topType = this.getCurrentConstructSchemaType();
        this.pushSubconstructsInReverseOrder(topType);
        this.assureConstructStackSize();
        ++this.constructStackTop;
        this.constructStack[this.constructStackTop] = null;
        this.typeStack[this.constructStackTop] = null;
        this.originalTypeStack[this.constructStackTop] = null;
        this.iteratorStack[this.constructStackTop] = 0;
        this.iteratorStack[this.constructStackBase] = 0;
        this.originalIteratorStack[this.constructStackBase] = -1;
        return ret;
    }

    private final void pushSubconstructsInReverseOrder(Type top) {
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(top);
        if (subconstructs != null) {
            int i = subconstructs.length - 1;
            while (i >= 0) {
                this.assureConstructStackSize();
                ++this.constructStackTop;
                SchemaConstruct construct = subconstructs[i];
                if (construct.getReferencedConstruct() != null) {
                    construct = SchemaHandler.flatReference(subconstructs, i);
                }
                this.constructStack[this.constructStackTop] = construct;
                this.typeStack[this.constructStackTop] = null;
                this.originalTypeStack[this.constructStackTop] = null;
                --i;
            }
        } else {
            Type type = new Type(null, 35, null, 1, 1);
            Type cloned = (Type)top.clone();
            cloned.setBaseType(null);
            type.setSubconstructs(new SchemaConstruct[]{top.getBaseType(), cloned});
            this.assureConstructStackSize();
            ++this.constructStackTop;
            this.constructStack[this.constructStackTop] = type;
            this.typeStack[this.constructStackTop] = null;
            this.originalTypeStack[this.constructStackTop] = null;
        }
    }

    private static final synchronized SchemaConstruct flatReference(SchemaConstruct[] constructs, int pos) {
        SchemaConstruct cloned;
        constructs[pos] = cloned = SchemaHandler.flatReference(constructs[pos]);
        return cloned;
    }

    private static final SchemaConstruct flatReference(SchemaConstruct construct) {
        SchemaConstruct referenced = construct.getReferencedConstruct();
        if (referenced == null) {
            return construct;
        }
        SchemaConstruct cloned = (SchemaConstruct)SchemaHandler.flatReference(referenced).clone();
        cloned.setJavaName(construct.getJavaName());
        if (cloned instanceof RepeatableSchemaConstruct) {
            ((RepeatableSchemaConstruct)cloned).setMinOccurs(((RepeatableSchemaConstruct)construct).getMinOccurs());
            ((RepeatableSchemaConstruct)cloned).setMaxOccurs(((RepeatableSchemaConstruct)construct).getMaxOccurs());
        }
        return cloned;
    }

    public final void leave(SchemaContext.State state) {
        this.typeOfCurrentConstructReplaced = false;
        SchemaContextState schemaContextState = (SchemaContextState)state;
        int requiredLevel = schemaContextState.enterLevel;
        if (requiredLevel != this.enterLevel - 1) {
            throw new IllegalStateException("Leaving from a bad state, " + (this.enterLevel - 1 - requiredLevel) + " leaves missing");
        }
        --this.enterLevel;
        this.constructStackTop = schemaContextState.constructStackTop;
        this.constructStackBase = schemaContextState.constructStackBase;
        if (this.constructStackBase >= 0 && this.originalIteratorStack[this.constructStackBase] >= 0) {
            this.iteratorStack[this.constructStackBase] = this.originalIteratorStack[this.constructStackBase];
            this.originalIteratorStack[this.constructStackBase] = -1;
        }
    }

    public final Member getCurrentMember() {
        SchemaConstruct construct = this.getCurrentSchemaConstruct();
        while (construct != null && construct.getConstructType() != SchemaConstruct.ConstructType.MEMBER) {
            construct = this.getCurrentSchemaConstruct();
        }
        return (Member)construct;
    }

    public SchemaConstruct getCurrentSchemaConstruct() {
        SchemaConstruct ref;
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        SchemaConstruct construct = this.constructStack[this.constructStackTop];
        if (construct == null) {
            return null;
        }
        Type type = this.typeStack[this.constructStackTop];
        if (type != null) {
            Type constructType = XMLSchemaUtil.getConstructType(construct);
            SchemaConstruct.ConstructType constructCt = construct.getConstructType();
            if (constructType != type) {
                this.constructStack[this.constructStackTop] = construct = (SchemaConstruct)construct.clone();
                this.originalTypeStack[this.constructStackTop] = constructType;
                if (constructCt == SchemaConstruct.ConstructType.MEMBER) {
                    Member ret = (Member)XMLSchemaUtil.dereferenceMember((Member)construct).clone();
                    ret.setType(type);
                    return ret;
                }
                if (constructCt == SchemaConstruct.ConstructType.ATTRIBUTE) {
                    Attribute ret = (Attribute)XMLSchemaUtil.dereferenceAttribute((Attribute)construct).clone();
                    ret.setType(type);
                    return ret;
                }
                if (constructCt == SchemaConstruct.ConstructType.TYPE) {
                    return XMLSchemaUtil.dereferenceType(type);
                }
                throw new RuntimeException("Don't know how to handle " + construct);
            }
        }
        if (this.constructStack[this.constructStackTop] != null && (ref = this.constructStack[this.constructStackTop].getReferencedConstruct()) != null) {
            return ref;
        }
        return this.constructStack[this.constructStackTop];
    }

    public final Member nextMember() {
        SchemaConstruct ret;
        do {
            if ((ret = this.nextSchemaConstruct()) == null) continue;
        } while (ret != null && ret.getConstructType() != SchemaConstruct.ConstructType.MEMBER);
        return (Member)ret;
    }

    public final SchemaConstruct nextSchemaConstruct() {
        this.typeOfCurrentConstructReplaced = false;
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        --this.constructStackTop;
        if (this.constructStackTop < 0) {
            this.constructStackTop = 0;
            return null;
        }
        if (this.constructStackTop == this.constructStackBase) {
            this.assureConstructStackSize();
            ++this.constructStackTop;
            this.constructStack[this.constructStackTop] = null;
            return null;
        }
        return this.constructStack[this.constructStackTop];
    }

    public final SchemaConstruct nextSchemaConstruct(String namespaceURI, String localPart) {
        SchemaConstruct actConstruct;
        this.typeOfCurrentConstructReplaced = false;
        if (this.constructStackTop <= 0) {
            throw new IllegalStateException("Invalid state");
        }
        SchemaConstruct construct = this.constructStack[this.constructStackBase];
        Type type = this.getConstructSchemaType(this.constructStackBase);
        if (type.getKind() == 35) {
            actConstruct = this.findNextInSequence(localPart, type, this.constructStackBase);
        } else if (type.getKind() == 37) {
            actConstruct = this.findNextInAll(localPart, type, this.constructStackBase);
        } else if (type.getKind() == 38) {
            actConstruct = this.findNextInChoice(localPart, type, this.constructStackBase);
        } else {
            throw new UnsupportedOperationException("Unhandled construct type " + type.toIndentedString() + " in " + this.toString(true));
        }
        if (actConstruct == null && construct.getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
            throw new IllegalStateException("Unexpected input element with local part: " + localPart + " in " + this.toString(true));
        }
        return actConstruct;
    }

    private SchemaConstruct findNextInSequence(String localPart, Type type, int baseTypePos) {
        this.constructStackTop = baseTypePos + 1;
        this.assureConstructStackSize();
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
        if (subconstructs == null) {
            Type cloned = (Type)type.clone();
            cloned.setBaseType(null);
            subconstructs = new SchemaConstruct[]{type.getBaseType(), cloned};
        }
        int i = this.encodingUri != null ? 0 : this.iteratorStack[baseTypePos];
        while (i < subconstructs.length) {
            SchemaConstruct.ConstructType constructType = subconstructs[i].getConstructType();
            if (constructType == SchemaConstruct.ConstructType.MEMBER || constructType == SchemaConstruct.ConstructType.TYPE) {
                int subconstructOccurs = ((RepeatableSchemaConstruct)subconstructs[i]).getMaxOccurs();
                if (subconstructOccurs == 1) {
                    subconstructOccurs = XMLSchemaUtil.getConstructType(subconstructs[i]).getMaxOccurs();
                }
                if (subconstructOccurs == 1) {
                    if (subconstructs[i].containsInFirst(localPart)) {
                        this.constructStack[this.constructStackTop] = SchemaHandler.flatReference(subconstructs, i);
                        this.typeStack[this.constructStackTop] = null;
                        this.originalTypeStack[this.constructStackTop] = null;
                        this.iteratorStack[baseTypePos] = i + 1;
                        return subconstructs[i];
                    }
                    ++i;
                    continue;
                }
                if (subconstructs[i].containsInFirst(localPart)) {
                    this.constructStack[this.constructStackTop] = SchemaHandler.flatReference(subconstructs, i);
                    this.typeStack[this.constructStackTop] = null;
                    this.originalTypeStack[this.constructStackTop] = null;
                    this.iteratorStack[baseTypePos] = i;
                    return subconstructs[i];
                }
                ++i;
                continue;
            }
            throw new UnsupportedOperationException("Only Member and Type constructs are supported, stack trace: " + this.toString(true));
        }
        this.constructStack[this.constructStackTop] = null;
        return null;
    }

    private SchemaConstruct findNextInAll(String localPart, Type type, int baseTypePos) {
        this.constructStackTop = baseTypePos + 1;
        this.assureConstructStackSize();
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
        if (subconstructs == null) {
            return this.findNextInSequence(localPart, type, baseTypePos);
        }
        int i = 0;
        while (i < subconstructs.length) {
            if (subconstructs[i].getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                if (subconstructs[i].containsInFirst(localPart)) {
                    this.constructStack[this.constructStackTop] = SchemaHandler.flatReference(subconstructs, i);
                    this.typeStack[this.constructStackTop] = null;
                    this.originalTypeStack[this.constructStackTop] = null;
                    return subconstructs[i];
                }
            } else {
                throw new UnsupportedOperationException("Only <Member> construct in <all> is supported, stack trace: " + this.toString(true));
            }
            ++i;
        }
        this.constructStack[this.constructStackTop] = null;
        return null;
    }

    private SchemaConstruct findNextInChoice(String localPart, Type type, int baseTypePos) {
        this.constructStackTop = baseTypePos + 1;
        this.assureConstructStackSize();
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
        if (subconstructs == null) {
            return this.findNextInSequence(localPart, type, baseTypePos);
        }
        int i = 0;
        while (i < subconstructs.length) {
            SchemaConstruct.ConstructType constructType = subconstructs[i].getConstructType();
            if (constructType == SchemaConstruct.ConstructType.MEMBER || constructType == SchemaConstruct.ConstructType.TYPE) {
                if (subconstructs[i].containsInFirst(localPart)) {
                    boolean moreOccurences;
                    boolean bl = moreOccurences = subconstructs[i] instanceof RepeatableSchemaConstruct && ((RepeatableSchemaConstruct)subconstructs[i]).getMaxOccurs() != 1;
                    if (this.iteratorStack[baseTypePos] > 0 && !moreOccurences) {
                        return null;
                    }
                    this.constructStack[this.constructStackTop] = SchemaHandler.flatReference(subconstructs, i);
                    this.typeStack[this.constructStackTop] = null;
                    this.originalTypeStack[this.constructStackTop] = null;
                    this.iteratorStack[baseTypePos] = 1;
                    return subconstructs[i];
                }
            } else {
                throw new UnsupportedOperationException("Only <Member> and <Type> constructs are supported, stack trace: " + this.toString(true));
            }
            ++i;
        }
        this.constructStack[this.constructStackTop] = null;
        return null;
    }

    public final void replaceTopMember(QName name, Type type) {
        Type constructType;
        this.typeOfCurrentConstructReplaced = true;
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Invalid state - nothing to replace");
        }
        Member member = new Member(name, type, true);
        SchemaConstruct construct = this.constructStack[this.constructStackTop];
        this.originalTypeStack[this.constructStackTop] = constructType = XMLSchemaUtil.getConstructType(construct);
        this.constructStack[this.constructStackTop] = member;
        this.typeStack[this.constructStackTop] = type;
    }

    private final void assureConstructStackSize() {
        if (this.constructStackTop + 1 == this.constructStackSize) {
            int os = this.constructStackSize;
            this.constructStackSize += 5;
            SchemaConstruct[] newMemberStack = new SchemaConstruct[this.constructStackSize];
            Type[] newTypeStack = new Type[this.constructStackSize];
            Type[] newOriginalTypeStack = new Type[this.constructStackSize];
            int[] newIteratorStack = new int[this.constructStackSize];
            int[] newOriginalIteratorStack = new int[this.constructStackSize];
            System.arraycopy(this.constructStack, 0, newMemberStack, 0, os);
            System.arraycopy(this.typeStack, 0, newTypeStack, 0, os);
            System.arraycopy(this.originalTypeStack, 0, newOriginalTypeStack, 0, os);
            System.arraycopy(this.iteratorStack, 0, newIteratorStack, 0, os);
            System.arraycopy(this.originalIteratorStack, 0, newOriginalIteratorStack, 0, os);
            this.constructStack = newMemberStack;
            this.typeStack = newTypeStack;
            this.originalTypeStack = newOriginalTypeStack;
            this.iteratorStack = newIteratorStack;
            this.originalIteratorStack = newOriginalIteratorStack;
        }
    }

    public final Type replaceTopMemberType(Type newType) {
        this.typeOfCurrentConstructReplaced = true;
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Invalid state - nothing to replace");
        }
        this.typeStack[this.constructStackTop] = (Type)SchemaHandler.flatReference(newType);
        SchemaConstruct construct = this.constructStack[this.constructStackTop];
        SchemaConstruct.ConstructType constructCt = construct.getConstructType();
        if (constructCt == SchemaConstruct.ConstructType.MEMBER) {
            return ((Member)construct).getType();
        }
        if (constructCt == SchemaConstruct.ConstructType.ATTRIBUTE) {
            return ((Attribute)construct).getType();
        }
        if (constructCt == SchemaConstruct.ConstructType.TYPE) {
            return (Type)construct;
        }
        throw new RuntimeException("Don't know how to handle " + construct);
    }

    public boolean typeOfCurrentConstructReplaced() {
        return this.typeOfCurrentConstructReplaced;
    }

    public final Type getOriginalType() {
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        if (this.originalTypeStack[this.constructStackTop] == null) {
            this.originalTypeStack[this.constructStackTop] = this.getCurrentConstructSchemaType();
        }
        return this.originalTypeStack[this.constructStackTop];
    }

    public final Type getCurrentConstructSchemaType() {
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        return this.getConstructSchemaType(this.constructStackTop);
    }

    private final Type getConstructSchemaType(int pos) {
        if (this.typeStack[pos] != null) {
            return this.typeStack[pos];
        }
        if (this.constructStack[pos] != null) {
            return XMLSchemaUtil.getConstructType(this.constructStack[pos]);
        }
        return null;
    }

    public final QName getCurrentConstructName() {
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        if (this.constructStack[this.constructStackTop] != null) {
            return this.getName(this.constructStack[this.constructStackTop]);
        }
        return null;
    }

    private QName getName(SchemaConstruct construct) {
        if (construct.getReferencedConstruct() != null) {
            return this.getName(construct.getReferencedConstruct());
        }
        return construct.getName();
    }

    public final SchemaConstruct.ConstructType getCurrentConstructType() {
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Bad state");
        }
        return this.constructStack[this.constructStackTop].getConstructType();
    }

    public void replaceTopSchemaConstruct(SchemaConstruct referencedConstruct) {
        Type constructType;
        this.typeOfCurrentConstructReplaced = true;
        if (this.constructStackTop < 0) {
            throw new IllegalStateException("Invalid state - nothing to replace");
        }
        this.originalTypeStack[this.constructStackTop] = constructType = XMLSchemaUtil.getConstructType(this.constructStack[this.constructStackTop]);
        this.constructStack[this.constructStackTop] = referencedConstruct;
        this.typeStack[this.constructStackTop] = XMLSchemaUtil.getConstructType(referencedConstruct);
    }

    public boolean isCurrentConstructArray() {
        SchemaConstruct construct = this.constructStack[this.constructStackTop];
        boolean isArray = false;
        if (construct instanceof RepeatableSchemaConstruct && ((RepeatableSchemaConstruct)construct).getMaxOccurs() != 1) {
            isArray = true;
        }
        if (!isArray) {
            isArray = XMLSchemaUtil.isArray(this.getCurrentConstructSchemaType());
        }
        return isArray;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuffer ret = new StringBuffer();
        ret.append("    ElementStack[\n");
        int i = this.constructStackTop;
        while (i >= 0) {
            if (this.constructStack[i] != null) {
                Type type;
                ret.append("        ");
                ret.append(this.constructStack[i].getName());
                ret.append("[type=");
                if (verbose && (type = this.getConstructSchemaType(i)) != null) {
                    ret.append(type.toIndentedString());
                    verbose = false;
                }
                ret.append(this.getConstructSchemaType(i));
                ret.append("]\n");
            }
            --i;
        }
        ret.append("]");
        return ret.toString();
    }

    public static final class SchemaContextState
    implements SchemaContext.State {
        protected int constructStackTop;
        protected int enterLevel;
        protected int constructStackBase;

        protected SchemaContextState(int constructStackTop, int enterLevel, int constructStackBase) {
            this.constructStackTop = constructStackTop;
            this.enterLevel = enterLevel;
            this.constructStackBase = constructStackBase;
        }
    }
}

