/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.serialization.TypeSerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.TypeMappingContext;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;

public class TypeMappingContextImpl
implements TypeMappingContext {
    private TypeSerializationHelper helper;
    private SerializationRepositoryImpl serializationRepository;
    private Schema schema;
    private String serializationID;
    private String encodingURI;

    public String toString() {
        return "tmc:" + this.serializationID + ":" + this.encodingURI;
    }

    public void init(SerializationRepositoryImpl repository, String serializationID, String encodingURI, String targetLanguage) {
        this.serializationRepository = repository;
        this.helper = new TypeSerializationHelper();
        this.helper.init(serializationID, targetLanguage, this.serializationRepository, encodingURI);
        this.serializationID = serializationID;
        this.encodingURI = encodingURI;
    }

    public void enter(QName name, QName type) {
    }

    public void leave() {
    }

    public String getType(QName name, QName type) throws SchemaException {
        return this.helper.getType(this.getSchemaType(type));
    }

    public String getType(Type type) {
        return this.helper.getType(type);
    }

    public QName getSchemaType(QName name, String progLangType) throws SchemaException {
        return this.helper.getSchemaType(progLangType);
    }

    public QName getSchemaType(String progLangType) throws SchemaException {
        return this.helper.getSchemaType(progLangType);
    }

    public Type getSchemaType(QName typeName) throws SchemaException {
        return XMLSchemaUtil.getSchemaType(this.schema, typeName);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema, boolean useSchemaTypeMapping) {
        this.schema = schema;
        this.helper.setSchema(schema, useSchemaTypeMapping);
    }

    public String getSerializationID() {
        return this.serializationID;
    }

    public String getAttachmentMimeType(String className) {
        return this.serializationRepository.getAttachmentMimeType(className, this.serializationID, this.encodingURI);
    }

    public String getAttachmentClassName(String mimeType) {
        return this.serializationRepository.getAttachmentClassName(mimeType, this.serializationID, this.encodingURI);
    }
}

