/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.debug.Category;
import com.idoox.xml.Tokenizer2Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.wasp.SoapFaultException;
import org.idoox.wasp.serialization.FaultSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Fault;

public class SoapFaultSerializer
implements FaultSerializer {
    private static final Category log = Category.getCategory("com.idoox.wasp.serialization.SoapFaultSerializer");

    public void serializeFault(Fault fault, Throwable throwable) {
        String faultNode;
        if (!(throwable instanceof SoapFaultException)) {
            log.error("", throwable);
            return;
        }
        SoapFaultException sfe = (SoapFaultException)throwable;
        fault.setFaultCode(sfe.getFaultCode());
        fault.setFaultReason(sfe.getFaultReason());
        String faultRole = sfe.getFaultRole();
        if (faultRole != null) {
            fault.setFaultRole(faultRole);
        }
        if ((faultNode = sfe.getFaultNode()) != null) {
            fault.setFaultNode(faultNode);
        }
        List subcodes = sfe.getFaultSubcodes();
        Iterator it = subcodes.iterator();
        while (it.hasNext()) {
            fault.addFaultSubcode((QName)it.next());
        }
        try {
            Tokenizer faultTokenizer = sfe.getDetailTokenizer();
            if (faultTokenizer != null) {
                TokenWriter tw1 = fault.getDetailTokenWriter();
                faultTokenizer.next();
                Tokenizer2Writer.copy(faultTokenizer, tw1);
            }
        }
        catch (IOException e) {
            log.error(e);
        }
        catch (TokenizerException e) {
            log.error(e);
        }
    }
}

