/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.xml.XMLEncSerializerWrapper;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import java.util.NoSuchElementException;
import javax.xml.rpc.encoding.Serializer;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.NoConversionException;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.webservice.CallContext;

public class SerializationChainImpl
implements SerializationChain {
    Serializer[] excludedSerializers;
    Serializer[] serializers = new Serializer[5];
    int serializersUsed;
    int serializerPos;

    public int getSerializerState() {
        return this.serializerPos;
    }

    public void setSerializerState(int serializerPos) {
        this.serializerPos = serializerPos;
    }

    public void removeSerializer(Serializer serializer) {
        if (this.excludedSerializers == null) {
            this.excludedSerializers = new Serializer[]{serializer};
        } else {
            Serializer[] ns = new Serializer[this.excludedSerializers.length + 1];
            System.arraycopy(this.excludedSerializers, 0, ns, 0, this.excludedSerializers.length);
            ns[this.excludedSerializers.length] = serializer;
            this.excludedSerializers = ns;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasMoreSerializers() {
        if (this.serializerPos == this.serializersUsed) {
            return false;
        }
        if (this.serializerPos >= this.serializersUsed) {
            return false;
        }
        if (this.excludedSerializers != null) {
            int i = 0;
            while (i < this.excludedSerializers.length) {
                if (this.excludedSerializers[i] == this.serializers[this.serializerPos]) {
                    ++this.serializerPos;
                }
                ++i;
            }
        }
        return true;
    }

    public String getNextSerializersType() throws NoSuchElementException {
        if (!this.hasMoreSerializers()) {
            throw new NoSuchElementException();
        }
        return this.serializers[this.serializerPos].getMechanismType();
    }

    public Serializer getNextSerializerAs(String mechanismType) throws NoSuchElementException, NoConversionException {
        if (mechanismType == org.idoox.wasp.serialization.Serializer.MECHANISM_TYPE) {
            return this.getNextSerializer();
        }
        if (mechanismType == "systinet:xmlser/1.0") {
            return this.getNextXMLSerializer();
        }
        throw new NoConversionException("No conversion of " + this.getNextSerializersType() + " to " + mechanismType);
    }

    public org.idoox.wasp.serialization.Serializer getNextSerializer() throws NoSuchElementException, NoConversionException {
        Serializer ser;
        if (!this.hasMoreSerializers()) {
            throw new NoSuchElementException();
        }
        if ((ser = this.serializers[this.serializerPos++]).getMechanismType() == org.idoox.wasp.serialization.Serializer.MECHANISM_TYPE) {
            return (org.idoox.wasp.serialization.Serializer)ser;
        }
        throw new NoConversionException("No conversion specified from " + ser.getClass() + "[" + ser.getMechanismType() + "] to " + org.idoox.wasp.serialization.Serializer.MECHANISM_TYPE);
    }

    public XMLSerializer getNextXMLSerializer() throws NoSuchElementException, NoConversionException {
        Serializer ser;
        String serMechanismType;
        if (!this.hasMoreSerializers()) {
            throw new NoSuchElementException("No appropriate serializer found in the serialization chain");
        }
        if ((serMechanismType = (ser = this.serializers[this.serializerPos++]).getMechanismType()) == "systinet:xmlser/1.0") {
            return (XMLSerializer)ser;
        }
        if (serMechanismType == org.idoox.wasp.serialization.Serializer.MECHANISM_TYPE) {
            String encodingURI;
            String encodingID;
            EncodingRepository repo = (EncodingRepository)Context.getInstance("com.idoox.xmlrpc.encoding.EncodingRepository");
            CallContext callC = CallContext.getInstance();
            if (callC != null) {
                encodingID = (String)callC.get("wasp.encodingID");
                encodingURI = (String)callC.get("wasp.encodingURI");
            } else {
                encodingID = null;
                encodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            return new XMLEncSerializerWrapper(repo, (org.idoox.wasp.serialization.Serializer)ser, encodingID, encodingURI);
        }
        throw new NoConversionException("No conversion specified from " + ser.getClass() + "[" + ser.getMechanismType() + "] to " + "systinet:xmlser/1.0");
    }

    public void add(Serializer serializer) {
        if (this.serializersUsed == this.serializers.length) {
            Serializer[] newSerializers = new Serializer[this.serializersUsed + 5];
            System.arraycopy(this.serializers, 0, newSerializers, 0, this.serializersUsed);
            this.serializers = newSerializers;
        }
        this.serializers[this.serializersUsed++] = serializer;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("SerializationChain[");
        int i = this.serializerPos;
        while (i < this.serializersUsed) {
            ret.append(this.serializers[i].getClass().getName() + " ");
            ++i;
        }
        ret.append("]");
        return ret.toString();
    }

    public void clear() {
        this.excludedSerializers = null;
        this.serializersUsed = 0;
        this.serializerPos = 0;
    }
}

