/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.Namespaces;
import com.idoox.soap.BadArgumentsException;
import com.idoox.soap.MustUnderstandException;
import com.idoox.soap.ProcedureNotPresentException;
import com.idoox.soap.VersionMismatchException;
import com.idoox.wasp.serialization.DefaultFaultSerializer;
import com.idoox.wasp.serialization.DeserializationException;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.FaultSerializer;
import org.idoox.webservice.CallContext;
import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.Fault;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.systinet.wasp.webservice.Current;

public class SOAP12SpecFaultsSerializer
implements FaultSerializer {
    private static final LinkedList UNDERSTOOD_HEADERS = new LinkedList();
    private static final Integer BAD_REQUEST;
    private FaultSerializer default12FaultSerializer = new DefaultFaultSerializer();

    public void serializeFault(Fault fault, Throwable throwable) {
        if (throwable instanceof MustUnderstandException) {
            fault.setFaultCode(Constants.MUST_UNDERSTAND_FAULT_CODE_12);
            StringBuffer tmp = new StringBuffer("do not understand headers: ");
            QName[] headers = ((MustUnderstandException)throwable).getCauseHeaders();
            LinkedList<QName> misunderstoodHeaders = new LinkedList<QName>();
            int i = 0;
            while (headers != null && i < headers.length) {
                misunderstoodHeaders.add(headers[i]);
                tmp.append(headers[i].toString());
                if (i < headers.length - 1) {
                    tmp.append(", ");
                }
                ++i;
            }
            Map contextData = Current.getCallContext().getContextData();
            contextData.put("soap.MisunderstoodHeaders", misunderstoodHeaders);
            fault.setFaultReason(tmp.toString());
        } else if (throwable instanceof VersionMismatchException) {
            fault.setFaultCode(Constants.VERSION_MISMATCH_FAULT_CODE_12);
            fault.setFaultReason("received something that is not a SOAP Envelope");
        } else if (throwable instanceof NoSuchEncodingException) {
            fault.setFaultCode(Constants.DATA_ENCODING_UNKNOWN_FAULT_CODE_12);
            fault.setFaultReason("Data Encoding Unknown: " + throwable.getMessage());
        } else if (throwable instanceof BadArgumentsException || throwable instanceof DeserializationException) {
            fault.setFaultCode(Constants.SENDER_FAULT_CODE_12);
            fault.setFaultReason(throwable.getMessage());
            fault.addFaultSubcode(Constants.BAD_ARGUMENTS_FAULT_CODE_12);
            CallContext context = CallContext.getInstance();
            if (context != null) {
                context.put("transport.StatusCode", BAD_REQUEST);
            }
        } else if (throwable instanceof ProcedureNotPresentException) {
            fault.setFaultCode(Constants.SENDER_FAULT_CODE_12);
            fault.setFaultReason(throwable.getMessage());
            fault.addFaultSubcode(Constants.PROCEDURE_NOT_PRESENT_FAULT_CODE_12);
            CallContext context = CallContext.getInstance();
            if (context != null) {
                context.put("transport.StatusCode", BAD_REQUEST);
            }
        } else {
            this.default12FaultSerializer.serializeFault(fault, throwable);
            return;
        }
    }

    static {
        UNDERSTOOD_HEADERS.add(new QName(Namespaces.SOAP12_ENV_NS, "Envelope"));
        BAD_REQUEST = new Integer(400);
    }
}

