/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.DuplicateAccessException;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.TypeMappingContext;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;

public class PolymorphismHelper {
    private static QName ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    private static QName SOAPENC_ARRAY = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    private static Set baseSchemaTypes = new HashSet(23);
    static /* synthetic */ Class class$java$lang$Object;

    private QName getSchemaTypeFromRepository(TypeMappingContext context, Class cls) throws SchemaException {
        if (!cls.isArray()) {
            return context.getSchemaType(cls.getName());
        }
        QName schemaType = context.getSchemaType(cls.getName());
        if (schemaType != null) {
            return schemaType;
        }
        StringBuffer name = new StringBuffer();
        int dimensions = 0;
        while (cls.isArray()) {
            cls = cls.getComponentType();
            ++dimensions;
        }
        name.append(cls.getName());
        while (dimensions-- > 0) {
            name.append('[').append(']');
        }
        return context.getSchemaType(name.toString());
    }

    private Type getTypeFromRepository(TypeMappingContext context, Class cls, boolean matchGeneratedTypes) throws SchemaException {
        Class origCls = cls;
        boolean add = false;
        do {
            QName fromRepository;
            if ((fromRepository = this.getSchemaTypeFromRepository(context, cls)) != null && (matchGeneratedTypes || !fromRepository.getNamespaceURI().equals("http://idoox.com/package/"))) {
                Type t = context.getSchemaType(fromRepository);
                if (add) {
                    context.getSchema().addJavaSchemaTypeMapping(origCls.getName(), t);
                }
                return t;
            }
            cls = cls.getSuperclass();
            matchGeneratedTypes = false;
            add = true;
        } while (cls != null && cls != (class$java$lang$Object == null ? PolymorphismHelper.class$("java.lang.Object") : class$java$lang$Object));
        Class<?>[] interfaces = origCls.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            Type ret = this.getTypeFromRepository(context, interfaces[i], false);
            if (ret != null) {
                if (add) {
                    context.getSchema().addJavaSchemaTypeMapping(origCls.getName(), ret);
                }
                return ret;
            }
            ++i;
        }
        return null;
    }

    public Type getClassSchemaType(SerializationContext context, Class dataClass) throws MessageCreatingException {
        Type contextType = context.getCurrentConstructSchemaType();
        Type returnType = this.getSchemaType(context, dataClass, contextType != null ? contextType.getName() : null);
        return returnType;
    }

    public Type getClassSchemaType(DeserializationContext context, Class dataClass) throws MessageCreatingException {
        Type contextType = context.getCurrentConstructSchemaType();
        Type returnType = this.getSchemaType(context, dataClass, contextType != null ? contextType.getName() : null);
        return returnType;
    }

    private Type getSchemaType(TypeMappingContext context, Class dataClass, QName contextTypeName) throws MessageCreatingException {
        try {
            Type fromTypeMapping = this.getTypeFromRepository(context, dataClass, true);
            if (fromTypeMapping != null) {
                return fromTypeMapping;
            }
            if (contextTypeName != null) {
                boolean shouldGenerate = false;
                if (contextTypeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    String lp = contextTypeName.getLocalPart();
                    if (lp.equals("anyType") || lp.equals("anySimpleType")) {
                        shouldGenerate = true;
                    }
                } else if (contextTypeName.getNamespaceURI().equals("http://idoox.com/package/")) {
                    shouldGenerate = true;
                }
                if (shouldGenerate) {
                    fromTypeMapping = this.generateSchemaType(context, dataClass);
                    return fromTypeMapping;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new MessageCreatingException(e);
        }
    }

    private String getGeneratedTypeName(Class cls) {
        if (cls.isArray()) {
            return "ArrayOf" + this.getGeneratedTypeName(cls.getComponentType());
        }
        return cls.getName();
    }

    private Class getGeneratedClass(DeserializationContext ctx, String name) throws ClassNotFoundException {
        if (name.startsWith("ArrayOf")) {
            Class component = this.getGeneratedClass(ctx, name.substring(7));
            return Array.newInstance(component, 0).getClass();
        }
        Class primitiveClass = PrimitiveTypeAccessor.convertPrimitiveToJavaClass(name);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        Class aClass = PrimitiveTypeAccessor.getPrimitiveClass("http://www.w3.org/2001/XMLSchema", name);
        if (aClass != null) {
            return aClass;
        }
        return Class.forName(name, true, ctx.getClassLoader());
    }

    public Type getGeneratedSchemaType(DeserializationContext context, QName typeName) throws SchemaException {
        try {
            if ("http://idoox.com/package/".equals(typeName.getNamespaceURI())) {
                Class cls = this.getGeneratedClass(context, typeName.getLocalPart());
                return this.generateSchemaType(context, cls);
            }
            return null;
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    private Type generateSchemaType(TypeMappingContext context, Class cls) throws IntrospectionException, DuplicateAccessException, SchemaException, MessageCreatingException {
        Type knownType = context.getSchema().getSchemaType(cls.getName());
        if (knownType != null) {
            return knownType;
        }
        Type placeTo = new Type(new QName("http://idoox.com/package/", this.getGeneratedTypeName(cls)));
        placeTo.setJavaTypeName(cls.getName());
        context.getSchema().addSchemaType(placeTo);
        context.getSchema().addJavaSchemaTypeMapping(cls.getName(), placeTo);
        if (cls.isArray()) {
            placeTo.setKind((short)35);
            placeTo.setDimensions(1);
            placeTo.setBaseType(context.getSchemaType(SOAPENC_ARRAY));
            QName memberQName = new QName(null, "item");
            SchemaConstruct[] constructs = new Member[]{new Member(memberQName, this.getSchemaType(context, cls.getComponentType(), ANY_TYPE), true)};
            constructs[0].setMaxOccurs(-1);
            placeTo.setSubconstructs(constructs);
        } else if (cls != (class$java$lang$Object == null ? (class$java$lang$Object = PolymorphismHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
            placeTo.setKind((short)35);
            Map properties = WaspSerializationHelper.getProperties(cls);
            int size = properties.size();
            int pos = 0;
            SchemaConstruct[] constructs = new Member[size];
            Iterator i = properties.entrySet().iterator();
            while (i.hasNext()) {
                Class<?> memberClass;
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                Object accessor = entry.getValue();
                if (accessor instanceof PropertyDescriptor) {
                    PropertyDescriptor pd = (PropertyDescriptor)accessor;
                    memberClass = pd.getPropertyType();
                } else {
                    Field f = (Field)accessor;
                    memberClass = f.getType();
                }
                QName memberQName = new QName(null, name);
                Type t = this.getSchemaType(context, memberClass, ANY_TYPE);
                if (t == null) {
                    throw new RuntimeException("Can not get schema type for " + memberClass + " in " + context.toString());
                }
                constructs[pos++] = new Member(memberQName, t, true);
            }
            placeTo.setSubconstructs(constructs);
        }
        return placeTo;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isExtendedFrom(Type polymorphismType, Type baseType) {
        if (polymorphismType == null || baseType == null) {
            return false;
        }
        n = baseType.getName();
        if (n != null) {
            if (PolymorphismHelper.baseSchemaTypes.contains(n)) {
                return true;
            }
            if ("http://idoox.com/package/".equals(n.getNamespaceURI())) {
                return true;
            }
        }
        if ((n = polymorphismType.getName()) == null || !"http://idoox.com/package/".equals(n.getNamespaceURI())) ** GOTO lbl14
        return true;
lbl-1000:
        // 1 sources

        {
            if (polymorphismType.getName() != null && polymorphismType.getName().equals(baseType.getName())) {
                return true;
            }
            polymorphismType = polymorphismType.getBaseType();
lbl14:
            // 2 sources

            ** while (polymorphismType != null)
        }
lbl15:
        // 1 sources

        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        baseSchemaTypes.add(new QName("http://www.w3.org/2001/XMLSchema", "anyType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/2000/10/XMLSchema", "anyType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/2000/10/XMLSchema", "anySimpleType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/1999/XMLSchema", "anyType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/1999/XMLSchema", "anySimpleType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/1999/XMLSchema", "urType"));
        baseSchemaTypes.add(new QName("http://www.w3.org/1999/XMLSchema", "simpleType"));
    }
}

