/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.soap.MustUnderstandException;
import com.idoox.soap.VersionMismatchException;
import com.idoox.wasp.serialization.DefaultFaultSerializer;
import com.idoox.wasp.serialization.SOAP12SpecFaultsSerializer;
import com.idoox.wasp.serialization.SOAPSpecFaultsSerializer;
import org.idoox.wasp.serialization.FaultSerializer;
import org.idoox.xmlrpc.Fault;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;

public class GenericSOAPSpecFaultSerializer
implements FaultSerializer {
    private FaultSerializer defaultFaultSerializer = new DefaultFaultSerializer();
    private FaultSerializer soap11FaultSerializer = new SOAPSpecFaultsSerializer();
    private FaultSerializer soap12FaultSerializer = new SOAP12SpecFaultsSerializer();

    public void serializeFault(Fault fault, Throwable throwable) {
        CallContext callContext = Current.getCallContext();
        Object protocol = callContext.getContextData().get("wasp.xml.protocol");
        if ("soap11".equals(protocol)) {
            if (throwable instanceof MustUnderstandException || throwable instanceof VersionMismatchException) {
                this.soap11FaultSerializer.serializeFault(fault, throwable);
            } else {
                this.defaultFaultSerializer.serializeFault(fault, throwable);
            }
        } else if ("soap12".equals(protocol)) {
            this.soap12FaultSerializer.serializeFault(fault, throwable);
        } else {
            throw new RuntimeException("Unkown protocol:" + protocol);
        }
    }
}

