/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.xml.XMLEncDeserializerWrapper;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import java.util.NoSuchElementException;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.NoConversionException;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.webservice.CallContext;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;

public class DeserializationChainImpl
implements DeserializationChain {
    javax.xml.rpc.encoding.Deserializer[] excludedDeserializers;
    javax.xml.rpc.encoding.Deserializer[] deserializers = new javax.xml.rpc.encoding.Deserializer[5];
    int deserializersUsed;
    int deserializerPos;

    public int getDeserializerState() {
        return this.deserializerPos;
    }

    public void setDeserializerState(int deserializerPos) {
        this.deserializerPos = deserializerPos;
    }

    public void removeDeserializer(javax.xml.rpc.encoding.Deserializer deserializer) {
        if (this.excludedDeserializers == null) {
            this.excludedDeserializers = new javax.xml.rpc.encoding.Deserializer[]{deserializer};
        } else {
            javax.xml.rpc.encoding.Deserializer[] ns = new javax.xml.rpc.encoding.Deserializer[this.excludedDeserializers.length + 1];
            System.arraycopy(this.excludedDeserializers, 0, ns, 0, this.excludedDeserializers.length);
            ns[this.excludedDeserializers.length] = deserializer;
            this.excludedDeserializers = ns;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasMoreDeserializers() {
        if (this.deserializerPos == this.deserializersUsed) {
            return false;
        }
        if (this.deserializerPos >= this.deserializersUsed) {
            return false;
        }
        if (this.excludedDeserializers != null) {
            int i = 0;
            while (i < this.excludedDeserializers.length) {
                if (this.excludedDeserializers[i] == this.deserializers[this.deserializerPos]) {
                    ++this.deserializerPos;
                }
                ++i;
            }
        }
        return true;
    }

    public String getNextDeserializersType() throws NoSuchElementException {
        if (!this.hasMoreDeserializers()) {
            throw new NoSuchElementException();
        }
        return this.deserializers[this.deserializerPos].getMechanismType();
    }

    public javax.xml.rpc.encoding.Deserializer getNextDeserializerAs(String mechanismType) throws NoSuchElementException, NoConversionException {
        if (mechanismType == Deserializer.MECHANISM_TYPE) {
            return this.getNextDeserializer();
        }
        if (mechanismType == "systinet:xmlser/1.0") {
            return this.getNextXMLDeserializer();
        }
        throw new NoConversionException("No conversion of " + this.getNextDeserializersType() + " to " + mechanismType);
    }

    public Deserializer getNextDeserializer() throws NoSuchElementException, NoConversionException {
        javax.xml.rpc.encoding.Deserializer deser;
        if (!this.hasMoreDeserializers()) {
            throw new NoSuchElementException();
        }
        if ((deser = this.deserializers[this.deserializerPos++]).getMechanismType() == Deserializer.MECHANISM_TYPE) {
            return (Deserializer)deser;
        }
        throw new NoConversionException("No conversion specified from " + deser.getClass() + "[" + deser.getMechanismType() + "] to " + Deserializer.MECHANISM_TYPE);
    }

    public XMLDeserializer getNextXMLDeserializer() throws NoSuchElementException, NoConversionException {
        javax.xml.rpc.encoding.Deserializer deser;
        String deserMechanismType;
        if (!this.hasMoreDeserializers()) {
            throw new NoSuchElementException();
        }
        if ((deserMechanismType = (deser = this.deserializers[this.deserializerPos++]).getMechanismType()) == "systinet:xmlser/1.0") {
            return (XMLDeserializer)deser;
        }
        if (deserMechanismType == Deserializer.MECHANISM_TYPE) {
            try {
                String encodingURI;
                String encodingID;
                EncodingRepository repo = (EncodingRepository)Context.getInstance("com.idoox.xmlrpc.encoding.EncodingRepository");
                CallContext callC = CallContext.getInstance();
                if (callC != null) {
                    encodingID = (String)callC.get("wasp.encodingID");
                    encodingURI = (String)callC.get("wasp.encodingURI");
                } else {
                    encodingID = null;
                    encodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
                }
                EncodingTokenizer tokenizer = repo.getEncodingTokenizer(encodingID, encodingURI);
                return new XMLEncDeserializerWrapper(repo, tokenizer, (Deserializer)deser, encodingID, encodingURI);
            }
            catch (NoSuchEncodingException e) {
                throw new NoConversionException(e);
            }
        }
        throw new NoConversionException("No conversion specified from " + deser.getClass() + "[" + deser.getMechanismType() + "] to " + "systinet:xmlser/1.0");
    }

    public void add(javax.xml.rpc.encoding.Deserializer deserializer) {
        if (this.deserializersUsed == this.deserializers.length) {
            javax.xml.rpc.encoding.Deserializer[] newDeserializers = new javax.xml.rpc.encoding.Deserializer[this.deserializersUsed + 5];
            System.arraycopy(this.deserializers, 0, newDeserializers, 0, this.deserializersUsed);
            this.deserializers = newDeserializers;
        }
        this.deserializers[this.deserializersUsed++] = deserializer;
    }

    public void clear() {
        this.excludedDeserializers = null;
        this.deserializersUsed = 0;
        this.deserializerPos = 0;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("DeserializationChain[");
        int i = this.deserializerPos;
        while (i < this.deserializersUsed) {
            ret.append(this.deserializers[i].getClass().getName() + " ");
            ++i;
        }
        ret.append("]");
        return ret.toString();
    }

    public void replaceLast(javax.xml.rpc.encoding.Deserializer deser) {
        int index = this.deserializersUsed - 1;
        this.deserializers[index] = deser;
    }
}

