/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.SoapFaultException;
import org.idoox.wasp.serialization.FaultDeserializer;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.Fault;
import sun.security.action.GetPropertyAction;

public class DefaultFaultDeserializer
implements FaultDeserializer {
    private int IDOOX_JAVA_MAPPING_ID_LENGTH = "idoox-java-mapping.".length();
    private static final int STATE_START = 0;
    private static final int STATE_CLASS_METHOD = 1;
    private static final int STATE_NATIVE = 2;
    private static final int STATE_FILE_NAME = 3;
    Constructor cons = null;
    Field className = null;
    Field fileName = null;
    Field lineNumber = null;
    Field methodName = null;
    BufferedReader reader = null;
    Field wrappedReason = null;
    Field runtimeWrappedReason = null;
    Field throwableCause = null;
    Field throwableDetailMessage = null;
    String line = null;
    ClassLoader contextLoader = null;
    ClassLoader loader = null;
    String lineSeparator = null;
    Class stackTraceElementElement = null;
    Class stackTraceElementElementArray = null;
    Class exception = null;
    static /* synthetic */ Class class$com$idoox$wasp$serialization$DefaultFaultDeserializer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$idoox$util$WrappedException;
    static /* synthetic */ Class class$org$idoox$util$RuntimeWrappedException;
    static /* synthetic */ Class class$java$lang$Throwable;

    public Exception deserializeFault(Fault fault) {
        try {
            String faultString = fault.getFaultString();
            StringBuffer faultText = new StringBuffer();
            Tokenizer detailTokenizer = fault.getDetailTokenizer();
            String exceptionName = null;
            if (detailTokenizer == null) {
                return new SoapFaultException(fault);
            }
            byte token = detailTokenizer.currentState();
            String firstElementName = null;
            if (token == 2) {
                firstElementName = detailTokenizer.getLocalName();
            }
            if (firstElementName != null && firstElementName.startsWith("idoox-java-mapping.")) {
                detailTokenizer.next();
                detailTokenizer.next();
                String stackTrace = detailTokenizer.readContent();
                exceptionName = firstElementName.substring(this.IDOOX_JAVA_MAPPING_ID_LENGTH);
                try {
                    Throwable ex;
                    this.contextLoader = Thread.currentThread().getContextClassLoader();
                    this.loader = (class$com$idoox$wasp$serialization$DefaultFaultDeserializer == null ? (class$com$idoox$wasp$serialization$DefaultFaultDeserializer = DefaultFaultDeserializer.class$("com.idoox.wasp.serialization.DefaultFaultDeserializer")) : class$com$idoox$wasp$serialization$DefaultFaultDeserializer).getClassLoader();
                    if (this.contextLoader != null) {
                        try {
                            this.exception = Class.forName(exceptionName, true, this.contextLoader);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (this.exception == null && this.loader != null) {
                        try {
                            this.exception = Class.forName(exceptionName, true, this.loader);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (this.exception == null) {
                        return new SoapFaultException(fault.getFaultCode(), (exceptionName != null ? exceptionName + ": " : "") + fault.getFaultString(), fault.getFaultActor(), fault.getDetailTokenizer());
                    }
                    Method setmethod = null;
                    try {
                        this.stackTraceElementElement = Class.forName("java.lang.StackTraceElement", true, this.loader);
                        this.stackTraceElementElementArray = Array.newInstance(this.stackTraceElementElement, 0).getClass();
                        setmethod = this.exception.getMethod("setStackTrace", this.stackTraceElementElementArray);
                    }
                    catch (Exception e) {
                        setmethod = null;
                    }
                    if (setmethod != null && (ex = this.parseException(stackTrace)) != null) {
                        return (Exception)ex;
                    }
                    faultText.append(faultString + "\n" + faultText.toString() + "\n======= Server stack trace =======\n\n" + stackTrace + "\n======= Client stack trace =======\n\n");
                    return (Exception)this.exception.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultFaultDeserializer.class$("java.lang.String")) : class$java$lang$String).newInstance(faultText.toString());
                }
                catch (Exception ee) {
                    try {
                        return (Exception)this.exception.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return new SoapFaultException(fault.getFaultCode(), (exceptionName != null ? exceptionName + ": " : "") + fault.getFaultString(), fault.getFaultActor(), fault.getDetailTokenizer());
        }
        catch (SoapFaultException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Throwable parseException(String stackTrace) {
        ArrayList<ExceptionDesc> chain = new ArrayList<ExceptionDesc>();
        this.reader = new BufferedReader(new StringReader(stackTrace));
        try {
            this.cons = this.stackTraceElementElement.getDeclaredConstructor(new Class[0]);
            ((AccessibleObject)this.cons).setAccessible(true);
            this.className = this.stackTraceElementElement.getDeclaredField("declaringClass");
            ((AccessibleObject)this.className).setAccessible(true);
            this.fileName = this.stackTraceElementElement.getDeclaredField("fileName");
            ((AccessibleObject)this.fileName).setAccessible(true);
            this.lineNumber = this.stackTraceElementElement.getDeclaredField("lineNumber");
            ((AccessibleObject)this.lineNumber).setAccessible(true);
            this.methodName = this.stackTraceElementElement.getDeclaredField("methodName");
            ((AccessibleObject)this.methodName).setAccessible(true);
            this.wrappedReason = (class$org$idoox$util$WrappedException == null ? (class$org$idoox$util$WrappedException = DefaultFaultDeserializer.class$("org.idoox.util.WrappedException")) : class$org$idoox$util$WrappedException).getDeclaredField("reason");
            ((AccessibleObject)this.wrappedReason).setAccessible(true);
            this.runtimeWrappedReason = (class$org$idoox$util$RuntimeWrappedException == null ? (class$org$idoox$util$RuntimeWrappedException = DefaultFaultDeserializer.class$("org.idoox.util.RuntimeWrappedException")) : class$org$idoox$util$RuntimeWrappedException).getDeclaredField("reason");
            ((AccessibleObject)this.runtimeWrappedReason).setAccessible(true);
            this.throwableCause = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = DefaultFaultDeserializer.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredField("cause");
            ((AccessibleObject)this.throwableCause).setAccessible(true);
            this.throwableDetailMessage = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = DefaultFaultDeserializer.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredField("detailMessage");
            ((AccessibleObject)this.throwableDetailMessage).setAccessible(true);
            this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.line = this.reader.readLine();
            ExceptionDesc parent = null;
            Class exceptionClass = null;
            if (this.line == null) return null;
            StringBuffer message = new StringBuffer();
            exceptionClass = this.readNextException(message);
            Object trace = this.parseTrace(null);
            parent = new ExceptionDesc(message.toString(), exceptionClass, trace);
            chain.add(parent);
            while (this.line != null) {
                message = new StringBuffer();
                exceptionClass = this.readNextException(message);
                trace = this.parseTrace(trace);
                parent = new ExceptionDesc(message.toString(), exceptionClass, trace);
                chain.add(parent);
            }
            return this.constructChain(chain);
        }
        catch (Exception e) {
            return null;
        }
    }

    Class readNextException(StringBuffer message) {
        String ftext;
        String className = null;
        int pointer = 0;
        pointer = this.line.indexOf(58);
        if (pointer >= 0) {
            ftext = this.line.substring(0, pointer);
        } else {
            ftext = this.line;
            pointer = this.line.length() - 2;
        }
        if (ftext.equals("Caused by")) {
            int aux = this.line.indexOf(58, pointer + 1);
            className = this.line.substring(pointer + 2, aux);
            pointer = aux;
        } else {
            className = ftext;
        }
        message.append(this.line.substring(pointer + 2));
        try {
            this.line = this.reader.readLine();
            while (!this.line.startsWith("\tat ") && !this.line.startsWith("\t... ")) {
                message.append(this.lineSeparator + this.line);
                this.line = this.reader.readLine();
            }
        }
        catch (IOException e) {
            this.line = null;
        }
        Class<?> exception = null;
        if (this.contextLoader != null) {
            try {
                exception = Class.forName(className, true, this.contextLoader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (exception == null && this.loader != null) {
            try {
                exception = Class.forName(className, true, this.loader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (exception != null) {
            return exception;
        }
        this.line = null;
        return null;
    }

    Object parseTrace(Object parent) {
        ArrayList<Object> stack = new ArrayList<Object>();
        Object[] parentArray = (Object[])parent;
        try {
            while (this.line != null && (this.line.startsWith("\tat ") || this.line.startsWith("\t... "))) {
                Object sElement = this.cons.newInstance(new Object[0]);
                if (this.line.startsWith("\t... ")) {
                    StringTokenizer tokenizer = new StringTokenizer(this.line);
                    tokenizer.nextToken();
                    int count = Integer.parseInt(tokenizer.nextToken());
                    int i = parentArray.length - count;
                    while (i < parentArray.length) {
                        stack.add(parentArray[i]);
                        ++i;
                    }
                    this.line = this.reader.readLine();
                    break;
                }
                String auxL = this.line.substring(4);
                int state = 0;
                StringTokenizer sTokenizer = new StringTokenizer(auxL, "():");
                while (sTokenizer.hasMoreTokens()) {
                    String sToken = sTokenizer.nextToken();
                    switch (state) {
                        case 0: {
                            int lastDot = sToken.lastIndexOf(46);
                            this.className.set(sElement, sToken.substring(0, lastDot));
                            this.methodName.set(sElement, sToken.substring(lastDot + 1));
                            state = 1;
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (sToken.equals("Native Method")) {
                                this.lineNumber.setInt(sElement, -2);
                                state = 2;
                                break;
                            }
                            this.fileName.set(sElement, sToken);
                            state = 3;
                            break;
                        }
                        case 3: {
                            this.lineNumber.setInt(sElement, Integer.parseInt(sToken));
                            break;
                        }
                    }
                }
                stack.add(sElement);
                this.line = this.reader.readLine();
            }
        }
        catch (Exception e) {
            return null;
        }
        return stack.toArray((Object[])Array.newInstance(this.stackTraceElementElement, 0));
    }

    private Throwable constructChain(List chain) {
        Throwable cause = null;
        int i = chain.size() - 1;
        while (i >= 0) {
            ExceptionDesc desc = (ExceptionDesc)chain.get(i);
            if ((cause = cause == null ? this.createException(desc.exceptionClass, desc.message, null) : this.createException(desc.exceptionClass, desc.message, cause)) == null) {
                return null;
            }
            try {
                Method setStackTrace = (class$java$lang$Throwable == null ? DefaultFaultDeserializer.class$("java.lang.Throwable") : class$java$lang$Throwable).getDeclaredMethod("setStackTrace", this.stackTraceElementElementArray);
                setStackTrace.invoke((Object)cause, desc.trace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --i;
        }
        return cause;
    }

    Throwable createExceptionNoConstructor(Class clazz) {
        return null;
    }

    private Throwable createException(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (Throwable)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return this.createExceptionNoConstructor(clazz);
        }
    }

    private Throwable createException(Class clazz, String message) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultFaultDeserializer.class$("java.lang.String")) : class$java$lang$String);
            return (Throwable)constructor.newInstance(message);
        }
        catch (Exception e) {
            return this.createException(clazz);
        }
    }

    private Throwable createException(Class clazz, String message, Throwable cause) {
        Throwable ret;
        block11: {
            ret = null;
            if (cause == null) {
                ret = this.createException(clazz, message);
            } else {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultFaultDeserializer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = DefaultFaultDeserializer.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                    ret = (Throwable)constructor.newInstance(message, cause);
                }
                catch (Exception e) {
                    try {
                        Constructor constructor = clazz.getDeclaredConstructor(class$java$lang$Throwable == null ? (class$java$lang$Throwable = DefaultFaultDeserializer.class$("java.lang.Throwable")) : class$java$lang$Throwable, class$java$lang$String == null ? (class$java$lang$String = DefaultFaultDeserializer.class$("java.lang.String")) : class$java$lang$String);
                        ret = (Throwable)constructor.newInstance(cause, message);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (ret != null) break block11;
                    ret = this.createException(clazz, message);
                }
            }
        }
        try {
            if (cause != null) {
                if ((class$org$idoox$util$WrappedException == null ? (class$org$idoox$util$WrappedException = DefaultFaultDeserializer.class$("org.idoox.util.WrappedException")) : class$org$idoox$util$WrappedException).isAssignableFrom(clazz)) {
                    this.wrappedReason.set(ret, cause);
                } else {
                    this.throwableCause.set(ret, cause);
                }
            }
            this.throwableDetailMessage.set(ret, message);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ExceptionDesc {
        public String message;
        public Class exceptionClass;
        public Object trace;

        public ExceptionDesc(String message, Class exceptionClass, Object trace) {
            this.message = message;
            this.exceptionClass = exceptionClass;
            this.trace = trace;
        }
    }
}

