/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.WaspSerializationHelper;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;

public class ChoiceHelper {
    static /* synthetic */ Class class$java$lang$Object;

    public static String getClassName(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static Method getMethod(Class cls, String prefix, String suffix, String recInfix) {
        recInfix = ChoiceHelper.getClassName(recInfix != null ? recInfix : cls.getName());
        Method[] methods = cls.getMethods();
        if (methods != null) {
            String name = prefix + suffix;
            String extName = prefix + recInfix + suffix;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equalsIgnoreCase(extName)) {
                    return methods[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equalsIgnoreCase(name)) {
                    return methods[i2];
                }
                ++i2;
            }
        }
        throw new IllegalArgumentException("Method " + prefix + suffix + " not found in " + cls.getName() + ".");
    }

    public static Field getField(Class cls, String prefix, String infix, String suffix, String recInfix) {
        recInfix = ChoiceHelper.getClassName(recInfix != null ? recInfix : cls.getName());
        Field[] fields = cls.getFields();
        if (fields != null) {
            String name = prefix + suffix;
            String extName = prefix + recInfix + infix + suffix;
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().equalsIgnoreCase(extName)) {
                    return fields[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < fields.length) {
                if (fields[i2].getName().equalsIgnoreCase(name)) {
                    return fields[i2];
                }
                ++i2;
            }
        }
        throw new IllegalArgumentException("Field " + prefix + suffix + " not found in " + cls.getName() + ".");
    }

    public static Method getDeclaredMethod(Class cls, String prefix, String suffix) {
        Method[] methods = cls.getMethods();
        if (methods != null) {
            String name = prefix + suffix;
            String extName = prefix + ChoiceHelper.getClassName(cls.getName()) + suffix;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equalsIgnoreCase(extName)) {
                    return methods[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equalsIgnoreCase(name)) {
                    return methods[i2];
                }
                ++i2;
            }
        }
        throw new IllegalArgumentException("Method " + prefix + suffix + " not found in " + cls.getName() + ".");
    }

    public static Field getDeclaredField(Class cls, String prefix, String infix, String suffix) {
        Field[] fields = cls.getFields();
        if (fields != null) {
            String name = prefix + suffix;
            String extName = prefix + ChoiceHelper.getClassName(cls.getName()) + infix + suffix;
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().equalsIgnoreCase(extName)) {
                    return fields[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < fields.length) {
                if (fields[i2].getName().equalsIgnoreCase(name)) {
                    return fields[i2];
                }
                ++i2;
            }
        }
        throw new IllegalArgumentException("Field " + prefix + suffix + " not found in " + cls.getName() + ".");
    }

    public static Class getChoiceClass(Class cls, String selection, String recInfix) {
        Method method = ChoiceHelper.getMethod(cls, "get", WaspSerializationHelper.mapElementName(selection), recInfix);
        return method.getReturnType();
    }

    public static int getChoiceClassDiscriminator(Class cls, String selection) throws IllegalAccessException {
        selection = WaspSerializationHelper.mapElementName(selection);
        Field fld = ChoiceHelper.getField(cls, "DISC_", "_", selection, cls.getName());
        return fld.getInt(null);
    }

    public static int getChoiceDiscriminator(Object choiceObject, String recInfix) {
        try {
            Method method = ChoiceHelper.getMethod(choiceObject.getClass(), "get", "Discriminator", recInfix);
            return (Integer)method.invoke(choiceObject, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Choice discriminator method not found in class '" + choiceObject.getClass() + "': " + e);
        }
    }

    public static String getChoiceDiscriminatorString(Object choiceObject, Class cls) throws IllegalAccessException {
        int disc = ChoiceHelper.getChoiceDiscriminator(choiceObject, cls.getName());
        Field[] fields = cls.getFields();
        if (fields != null && cls != null) {
            String discName = ("DISC_" + ChoiceHelper.getClassName(cls.getName())).toUpperCase();
            int i = 0;
            while (i < fields.length) {
                Object val;
                if (fields[i].getName().toUpperCase().startsWith(discName) && (val = fields[i].get(choiceObject)) != null && val instanceof Integer && (Integer)val == disc) {
                    return fields[i].getName().substring(5);
                }
                ++i;
            }
        }
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                Object val;
                if (fields[i].getName().toUpperCase().startsWith("DISC_") && (val = fields[i].get(choiceObject)) != null && val instanceof Integer && (Integer)val == disc) {
                    return fields[i].getName().substring(5);
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("Choice discriminator not found in " + choiceObject.getClass() + ". Choicable object is probably in a bad state.");
    }

    public static Object getChoiceValue(Object choiceObject, String method) throws InvocationTargetException, IllegalAccessException {
        Method getter = ChoiceHelper.getMethod(choiceObject.getClass(), "get", method, "");
        return getter.invoke(choiceObject, new Object[0]);
    }

    public static SchemaConstruct getChoiceConstruct(Type choiceType, String disc) {
        disc = WaspSerializationHelper.mapElementName(disc);
        SchemaConstruct[] subs = choiceType.getSubconstructs();
        if (subs != null) {
            int i = 0;
            while (i < subs.length) {
                SchemaConstruct.ConstructType constructType = subs[i].getConstructType();
                if (constructType == SchemaConstruct.ConstructType.MEMBER || constructType == SchemaConstruct.ConstructType.TYPE) {
                    String name = WaspSerializationHelper.getConstructJavaMemberName(subs[i]);
                    if (disc.equalsIgnoreCase(name)) {
                        return subs[i];
                    }
                    if (name != null) {
                        int j = 0;
                        while (j < disc.length() && j < name.length()) {
                            if (Character.toUpperCase(disc.charAt(j)) != Character.toUpperCase(name.charAt(j))) {
                                if (!disc.equalsIgnoreCase(name.substring(0, j) + "_" + name.substring(j))) break;
                                return subs[i];
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("Choice member for " + disc + " not found in " + choiceType.toIndentedString());
    }

    public static boolean isChoiceEmpty(Object choiceObject, String recInfix) throws IllegalAccessException {
        Field emptyChoiceField;
        try {
            emptyChoiceField = ChoiceHelper.getField(choiceObject.getClass(), "DISC_", "_", "EMPTY_CHOICE", recInfix);
        }
        catch (Exception e) {
            return false;
        }
        int disc = ChoiceHelper.getChoiceDiscriminator(choiceObject, recInfix);
        return disc == emptyChoiceField.getInt(choiceObject);
    }

    public static Object newInstance(Class choiceClass, int disc, Object inner) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor constr = choiceClass.getConstructor(Integer.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = ChoiceHelper.class$("java.lang.Object")) : class$java$lang$Object);
        if (constr == null) {
            throw new IllegalArgumentException("A choice constructor not found for class " + choiceClass.getName() + ": " + choiceClass.getName() + "." + choiceClass.getName() + "(int, Object)");
        }
        return constr.newInstance(new Integer(disc), inner);
    }

    public static Object newEmptyInstance(Class choiceClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        int disc = ChoiceHelper.getChoiceClassDiscriminator(choiceClass, "EMPTY_CHOICE");
        return ChoiceHelper.newInstance(choiceClass, disc, null);
    }

    public static boolean decomposeChoice(Class choiceClass, List choiceValues, List choiceFields, List choiceGetters, List choiceParents) {
        if (choiceClass == null) {
            return false;
        }
        if (ChoiceHelper.decomposeChoice(choiceClass.getSuperclass(), new ArrayList(), new ArrayList(), new ArrayList(), choiceParents)) {
            choiceParents.add(choiceClass.getSuperclass());
        }
        if (choiceClass.isArray() || choiceClass.isPrimitive()) {
            return false;
        }
        if (!choiceClass.isInterface()) {
            try {
                Class[] constructorArgs = new Class[choiceParents.size() * 2 + 2];
                int i = 0;
                while (i <= choiceParents.size()) {
                    constructorArgs[i * 2] = Integer.TYPE;
                    constructorArgs[i * 2 + 1] = class$java$lang$Object == null ? ChoiceHelper.class$("java.lang.Object") : class$java$lang$Object;
                    ++i;
                }
                if (choiceClass.getDeclaredConstructor(constructorArgs) == null) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            Method discMethod = ChoiceHelper.getDeclaredMethod(choiceClass, "get", "Discriminator");
            if (discMethod == null || discMethod.getParameterTypes().length > 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        Method[] methods = choiceClass.getDeclaredMethods();
        Field[] fields = choiceClass.getDeclaredFields();
        choiceValues.clear();
        choiceFields.clear();
        choiceGetters.clear();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            int methodModif = method.getModifiers();
            if (Modifier.isPublic(methodModif) && !Modifier.isStatic(methodModif) && methodName.startsWith("get")) {
                methodName = Introspector.decapitalize(methodName.substring(3));
                int j = 0;
                while (j < fields.length) {
                    Field field = fields[j];
                    String fieldName = field.getName();
                    int fieldModif = field.getModifiers();
                    if (Modifier.isPublic(fieldModif) && Modifier.isStatic(fieldModif) && Modifier.isFinal(fieldModif) && field.getType().equals(Integer.TYPE) && fieldName.startsWith("DISC_")) {
                        if ((fieldName = fieldName.substring(5)).equalsIgnoreCase(methodName)) {
                            choiceValues.add(methodName);
                            choiceFields.add(methodName);
                            choiceGetters.add(method);
                        } else {
                            String className = ChoiceHelper.getClassName(choiceClass.getName());
                            if (methodName.length() > className.length()) {
                                String enhMethodName = Introspector.decapitalize(methodName.substring(className.length()));
                                if (fieldName.equalsIgnoreCase(className + "_" + enhMethodName)) {
                                    choiceValues.add(enhMethodName);
                                    choiceFields.add(methodName);
                                    choiceGetters.add(method);
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return choiceValues.size() > 0;
    }

    public static boolean canBeEmpty(Class typeClass) {
        try {
            return ChoiceHelper.getField(typeClass, "DISC_", "_", "EMPTY_CHOICE", null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

