/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.routing;

import com.idoox.debug.Category;
import com.idoox.wasp.HProcessor;
import com.idoox.wasp.routing.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.wasp.Context;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.MultipleHeadersException;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.handler.WaspHandlerInfo;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSRoutingHeaderProcessor
implements HProcessor {
    private static final Category log = Category.getCategory("com.idoox.wasp.WSRoutingHeaderProcessor");
    public static final String ROUTING_HEADER_NS = "http://schemas.xmlsoap.org/rp";
    public static final String ROUTING_HEADER_NAME = "path";
    public static final String CALL_CONTEXT_CURRENT_PATH_KEY = "routing.current.path";
    private boolean headerCreated;
    private boolean bcMode = false;
    private boolean bcModeDetected = false;

    public boolean wasHeaderCreated() {
        return this.headerCreated;
    }

    public static Path getCurrentPath() {
        return WSRoutingHeaderProcessor.getCurrentPath(Current.getCallContext().getContextData());
    }

    public static Path getCurrentPath(Map callContextData) {
        try {
            return (Path)callContextData.get(CALL_CONTEXT_CURRENT_PATH_KEY);
        }
        catch (ClassCastException e) {
            log.error("CallContext contains non-Path as the current Path");
            return null;
        }
    }

    public static void storeIncomingPath(Path path) {
        Map callContextData = Current.getCallContext().getContextData();
        AddressingHeaders addr = (AddressingHeaders)callContextData.get("addressing.input");
        if (addr == null) {
            addr = new AddressingHeaders(new EndpointReference(path.to), path.id);
            addr.setRelatedMessageID(path.relatesTo, null);
            addr.replyTo = path.rev != null && path.rev.via.length > 0 ? new EndpointReference(path.rev.via[0].value) : new EndpointReference("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous");
            callContextData.put("addressing.input", addr);
        }
    }

    public void processOutput(Message message, Map callContextData, String soapAction) throws HeaderProcessingException {
        this.headerCreated = false;
        this.detectBCMode();
        AddressingHeaders addr = (AddressingHeaders)callContextData.get("addressing.output");
        if (this.bcMode && addr.messageID == null) {
            return;
        }
        Path path = this.createPath(callContextData);
        if (path.relatesTo == null) {
            path.action = soapAction;
        }
        RoutingCreatingTokenizer header = new RoutingCreatingTokenizer(path, message);
        try {
            message.addHeader(header);
            this.headerCreated = true;
        }
        catch (IOException e) {
            log.error("an IOException occurred when adding the Routing header", e);
            throw new HeaderProcessingException("IOException when adding the Routing header.");
        }
        catch (TokenizerException e) {
            log.error("a tokenizer exception occurred when adding the Routing header", e);
            throw new HeaderProcessingException("Tokenizer exception when adding the Routing header.");
        }
        catch (MessageProcessingException e) {
            log.error("a MessageProcessingException occurred when adding the Routing header", e);
            throw new HeaderProcessingException("MessageProcessingException when adding the Routing header.");
        }
    }

    public void processOutput(Message message) throws HeaderProcessingException {
        this.headerCreated = false;
        Map contextData = Current.getCallContext().getContextData();
        AddressingHeaders addr = (AddressingHeaders)contextData.get("addressing.output");
        if (addr != null) {
            this.processOutput(message, contextData, null);
        }
    }

    private Path createPath(Map callContext) {
        String replyTo;
        AddressingHeaders addr = (AddressingHeaders)callContext.get("addressing.output");
        Path path = new Path();
        path.id = addr.messageID;
        path.relatesTo = addr.getRelatedMessageID(AddressingHeaders.Relationship.RESPONSE);
        path.rev = new Path.Vias();
        path.fwd = new Path.Vias();
        String string = replyTo = addr.replyTo != null ? addr.replyTo.getAddress() : null;
        if (replyTo != null && !"http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous".equals(replyTo)) {
            path.rev.via = new Path.Via[1];
            path.rev.via[0] = new Path.Via();
            path.rev.via[0].value = replyTo;
            path.fwd.via = new Path.Via[1];
            path.fwd.via[0] = new Path.Via();
            path.fwd.via[0].vid = null;
        } else {
            path.rev.via = new Path.Via[0];
        }
        return path;
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
        this.processOutput(message);
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
        Tokenizer header;
        try {
            header = message.getHeader(new QName(ROUTING_HEADER_NS, ROUTING_HEADER_NAME));
            if (header != null) {
                message.removeHeader(new QName(ROUTING_HEADER_NS, ROUTING_HEADER_NAME));
            }
        }
        catch (MultipleHeadersException e) {
            log.error("Too many Routing headers present in one message.");
            throw new HeaderProcessingException("Multiple Routing headers present in one message.");
        }
        if (header == null) {
            return;
        }
        Path incomingPath = this.deserializePath(header);
        WSRoutingHeaderProcessor.storeIncomingPath(incomingPath);
    }

    public void processInput(Message message) throws HeaderProcessingException {
        Tokenizer header;
        try {
            header = message.getHeader(new QName(ROUTING_HEADER_NS, ROUTING_HEADER_NAME));
            if (header != null) {
                message.removeHeader(new QName(ROUTING_HEADER_NS, ROUTING_HEADER_NAME));
            }
        }
        catch (MultipleHeadersException e) {
            log.error("Too many Routing headers present in one message.");
            throw new HeaderProcessingException("Multiple Routing headers present in one message.");
        }
        if (header == null) {
            return;
        }
        Path incomingPath = this.deserializePath(header);
        WSRoutingHeaderProcessor.storeIncomingPath(incomingPath);
    }

    private Path deserializePath(Tokenizer header) throws HeaderProcessingException {
        Path path = new Path();
        try {
            byte state = header.next();
            while (state == 2 || state == 4) {
                WSRoutingHeaderProcessor.skipContent(header);
                if (!ROUTING_HEADER_NS.equals(header.getNamespace())) {
                    WSRoutingHeaderProcessor.skipUnknownElement(header);
                    continue;
                }
                String localName = header.getLocalName();
                if ("action".equals(localName)) {
                    path.action = WSRoutingHeaderProcessor.readString(header);
                } else if ("to".equals(localName)) {
                    path.to = WSRoutingHeaderProcessor.readString(header);
                } else if ("from".equals(localName)) {
                    path.from = WSRoutingHeaderProcessor.readString(header);
                } else if ("id".equals(localName)) {
                    path.id = WSRoutingHeaderProcessor.readString(header);
                } else if ("relatesTo".equals(localName)) {
                    path.relatesTo = WSRoutingHeaderProcessor.readString(header);
                } else if ("req".equals(localName)) {
                    path.fwd = this.deserializeVias(header);
                } else if ("rev".equals(localName)) {
                    path.rev = this.deserializeVias(header);
                } else if ("fault".equals(localName)) {
                    path.fault = this.deserializeFault(header);
                } else {
                    WSRoutingHeaderProcessor.skipUnknownElement(header);
                }
                state = header.next();
            }
            if (state != 3) {
                throw new HeaderProcessingException("malformed <routing> element");
            }
        }
        catch (IOException e) {
            log.error("an IOException occurred when reading the Routing header", e);
            throw new HeaderProcessingException("IOException when trying to parse the Routing header.");
        }
        catch (TokenizerException e) {
            log.error("a tokenizer exception occurred when reading the Routing header", e);
            throw new HeaderProcessingException("Tokenizer exception when trying to parse the Routing header.");
        }
        return path;
    }

    private Path.Vias deserializeVias(Tokenizer header) throws HeaderProcessingException {
        ArrayList<Path.Via> viaList = new ArrayList<Path.Via>();
        try {
            byte state = header.next();
            while (state == 2 || state == 4) {
                WSRoutingHeaderProcessor.skipContent(header);
                if (!ROUTING_HEADER_NS.equals(header.getNamespace())) {
                    WSRoutingHeaderProcessor.skipUnknownElement(header);
                    continue;
                }
                String localName = header.getLocalName();
                if ("addr".equals(localName) || "via".equals(localName)) {
                    Path.Via via = new Path.Via();
                    via.value = WSRoutingHeaderProcessor.readString(header);
                    viaList.add(via);
                } else {
                    WSRoutingHeaderProcessor.skipUnknownElement(header);
                }
                state = header.next();
            }
            if (state != 3) {
                log.error("malformed <routing> element");
                throw new HeaderProcessingException("malformed <routing> element");
            }
        }
        catch (IOException e) {
            log.error("an IOException occurred when reading the Routing header", e);
            throw new HeaderProcessingException("IOException when trying to parse the Routing header.");
        }
        catch (TokenizerException e) {
            log.error("a tokenizer exception occurred when reading the Routing header", e);
            throw new HeaderProcessingException("Tokenizer exception when trying to parse the Routing header.");
        }
        Path.Vias vias = new Path.Vias();
        vias.via = viaList.toArray(new Path.Via[0]);
        return vias;
    }

    private Path.Fault deserializeFault(Tokenizer header) throws HeaderProcessingException, TokenizerException, IOException {
        WSRoutingHeaderProcessor.skipUnknownElement(header);
        return null;
    }

    private static String readString(Tokenizer tokenizer) throws HeaderProcessingException {
        try {
            String elementName = tokenizer.getLocalName();
            String ret = "";
            byte token = tokenizer.next();
            if (token == 4) {
                ret = tokenizer.readContent();
                token = tokenizer.next();
            }
            if (token != 3) {
                throw new HeaderProcessingException("Unexpected token " + Tokenizer.typeNames[token] + " in reading contents of element " + elementName);
            }
            return ret;
        }
        catch (TokenizerException e) {
            log.error("a TokenizerException occurred when reading the Routing header", e);
            throw new HeaderProcessingException("a TokenizerException occurred when reading the Routing header");
        }
        catch (IOException e) {
            log.error("an IOException occurred when reading the Routing header", e);
            throw new HeaderProcessingException("a TokenizerException occurred when reading the Routing header");
        }
    }

    private static void skipContent(Tokenizer header) throws TokenizerException, IOException {
        byte state = header.currentState();
        while (state == 4) {
            state = header.next();
        }
    }

    private static void skipUnknownElement(Tokenizer header) throws HeaderProcessingException, TokenizerException, IOException {
        int depth = 1;
        log.warn("skipping unknown element {" + header.getNamespace() + "}" + header.getLocalName());
        do {
            byte state = header.next();
            switch (state) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                    break;
                }
                case 1: {
                    HeaderProcessingException e = new HeaderProcessingException("Unexpected tokenizer end of document in routing header.");
                    log.error(e);
                    throw e;
                }
            }
        } while (depth > 0);
    }

    private synchronized void detectBCMode() {
        if (!this.bcModeDetected) {
            this.bcModeDetected = true;
            HandlerRepository handlerRepository = (HandlerRepository)Context.getInstance("wasp.core.jaxrpc_handler_repository");
            HandlerRepository.HandlerChainRepresentation chain = handlerRepository.getHandlerChain("DefaultClientHandlers");
            int i = 0;
            while (i < chain.getHandlersCount()) {
                WaspHandlerInfo handlerInfo = chain.getHandler(i);
                if ("com.systinet.wsaddressing.WSAddressingHandler".equals(handlerInfo.getHandlerClass().getName())) {
                    this.bcMode = true;
                    return;
                }
                ++i;
            }
        }
    }

    class RoutingCreatingTokenizer
    implements Tokenizer {
        private Path path;
        private byte state = 0;
        private int count = 0;
        private String localName;
        private String content;
        private Attribute[] attrs;
        private Message message = null;
        private byte[] states = new byte[]{2, 2, 4, 3, 2, 4, 3, 2, 2, 4, 3, 3, 2, 2, 4, 3, 3, 2, 4, 3, 2, 4, 3, 2, 4, 3, 2, 2, 4, 3, 2, 4, 3, 2, 4, 3, 2, 2, 4, 3, 3, 2, 4, 3, 2, 4, 3, 2, 4, 3, 3, 3};
        private String[] localNames = new String[]{"path", "action", null, "action", "to", null, "to", "req", "addr", null, "addr", "req", "rev", "via", null, "via", "rev", "from", null, "from", "id", null, "id", "relatesTo", null, "relatesTo", "fault", "faultcode", null, "faultcode", "faultreason", null, "faultreason", "endpoint", null, "endpoint", "found", "at", null, "at", "found", "maxsize", null, "maxsize", "maxtime", null, "maxtime", "retryAfter", null, "retryAfter", "fault", "path"};
        private int arrayPos = 0;

        RoutingCreatingTokenizer(Path path, Message message) {
            this.message = message;
            this.path = path;
            try {
                this.next();
            }
            catch (TokenizerException e) {
                // empty catch block
            }
        }

        private void theUsual() {
            this.state = this.states[this.count];
            this.localName = this.localNames[this.count];
            ++this.count;
        }

        public byte next() throws TokenizerException {
            boolean loop;
            block32: do {
                loop = false;
                switch (this.count) {
                    case 0: {
                        this.theUsual();
                        if (WSRoutingHeaderProcessor.this.bcMode) continue block32;
                        Attribute mU = new Attribute();
                        QName muQName = this.message.getAttrQNameMustUnderstand();
                        mU.localName = muQName.getLocalPart();
                        mU.uri = muQName.getNamespaceURI();
                        mU.value = "1";
                        this.attrs = new Attribute[1];
                        this.attrs[0] = mU;
                        break;
                    }
                    case 1: {
                        this.attrs = null;
                        this.theUsual();
                        break;
                    }
                    case 2: {
                        this.theUsual();
                        this.content = this.path.action;
                        break;
                    }
                    case 3: {
                        this.theUsual();
                        break;
                    }
                    case 4: {
                        if (this.path.to != null) {
                            this.theUsual();
                            break;
                        }
                        this.count = 7;
                        loop = true;
                        break;
                    }
                    case 5: {
                        this.theUsual();
                        this.content = this.path.to;
                        break;
                    }
                    case 6: {
                        this.theUsual();
                        break;
                    }
                    case 7: {
                        this.count = 12;
                        loop = true;
                        break;
                    }
                    case 8: {
                        Attribute vidattr;
                        if (this.path.fwd.via != null && this.path.fwd.via.length > this.arrayPos) {
                            this.theUsual();
                            if (this.path.fwd.via[this.arrayPos] == null || this.path.fwd.via[this.arrayPos].vid == null) continue block32;
                            vidattr = new Attribute();
                            vidattr.localName = "vid";
                            vidattr.uri = WSRoutingHeaderProcessor.ROUTING_HEADER_NS;
                            vidattr.value = this.path.fwd.via[this.arrayPos].vid;
                            this.attrs = new Attribute[1];
                            this.attrs[0] = vidattr;
                            break;
                        }
                        this.arrayPos = 0;
                        this.count = 11;
                        loop = true;
                        break;
                    }
                    case 9: {
                        this.theUsual();
                        this.content = this.path.fwd.via[this.arrayPos++].value;
                        if (this.content != null) continue block32;
                    }
                    case 10: {
                        this.theUsual();
                        this.attrs = null;
                        this.count = 8;
                        break;
                    }
                    case 11: {
                        this.theUsual();
                        break;
                    }
                    case 12: {
                        if (this.path.rev != null) {
                            this.theUsual();
                            break;
                        }
                        this.count = 17;
                        loop = true;
                        break;
                    }
                    case 13: {
                        Attribute vidattr;
                        if (this.path.rev.via != null && this.path.rev.via.length > this.arrayPos) {
                            this.theUsual();
                            if (this.path.fwd.via[this.arrayPos] == null || this.path.fwd.via[this.arrayPos].vid == null) continue block32;
                            vidattr = new Attribute();
                            vidattr.localName = "vid";
                            vidattr.uri = WSRoutingHeaderProcessor.ROUTING_HEADER_NS;
                            vidattr.value = this.path.fwd.via[this.arrayPos].vid;
                            this.attrs = new Attribute[1];
                            this.attrs[0] = vidattr;
                            break;
                        }
                        this.arrayPos = 0;
                        this.count = 16;
                        loop = true;
                        break;
                    }
                    case 14: {
                        this.theUsual();
                        this.content = this.path.rev.via[this.arrayPos++].value;
                        if (this.content != null) continue block32;
                    }
                    case 15: {
                        this.theUsual();
                        this.attrs = null;
                        this.count = 13;
                        break;
                    }
                    case 16: {
                        this.theUsual();
                        break;
                    }
                    case 17: {
                        if (this.path.from != null) {
                            this.theUsual();
                            break;
                        }
                        this.count = 20;
                        loop = true;
                        break;
                    }
                    case 18: {
                        this.theUsual();
                        this.content = this.path.from;
                        break;
                    }
                    case 19: {
                        this.theUsual();
                        break;
                    }
                    case 20: {
                        if (this.path.id != null) {
                            this.theUsual();
                            break;
                        }
                        this.count = 23;
                        loop = true;
                        break;
                    }
                    case 21: {
                        this.theUsual();
                        this.content = this.path.id;
                        break;
                    }
                    case 22: {
                        this.theUsual();
                        break;
                    }
                    case 23: {
                        if (this.path.relatesTo != null) {
                            this.theUsual();
                            break;
                        }
                        this.count = 26;
                        loop = true;
                        break;
                    }
                    case 24: {
                        this.theUsual();
                        this.content = this.path.relatesTo;
                        break;
                    }
                    case 25: {
                        this.theUsual();
                        break;
                    }
                    case 26: {
                        if (this.path.fault != null) {
                            this.theUsual();
                            break;
                        }
                        this.count = 51;
                        loop = true;
                        break;
                    }
                    case 50: {
                        this.theUsual();
                        break;
                    }
                    case 51: {
                        this.theUsual();
                        break;
                    }
                    case 52: {
                        this.state = 1;
                        ++this.count;
                        break;
                    }
                    default: {
                        throw new TokenizerException("next() after the end of the document!");
                    }
                }
            } while (loop);
            return this.state;
        }

        public String getLocalName() throws TokenizerException {
            if (this.state == 0) {
                throw new TokenizerException("Invalid state.");
            }
            return this.localName;
        }

        public String getNamespace() throws TokenizerException {
            if (this.state == 0) {
                throw new TokenizerException("Invalid state.");
            }
            return WSRoutingHeaderProcessor.ROUTING_HEADER_NS;
        }

        public String getNamespaceForPrefix(String prefix) {
            return null;
        }

        public QName parseQName(String qName) {
            return null;
        }

        public byte currentState() {
            return this.state;
        }

        public String readContent() throws TokenizerException {
            if (this.state != 4) {
                throw new TokenizerException("Invalid state.");
            }
            if (this.content == null) {
                return "";
            }
            return this.content;
        }

        public void readToken(Token stoken) throws TokenizerException {
            if (stoken == null) {
                throw new TokenizerException("Null token to fill.");
            }
            stoken.clear();
            stoken.type = this.state;
            stoken.uri = WSRoutingHeaderProcessor.ROUTING_HEADER_NS;
            stoken.localName = this.localName;
            stoken.attArr = this.attrs;
            stoken.attEnd = this.attrs != null ? this.attrs.length : 0;
        }

        public boolean whitespaceContent() throws TokenizerException {
            if (this.state != 4) {
                throw new TokenizerException("Invalid state.");
            }
            return false;
        }

        public Map getCurrentPrefixMap() {
            return null;
        }

        public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
            return 0;
        }

        public Element getDOMRepresentation(Document doc) throws TokenizerException {
            throw new UnsupportedOperationException("not supported");
        }
    }
}

