/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interrefs;

import com.idoox.wasp.interrefs.ClientInterrefDeserializer;
import com.idoox.wasp.interrefs.ServiceReference;
import java.util.Map;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ServerInterrefDeserializer
extends ClientInterrefDeserializer {
    public String getMechanismType() {
        return Deserializer.MECHANISM_TYPE;
    }

    public Object deserialize(EncodingTokenizer data, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        Object ret;
        ServiceEndpointContext wsCtx = Current.getServiceEndpointContext();
        if (wsCtx == null) {
            return super.deserialize(data, targetClass, context, chain);
        }
        WSRegistry wsReg = (WSRegistry)wsCtx.getContextData().get("core.ws_registry");
        if (wsReg == null) {
            throw new MessageProcessingException("Cannot get WSRegistry instance!");
        }
        ServiceReference sRef = this.decodeServiceReference(data, context);
        String instanceID = sRef.getInstanceID();
        if (instanceID != null && (ret = wsReg.getService(instanceID)) != null) {
            return ret;
        }
        return this.deserializeServiceReference(sRef, targetClass, context);
    }

    protected String getPortTypeMappingRegistryConfigName() {
        ServiceEndpointContext wsc = Current.getServiceEndpointContext();
        if (wsc == null) {
            return super.getPortTypeMappingRegistryConfigName();
        }
        Map context = wsc.getContextData();
        return (String)context.get("wasp.JavaAdaptor.PortTypeMappingRegistryConfig");
    }
}

