/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interrefs;

import com.idoox.debug.Category;
import com.idoox.wasp.PortTypeMappingRegistry;
import com.idoox.wasp.SOAPServiceInfoCache;
import com.idoox.wasp.interrefs.ClientInterrefSerializer;
import com.idoox.wasp.interrefs.ServiceReference;
import com.idoox.wasp.serialization.DeserializationException;
import com.systinet.wasp.client.MultipleInterfaceProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.security.Credentials;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.wasp.wsdl.WSDLRepository;
import org.idoox.webservice.CallContext;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClient;

public class ClientInterrefDeserializer
implements Deserializer {
    private static final Category log = Category.getCategory("com.idoox.wasp.interrefs.ClientInterrefDeserializer");
    private WSDLRepository wsdlRepo = (WSDLRepository)Context.getInstance("org.idoox.wasp.wsdl.WSDLRepository");

    public String getMechanismType() {
        return Deserializer.MECHANISM_TYPE;
    }

    public Object deserialize(EncodingTokenizer data, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceReference sRef = this.decodeServiceReference(data, context);
        return this.deserializeServiceReference(sRef, targetClass, context);
    }

    protected String getPortTypeMappingRegistryConfigName() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void findTokenEnd(EncodingTokenizer stream) throws MessageProcessingException {
        int token;
        int depth = 1;
        while (depth > 0 && (token = stream.nextToken()) != 0) {
            void var3_3;
            switch (var3_3) {
                case 1: 
                case 3: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
    }

    public void init(Configurable config) {
    }

    private void handleInterfaceMappings(List mappings, DeserializationContext context) {
        if (mappings.size() == 0) {
            return;
        }
        PortTypeMappingRegistry irepo = (PortTypeMappingRegistry)Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
        String irepoKey = this.getPortTypeMappingRegistryConfigName();
        ClassLoader cl = context.getClassLoader();
        Iterator it = mappings.iterator();
        while (it.hasNext()) {
            ClientInterrefSerializer.InterfaceMapping mapping = (ClientInterrefSerializer.InterfaceMapping)it.next();
            Class old = irepo.getInterfaceOfPortType(irepoKey, mapping.portType);
            if (old != null) continue;
            Class<?> iface = null;
            try {
                iface = Class.forName(mapping.className, true, cl);
                irepo.setInterfaceMapping(irepoKey, mapping.portType, iface);
            }
            catch (ClassNotFoundException e) {
                log.warn("failed to load interface " + mapping.className);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ServiceReference decodeServiceReference(EncodingTokenizer data, DeserializationContext context) throws MessageProcessingException {
        int current;
        QName service = null;
        String instanceID = null;
        String wsdl = null;
        SchemaContext.State state = context.enterCurrentMember();
        while ((current = data.nextToken()) != 0 && current != 2) {
            void var3_7;
            switch (var3_7) {
                case 1: {
                    log.warn("the remote reference structure contains an unknown complex token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                    this.findTokenEnd(data);
                    break;
                }
                case 3: {
                    if ("portTypeMappings".equals(data.getTokenName())) {
                        List mappings = this.deserializeMappings(data);
                        this.handleInterfaceMappings(mappings, context);
                        break;
                    }
                    log.warn("the remote reference structure contains an unknown array token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                    break;
                }
                case 4: {
                    context.nextSchemaConstruct(data.getTokenNamespaceURI(), data.getTokenName());
                    if ("instanceID".equals(data.getTokenName())) {
                        instanceID = data.getPrimitiveTokenValue();
                        break;
                    }
                    if ("service".equals(data.getTokenName())) {
                        String serviceQName = data.getPrimitiveTokenValue();
                        service = data.convertToQName(serviceQName);
                        break;
                    }
                    if ("wsdl".equals(data.getTokenName())) {
                        wsdl = data.getPrimitiveTokenValue();
                        break;
                    }
                    log.warn("the remote reference structure contains an unknown token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                    break;
                }
                case 5: {
                    context.nextSchemaConstruct(data.getTokenNamespaceURI(), data.getTokenName());
                    log.warn("the remote reference structure contains a reference {" + data.getTokenNamespaceURI() + "}" + data.getTokenName());
                    break;
                }
                case 6: {
                    context.nextSchemaConstruct(data.getTokenNamespaceURI(), data.getTokenName());
                    log.warn("the remote reference structure contains a null value {" + data.getTokenNamespaceURI() + "}" + data.getTokenName());
                }
            }
        }
        context.leave(state);
        return new ServiceReference(instanceID, service, wsdl);
    }

    /*
     * WARNING - void declaration
     */
    private List deserializeMappings(EncodingTokenizer data) throws MessageProcessingException {
        int current;
        ArrayList<ClientInterrefSerializer.InterfaceMapping> retval = new ArrayList<ClientInterrefSerializer.InterfaceMapping>();
        boolean end = false;
        ClientInterrefSerializer.InterfaceMapping currentMapping = null;
        while (!end && (current = data.nextToken()) != 0) {
            void var2_5;
            switch (var2_5) {
                case 2: {
                    if (currentMapping == null) {
                        end = true;
                        break;
                    }
                    retval.add(currentMapping);
                    currentMapping = null;
                    break;
                }
                case 1: {
                    if (currentMapping == null) {
                        currentMapping = new ClientInterrefSerializer.InterfaceMapping();
                        break;
                    }
                    log.warn("an interface mapping structure contains an unknown complex token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                    this.findTokenEnd(data);
                    break;
                }
                case 3: {
                    log.warn("the array of interface mappings contains an unknown array token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                    this.findTokenEnd(data);
                    break;
                }
                case 4: {
                    if (currentMapping == null) {
                        log.warn("the interface mappings array contains an unknown token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                        break;
                    }
                    if ("portType".equals(data.getTokenName())) {
                        String qname = data.getPrimitiveTokenValue();
                        currentMapping.portType = data.convertToQName(qname);
                        break;
                    }
                    if ("className".equals(data.getTokenName())) {
                        currentMapping.className = data.getPrimitiveTokenValue();
                        break;
                    }
                    log.warn("an interface mapping structure contains an unknown token {" + data.getTokenNamespaceURI() + "}" + data.getTokenName() + " typed {" + data.getTokenTypeNamespaceURI() + "}" + data.getTokenTypeName());
                    break;
                }
                case 5: {
                    log.warn("the remote reference structure contains an unsupported reference {" + data.getTokenNamespaceURI() + "}" + data.getTokenName());
                    break;
                }
                case 6: {
                    log.warn("the remote reference structure contains an unsupported null value {" + data.getTokenNamespaceURI() + "}" + data.getTokenName());
                }
            }
        }
        return retval;
    }

    protected Object deserializeServiceReference(ServiceReference serviceReference, Class targetClass, DeserializationContext context) throws MessageProcessingException {
        SOAPServiceInfo[] serviceInfos;
        Definition definition;
        String instanceID = serviceReference.getInstanceID();
        QName service = serviceReference.getServiceName();
        String wsdl = serviceReference.getWSDLUrl();
        if (service == null || wsdl == null) {
            throw new DeserializationException("incomplete information in remote reference");
        }
        PortTypeMappingRegistry irepo = (PortTypeMappingRegistry)Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
        String irepoKey = this.getPortTypeMappingRegistryConfigName();
        try {
            definition = this.wsdlRepo.getDefinition(wsdl);
        }
        catch (Exception e) {
            throw new DeserializationException("reading wsdl failed", e);
        }
        try {
            serviceInfos = SOAPServiceInfoCache.getServices(definition);
        }
        catch (SchemaException e) {
            throw new DeserializationException("reading wsdl failed", e);
        }
        if (serviceInfos == null) {
            throw new DeserializationException("reading wsdl failed.");
        }
        SOAPServiceInfo serviceInfo = null;
        int i = 0;
        while (i < serviceInfos.length) {
            if (serviceInfos[i].getServiceQName().equals(service)) {
                serviceInfo = serviceInfos[i];
                break;
            }
            ++i;
        }
        if (serviceInfo == null) {
            throw new DeserializationException("service not found: " + service);
        }
        SOAPPortInfo[] portInfos = serviceInfo.getPortInfos();
        ServiceClient[] clients = new ServiceClient[portInfos.length];
        Class[] ifaces = new Class[portInfos.length];
        Credentials[] credentialses = null;
        String initiatingProvider = null;
        if (Current.getProcessingType() == 1) {
            ServiceClient currentServiceClient = Current.getServiceClientContext().getServiceClient();
            credentialses = WaspSecurity.getCredentials(currentServiceClient);
            initiatingProvider = WaspSecurity.getInitiatingProvider(currentServiceClient);
        }
        int i2 = 0;
        while (i2 < portInfos.length) {
            ServiceClient client = ServiceClient.create();
            client.setWSDLServiceName(service);
            client.setWSDLPortName(portInfos[i2].getPortName());
            client.setWSDLLocation(wsdl);
            if (initiatingProvider != null) {
                WaspSecurity.setCredentials(client, credentialses);
                try {
                    WaspSecurity.setInitiatingProvider(client, initiatingProvider);
                }
                catch (NoSuchProviderException e) {
                    log.error("", e);
                }
            }
            ifaces[i2] = irepo.getInterfaceOfPortType(irepoKey, portInfos[i2].getPortTypeQName());
            if (ifaces[i2] == null) {
                log.warn("don't know interface for portType " + portInfos[i2].getPortTypeQName() + " in port " + portInfos[i2].getPortName() + " in service " + service);
            }
            clients[i2] = client;
            ++i2;
        }
        ArrayList<Class> ifaceList = new ArrayList<Class>();
        ArrayList<ServiceClient> clientList = new ArrayList<ServiceClient>();
        if (instanceID != null) {
            int i3 = 0;
            while (i3 < clients.length) {
                if (ifaces[i3] != null) {
                    clients[i3].getContext().getContextData().put(CallContext.INSTANCE_ID_KEY, instanceID);
                    ifaceList.add(ifaces[i3]);
                    clientList.add(clients[i3]);
                }
                ++i3;
            }
        }
        ifaces = ifaceList.toArray(new Class[0]);
        clients = clientList.toArray(new ServiceClient[0]);
        return Proxy.newProxyInstance(context.getClassLoader(), ifaces, (InvocationHandler)new MultipleInterfaceProxy(clients, ifaces));
    }
}

