/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interceptor;

import com.idoox.debug.Category;
import com.idoox.wasp.config.InterceptorChainConfig;
import com.idoox.wasp.interceptor.InterceptorRepository;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.Interceptor;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.idoox.wasp.interceptor.TransportInterceptorChain;

public class TransportInterceptorChainImpl
implements TransportInterceptorChain {
    private static final Category log = Category.getCategory("com.idoox.wasp.interceptor.TransportInterceptorChainImpl");
    protected List interceptorList;
    private LinkedList interceptorListUnsynchronized;
    private String name;
    private InterceptorRepository repository = (InterceptorRepository)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
    static /* synthetic */ Class class$com$idoox$wasp$config$InterceptorChainConfig;

    public TransportInterceptorChainImpl() {
        this.interceptorListUnsynchronized = new LinkedList();
        this.interceptorList = Collections.synchronizedList(this.interceptorListUnsynchronized);
    }

    public TransportInterceptorChainImpl(String name) {
        this();
        this.name = name;
    }

    public TransportInterceptorChainImpl(String name, TransportInterceptorChainImpl def, TransportInterceptorChainImpl orig) {
        this.interceptorListUnsynchronized = (LinkedList)orig.interceptorListUnsynchronized.clone();
        if (def != null) {
            this.interceptorListUnsynchronized.addAll(0, def.interceptorListUnsynchronized);
        }
        this.interceptorList = Collections.synchronizedList(this.interceptorListUnsynchronized);
        this.name = name;
    }

    public void load(Configurable c) {
        this.name = c.getName();
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        InterceptorChainConfig config = (InterceptorChainConfig)c.narrow(class$com$idoox$wasp$config$InterceptorChainConfig == null ? (class$com$idoox$wasp$config$InterceptorChainConfig = TransportInterceptorChainImpl.class$("com.idoox.wasp.config.InterceptorChainConfig")) : class$com$idoox$wasp$config$InterceptorChainConfig);
        InterceptorChainConfig.InterceptorConfig[] configs = config.getInterceptors();
        int i = 0;
        while (i < configs.length) {
            boolean in = false;
            boolean out = false;
            try {
                in = configs[i].getIn();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                out = configs[i].getOut();
            }
            catch (Exception e) {
                // empty catch block
            }
            Configurable interceptorConfig = Configurator.getConfigurable("interceptor", configs[i].getInstanceName());
            if (interceptorConfig == null) {
                log.warn("Interceptor with instance name " + configs[i].getInstanceName() + " wasn't found");
            } else {
                this.repository.addInterceptor(interceptorConfig);
                int direction = 0;
                if (in) {
                    direction |= 1;
                }
                if (out) {
                    direction |= 2;
                }
                this.interceptorList.add(new InterceptorRecord(configs[i].getInstanceName(), direction));
            }
            ++i;
        }
    }

    public Interceptor get(int position) {
        InterceptorRecord record = (InterceptorRecord)this.interceptorList.get(position);
        return this.repository.getInterceptor(record.name);
    }

    public String getName(int position) {
        InterceptorRecord record = (InterceptorRecord)this.interceptorList.get(position);
        return record.name;
    }

    public void add(String name, int position, int direction) {
        this.interceptorList.add(position, new InterceptorRecord(name, direction));
    }

    public void add(String name, int direction) {
        this.add(name, this.interceptorList.size(), direction);
    }

    public void remove(int position) {
        InterceptorRecord interceptorRecord = (InterceptorRecord)this.interceptorList.remove(position);
    }

    public int getDirection(int position) {
        InterceptorRecord record = (InterceptorRecord)this.interceptorList.get(position);
        return record.direction;
    }

    public void setDirection(int position, int direction) {
        InterceptorRecord record = (InterceptorRecord)this.interceptorList.get(position);
        record.direction = direction;
    }

    public int size() {
        return this.interceptorList.size();
    }

    public void intercept(Connection connection) throws IOException, StopProcessingException {
        int i = 0;
        while (i < this.interceptorList.size()) {
            InterceptorRecord record = (InterceptorRecord)this.interceptorList.get(i);
            Interceptor interceptor = this.repository.getInterceptor(record.name);
            if (interceptor == null) {
                log.warn("Interceptor with instance name " + record.name + " wasn't found in the repository");
            } else if (connection != null) {
                Connection connection2 = connection;
                synchronized (connection2) {
                    Object var9_8;
                    InputMessage in = null;
                    OutputMessage out = null;
                    if ((record.direction & 1) == 0) {
                        in = connection.getInputMessage();
                        connection.setInputMessage(null);
                    }
                    if ((record.direction & 2) == 0) {
                        out = connection.getOutputMessage();
                        connection.setOutputMessage(null);
                    }
                    try {
                        ((TransportInterceptor)interceptor).intercept(connection, this, i);
                        var9_8 = null;
                        if (in != null) {
                            connection.setInputMessage(in);
                        }
                        if (out != null) {
                            connection.setOutputMessage(out);
                        }
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (in != null) {
                            connection.setInputMessage(in);
                        }
                        if (out != null) {
                            connection.setOutputMessage(out);
                        }
                        throw throwable;
                    }
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InterceptorRecord {
        public String name;
        public int direction;

        public InterceptorRecord(String name, int direction) {
            this.name = name;
            this.direction = direction;
        }
    }
}

