/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interceptor;

import com.idoox.debug.Category;
import com.idoox.util.CopyOnWriteHelper;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.InterceptorChainConfig;
import com.idoox.wasp.config.InterceptorConfig;
import com.idoox.wasp.interceptor.InterceptorRepository;
import com.idoox.wasp.interceptor.TransportInterceptorChainImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.interceptor.Interceptor;
import org.idoox.wasp.interceptor.InterceptorChain;

public class InterceptorRepositoryImpl
implements InterceptorRepository,
Module,
CopyOnWriteHelper.CopyingHandler {
    private static final Category log = Category.getCategory("com.idoox.wasp.InterceptorRepositoryImpl");
    public static final String CLIENT_DEFAULT_INTERCEPTOR_CHAIN = "clientTransportInterceptors";
    public static final String SERVER_DEFAULT_INTERCEPTOR_CHAIN = "serverTransportInterceptors";
    protected Map chainMap;
    protected Map chainDefaultsMap;
    protected Map interceptorMap;
    private Configurator configurator;
    private static long chainCount = 0L;
    private static final String CHAIN_NAME_PREFIX = "||";
    private CopyOnWriteHelper COW = new CopyOnWriteHelper(this, "|");
    static /* synthetic */ Class class$com$idoox$wasp$config$InterceptorChainConfig;
    static /* synthetic */ Class class$org$idoox$wasp$interceptor$InterceptorChain;
    static /* synthetic */ Class class$org$idoox$wasp$interceptor$Interceptor;
    static /* synthetic */ Class class$com$idoox$wasp$config$InterceptorConfig;

    public InterceptorRepositoryImpl() {
        this.chainMap = new HashMap(13);
        this.chainDefaultsMap = new HashMap(13);
        this.interceptorMap = new HashMap(13);
    }

    public synchronized Set getChainNames() {
        return this.chainMap.keySet();
    }

    public synchronized InterceptorChain getChain(String name) {
        ChainRecord chainRecord = (ChainRecord)this.chainMap.get(name = this.COW.resolveID(name, true));
        if (chainRecord == null) {
            return null;
        }
        return chainRecord.chain;
    }

    public String createTransportInterceptorChain() {
        String name;
        String string = CHAIN_NAME_PREFIX;
        synchronized (string) {
            name = CHAIN_NAME_PREFIX + chainCount++;
        }
        this.createTransportInterceptorChain(name);
        return name;
    }

    private synchronized void createTransportInterceptorChain(String name) {
        TransportInterceptorChainImpl chain = new TransportInterceptorChainImpl(name);
        ChainRecord record = new ChainRecord(name, null, null, chain, null, false);
        this.chainMap.put(name, record);
    }

    public synchronized void addChain(String name, InterceptorChain chain) {
        this.COW.removeID(name);
        ChainRecord record = new ChainRecord(name, null, null, chain, null, false);
        this.chainMap.put(name, record);
    }

    public synchronized InterceptorChain addChain(Configurable c) {
        InterceptorChainConfig config = (InterceptorChainConfig)c.narrow(class$com$idoox$wasp$config$InterceptorChainConfig == null ? (class$com$idoox$wasp$config$InterceptorChainConfig = InterceptorRepositoryImpl.class$("com.idoox.wasp.config.InterceptorChainConfig")) : class$com$idoox$wasp$config$InterceptorChainConfig);
        String name = config.getName();
        try {
            ClassSpace classSpace;
            String classSpaceName = config.getClassSpaceName();
            try {
                classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
            }
            catch (MalformedURLException e) {
                log.error("Could not find class space " + classSpaceName + " for chain " + name, e);
                return null;
            }
            String className = config.getClassName();
            if (className == null) {
                log.error("Config does not contain class name for chain " + name);
                return null;
            }
            InterceptorChain chain = (InterceptorChain)classSpace.createInstance(class$org$idoox$wasp$interceptor$InterceptorChain == null ? (class$org$idoox$wasp$interceptor$InterceptorChain = InterceptorRepositoryImpl.class$("org.idoox.wasp.interceptor.InterceptorChain")) : class$org$idoox$wasp$interceptor$InterceptorChain, className);
            if (chain == null) {
                log.error("Could not access chain " + className + " in class space " + classSpaceName);
                return null;
            }
            ChainRecord record = new ChainRecord(name, classSpace, className, chain, c, false);
            chain.load(c);
            c.addVetoableChangeListener(record);
            this.chainMap.put(name, record);
            return chain;
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found exception", e);
        }
        catch (InstantiationException e) {
            log.error("Instantiation exception", e);
        }
        catch (IllegalAccessException e) {
            log.error("Illegal access exception", e);
        }
        return null;
    }

    public synchronized InterceptorChain removeChain(String name) {
        return this.removeChain(name, true);
    }

    private InterceptorChain removeChain(String name, boolean remove) {
        ChainRecord record;
        if (remove) {
            this.COW.removeID(name);
            record = (ChainRecord)this.chainMap.remove(name);
            this.chainDefaultsMap.remove(name);
        } else {
            record = (ChainRecord)this.chainMap.get(name);
        }
        if (record == null) {
            return null;
        }
        if (record.config != null) {
            record.config.removeVetoableChangeListener(record);
        }
        return record.chain;
    }

    public synchronized void load(Configurable c) {
        InitialReferencesRegistrar.addInitialReference("com.idoox.wasp.interceptor.InterceptorRepository", this);
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] chains = Configurator.getTopEntries("InterceptorChain");
        int i = 0;
        while (i < chains.length) {
            try {
                this.addChain(chains[i]);
            }
            catch (Exception e) {
                log.error("Exception in interceptor's chain " + chains[i].getName(), e);
            }
            ++i;
        }
        Configurable[] interceptors = Configurator.getTopEntries("interceptor");
        int i2 = 0;
        while (i2 < interceptors.length) {
            this.addInterceptor(interceptors[i2]);
            ++i2;
        }
    }

    public synchronized void init() {
    }

    public synchronized void destroy() {
        Iterator i = this.chainMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.removeChain(name, false);
        }
        this.chainMap.clear();
        this.chainDefaultsMap.clear();
        Iterator i2 = this.interceptorMap.keySet().iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            this.removeInterceptor(name, false);
        }
        this.interceptorMap.clear();
        this.configurator = null;
    }

    public synchronized Set getInterceptorNames() {
        return this.interceptorMap.keySet();
    }

    public synchronized Interceptor getInterceptor(String name) {
        InterceptorRecord record = (InterceptorRecord)this.interceptorMap.get(name);
        if (record == null) {
            Configurable interceptorConfig = Configurator.getConfigurable("interceptor", name);
            if (interceptorConfig == null) {
                return null;
            }
            this.addInterceptor(interceptorConfig);
            record = (InterceptorRecord)this.interceptorMap.get(name);
            if (record == null) {
                return null;
            }
        }
        if (record.disable) {
            return null;
        }
        if (record.interceptor == null) {
            try {
                record.interceptor = (Interceptor)record.classSpace.createInstance(class$org$idoox$wasp$interceptor$Interceptor == null ? (class$org$idoox$wasp$interceptor$Interceptor = InterceptorRepositoryImpl.class$("org.idoox.wasp.interceptor.Interceptor")) : class$org$idoox$wasp$interceptor$Interceptor, record.className);
                if (record.interceptor == null) {
                    log.error("Could not access interceptor " + record.className + " in class space " + record.classSpace.getName());
                    record.disable = true;
                    return null;
                }
                record.interceptor.load(record.config);
            }
            catch (ClassNotFoundException e) {
                log.error("Class not found exception", e);
                record.disable = true;
                return null;
            }
            catch (InstantiationException e) {
                log.error("Instantiation exception", e);
                record.disable = true;
                return null;
            }
            catch (IllegalAccessException e) {
                log.error("Illegal access exception", e);
                record.disable = true;
                return null;
            }
            catch (WaspInternalException e) {
                log.error("Error when loading interceptor ", e);
                record.disable = true;
                return null;
            }
        }
        return record.interceptor;
    }

    public synchronized void addInterceptor(String name, Interceptor interceptor) {
        InterceptorRecord record = new InterceptorRecord(name, null, null, interceptor, null);
        this.interceptorMap.put(name, record);
    }

    public synchronized void addInterceptor(Configurable c) {
        ClassSpace classSpace;
        InterceptorConfig config = (InterceptorConfig)c.narrow(class$com$idoox$wasp$config$InterceptorConfig == null ? (class$com$idoox$wasp$config$InterceptorConfig = InterceptorRepositoryImpl.class$("com.idoox.wasp.config.InterceptorConfig")) : class$com$idoox$wasp$config$InterceptorConfig);
        String name = config.getName();
        if (this.interceptorMap.get(name) != null) {
            return;
        }
        String classSpaceName = config.getClassSpaceName();
        try {
            classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
        }
        catch (MalformedURLException e) {
            log.error("Could not find class space " + classSpaceName + " for interceptor " + name, e);
            return;
        }
        String className = config.getClassName();
        if (className == null) {
            log.error("Config does not contain class name for interceptor " + name);
            return;
        }
        InterceptorRecord record = new InterceptorRecord(name, classSpace, className, null, c);
        c.addVetoableChangeListener(record);
        this.interceptorMap.put(name, record);
    }

    public synchronized Interceptor removeInterceptor(String name) {
        return this.removeInterceptor(name, true);
    }

    private Interceptor removeInterceptor(String name, boolean removeFromMap) {
        InterceptorRecord record = removeFromMap ? (InterceptorRecord)this.interceptorMap.remove(name) : (InterceptorRecord)this.interceptorMap.get(name);
        if (record == null) {
            log.warn("Interceptor " + name + " wasn't found in the interceptor repository");
            return null;
        }
        if (record.config != null) {
            record.config.removeVetoableChangeListener(record);
        }
        if (record.interceptor != null) {
            record.interceptor.destroy();
        }
        return record.interceptor;
    }

    public String cloneInterceptorsID(String id, String defaultInterceptorChain) {
        String newID = this.COW.cloneID(id);
        this.chainDefaultsMap.put(newID, defaultInterceptorChain);
        return newID;
    }

    public void doCopy(String origID, String newID) {
        String defChainName = (String)this.chainDefaultsMap.get(newID);
        ChainRecord defChainRecord = defChainName == null ? null : (ChainRecord)this.chainMap.get(defChainName);
        TransportInterceptorChainImpl defChain = defChainRecord == null ? null : (TransportInterceptorChainImpl)defChainRecord.chain;
        ChainRecord orig = (ChainRecord)this.chainMap.get(origID);
        if (orig == null) {
            if (defChain == null) {
                this.createTransportInterceptorChain(newID);
            } else {
                ChainRecord fresh = new ChainRecord(newID, null, null, new TransportInterceptorChainImpl(newID, null, defChain), null, defChain != null);
                this.chainMap.put(newID, fresh);
            }
            return;
        }
        ChainRecord fresh = orig.containsDefaults ? new ChainRecord(newID, orig.classSpace, orig.className, new TransportInterceptorChainImpl(newID, null, (TransportInterceptorChainImpl)orig.chain), orig.config, true) : new ChainRecord(newID, orig.classSpace, orig.className, new TransportInterceptorChainImpl(newID, defChain, (TransportInterceptorChainImpl)orig.chain), orig.config, defChain != null);
        this.chainMap.put(newID, fresh);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InterceptorRecord
    implements VetoableChangeListener {
        public String name;
        public ClassSpace classSpace;
        public String className;
        public Interceptor interceptor;
        public Configurable config;
        public boolean disable;

        public InterceptorRecord(String name, ClassSpace classSpace, String className, Interceptor interceptor, Configurable config) {
            this.name = name;
            this.classSpace = classSpace;
            this.className = className;
            this.interceptor = interceptor;
            this.config = config;
            this.disable = false;
        }

        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if (event.getPropertyName().equals("Name")) {
                this.name = (String)event.getNewValue();
                InterceptorRepositoryImpl.this.interceptorMap.remove(event.getOldValue());
                InterceptorRepositoryImpl.this.interceptorMap.put(this.name, this);
            } else if (event.getPropertyName().equals("ClassSpaceName")) {
                ClassSpace cs;
                String classSpaceName = (String)event.getNewValue();
                try {
                    cs = ClassSpaceHelper.getClassSpace(classSpaceName, this.config.getReferenceLocation());
                }
                catch (MalformedURLException e) {
                    throw new PropertyVetoException("Could not find class space " + classSpaceName + " for interceptor " + this.name + " - MalformedURLException: " + e.getMessage(), event);
                }
                this.reload(this.className, cs);
            } else if (event.getPropertyName().equals("ClassName")) {
                String cn = (String)event.getNewValue();
                if (cn == null) {
                    throw new PropertyVetoException("Config does not contain class name for interceptor " + this.name, event);
                }
                this.reload(cn, this.classSpace);
            }
        }

        private void reload(String className, ClassSpace classSpace) {
            if (this.interceptor != null) {
                this.interceptor.destroy();
                this.interceptor = null;
            }
            this.className = className;
            this.classSpace = classSpace;
            this.disable = false;
        }
    }

    class ChainRecord
    implements VetoableChangeListener {
        public String name;
        public ClassSpace classSpace;
        public String className;
        public InterceptorChain chain;
        public Configurable config;
        public boolean containsDefaults;
        static /* synthetic */ Class class$org$idoox$wasp$interceptor$InterceptorChain;

        public ChainRecord(String name, ClassSpace classSpace, String className, InterceptorChain chain, Configurable config, boolean containsDefaults) {
            this.name = name;
            this.classSpace = classSpace;
            this.className = className;
            this.chain = chain;
            this.config = config;
            this.containsDefaults = containsDefaults;
        }

        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if (event.getPropertyName().equals("name")) {
                this.name = (String)event.getNewValue();
                String oldName = (String)event.getOldValue();
                InterceptorRepositoryImpl.this.COW.removeID(oldName);
                InterceptorRepositoryImpl.this.chainMap.remove(oldName);
                InterceptorRepositoryImpl.this.chainMap.put(this.name, this);
            } else if (event.getPropertyName().equals("classSpaceName")) {
                ClassSpace cs;
                String classSpaceName = (String)event.getNewValue();
                try {
                    cs = ClassSpaceHelper.getClassSpace(classSpaceName, this.config.getReferenceLocation());
                }
                catch (MalformedURLException e) {
                    throw new PropertyVetoException("Could not find class space " + classSpaceName + " for chain " + this.name + " - MalformedURLException: " + e.getMessage(), event);
                }
                this.reload(this.className, cs, event);
            } else if (event.getPropertyName().equals("className")) {
                String cn = (String)event.getNewValue();
                if (cn == null) {
                    throw new PropertyVetoException("Config does not contain class name for chain " + this.name, event);
                }
                this.reload(cn, this.classSpace, event);
            }
        }

        private void reload(String className, ClassSpace classSpace, PropertyChangeEvent event) throws PropertyVetoException {
            try {
                InterceptorChain chain = (InterceptorChain)classSpace.createInstance(class$org$idoox$wasp$interceptor$InterceptorChain == null ? (class$org$idoox$wasp$interceptor$InterceptorChain = ChainRecord.class$("org.idoox.wasp.interceptor.InterceptorChain")) : class$org$idoox$wasp$interceptor$InterceptorChain, className);
                if (chain == null) {
                    throw new PropertyVetoException("Could not access chain " + this.name + " in class space " + classSpace, event);
                }
            }
            catch (Exception e) {
                throw new PropertyVetoException("Exception in chain " + this.name + "(class-space: " + classSpace + ", class-name: " + className + ")" + ": " + e, event);
            }
            this.chain.load(this.config);
            this.className = className;
            this.classSpace = classSpace;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

