/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.client;

import com.idoox.debug.Category;
import com.idoox.wasp.client.config.ConnectorConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.idoox.config.Configurable;
import org.idoox.wasp.Module;

public class Connector
implements Module {
    private static final Category log = Category.getCategory("com.idoox.wasp.client.Connector");
    private static int CLIENT_SOCKET_TIMEOUT = 60000;
    private static byte SIGNAL_SHUTDOWN = (byte)107;
    private static byte SIGNAL_KILL = (byte)108;
    private int port = -1;
    private Configurable config;
    static /* synthetic */ Class class$com$idoox$wasp$client$config$ConnectorConfig;

    public void load(Configurable c) {
        ConnectorConfig config = (ConnectorConfig)c.narrow(class$com$idoox$wasp$client$config$ConnectorConfig == null ? (class$com$idoox$wasp$client$config$ConnectorConfig = Connector.class$("com.idoox.wasp.client.config.ConnectorConfig")) : class$com$idoox$wasp$client$config$ConnectorConfig);
        try {
            this.port = config.getPort();
        }
        catch (Exception e) {
            log.warn("Config does not contain server port for connector " + c.getName());
            this.port = -1;
        }
    }

    public void init() {
    }

    public void destroy() {
    }

    public void shutdown() throws IOException {
        this.sendSignal(SIGNAL_SHUTDOWN);
    }

    public void kill() throws IOException {
        this.sendSignal(SIGNAL_KILL);
    }

    private void sendSignal(byte signal) throws IOException {
        if (this.port <= 0) {
            throw new IOException("Connector can't connect to the server: unknown port");
        }
        Socket client = new Socket(InetAddress.getLocalHost(), this.port);
        client.setSoTimeout(CLIENT_SOCKET_TIMEOUT);
        client.getOutputStream().write(signal);
        client.getOutputStream().flush();
        client.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

