/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.client;

import com.idoox.debug.Category;
import com.systinet.wasp.async.AsyncConversationImpl;
import com.systinet.wasp.client.BCAwareClientProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.idoox.wasp.types.AsyncReceipt;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.async.GenericAsyncCallback;

public class AsyncReceiptHelper
implements InvocationHandler,
AsyncReceipt {
    private static final Category log = Category.getCategory("com.idoox.wasp.client.AsyncReceiptHelper");
    private AsyncConversation async;
    private boolean finished = false;
    private BCAwareClientProxy bcProxy;
    private Method method;
    private static String lock = new String();
    private boolean interrupted = false;
    private Throwable exception;
    private Object result;
    boolean deserialized = false;
    Object retval;
    Object paramStruct;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$idoox$wasp$types$AsyncReceipt;

    public AsyncReceiptHelper() {
    }

    public AsyncReceiptHelper(AsyncConversation async, BCAwareClientProxy handler, Method method) {
        this.async = async;
        this.bcProxy = handler;
        this.method = method;
        async.setCallback(new Callback());
    }

    public static int select(AsyncReceipt[] receipts, long timeout) throws InterruptedException {
        int count = 0;
        String string = lock;
        synchronized (string) {
            while (count == 0) {
                int i = 0;
                while (i < receipts.length) {
                    AsyncReceipt receipt = receipts[i];
                    AsyncReceiptHelper async = (AsyncReceiptHelper)Proxy.getInvocationHandler(receipt);
                    if (async.isFinished()) {
                        ++count;
                    }
                    ++i;
                }
                if (count == 0) {
                    lock.wait(timeout);
                }
                if (timeout > 0L) break;
            }
        }
        return count;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final boolean finish(long timeout) {
        this.waitForResponseReady(timeout);
        this.setInterrupted(true);
        return this.isFinished();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        String methodName = method.getName();
        if ("getResult".equals(methodName)) {
            return this.getResult();
        }
        if ("getParams".equals(methodName)) {
            return this.getParams();
        }
        if ("getException".equals(methodName)) {
            return this.getException();
        }
        if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = AsyncReceiptHelper.class$("java.lang.Object")) : class$java$lang$Object) || method.getDeclaringClass() == (class$org$idoox$wasp$types$AsyncReceipt == null ? (class$org$idoox$wasp$types$AsyncReceipt = AsyncReceiptHelper.class$("org.idoox.wasp.types.AsyncReceipt")) : class$org$idoox$wasp$types$AsyncReceipt)) {
            return method.invoke((Object)this, args);
        }
        throw new UnsupportedOperationException("Method not implemented: " + method.getName());
    }

    private Object getResult() {
        if (!this.isInterrupted()) {
            this.waitForResponseReady(0L);
        }
        return this.result;
    }

    private Object getParams() {
        if (!this.isInterrupted()) {
            this.waitForResponseReady(0L);
        }
        return this.paramStruct;
    }

    private Throwable getException() {
        if (!this.isInterrupted()) {
            this.waitForResponseReady(0L);
        }
        return this.exception;
    }

    private void waitForResponseReady(long timeout) {
        if (!this.isFinished()) {
            AsyncReceiptHelper asyncReceiptHelper = this;
            synchronized (asyncReceiptHelper) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.warn("Waiting on async response interrupted." + e.getMessage());
                }
            }
        }
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setFinished() {
        this.async.finish();
        String string = lock;
        synchronized (string) {
            this.finished = true;
            AsyncReceiptHelper asyncReceiptHelper = this;
            synchronized (asyncReceiptHelper) {
                this.notifyAll();
            }
            lock.notifyAll();
        }
    }

    public void setParams(Object paramStruct) {
        this.paramStruct = paramStruct;
    }

    private void finishReceive() {
        this.bcProxy.finishAsyncCall(this.async, this, this.method);
        this.setFinished();
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        if (!((AsyncConversationImpl)this.async).isFinished()) {
            this.async.finish();
        }
        this.interrupted = interrupted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Callback
    extends GenericAsyncCallback {
        private Callback() {
        }

        public void onResponse(AsyncConversation asyncConversation) {
            AsyncReceiptHelper.this.finishReceive();
        }
    }
}

