/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.classloader;

import com.idoox.wasp.classloader.Resource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarResource
implements Resource {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = JarResource.getJavaVersion();
    private URL url;
    private URL original;
    private JarFile resource;

    public JarResource(URL url) throws MalformedURLException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("url argument is null.");
        }
        this.original = url;
        this.url = new URL("jar", "", -1, url + "!/");
        this.resource = this.getJarFile(url);
        if (this.resource == null) {
            throw new IOException("Resource from jar is null.");
        }
    }

    private JarFile getJarFile(URL url) throws IOException {
        String scheme = url.getProtocol();
        if ("file".equals(scheme)) {
            String path = url.getPath().replace('/', File.separatorChar);
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException(path);
            }
            return new JarFile(file);
        }
        URLConnection connection = this.url.openConnection();
        connection.setRequestProperty(USER_AGENT_JAVA_VERSION, JAVA_VERSION);
        return ((JarURLConnection)connection).getJarFile();
    }

    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getClassBytes(String name) {
        byte[] byArray;
        InputStream in;
        ByteArrayOutputStream out;
        block17: {
            byte[] byArray2;
            block16: {
                out = null;
                in = null;
                try {
                    try {
                        JarEntry entry = this.resource.getJarEntry(name);
                        if (entry == null) {
                            byArray2 = null;
                            Object var10_8 = null;
                            break block16;
                        }
                        out = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        in = this.resource.getInputStream(entry);
                        while (true) {
                            void var7_17;
                            int count;
                            if ((count = in.read(buffer)) == -1) {
                                byArray = out.toByteArray();
                                break block17;
                            }
                            out.write(buffer, 0, (int)var7_17);
                        }
                    }
                    catch (Exception e) {
                        byte[] byArray3 = null;
                        Object var10_10 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                            if (in == null) return byArray3;
                            in.close();
                            return byArray3;
                        }
                        catch (Exception ioe) {
                            return null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    try {}
                    catch (Exception ioe) {
                        return null;
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
            }
            try {}
            catch (Exception ioe) {
                return null;
            }
            if (out != null) {
                out.close();
            }
            if (in == null) return byArray2;
            in.close();
            return byArray2;
        }
        Object var10_9 = null;
        try {}
        catch (Exception ioe) {
            return null;
        }
        if (out != null) {
            out.close();
        }
        if (in == null) return byArray;
        in.close();
        return byArray;
    }

    public void release() throws IOException {
        this.resource.close();
    }

    public Manifest getManifest() throws IOException {
        if (this.resource != null) {
            return this.resource.getManifest();
        }
        return null;
    }

    public Certificate[] getCertificates(String name) {
        JarEntry entry;
        if (this.resource != null && (entry = this.resource.getJarEntry(name)) != null) {
            return entry.getCertificates();
        }
        return null;
    }

    public URL[] getLocalClassPath() throws IOException {
        String classPath;
        Attributes attr;
        Manifest mannifest = this.resource.getManifest();
        if (mannifest != null && (attr = mannifest.getMainAttributes()) != null && (classPath = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
            return this.parseClassPath(classPath);
        }
        return null;
    }

    private URL[] parseClassPath(String classPath) throws MalformedURLException {
        StringTokenizer tokenizer = new StringTokenizer(classPath);
        URL[] urls = new URL[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            urls[i] = new URL(this.original, path);
            ++i;
        }
        return urls;
    }

    private static String getJavaVersion() {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return System.getProperty("java.version");
                }
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }
}

