/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.classloader;

import com.idoox.wasp.classloader.ClassHolder;
import com.idoox.wasp.classloader.DirResource;
import com.idoox.wasp.classloader.JarResource;
import com.idoox.wasp.classloader.Resource;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class ClassPath {
    private ArrayList resources = new ArrayList();
    private HashMap cpToRes = new HashMap();
    private Stack dirtyUrls = new Stack();

    public ClassPath(URL[] urls) {
        int i = 0;
        while (i < urls.length) {
            this.dirtyUrls.push(urls[i]);
            ++i;
        }
    }

    private Resource createResource(final URL url) throws IOException {
        try {
            return (Resource)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String path = url.getPath();
                    if (path != null && path.endsWith("/")) {
                        return new DirResource(url);
                    }
                    return new JarResource(url);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private synchronized Resource getResource(int index) {
        while (this.resources.size() < index + 1) {
            Resource res;
            URL url;
            block8: {
                Stack stack = this.dirtyUrls;
                synchronized (stack) {
                    if (this.dirtyUrls.empty()) {
                        Resource resource = null;
                        return resource;
                    }
                    url = (URL)this.dirtyUrls.pop();
                }
                if (this.cpToRes.containsKey(url)) continue;
                res = null;
                try {
                    res = this.createResource(url);
                    URL[] points = res.getLocalClassPath();
                    if (points == null) break block8;
                    int i = 0;
                    while (i < points.length) {
                        this.dirtyUrls.push(points[i]);
                        ++i;
                    }
                }
                catch (IOException e) {
                    continue;
                }
            }
            this.resources.add(res);
            this.cpToRes.put(url, res);
        }
        return (Resource)this.resources.get(index);
    }

    /*
     * WARNING - void declaration
     */
    public ClassHolder getClassHolder(String name) {
        Resource res;
        int i = 0;
        while ((res = this.getResource(i)) != null) {
            byte[] bytes;
            void var2_3;
            if (var2_3 != null && (bytes = var2_3.getClassBytes(name)) != null) {
                return new ClassHolder(bytes, (Resource)var2_3);
            }
            ++i;
        }
        return null;
    }

    public Enumeration getResources(String name) {
        final String tmpName = !name.endsWith(".class") && !name.endsWith("/") ? name + "/" : name;
        return new Enumeration(){
            private Resource resource = null;
            int index = 0;

            /*
             * Unable to fully structure code
             */
            public boolean hasMoreElements() {
                if (this.resource == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    bytes = this.resource.getClassBytes(tmpName);
                    if (bytes == null) continue;
                    return true;
lbl6:
                    // 2 sources

                    ** while ((this.resource = ClassPath.access$000((ClassPath)ClassPath.this, (int)this.index++)) != null)
                }
lbl7:
                // 1 sources

                return false;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                Resource res = this.resource;
                this.resource = null;
                return res;
            }
        };
    }

    public void relaeseResource(URL url) throws IOException {
        Resource res = (Resource)this.cpToRes.get(url);
        if (res != null) {
            res.release();
            ArrayList arrayList = this.resources;
            synchronized (arrayList) {
                ((AbstractCollection)this.resources).remove(res);
            }
        }
    }

    public void releaseAllResources() throws IOException {
        ArrayList arrayList = this.resources;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.resources).iterator();
            while (iterator.hasNext()) {
                Resource res = (Resource)iterator.next();
                if (res == null) continue;
                res.release();
            }
            this.resources.clear();
        }
    }

    static /* synthetic */ Resource access$000(ClassPath x0, int x1) {
        return x0.getResource(x1);
    }
}

